/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.redis.lettuce;

import io.lettuce.core.BitFieldArgs;
import io.lettuce.core.Consumer;
import io.lettuce.core.GeoArgs;
import io.lettuce.core.GeoCoordinates;
import io.lettuce.core.GeoRadiusStoreArgs;
import io.lettuce.core.GeoWithin;
import io.lettuce.core.KeyScanCursor;
import io.lettuce.core.KeyValue;
import io.lettuce.core.KillArgs;
import io.lettuce.core.Limit;
import io.lettuce.core.MapScanCursor;
import io.lettuce.core.MigrateArgs;
import io.lettuce.core.Range;
import io.lettuce.core.RestoreArgs;
import io.lettuce.core.ScanArgs;
import io.lettuce.core.ScanCursor;
import io.lettuce.core.ScoredValue;
import io.lettuce.core.ScoredValueScanCursor;
import io.lettuce.core.ScriptOutputType;
import io.lettuce.core.SetArgs;
import io.lettuce.core.SortArgs;
import io.lettuce.core.StreamMessage;
import io.lettuce.core.StreamScanCursor;
import io.lettuce.core.UnblockType;
import io.lettuce.core.Value;
import io.lettuce.core.ValueScanCursor;
import io.lettuce.core.XAddArgs;
import io.lettuce.core.XClaimArgs;
import io.lettuce.core.XReadArgs;
import io.lettuce.core.ZAddArgs;
import io.lettuce.core.ZStoreArgs;
import io.lettuce.core.cluster.api.StatefulRedisClusterConnection;
import io.lettuce.core.cluster.api.sync.NodeSelection;
import io.lettuce.core.cluster.api.sync.RedisAdvancedClusterCommands;
import io.lettuce.core.cluster.api.sync.RedisClusterCommands;
import io.lettuce.core.cluster.models.partitions.RedisClusterNode;
import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.output.KeyStreamingChannel;
import io.lettuce.core.output.KeyValueStreamingChannel;
import io.lettuce.core.output.ScoredValueStreamingChannel;
import io.lettuce.core.output.ValueStreamingChannel;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandType;
import io.lettuce.core.protocol.ProtocolKeyword;
import io.opentracing.Span;
import io.opentracing.contrib.redis.common.TracingConfiguration;
import io.opentracing.contrib.redis.common.TracingHelper;
import io.opentracing.contrib.redis.lettuce.TracingRedisCommands;
import io.opentracing.contrib.redis.lettuce.TracingStatefulRedisClusterConnection;
import java.time.Duration;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public class TracingRedisAdvancedClusterCommands<K, V>
implements RedisAdvancedClusterCommands<K, V> {
    private final RedisAdvancedClusterCommands<K, V> commands;
    private final TracingHelper helper;
    private final TracingConfiguration tracingConfiguration;

    public TracingRedisAdvancedClusterCommands(RedisAdvancedClusterCommands<K, V> commands, TracingConfiguration tracingConfiguration) {
        this.commands = commands;
        this.helper = new TracingHelper(tracingConfiguration);
        this.tracingConfiguration = tracingConfiguration;
    }

    public String auth(String password) {
        Span span = this.helper.buildSpan("auth");
        try {
            String string = this.commands.auth(password);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public RedisClusterCommands<K, V> getConnection(String nodeId) {
        return new TracingRedisCommands(this.commands.getStatefulConnection().getConnection(nodeId).sync(), this.tracingConfiguration);
    }

    public RedisClusterCommands<K, V> getConnection(String host, int port) {
        return new TracingRedisCommands(this.commands.getStatefulConnection().getConnection(host, port).sync(), this.tracingConfiguration);
    }

    public StatefulRedisClusterConnection<K, V> getStatefulConnection() {
        return new TracingStatefulRedisClusterConnection(this.commands.getStatefulConnection(), this.tracingConfiguration);
    }

    public NodeSelection<K, V> readonly(Predicate<RedisClusterNode> predicate) {
        return this.commands.readonly(predicate);
    }

    public NodeSelection<K, V> nodes(Predicate<RedisClusterNode> predicate) {
        return this.commands.nodes(predicate);
    }

    public NodeSelection<K, V> nodes(Predicate<RedisClusterNode> predicate, boolean dynamic) {
        return this.commands.nodes(predicate, dynamic);
    }

    public Long hdel(K key, K ... fields) {
        Span span = this.helper.buildSpan("hdel", key);
        try {
            Long l = this.commands.hdel(key, (Object[])fields);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Boolean hexists(K key, K field) {
        Span span = this.helper.buildSpan("hexists", key);
        try {
            Boolean bl = this.commands.hexists(key, field);
            return bl;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public V hget(K key, K field) {
        Span span = this.helper.buildSpan("hget", key);
        try {
            Object object = this.commands.hget(key, field);
            return (V)object;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long hincrby(K key, K field, long amount) {
        Span span = this.helper.buildSpan("hincrby", key);
        span.setTag("amount", (Number)amount);
        try {
            Long l = this.commands.hincrby(key, field, amount);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Double hincrbyfloat(K key, K field, double amount) {
        Span span = this.helper.buildSpan("hincrbyfloat", key);
        span.setTag("amount", (Number)amount);
        try {
            Double d = this.commands.hincrbyfloat(key, field, amount);
            return d;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Map<K, V> hgetall(K key) {
        Span span = this.helper.buildSpan("hgetall", key);
        try {
            Map map = this.commands.hgetall(key);
            return map;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long hgetall(KeyValueStreamingChannel<K, V> channel, K key) {
        Span span = this.helper.buildSpan("hgetall", key);
        try {
            Long l = this.commands.hgetall(channel, key);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<K> hkeys(K key) {
        Span span = this.helper.buildSpan("hkeys", key);
        try {
            List list = this.commands.hkeys(key);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long hkeys(KeyStreamingChannel<K> channel, K key) {
        Span span = this.helper.buildSpan("hkeys", key);
        try {
            Long l = this.commands.hkeys(channel, key);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long hlen(K key) {
        Span span = this.helper.buildSpan("hlen", key);
        try {
            Long l = this.commands.hlen(key);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<KeyValue<K, V>> hmget(K key, K ... fields) {
        Span span = this.helper.buildSpan("hmget", key);
        try {
            List list = this.commands.hmget(key, (Object[])fields);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long hmget(KeyValueStreamingChannel<K, V> channel, K key, K ... fields) {
        Span span = this.helper.buildSpan("hmget", key);
        try {
            Long l = this.commands.hmget(channel, key, (Object[])fields);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String hmset(K key, Map<K, V> map) {
        Span span = this.helper.buildSpan("hmset", key);
        try {
            String string = this.commands.hmset(key, map);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public MapScanCursor<K, V> hscan(K key) {
        Span span = this.helper.buildSpan("hscan", key);
        try {
            MapScanCursor mapScanCursor = this.commands.hscan(key);
            return mapScanCursor;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public MapScanCursor<K, V> hscan(K key, ScanArgs scanArgs) {
        Span span = this.helper.buildSpan("hscan", key);
        try {
            MapScanCursor mapScanCursor = this.commands.hscan(key, scanArgs);
            return mapScanCursor;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public MapScanCursor<K, V> hscan(K key, ScanCursor scanCursor, ScanArgs scanArgs) {
        Span span = this.helper.buildSpan("hscan", key);
        try {
            MapScanCursor mapScanCursor = this.commands.hscan(key, scanCursor, scanArgs);
            return mapScanCursor;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public MapScanCursor<K, V> hscan(K key, ScanCursor scanCursor) {
        Span span = this.helper.buildSpan("hscan", key);
        try {
            MapScanCursor mapScanCursor = this.commands.hscan(key, scanCursor);
            return mapScanCursor;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public StreamScanCursor hscan(KeyValueStreamingChannel<K, V> channel, K key) {
        Span span = this.helper.buildSpan("hscan", key);
        try {
            StreamScanCursor streamScanCursor = this.commands.hscan(channel, key);
            return streamScanCursor;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public StreamScanCursor hscan(KeyValueStreamingChannel<K, V> channel, K key, ScanArgs scanArgs) {
        Span span = this.helper.buildSpan("hscan", key);
        try {
            StreamScanCursor streamScanCursor = this.commands.hscan(channel, key, scanArgs);
            return streamScanCursor;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public StreamScanCursor hscan(KeyValueStreamingChannel<K, V> channel, K key, ScanCursor scanCursor, ScanArgs scanArgs) {
        Span span = this.helper.buildSpan("hscan", key);
        try {
            StreamScanCursor streamScanCursor = this.commands.hscan(channel, key, scanCursor, scanArgs);
            return streamScanCursor;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public StreamScanCursor hscan(KeyValueStreamingChannel<K, V> channel, K key, ScanCursor scanCursor) {
        Span span = this.helper.buildSpan("hscan", key);
        try {
            StreamScanCursor streamScanCursor = this.commands.hscan(channel, key, scanCursor);
            return streamScanCursor;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Boolean hset(K key, K field, V value) {
        Span span = this.helper.buildSpan("hset", key);
        try {
            Boolean bl = this.commands.hset(key, field, value);
            return bl;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Boolean hsetnx(K key, K field, V value) {
        Span span = this.helper.buildSpan("hsetnx", key);
        try {
            Boolean bl = this.commands.hsetnx(key, field, value);
            return bl;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long hstrlen(K key, K field) {
        Span span = this.helper.buildSpan("hstrlen", key);
        try {
            Long l = this.commands.hstrlen(key, field);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<V> hvals(K key) {
        Span span = this.helper.buildSpan("hvals", key);
        try {
            List list = this.commands.hvals(key);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long hvals(ValueStreamingChannel<V> channel, K key) {
        Span span = this.helper.buildSpan("hvals", key);
        try {
            Long l = this.commands.hvals(channel, key);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long del(K ... keys) {
        Span span = this.helper.buildSpan("del", (Object[])keys);
        try {
            Long l = this.commands.del((Object[])keys);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long unlink(K ... keys) {
        Span span = this.helper.buildSpan("unlink", (Object[])keys);
        try {
            Long l = this.commands.unlink((Object[])keys);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public byte[] dump(K key) {
        Span span = this.helper.buildSpan("dump", key);
        try {
            byte[] byArray = this.commands.dump(key);
            return byArray;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long exists(K ... keys) {
        Span span = this.helper.buildSpan("exists", (Object[])keys);
        try {
            Long l = this.commands.exists((Object[])keys);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Boolean expire(K key, long seconds) {
        Span span = this.helper.buildSpan("expire", key);
        span.setTag("seconds", (Number)seconds);
        try {
            Boolean bl = this.commands.expire(key, seconds);
            return bl;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Boolean expireat(K key, Date timestamp) {
        Span span = this.helper.buildSpan("expireat", key);
        span.setTag("timestamp", TracingHelper.nullable((Object)timestamp));
        try {
            Boolean bl = this.commands.expireat(key, timestamp);
            return bl;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Boolean expireat(K key, long timestamp) {
        Span span = this.helper.buildSpan("expireat", key);
        span.setTag("timestamp", (Number)timestamp);
        try {
            Boolean bl = this.commands.expireat(key, timestamp);
            return bl;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<K> keys(K pattern) {
        Span span = this.helper.buildSpan("keys");
        span.setTag("pattern", TracingHelper.nullable(pattern));
        try {
            List list = this.commands.keys(pattern);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long keys(KeyStreamingChannel<K> channel, K pattern) {
        Span span = this.helper.buildSpan("keys");
        span.setTag("pattern", TracingHelper.nullable(pattern));
        try {
            Long l = this.commands.keys(channel, pattern);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String migrate(String host, int port, K key, int db, long timeout) {
        Span span = this.helper.buildSpan("migrate", key);
        span.setTag("host", host);
        span.setTag("port", (Number)port);
        span.setTag("db", (Number)db);
        span.setTag("timeout", (Number)timeout);
        try {
            String string = this.commands.migrate(host, port, key, db, timeout);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String migrate(String host, int port, int db, long timeout, MigrateArgs<K> migrateArgs) {
        Span span = this.helper.buildSpan("migrate");
        span.setTag("host", host);
        span.setTag("port", (Number)port);
        span.setTag("db", (Number)db);
        span.setTag("timeout", (Number)timeout);
        try {
            String string = this.commands.migrate(host, port, db, timeout, migrateArgs);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Boolean move(K key, int db) {
        Span span = this.helper.buildSpan("move", key);
        span.setTag("db", (Number)db);
        try {
            Boolean bl = this.commands.move(key, db);
            return bl;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String objectEncoding(K key) {
        Span span = this.helper.buildSpan("objectEncoding", key);
        try {
            String string = this.commands.objectEncoding(key);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long objectIdletime(K key) {
        Span span = this.helper.buildSpan("objectIdletime", key);
        try {
            Long l = this.commands.objectIdletime(key);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long objectRefcount(K key) {
        Span span = this.helper.buildSpan("objectRefcount", key);
        try {
            Long l = this.commands.objectRefcount(key);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Boolean persist(K key) {
        Span span = this.helper.buildSpan("persist", key);
        try {
            Boolean bl = this.commands.persist(key);
            return bl;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Boolean pexpire(K key, long milliseconds) {
        Span span = this.helper.buildSpan("pexpire", key);
        span.setTag("milliseconds", (Number)milliseconds);
        try {
            Boolean bl = this.commands.pexpire(key, milliseconds);
            return bl;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Boolean pexpireat(K key, Date timestamp) {
        Span span = this.helper.buildSpan("pexpireat", key);
        span.setTag("timestamp", timestamp == null ? "null" : timestamp.toString());
        try {
            Boolean bl = this.commands.pexpireat(key, timestamp);
            return bl;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Boolean pexpireat(K key, long timestamp) {
        Span span = this.helper.buildSpan("pexpireat", key);
        span.setTag("timestamp", (Number)timestamp);
        try {
            Boolean bl = this.commands.pexpireat(key, timestamp);
            return bl;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long pttl(K key) {
        Span span = this.helper.buildSpan("pttl", key);
        try {
            Long l = this.commands.pttl(key);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public V randomkey() {
        Span span = this.helper.buildSpan("randomkey");
        try {
            Object object = this.commands.randomkey();
            return (V)object;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String rename(K key, K newKey) {
        Span span = this.helper.buildSpan("rename", key);
        span.setTag("newKey", TracingHelper.nullable(newKey));
        try {
            String string = this.commands.rename(key, newKey);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Boolean renamenx(K key, K newKey) {
        Span span = this.helper.buildSpan("renamenx", key);
        span.setTag("newKey", TracingHelper.nullable(newKey));
        try {
            Boolean bl = this.commands.renamenx(key, newKey);
            return bl;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String restore(K key, long ttl, byte[] value) {
        Span span = this.helper.buildSpan("restore", key);
        span.setTag("ttl", (Number)ttl);
        try {
            String string = this.commands.restore(key, ttl, value);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String restore(K key, byte[] value, RestoreArgs args) {
        Span span = this.helper.buildSpan("restore", key);
        span.setTag("value", Arrays.toString(value));
        return (String)this.helper.decorate(span, () -> this.commands.restore(key, value, args));
    }

    public List<V> sort(K key) {
        Span span = this.helper.buildSpan("sort", key);
        try {
            List list = this.commands.sort(key);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long sort(ValueStreamingChannel<V> channel, K key) {
        Span span = this.helper.buildSpan("sort", key);
        try {
            Long l = this.commands.sort(channel, key);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<V> sort(K key, SortArgs sortArgs) {
        Span span = this.helper.buildSpan("sort", key);
        try {
            List list = this.commands.sort(key, sortArgs);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long sort(ValueStreamingChannel<V> channel, K key, SortArgs sortArgs) {
        Span span = this.helper.buildSpan("sort", key);
        try {
            Long l = this.commands.sort(channel, key, sortArgs);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long sortStore(K key, SortArgs sortArgs, K destination) {
        Span span = this.helper.buildSpan("sortStore", key);
        try {
            Long l = this.commands.sortStore(key, sortArgs, destination);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long touch(K ... keys) {
        Span span = this.helper.buildSpan("touch", (Object[])keys);
        try {
            Long l = this.commands.touch((Object[])keys);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long ttl(K key) {
        Span span = this.helper.buildSpan("ttl", key);
        try {
            Long l = this.commands.ttl(key);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String type(K key) {
        Span span = this.helper.buildSpan("type", key);
        try {
            String string = this.commands.type(key);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public KeyScanCursor<K> scan() {
        Span span = this.helper.buildSpan("scan");
        try {
            KeyScanCursor keyScanCursor = this.commands.scan();
            return keyScanCursor;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public KeyScanCursor<K> scan(ScanArgs scanArgs) {
        Span span = this.helper.buildSpan("scan");
        try {
            KeyScanCursor keyScanCursor = this.commands.scan(scanArgs);
            return keyScanCursor;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public KeyScanCursor<K> scan(ScanCursor scanCursor, ScanArgs scanArgs) {
        Span span = this.helper.buildSpan("scan");
        try {
            KeyScanCursor keyScanCursor = this.commands.scan(scanCursor, scanArgs);
            return keyScanCursor;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public KeyScanCursor<K> scan(ScanCursor scanCursor) {
        Span span = this.helper.buildSpan("scan");
        try {
            KeyScanCursor keyScanCursor = this.commands.scan(scanCursor);
            return keyScanCursor;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public StreamScanCursor scan(KeyStreamingChannel<K> channel) {
        Span span = this.helper.buildSpan("scan");
        try {
            StreamScanCursor streamScanCursor = this.commands.scan(channel);
            return streamScanCursor;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public StreamScanCursor scan(KeyStreamingChannel<K> channel, ScanArgs scanArgs) {
        Span span = this.helper.buildSpan("scan");
        try {
            StreamScanCursor streamScanCursor = this.commands.scan(channel, scanArgs);
            return streamScanCursor;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public StreamScanCursor scan(KeyStreamingChannel<K> channel, ScanCursor scanCursor, ScanArgs scanArgs) {
        Span span = this.helper.buildSpan("scan");
        try {
            StreamScanCursor streamScanCursor = this.commands.scan(channel, scanCursor, scanArgs);
            return streamScanCursor;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public StreamScanCursor scan(KeyStreamingChannel<K> channel, ScanCursor scanCursor) {
        Span span = this.helper.buildSpan("scan");
        try {
            StreamScanCursor streamScanCursor = this.commands.scan(channel, scanCursor);
            return streamScanCursor;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long append(K key, V value) {
        Span span = this.helper.buildSpan("append", key);
        try {
            Long l = this.commands.append(key, value);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long bitcount(K key) {
        Span span = this.helper.buildSpan("bitcount", key);
        try {
            Long l = this.commands.bitcount(key);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long bitcount(K key, long start, long end) {
        Span span = this.helper.buildSpan("bitcount", key);
        span.setTag("start", (Number)start);
        span.setTag("end", (Number)end);
        try {
            Long l = this.commands.bitcount(key, start, end);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<Long> bitfield(K key, BitFieldArgs bitFieldArgs) {
        Span span = this.helper.buildSpan("bitfield", key);
        try {
            List list = this.commands.bitfield(key, bitFieldArgs);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long bitpos(K key, boolean state) {
        Span span = this.helper.buildSpan("bitpos", key);
        span.setTag("state", state);
        try {
            Long l = this.commands.bitpos(key, state);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long bitpos(K key, boolean state, long start) {
        Span span = this.helper.buildSpan("bitpos", key);
        span.setTag("state", state);
        span.setTag("start", (Number)start);
        try {
            Long l = this.commands.bitpos(key, state, start);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long bitpos(K key, boolean state, long start, long end) {
        Span span = this.helper.buildSpan("bitpos", key);
        span.setTag("state", state);
        span.setTag("start", (Number)start);
        span.setTag("end", (Number)end);
        try {
            Long l = this.commands.bitpos(key, state, start, end);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long bitopAnd(K destination, K ... keys) {
        Span span = this.helper.buildSpan("bitopAnd", (Object[])keys);
        try {
            Long l = this.commands.bitopAnd(destination, (Object[])keys);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long bitopNot(K destination, K source) {
        Span span = this.helper.buildSpan("bitopNot");
        try {
            Long l = this.commands.bitopNot(destination, source);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long bitopOr(K destination, K ... keys) {
        Span span = this.helper.buildSpan("bitopOr", (Object[])keys);
        try {
            Long l = this.commands.bitopOr(destination, (Object[])keys);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long bitopXor(K destination, K ... keys) {
        Span span = this.helper.buildSpan("bitopXor", (Object[])keys);
        try {
            Long l = this.commands.bitopXor(destination, (Object[])keys);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long decr(K key) {
        Span span = this.helper.buildSpan("decr", key);
        try {
            Long l = this.commands.decr(key);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long decrby(K key, long amount) {
        Span span = this.helper.buildSpan("decrby", key);
        span.setTag("amount", (Number)amount);
        try {
            Long l = this.commands.decrby(key, amount);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public V get(K key) {
        Span span = this.helper.buildSpan("get", key);
        try {
            Object object = this.commands.get(key);
            return (V)object;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long getbit(K key, long offset) {
        Span span = this.helper.buildSpan("getbit", key);
        span.setTag("offset", (Number)offset);
        try {
            Long l = this.commands.getbit(key, offset);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public V getrange(K key, long start, long end) {
        Span span = this.helper.buildSpan("getrange", key);
        span.setTag("start", (Number)start);
        span.setTag("end", (Number)end);
        try {
            Object object = this.commands.getrange(key, start, end);
            return (V)object;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public V getset(K key, V value) {
        Span span = this.helper.buildSpan("getset", key);
        try {
            Object object = this.commands.getset(key, value);
            return (V)object;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long incr(K key) {
        Span span = this.helper.buildSpan("incr", key);
        try {
            Long l = this.commands.incr(key);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long incrby(K key, long amount) {
        Span span = this.helper.buildSpan("incrby", key);
        span.setTag("amount", (Number)amount);
        try {
            Long l = this.commands.incrby(key, amount);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Double incrbyfloat(K key, double amount) {
        Span span = this.helper.buildSpan("incrbyfloat", key);
        span.setTag("amount", (Number)amount);
        try {
            Double d = this.commands.incrbyfloat(key, amount);
            return d;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<KeyValue<K, V>> mget(K ... keys) {
        Span span = this.helper.buildSpan("mget", (Object[])keys);
        try {
            List list = this.commands.mget((Object[])keys);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long mget(KeyValueStreamingChannel<K, V> channel, K ... keys) {
        Span span = this.helper.buildSpan("mget", (Object[])keys);
        try {
            Long l = this.commands.mget(channel, (Object[])keys);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String mset(Map<K, V> map) {
        Span span = this.helper.buildSpan("mset");
        try {
            String string = this.commands.mset(map);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Boolean msetnx(Map<K, V> map) {
        Span span = this.helper.buildSpan("msetnx");
        try {
            Boolean bl = this.commands.msetnx(map);
            return bl;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String set(K key, V value) {
        Span span = this.helper.buildSpan("set", key);
        try {
            String string = this.commands.set(key, value);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String set(K key, V value, SetArgs setArgs) {
        Span span = this.helper.buildSpan("set", key);
        try {
            String string = this.commands.set(key, value, setArgs);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long setbit(K key, long offset, int value) {
        Span span = this.helper.buildSpan("setbit", key);
        span.setTag("offset", (Number)offset);
        span.setTag("value", (Number)value);
        try {
            Long l = this.commands.setbit(key, offset, value);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String setex(K key, long seconds, V value) {
        Span span = this.helper.buildSpan("setex", key);
        span.setTag("seconds", (Number)seconds);
        try {
            String string = this.commands.setex(key, seconds, value);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String psetex(K key, long milliseconds, V value) {
        Span span = this.helper.buildSpan("psetex", key);
        span.setTag("milliseconds", (Number)milliseconds);
        try {
            String string = this.commands.psetex(key, milliseconds, value);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Boolean setnx(K key, V value) {
        Span span = this.helper.buildSpan("setnx", key);
        try {
            Boolean bl = this.commands.setnx(key, value);
            return bl;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long setrange(K key, long offset, V value) {
        Span span = this.helper.buildSpan("setrange", key);
        span.setTag("offset", (Number)offset);
        try {
            Long l = this.commands.setrange(key, offset, value);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long strlen(K key) {
        Span span = this.helper.buildSpan("strlen", key);
        try {
            Long l = this.commands.strlen(key);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public KeyValue<K, V> blpop(long timeout, K ... keys) {
        Span span = this.helper.buildSpan("blpop", (Object[])keys);
        span.setTag("timeout", (Number)timeout);
        try {
            KeyValue keyValue = this.commands.blpop(timeout, (Object[])keys);
            return keyValue;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public KeyValue<K, V> brpop(long timeout, K ... keys) {
        Span span = this.helper.buildSpan("brpop", (Object[])keys);
        span.setTag("timeout", (Number)timeout);
        try {
            KeyValue keyValue = this.commands.brpop(timeout, (Object[])keys);
            return keyValue;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public V brpoplpush(long timeout, K source, K destination) {
        Span span = this.helper.buildSpan("brpoplpush");
        span.setTag("timeout", (Number)timeout);
        try {
            Object object = this.commands.brpoplpush(timeout, source, destination);
            return (V)object;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public V lindex(K key, long index) {
        Span span = this.helper.buildSpan("lindex", key);
        span.setTag("index", (Number)index);
        try {
            Object object = this.commands.lindex(key, index);
            return (V)object;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long linsert(K key, boolean before, V pivot, V value) {
        Span span = this.helper.buildSpan("linsert", key);
        span.setTag("before", before);
        try {
            Long l = this.commands.linsert(key, before, pivot, value);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long llen(K key) {
        Span span = this.helper.buildSpan("llen", key);
        try {
            Long l = this.commands.llen(key);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public V lpop(K key) {
        Span span = this.helper.buildSpan("lpop", key);
        try {
            Object object = this.commands.lpop(key);
            return (V)object;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long lpush(K key, V ... values) {
        Span span = this.helper.buildSpan("lpush", key);
        try {
            Long l = this.commands.lpush(key, (Object[])values);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long lpushx(K key, V ... values) {
        Span span = this.helper.buildSpan("lpushx", key);
        try {
            Long l = this.commands.lpushx(key, (Object[])values);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<V> lrange(K key, long start, long stop) {
        Span span = this.helper.buildSpan("lrange", key);
        span.setTag("start", (Number)start);
        span.setTag("stop", (Number)stop);
        try {
            List list = this.commands.lrange(key, start, stop);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long lrange(ValueStreamingChannel<V> channel, K key, long start, long stop) {
        Span span = this.helper.buildSpan("lrange", key);
        span.setTag("start", (Number)start);
        span.setTag("stop", (Number)stop);
        try {
            Long l = this.commands.lrange(channel, key, start, stop);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long lrem(K key, long count, V value) {
        Span span = this.helper.buildSpan("lrem", key);
        span.setTag("count", (Number)count);
        try {
            Long l = this.commands.lrem(key, count, value);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String lset(K key, long index, V value) {
        Span span = this.helper.buildSpan("lset", key);
        span.setTag("index", (Number)index);
        try {
            String string = this.commands.lset(key, index, value);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String ltrim(K key, long start, long stop) {
        Span span = this.helper.buildSpan("ltrim", key);
        span.setTag("start", (Number)start);
        span.setTag("stop", (Number)stop);
        try {
            String string = this.commands.ltrim(key, start, stop);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public V rpop(K key) {
        Span span = this.helper.buildSpan("rpop", key);
        try {
            Object object = this.commands.rpop(key);
            return (V)object;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public V rpoplpush(K source, K destination) {
        Span span = this.helper.buildSpan("rpoplpush");
        try {
            Object object = this.commands.rpoplpush(source, destination);
            return (V)object;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long rpush(K key, V ... values) {
        Span span = this.helper.buildSpan("rpush", key);
        try {
            Long l = this.commands.rpush(key, (Object[])values);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long rpushx(K key, V ... values) {
        Span span = this.helper.buildSpan("rpushx", key);
        try {
            Long l = this.commands.rpushx(key, (Object[])values);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long sadd(K key, V ... members) {
        Span span = this.helper.buildSpan("sadd", key);
        try {
            Long l = this.commands.sadd(key, (Object[])members);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long scard(K key) {
        Span span = this.helper.buildSpan("scard", key);
        try {
            Long l = this.commands.scard(key);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Set<V> sdiff(K ... keys) {
        Span span = this.helper.buildSpan("sdiff", (Object[])keys);
        try {
            Set set = this.commands.sdiff((Object[])keys);
            return set;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long sdiff(ValueStreamingChannel<V> channel, K ... keys) {
        Span span = this.helper.buildSpan("sdiff", (Object[])keys);
        try {
            Long l = this.commands.sdiff(channel, (Object[])keys);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long sdiffstore(K destination, K ... keys) {
        Span span = this.helper.buildSpan("sdiffstore", (Object[])keys);
        try {
            Long l = this.commands.sdiffstore(destination, (Object[])keys);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Set<V> sinter(K ... keys) {
        Span span = this.helper.buildSpan("sinter", (Object[])keys);
        try {
            Set set = this.commands.sinter((Object[])keys);
            return set;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long sinter(ValueStreamingChannel<V> channel, K ... keys) {
        Span span = this.helper.buildSpan("sinter", (Object[])keys);
        try {
            Long l = this.commands.sinter(channel, (Object[])keys);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long sinterstore(K destination, K ... keys) {
        Span span = this.helper.buildSpan("sinterstore", (Object[])keys);
        try {
            Long l = this.commands.sinterstore(destination, (Object[])keys);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Boolean sismember(K key, V member) {
        Span span = this.helper.buildSpan("sismember", key);
        try {
            Boolean bl = this.commands.sismember(key, member);
            return bl;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Boolean smove(K source, K destination, V member) {
        Span span = this.helper.buildSpan("smove");
        try {
            Boolean bl = this.commands.smove(source, destination, member);
            return bl;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Set<V> smembers(K key) {
        Span span = this.helper.buildSpan("smembers", key);
        try {
            Set set = this.commands.smembers(key);
            return set;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long smembers(ValueStreamingChannel<V> channel, K key) {
        Span span = this.helper.buildSpan("smembers", key);
        try {
            Long l = this.commands.smembers(channel, key);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public V spop(K key) {
        Span span = this.helper.buildSpan("spop", key);
        try {
            Object object = this.commands.spop(key);
            return (V)object;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Set<V> spop(K key, long count) {
        Span span = this.helper.buildSpan("spop", key);
        span.setTag("count", (Number)count);
        try {
            Set set = this.commands.spop(key, count);
            return set;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public V srandmember(K key) {
        Span span = this.helper.buildSpan("srandmember", key);
        try {
            Object object = this.commands.srandmember(key);
            return (V)object;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<V> srandmember(K key, long count) {
        Span span = this.helper.buildSpan("srandmember", key);
        span.setTag("count", (Number)count);
        try {
            List list = this.commands.srandmember(key, count);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long srandmember(ValueStreamingChannel<V> channel, K key, long count) {
        Span span = this.helper.buildSpan("srandmember", key);
        span.setTag("count", (Number)count);
        try {
            Long l = this.commands.srandmember(channel, key, count);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long srem(K key, V ... members) {
        Span span = this.helper.buildSpan("srem", key);
        try {
            Long l = this.commands.srem(key, (Object[])members);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Set<V> sunion(K ... keys) {
        Span span = this.helper.buildSpan("sunion", (Object[])keys);
        try {
            Set set = this.commands.sunion((Object[])keys);
            return set;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long sunion(ValueStreamingChannel<V> channel, K ... keys) {
        Span span = this.helper.buildSpan("sunion", (Object[])keys);
        try {
            Long l = this.commands.sunion(channel, (Object[])keys);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long sunionstore(K destination, K ... keys) {
        Span span = this.helper.buildSpan("sunionstore", (Object[])keys);
        try {
            Long l = this.commands.sunionstore(destination, (Object[])keys);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public ValueScanCursor<V> sscan(K key) {
        Span span = this.helper.buildSpan("sscan", key);
        try {
            ValueScanCursor valueScanCursor = this.commands.sscan(key);
            return valueScanCursor;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public ValueScanCursor<V> sscan(K key, ScanArgs scanArgs) {
        Span span = this.helper.buildSpan("sscan", key);
        try {
            ValueScanCursor valueScanCursor = this.commands.sscan(key, scanArgs);
            return valueScanCursor;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public ValueScanCursor<V> sscan(K key, ScanCursor scanCursor, ScanArgs scanArgs) {
        Span span = this.helper.buildSpan("sscan", key);
        try {
            ValueScanCursor valueScanCursor = this.commands.sscan(key, scanCursor, scanArgs);
            return valueScanCursor;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public ValueScanCursor<V> sscan(K key, ScanCursor scanCursor) {
        Span span = this.helper.buildSpan("sscan", key);
        try {
            ValueScanCursor valueScanCursor = this.commands.sscan(key, scanCursor);
            return valueScanCursor;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public StreamScanCursor sscan(ValueStreamingChannel<V> channel, K key) {
        Span span = this.helper.buildSpan("sscan", key);
        try {
            StreamScanCursor streamScanCursor = this.commands.sscan(channel, key);
            return streamScanCursor;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public StreamScanCursor sscan(ValueStreamingChannel<V> channel, K key, ScanArgs scanArgs) {
        Span span = this.helper.buildSpan("sscan", key);
        try {
            StreamScanCursor streamScanCursor = this.commands.sscan(channel, key, scanArgs);
            return streamScanCursor;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public StreamScanCursor sscan(ValueStreamingChannel<V> channel, K key, ScanCursor scanCursor, ScanArgs scanArgs) {
        Span span = this.helper.buildSpan("sscan", key);
        try {
            StreamScanCursor streamScanCursor = this.commands.sscan(channel, key, scanCursor, scanArgs);
            return streamScanCursor;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public StreamScanCursor sscan(ValueStreamingChannel<V> channel, K key, ScanCursor scanCursor) {
        Span span = this.helper.buildSpan("sscan", key);
        try {
            StreamScanCursor streamScanCursor = this.commands.sscan(channel, key, scanCursor);
            return streamScanCursor;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public KeyValue<K, ScoredValue<V>> bzpopmin(long timeout, K ... keys) {
        Span span = this.helper.buildSpan("bzpopmin", (Object[])keys);
        span.setTag("timeout", (Number)timeout);
        return (KeyValue)this.helper.decorate(span, () -> this.commands.bzpopmin(timeout, keys));
    }

    public KeyValue<K, ScoredValue<V>> bzpopmax(long timeout, K ... keys) {
        Span span = this.helper.buildSpan("bzpopmax", (Object[])keys);
        span.setTag("timeout", (Number)timeout);
        return (KeyValue)this.helper.decorate(span, () -> this.commands.bzpopmax(timeout, keys));
    }

    public Long zadd(K key, double score, V member) {
        Span span = this.helper.buildSpan("zadd", key);
        span.setTag("score", (Number)score);
        try {
            Long l = this.commands.zadd(key, score, member);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zadd(K key, Object ... scoresAndValues) {
        Span span = this.helper.buildSpan("zadd", key);
        try {
            Long l = this.commands.zadd(key, scoresAndValues);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zadd(K key, ScoredValue<V> ... scoredValues) {
        Span span = this.helper.buildSpan("zadd", key);
        try {
            Long l = this.commands.zadd(key, scoredValues);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zadd(K key, ZAddArgs zAddArgs, double score, V member) {
        Span span = this.helper.buildSpan("zadd", key);
        span.setTag("score", (Number)score);
        try {
            Long l = this.commands.zadd(key, zAddArgs, score, member);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zadd(K key, ZAddArgs zAddArgs, Object ... scoresAndValues) {
        Span span = this.helper.buildSpan("zadd", key);
        try {
            Long l = this.commands.zadd(key, zAddArgs, scoresAndValues);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zadd(K key, ZAddArgs zAddArgs, ScoredValue<V> ... scoredValues) {
        Span span = this.helper.buildSpan("zadd", key);
        try {
            Long l = this.commands.zadd(key, zAddArgs, scoredValues);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Double zaddincr(K key, double score, V member) {
        Span span = this.helper.buildSpan("zaddincr", key);
        span.setTag("score", (Number)score);
        try {
            Double d = this.commands.zaddincr(key, score, member);
            return d;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Double zaddincr(K key, ZAddArgs zAddArgs, double score, V member) {
        Span span = this.helper.buildSpan("zaddincr", key);
        span.setTag("score", (Number)score);
        try {
            Double d = this.commands.zaddincr(key, zAddArgs, score, member);
            return d;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zcard(K key) {
        Span span = this.helper.buildSpan("zcard", key);
        try {
            Long l = this.commands.zcard(key);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    @Deprecated
    public Long zcount(K key, double min, double max) {
        Span span = this.helper.buildSpan("zcount", key);
        span.setTag("min", (Number)min);
        span.setTag("max", (Number)max);
        try {
            Long l = this.commands.zcount(key, min, max);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    @Deprecated
    public Long zcount(K key, String min, String max) {
        Span span = this.helper.buildSpan("zcount", key);
        span.setTag("min", min);
        span.setTag("max", max);
        try {
            Long l = this.commands.zcount(key, min, max);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zcount(K key, Range<? extends Number> range) {
        Span span = this.helper.buildSpan("zcount", key);
        try {
            Long l = this.commands.zcount(key, range);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Double zincrby(K key, double amount, V member) {
        Span span = this.helper.buildSpan("zincrby", key);
        span.setTag("amount", (Number)amount);
        try {
            Double d = this.commands.zincrby(key, amount, member);
            return d;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zinterstore(K destination, K ... keys) {
        Span span = this.helper.buildSpan("zinterstore", (Object[])keys);
        try {
            Long l = this.commands.zinterstore(destination, (Object[])keys);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zinterstore(K destination, ZStoreArgs storeArgs, K ... keys) {
        Span span = this.helper.buildSpan("zinterstore", (Object[])keys);
        try {
            Long l = this.commands.zinterstore(destination, storeArgs, (Object[])keys);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    @Deprecated
    public Long zlexcount(K key, String min, String max) {
        Span span = this.helper.buildSpan("zlexcount", key);
        span.setTag("min", min);
        span.setTag("max", max);
        try {
            Long l = this.commands.zlexcount(key, min, max);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zlexcount(K key, Range<? extends V> range) {
        Span span = this.helper.buildSpan("zlexcount", key);
        span.setTag("range", range == null ? "null" : range.toString());
        try {
            Long l = this.commands.zlexcount(key, range);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public ScoredValue<V> zpopmin(K key) {
        Span span = this.helper.buildSpan("zpopmin", key);
        return (ScoredValue)this.helper.decorate(span, () -> this.commands.zpopmin(key));
    }

    public List<ScoredValue<V>> zpopmin(K key, long count) {
        Span span = this.helper.buildSpan("zpopmin", key);
        span.setTag("count", (Number)count);
        return (List)this.helper.decorate(span, () -> this.commands.zpopmin(key, count));
    }

    public ScoredValue<V> zpopmax(K key) {
        Span span = this.helper.buildSpan("zpopmax", key);
        return (ScoredValue)this.helper.decorate(span, () -> this.commands.zpopmax(key));
    }

    public List<ScoredValue<V>> zpopmax(K key, long count) {
        Span span = this.helper.buildSpan("zpopmax", key);
        span.setTag("count", (Number)count);
        return (List)this.helper.decorate(span, () -> this.commands.zpopmax(key, count));
    }

    public List<V> zrange(K key, long start, long stop) {
        Span span = this.helper.buildSpan("zrange", key);
        span.setTag("start", (Number)start);
        span.setTag("stop", (Number)stop);
        try {
            List list = this.commands.zrange(key, start, stop);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zrange(ValueStreamingChannel<V> channel, K key, long start, long stop) {
        Span span = this.helper.buildSpan("zrange", key);
        span.setTag("start", (Number)start);
        span.setTag("stop", (Number)stop);
        try {
            Long l = this.commands.zrange(channel, key, start, stop);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<ScoredValue<V>> zrangeWithScores(K key, long start, long stop) {
        Span span = this.helper.buildSpan("zrangeWithScores", key);
        span.setTag("start", (Number)start);
        span.setTag("stop", (Number)stop);
        try {
            List list = this.commands.zrangeWithScores(key, start, stop);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zrangeWithScores(ScoredValueStreamingChannel<V> channel, K key, long start, long stop) {
        Span span = this.helper.buildSpan("zrangeWithScores", key);
        span.setTag("start", (Number)start);
        span.setTag("stop", (Number)stop);
        try {
            Long l = this.commands.zrangeWithScores(channel, key, start, stop);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    @Deprecated
    public List<V> zrangebylex(K key, String min, String max) {
        Span span = this.helper.buildSpan("zrangebylex", key);
        span.setTag("min", min);
        span.setTag("max", max);
        try {
            List list = this.commands.zrangebylex(key, min, max);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<V> zrangebylex(K key, Range<? extends V> range) {
        Span span = this.helper.buildSpan("zrangebylex", key);
        span.setTag("range", range == null ? "null" : range.toString());
        try {
            List list = this.commands.zrangebylex(key, range);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    @Deprecated
    public List<V> zrangebylex(K key, String min, String max, long offset, long count) {
        Span span = this.helper.buildSpan("zrangebylex", key);
        span.setTag("min", min);
        span.setTag("max", max);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        try {
            List list = this.commands.zrangebylex(key, min, max, offset, count);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<V> zrangebylex(K key, Range<? extends V> range, Limit limit) {
        Span span = this.helper.buildSpan("zrangebylex", key);
        span.setTag("range", range == null ? "null" : range.toString());
        span.setTag("limit", limit == null ? "null" : limit.toString());
        try {
            List list = this.commands.zrangebylex(key, range, limit);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    @Deprecated
    public List<V> zrangebyscore(K key, double min, double max) {
        Span span = this.helper.buildSpan("zrangebyscore", key);
        span.setTag("min", (Number)min);
        span.setTag("max", (Number)max);
        try {
            List list = this.commands.zrangebyscore(key, min, max);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    @Deprecated
    public List<V> zrangebyscore(K key, String min, String max) {
        Span span = this.helper.buildSpan("zrangebyscore", key);
        span.setTag("min", min);
        span.setTag("max", max);
        try {
            List list = this.commands.zrangebyscore(key, min, max);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<V> zrangebyscore(K key, Range<? extends Number> range) {
        Span span = this.helper.buildSpan("zrangebyscore", key);
        span.setTag("range", range == null ? "null" : range.toString());
        try {
            List list = this.commands.zrangebyscore(key, range);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    @Deprecated
    public List<V> zrangebyscore(K key, double min, double max, long offset, long count) {
        Span span = this.helper.buildSpan("zrangebyscore", key);
        span.setTag("min", (Number)min);
        span.setTag("max", (Number)max);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        try {
            List list = this.commands.zrangebyscore(key, min, max, offset, count);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    @Deprecated
    public List<V> zrangebyscore(K key, String min, String max, long offset, long count) {
        Span span = this.helper.buildSpan("zrangebyscore", key);
        span.setTag("min", min);
        span.setTag("max", max);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        try {
            List list = this.commands.zrangebyscore(key, min, max, offset, count);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<V> zrangebyscore(K key, Range<? extends Number> range, Limit limit) {
        Span span = this.helper.buildSpan("zrangebyscore", key);
        span.setTag("range", range == null ? "null" : range.toString());
        span.setTag("limit", limit == null ? "null" : limit.toString());
        try {
            List list = this.commands.zrangebyscore(key, range, limit);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    @Deprecated
    public Long zrangebyscore(ValueStreamingChannel<V> channel, K key, double min, double max) {
        Span span = this.helper.buildSpan("zrangebyscore", key);
        span.setTag("min", (Number)min);
        span.setTag("max", (Number)max);
        try {
            Long l = this.commands.zrangebyscore(channel, key, min, max);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    @Deprecated
    public Long zrangebyscore(ValueStreamingChannel<V> channel, K key, String min, String max) {
        Span span = this.helper.buildSpan("zrangebyscore", key);
        span.setTag("min", min);
        span.setTag("max", max);
        try {
            Long l = this.commands.zrangebyscore(channel, key, min, max);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zrangebyscore(ValueStreamingChannel<V> channel, K key, Range<? extends Number> range) {
        Span span = this.helper.buildSpan("zrangebyscore", key);
        span.setTag("range", range == null ? "null" : range.toString());
        try {
            Long l = this.commands.zrangebyscore(channel, key, range);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    @Deprecated
    public Long zrangebyscore(ValueStreamingChannel<V> channel, K key, double min, double max, long offset, long count) {
        Span span = this.helper.buildSpan("zrangebyscore", key);
        span.setTag("min", (Number)min);
        span.setTag("max", (Number)max);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        try {
            Long l = this.commands.zrangebyscore(channel, key, min, max, offset, count);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    @Deprecated
    public Long zrangebyscore(ValueStreamingChannel<V> channel, K key, String min, String max, long offset, long count) {
        Span span = this.helper.buildSpan("zrangebyscore", key);
        span.setTag("min", min);
        span.setTag("max", max);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        try {
            Long l = this.commands.zrangebyscore(channel, key, min, max, offset, count);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zrangebyscore(ValueStreamingChannel<V> channel, K key, Range<? extends Number> range, Limit limit) {
        Span span = this.helper.buildSpan("zrangebyscore", key);
        span.setTag("range", range == null ? "null" : range.toString());
        span.setTag("limit", limit == null ? "null" : limit.toString());
        try {
            Long l = this.commands.zrangebyscore(channel, key, range, limit);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    @Deprecated
    public List<ScoredValue<V>> zrangebyscoreWithScores(K key, double min, double max) {
        Span span = this.helper.buildSpan("zrangebyscoreWithScores", key);
        span.setTag("min", (Number)min);
        span.setTag("max", (Number)max);
        try {
            List list = this.commands.zrangebyscoreWithScores(key, min, max);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    @Deprecated
    public List<ScoredValue<V>> zrangebyscoreWithScores(K key, String min, String max) {
        Span span = this.helper.buildSpan("zrangebyscoreWithScores", key);
        span.setTag("min", min);
        span.setTag("max", max);
        try {
            List list = this.commands.zrangebyscoreWithScores(key, min, max);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<ScoredValue<V>> zrangebyscoreWithScores(K key, Range<? extends Number> range) {
        Span span = this.helper.buildSpan("zrangebyscoreWithScores", key);
        span.setTag("range", range == null ? "null" : range.toString());
        try {
            List list = this.commands.zrangebyscoreWithScores(key, range);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    @Deprecated
    public List<ScoredValue<V>> zrangebyscoreWithScores(K key, double min, double max, long offset, long count) {
        Span span = this.helper.buildSpan("zrangebyscoreWithScores", key);
        span.setTag("min", (Number)min);
        span.setTag("max", (Number)max);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        try {
            List list = this.commands.zrangebyscoreWithScores(key, min, max, offset, count);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    @Deprecated
    public List<ScoredValue<V>> zrangebyscoreWithScores(K key, String min, String max, long offset, long count) {
        Span span = this.helper.buildSpan("zrangebyscoreWithScores", key);
        span.setTag("min", min);
        span.setTag("max", max);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        try {
            List list = this.commands.zrangebyscoreWithScores(key, min, max, offset, count);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<ScoredValue<V>> zrangebyscoreWithScores(K key, Range<? extends Number> range, Limit limit) {
        Span span = this.helper.buildSpan("zrangebyscoreWithScores", key);
        span.setTag("range", range == null ? "null" : range.toString());
        span.setTag("limit", limit == null ? "null" : limit.toString());
        try {
            List list = this.commands.zrangebyscoreWithScores(key, range, limit);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    @Deprecated
    public Long zrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, double min, double max) {
        Span span = this.helper.buildSpan("zrangebyscoreWithScores", key);
        span.setTag("min", (Number)min);
        span.setTag("max", (Number)max);
        try {
            Long l = this.commands.zrangebyscoreWithScores(channel, key, min, max);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    @Deprecated
    public Long zrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, String min, String max) {
        Span span = this.helper.buildSpan("zrangebyscoreWithScores", key);
        span.setTag("min", min);
        span.setTag("max", max);
        try {
            Long l = this.commands.zrangebyscoreWithScores(channel, key, min, max);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, Range<? extends Number> range) {
        Span span = this.helper.buildSpan("zrangebyscoreWithScores", key);
        span.setTag("range", range == null ? "null" : range.toString());
        try {
            Long l = this.commands.zrangebyscoreWithScores(channel, key, range);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    @Deprecated
    public Long zrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, double min, double max, long offset, long count) {
        Span span = this.helper.buildSpan("zrangebyscoreWithScores", key);
        span.setTag("min", (Number)min);
        span.setTag("max", (Number)max);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        try {
            Long l = this.commands.zrangebyscoreWithScores(channel, key, min, max, offset, count);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    @Deprecated
    public Long zrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, String min, String max, long offset, long count) {
        Span span = this.helper.buildSpan("zrangebyscoreWithScores", key);
        span.setTag("min", min);
        span.setTag("max", max);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        try {
            Long l = this.commands.zrangebyscoreWithScores(channel, key, min, max, offset, count);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, Range<? extends Number> range, Limit limit) {
        Span span = this.helper.buildSpan("zrangebyscoreWithScores", key);
        span.setTag("range", TracingHelper.nullable(range));
        span.setTag("limit", TracingHelper.nullable((Object)limit));
        try {
            Long l = this.commands.zrangebyscoreWithScores(channel, key, range, limit);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zrank(K key, V member) {
        Span span = this.helper.buildSpan("zrank", key);
        try {
            Long l = this.commands.zrank(key, member);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zrem(K key, V ... members) {
        Span span = this.helper.buildSpan("zrem", key);
        try {
            Long l = this.commands.zrem(key, (Object[])members);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    @Deprecated
    public Long zremrangebylex(K key, String min, String max) {
        Span span = this.helper.buildSpan("zremrangebylex", key);
        span.setTag("min", min);
        span.setTag("max", max);
        try {
            Long l = this.commands.zremrangebylex(key, min, max);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zremrangebylex(K key, Range<? extends V> range) {
        Span span = this.helper.buildSpan("zremrangebylex", key);
        span.setTag("range", TracingHelper.nullable(range));
        try {
            Long l = this.commands.zremrangebylex(key, range);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zremrangebyrank(K key, long start, long stop) {
        Span span = this.helper.buildSpan("zremrangebyrank", key);
        span.setTag("start", (Number)start);
        span.setTag("stop", (Number)stop);
        try {
            Long l = this.commands.zremrangebyrank(key, start, stop);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    @Deprecated
    public Long zremrangebyscore(K key, double min, double max) {
        Span span = this.helper.buildSpan("zremrangebyscore", key);
        span.setTag("min", (Number)min);
        span.setTag("max", (Number)max);
        try {
            Long l = this.commands.zremrangebyscore(key, min, max);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    @Deprecated
    public Long zremrangebyscore(K key, String min, String max) {
        Span span = this.helper.buildSpan("zremrangebyscore", key);
        span.setTag("min", min);
        span.setTag("max", max);
        try {
            Long l = this.commands.zremrangebyscore(key, min, max);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zremrangebyscore(K key, Range<? extends Number> range) {
        Span span = this.helper.buildSpan("zremrangebyscore", key);
        span.setTag("range", TracingHelper.nullable(range));
        try {
            Long l = this.commands.zremrangebyscore(key, range);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<V> zrevrange(K key, long start, long stop) {
        Span span = this.helper.buildSpan("zrevrange", key);
        span.setTag("start", (Number)start);
        span.setTag("stop", (Number)stop);
        try {
            List list = this.commands.zrevrange(key, start, stop);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zrevrange(ValueStreamingChannel<V> channel, K key, long start, long stop) {
        Span span = this.helper.buildSpan("zrevrange", key);
        span.setTag("start", (Number)start);
        span.setTag("stop", (Number)stop);
        try {
            Long l = this.commands.zrevrange(channel, key, start, stop);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<ScoredValue<V>> zrevrangeWithScores(K key, long start, long stop) {
        Span span = this.helper.buildSpan("zrevrangeWithScores", key);
        span.setTag("start", (Number)start);
        span.setTag("stop", (Number)stop);
        try {
            List list = this.commands.zrevrangeWithScores(key, start, stop);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zrevrangeWithScores(ScoredValueStreamingChannel<V> channel, K key, long start, long stop) {
        Span span = this.helper.buildSpan("zrevrangeWithScores", key);
        span.setTag("start", (Number)start);
        span.setTag("stop", (Number)stop);
        try {
            Long l = this.commands.zrevrangeWithScores(channel, key, start, stop);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<V> zrevrangebylex(K key, Range<? extends V> range) {
        Span span = this.helper.buildSpan("zrevrangebylex", key);
        span.setTag("range", TracingHelper.nullable(range));
        try {
            List list = this.commands.zrevrangebylex(key, range);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<V> zrevrangebylex(K key, Range<? extends V> range, Limit limit) {
        Span span = this.helper.buildSpan("zrevrangebylex", key);
        span.setTag("range", TracingHelper.nullable(range));
        span.setTag("limit", TracingHelper.nullable((Object)limit));
        try {
            List list = this.commands.zrevrangebylex(key, range, limit);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    @Deprecated
    public List<V> zrevrangebyscore(K key, double max, double min) {
        Span span = this.helper.buildSpan("zrevrangebyscore", key);
        span.setTag("max", (Number)max);
        span.setTag("min", (Number)min);
        try {
            List list = this.commands.zrevrangebyscore(key, max, min);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    @Deprecated
    public List<V> zrevrangebyscore(K key, String max, String min) {
        Span span = this.helper.buildSpan("zrevrangebyscore", key);
        span.setTag("max", max);
        span.setTag("min", min);
        try {
            List list = this.commands.zrevrangebyscore(key, max, min);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<V> zrevrangebyscore(K key, Range<? extends Number> range) {
        Span span = this.helper.buildSpan("zrevrangebyscore", key);
        span.setTag("range", TracingHelper.nullable(range));
        try {
            List list = this.commands.zrevrangebyscore(key, range);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    @Deprecated
    public List<V> zrevrangebyscore(K key, double max, double min, long offset, long count) {
        Span span = this.helper.buildSpan("zrevrangebyscore", key);
        span.setTag("max", (Number)max);
        span.setTag("min", (Number)min);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        try {
            List list = this.commands.zrevrangebyscore(key, max, min, offset, count);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    @Deprecated
    public List<V> zrevrangebyscore(K key, String max, String min, long offset, long count) {
        Span span = this.helper.buildSpan("zrevrangebyscore", key);
        span.setTag("max", max);
        span.setTag("min", min);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        try {
            List list = this.commands.zrevrangebyscore(key, max, min, offset, count);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<V> zrevrangebyscore(K key, Range<? extends Number> range, Limit limit) {
        Span span = this.helper.buildSpan("zrevrangebyscore", key);
        span.setTag("range", TracingHelper.nullable(range));
        span.setTag("limit", TracingHelper.nullable((Object)limit));
        try {
            List list = this.commands.zrevrangebyscore(key, range, limit);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    @Deprecated
    public Long zrevrangebyscore(ValueStreamingChannel<V> channel, K key, double max, double min) {
        Span span = this.helper.buildSpan("zrevrangebyscore", key);
        span.setTag("max", (Number)max);
        span.setTag("min", (Number)min);
        try {
            Long l = this.commands.zrevrangebyscore(channel, key, max, min);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    @Deprecated
    public Long zrevrangebyscore(ValueStreamingChannel<V> channel, K key, String max, String min) {
        Span span = this.helper.buildSpan("zrevrangebyscore", key);
        span.setTag("max", max);
        span.setTag("min", min);
        try {
            Long l = this.commands.zrevrangebyscore(channel, key, max, min);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zrevrangebyscore(ValueStreamingChannel<V> channel, K key, Range<? extends Number> range) {
        Span span = this.helper.buildSpan("zrevrangebyscore", key);
        span.setTag("range", TracingHelper.nullable(range));
        try {
            Long l = this.commands.zrevrangebyscore(channel, key, range);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    @Deprecated
    public Long zrevrangebyscore(ValueStreamingChannel<V> channel, K key, double max, double min, long offset, long count) {
        Span span = this.helper.buildSpan("zrevrangebyscore", key);
        span.setTag("max", (Number)max);
        span.setTag("min", (Number)min);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        try {
            Long l = this.commands.zrevrangebyscore(channel, key, max, min, offset, count);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    @Deprecated
    public Long zrevrangebyscore(ValueStreamingChannel<V> channel, K key, String max, String min, long offset, long count) {
        Span span = this.helper.buildSpan("zrevrangebyscore", key);
        span.setTag("max", max);
        span.setTag("min", min);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        try {
            Long l = this.commands.zrevrangebyscore(channel, key, max, min, offset, count);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zrevrangebyscore(ValueStreamingChannel<V> channel, K key, Range<? extends Number> range, Limit limit) {
        Span span = this.helper.buildSpan("zrevrangebyscore", key);
        span.setTag("range", TracingHelper.nullable(range));
        span.setTag("limit", TracingHelper.nullable((Object)limit));
        try {
            Long l = this.commands.zrevrangebyscore(channel, key, range, limit);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    @Deprecated
    public List<ScoredValue<V>> zrevrangebyscoreWithScores(K key, double max, double min) {
        Span span = this.helper.buildSpan("zrevrangebyscoreWithScores", key);
        span.setTag("max", (Number)max);
        span.setTag("min", (Number)min);
        try {
            List list = this.commands.zrevrangebyscoreWithScores(key, max, min);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    @Deprecated
    public List<ScoredValue<V>> zrevrangebyscoreWithScores(K key, String max, String min) {
        Span span = this.helper.buildSpan("zrevrangebyscoreWithScores", key);
        span.setTag("max", max);
        span.setTag("min", min);
        try {
            List list = this.commands.zrevrangebyscoreWithScores(key, max, min);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<ScoredValue<V>> zrevrangebyscoreWithScores(K key, Range<? extends Number> range) {
        Span span = this.helper.buildSpan("zrevrangebyscoreWithScores", key);
        span.setTag("range", TracingHelper.nullable(range));
        try {
            List list = this.commands.zrevrangebyscoreWithScores(key, range);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    @Deprecated
    public List<ScoredValue<V>> zrevrangebyscoreWithScores(K key, double max, double min, long offset, long count) {
        Span span = this.helper.buildSpan("zrevrangebyscoreWithScores", key);
        span.setTag("max", (Number)max);
        span.setTag("min", (Number)min);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        try {
            List list = this.commands.zrevrangebyscoreWithScores(key, max, min, offset, count);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    @Deprecated
    public List<ScoredValue<V>> zrevrangebyscoreWithScores(K key, String max, String min, long offset, long count) {
        Span span = this.helper.buildSpan("zrevrangebyscoreWithScores", key);
        span.setTag("max", max);
        span.setTag("min", min);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        try {
            List list = this.commands.zrevrangebyscoreWithScores(key, max, min, offset, count);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<ScoredValue<V>> zrevrangebyscoreWithScores(K key, Range<? extends Number> range, Limit limit) {
        Span span = this.helper.buildSpan("zrevrangebyscoreWithScores", key);
        span.setTag("range", TracingHelper.nullable(range));
        span.setTag("limit", TracingHelper.nullable((Object)limit));
        try {
            List list = this.commands.zrevrangebyscoreWithScores(key, range, limit);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    @Deprecated
    public Long zrevrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, double max, double min) {
        Span span = this.helper.buildSpan("zrevrangebyscoreWithScores", key);
        span.setTag("max", (Number)max);
        span.setTag("min", (Number)min);
        try {
            Long l = this.commands.zrevrangebyscoreWithScores(channel, key, max, min);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    @Deprecated
    public Long zrevrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, String max, String min) {
        Span span = this.helper.buildSpan("zrevrangebyscoreWithScores", key);
        span.setTag("max", max);
        span.setTag("min", min);
        try {
            Long l = this.commands.zrevrangebyscoreWithScores(channel, key, max, min);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zrevrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, Range<? extends Number> range) {
        Span span = this.helper.buildSpan("zrevrangebyscoreWithScores", key);
        span.setTag("range", TracingHelper.nullable(range));
        try {
            Long l = this.commands.zrevrangebyscoreWithScores(channel, key, range);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    @Deprecated
    public Long zrevrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, double max, double min, long offset, long count) {
        Span span = this.helper.buildSpan("zrevrangebyscoreWithScores", key);
        span.setTag("max", (Number)max);
        span.setTag("min", (Number)min);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        try {
            Long l = this.commands.zrevrangebyscoreWithScores(channel, key, max, min, offset, count);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    @Deprecated
    public Long zrevrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, String max, String min, long offset, long count) {
        Span span = this.helper.buildSpan("zrevrangebyscoreWithScores", key);
        span.setTag("max", max);
        span.setTag("min", min);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        try {
            Long l = this.commands.zrevrangebyscoreWithScores(channel, key, max, min, offset, count);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zrevrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, Range<? extends Number> range, Limit limit) {
        Span span = this.helper.buildSpan("zrevrangebyscoreWithScores", key);
        span.setTag("range", TracingHelper.nullable(range));
        span.setTag("limit", TracingHelper.nullable((Object)limit));
        try {
            Long l = this.commands.zrevrangebyscoreWithScores(channel, key, range, limit);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zrevrank(K key, V member) {
        Span span = this.helper.buildSpan("zrevrank", key);
        try {
            Long l = this.commands.zrevrank(key, member);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public ScoredValueScanCursor<V> zscan(K key) {
        Span span = this.helper.buildSpan("zscan", key);
        try {
            ScoredValueScanCursor scoredValueScanCursor = this.commands.zscan(key);
            return scoredValueScanCursor;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public ScoredValueScanCursor<V> zscan(K key, ScanArgs scanArgs) {
        Span span = this.helper.buildSpan("zscan", key);
        try {
            ScoredValueScanCursor scoredValueScanCursor = this.commands.zscan(key, scanArgs);
            return scoredValueScanCursor;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public ScoredValueScanCursor<V> zscan(K key, ScanCursor scanCursor, ScanArgs scanArgs) {
        Span span = this.helper.buildSpan("zscan", key);
        try {
            ScoredValueScanCursor scoredValueScanCursor = this.commands.zscan(key, scanCursor, scanArgs);
            return scoredValueScanCursor;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public ScoredValueScanCursor<V> zscan(K key, ScanCursor scanCursor) {
        Span span = this.helper.buildSpan("zscan", key);
        try {
            ScoredValueScanCursor scoredValueScanCursor = this.commands.zscan(key, scanCursor);
            return scoredValueScanCursor;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public StreamScanCursor zscan(ScoredValueStreamingChannel<V> channel, K key) {
        Span span = this.helper.buildSpan("zscan", key);
        try {
            StreamScanCursor streamScanCursor = this.commands.zscan(channel, key);
            return streamScanCursor;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public StreamScanCursor zscan(ScoredValueStreamingChannel<V> channel, K key, ScanArgs scanArgs) {
        Span span = this.helper.buildSpan("zscan", key);
        try {
            StreamScanCursor streamScanCursor = this.commands.zscan(channel, key, scanArgs);
            return streamScanCursor;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public StreamScanCursor zscan(ScoredValueStreamingChannel<V> channel, K key, ScanCursor scanCursor, ScanArgs scanArgs) {
        Span span = this.helper.buildSpan("zscan", key);
        try {
            StreamScanCursor streamScanCursor = this.commands.zscan(channel, key, scanCursor, scanArgs);
            return streamScanCursor;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public StreamScanCursor zscan(ScoredValueStreamingChannel<V> channel, K key, ScanCursor scanCursor) {
        Span span = this.helper.buildSpan("zscan", key);
        try {
            StreamScanCursor streamScanCursor = this.commands.zscan(channel, key, scanCursor);
            return streamScanCursor;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Double zscore(K key, V member) {
        Span span = this.helper.buildSpan("zscore", key);
        try {
            Double d = this.commands.zscore(key, member);
            return d;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zunionstore(K destination, K ... keys) {
        Span span = this.helper.buildSpan("zunionstore", (Object[])keys);
        try {
            Long l = this.commands.zunionstore(destination, (Object[])keys);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long zunionstore(K destination, ZStoreArgs storeArgs, K ... keys) {
        Span span = this.helper.buildSpan("zunionstore", (Object[])keys);
        try {
            Long l = this.commands.zunionstore(destination, storeArgs, (Object[])keys);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long xack(K key, K group, String ... messageIds) {
        Span span = this.helper.buildSpan("xack", key);
        span.setTag("group", TracingHelper.nullable(group));
        span.setTag("messageIds", Arrays.toString(messageIds));
        return (Long)this.helper.decorate(span, () -> this.commands.xack(key, group, messageIds));
    }

    public String xadd(K key, Map<K, V> body) {
        Span span = this.helper.buildSpan("xadd", key);
        span.setTag("body", TracingHelper.mapToString(body));
        return (String)this.helper.decorate(span, () -> this.commands.xadd(key, body));
    }

    public String xadd(K key, XAddArgs args, Map<K, V> body) {
        Span span = this.helper.buildSpan("xadd", key);
        span.setTag("body", TracingHelper.mapToString(body));
        return (String)this.helper.decorate(span, () -> this.commands.xadd(key, args, body));
    }

    public String xadd(K key, Object ... keysAndValues) {
        Span span = this.helper.buildSpan("xadd", key);
        span.setTag("keysAndValues", Arrays.toString(keysAndValues));
        return (String)this.helper.decorate(span, () -> this.commands.xadd(key, keysAndValues));
    }

    public String xadd(K key, XAddArgs args, Object ... keysAndValues) {
        Span span = this.helper.buildSpan("xadd", key);
        span.setTag("keysAndValues", Arrays.toString(keysAndValues));
        return (String)this.helper.decorate(span, () -> this.commands.xadd(key, args, keysAndValues));
    }

    public List<StreamMessage<K, V>> xclaim(K key, Consumer<K> consumer, long minIdleTime, String ... messageIds) {
        Span span = this.helper.buildSpan("xclaim", key);
        span.setTag("minIdleTime", (Number)minIdleTime);
        span.setTag("consumer", TracingHelper.nullable(consumer));
        span.setTag("messageIds", Arrays.toString(messageIds));
        return (List)this.helper.decorate(span, () -> this.commands.xclaim(key, consumer, minIdleTime, messageIds));
    }

    public List<StreamMessage<K, V>> xclaim(K key, Consumer<K> consumer, XClaimArgs args, String ... messageIds) {
        Span span = this.helper.buildSpan("xclaim", key);
        span.setTag("consumer", TracingHelper.nullable(consumer));
        span.setTag("messageIds", Arrays.toString(messageIds));
        return (List)this.helper.decorate(span, () -> this.commands.xclaim(key, consumer, args, messageIds));
    }

    public Long xdel(K key, String ... messageIds) {
        Span span = this.helper.buildSpan("xdel", key);
        span.setTag("messageIds", Arrays.toString(messageIds));
        return (Long)this.helper.decorate(span, () -> this.commands.xdel(key, messageIds));
    }

    public String xgroupCreate(XReadArgs.StreamOffset<K> streamOffset, K group) {
        Span span = this.helper.buildSpan("xgroupCreate");
        span.setTag("streamOffset", TracingHelper.nullable(streamOffset));
        span.setTag("group", TracingHelper.nullable(group));
        return (String)this.helper.decorate(span, () -> this.commands.xgroupCreate(streamOffset, group));
    }

    public Boolean xgroupDelconsumer(K key, Consumer<K> consumer) {
        Span span = this.helper.buildSpan("xgroupDelconsumer", key);
        span.setTag("consumer", TracingHelper.nullable(consumer));
        return (Boolean)this.helper.decorate(span, () -> this.commands.xgroupDelconsumer(key, consumer));
    }

    public Boolean xgroupDestroy(K key, K group) {
        Span span = this.helper.buildSpan("xgroupDestroy", key);
        span.setTag("group", TracingHelper.nullable(group));
        return (Boolean)this.helper.decorate(span, () -> this.commands.xgroupDestroy(key, group));
    }

    public String xgroupSetid(XReadArgs.StreamOffset<K> streamOffset, K group) {
        Span span = this.helper.buildSpan("xgroupSetid");
        span.setTag("streamOffset", TracingHelper.nullable(streamOffset));
        span.setTag("group", TracingHelper.nullable(group));
        return (String)this.helper.decorate(span, () -> this.commands.xgroupSetid(streamOffset, group));
    }

    public Long xlen(K key) {
        Span span = this.helper.buildSpan("xlen", key);
        return (Long)this.helper.decorate(span, () -> this.commands.xlen(key));
    }

    public List<Object> xpending(K key, K group) {
        Span span = this.helper.buildSpan("xpending", key);
        span.setTag("group", TracingHelper.nullable(group));
        return (List)this.helper.decorate(span, () -> this.commands.xpending(key, group));
    }

    public List<Object> xpending(K key, K group, Range<String> range, Limit limit) {
        Span span = this.helper.buildSpan("xpending", key);
        span.setTag("group", TracingHelper.nullable(group));
        span.setTag("range", TracingHelper.nullable(range));
        span.setTag("limit", TracingHelper.nullable((Object)limit));
        return (List)this.helper.decorate(span, () -> this.commands.xpending(key, group, range, limit));
    }

    public List<Object> xpending(K key, Consumer<K> consumer, Range<String> range, Limit limit) {
        Span span = this.helper.buildSpan("xpending", key);
        span.setTag("consumer", TracingHelper.nullable(consumer));
        span.setTag("range", TracingHelper.nullable(range));
        span.setTag("limit", TracingHelper.nullable((Object)limit));
        return (List)this.helper.decorate(span, () -> this.commands.xpending(key, consumer, range, limit));
    }

    public List<StreamMessage<K, V>> xrange(K key, Range<String> range) {
        Span span = this.helper.buildSpan("xrange", key);
        span.setTag("range", TracingHelper.nullable(range));
        return (List)this.helper.decorate(span, () -> this.commands.xrange(key, range));
    }

    public List<StreamMessage<K, V>> xrange(K key, Range<String> range, Limit limit) {
        Span span = this.helper.buildSpan("xrange", key);
        span.setTag("range", TracingHelper.nullable(range));
        span.setTag("limit", TracingHelper.nullable((Object)limit));
        return (List)this.helper.decorate(span, () -> this.commands.xrange(key, range, limit));
    }

    public List<StreamMessage<K, V>> xread(XReadArgs.StreamOffset<K> ... streams) {
        Span span = this.helper.buildSpan("xread");
        span.setTag("streams", Arrays.toString(streams));
        return (List)this.helper.decorate(span, () -> this.commands.xread(streams));
    }

    public List<StreamMessage<K, V>> xread(XReadArgs args, XReadArgs.StreamOffset<K> ... streams) {
        Span span = this.helper.buildSpan("xread");
        span.setTag("streams", Arrays.toString(streams));
        return (List)this.helper.decorate(span, () -> this.commands.xread(args, streams));
    }

    public List<StreamMessage<K, V>> xreadgroup(Consumer<K> consumer, XReadArgs.StreamOffset<K> ... streams) {
        Span span = this.helper.buildSpan("xreadgroup");
        span.setTag("consumer", TracingHelper.nullable(consumer));
        span.setTag("streams", Arrays.toString(streams));
        return (List)this.helper.decorate(span, () -> this.commands.xreadgroup(consumer, streams));
    }

    public List<StreamMessage<K, V>> xreadgroup(Consumer<K> consumer, XReadArgs args, XReadArgs.StreamOffset<K> ... streams) {
        Span span = this.helper.buildSpan("xreadgroup");
        span.setTag("consumer", TracingHelper.nullable(consumer));
        span.setTag("streams", Arrays.toString(streams));
        return (List)this.helper.decorate(span, () -> this.commands.xreadgroup(consumer, args, streams));
    }

    public List<StreamMessage<K, V>> xrevrange(K key, Range<String> range) {
        Span span = this.helper.buildSpan("xrevrange", key);
        span.setTag("range", TracingHelper.nullable(range));
        return (List)this.helper.decorate(span, () -> this.commands.xrevrange(key, range));
    }

    public List<StreamMessage<K, V>> xrevrange(K key, Range<String> range, Limit limit) {
        Span span = this.helper.buildSpan("xrevrange", key);
        span.setTag("range", TracingHelper.nullable(range));
        span.setTag("limit", TracingHelper.nullable((Object)limit));
        return (List)this.helper.decorate(span, () -> this.commands.xrevrange(key, range, limit));
    }

    public Long xtrim(K key, long count) {
        Span span = this.helper.buildSpan("xtrim", key);
        span.setTag("count", (Number)count);
        return (Long)this.helper.decorate(span, () -> this.commands.xtrim(key, count));
    }

    public Long xtrim(K key, boolean approximateTrimming, long count) {
        Span span = this.helper.buildSpan("xtrim", key);
        span.setTag("approximateTrimming", approximateTrimming);
        span.setTag("count", (Number)count);
        return (Long)this.helper.decorate(span, () -> this.commands.xtrim(key, approximateTrimming, count));
    }

    public <T> T eval(String script, ScriptOutputType type, K ... keys) {
        Span span = this.helper.buildSpan("eval", (Object[])keys);
        try {
            Object object = this.commands.eval(script, type, (Object[])keys);
            return (T)object;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public <T> T eval(String script, ScriptOutputType type, K[] keys, V ... values) {
        Span span = this.helper.buildSpan("eval", (Object[])keys);
        try {
            Object object = this.commands.eval(script, type, (Object[])keys, (Object[])values);
            return (T)object;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public <T> T evalsha(String digest, ScriptOutputType type, K ... keys) {
        Span span = this.helper.buildSpan("evalsha", (Object[])keys);
        try {
            Object object = this.commands.evalsha(digest, type, (Object[])keys);
            return (T)object;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public <T> T evalsha(String digest, ScriptOutputType type, K[] keys, V ... values) {
        Span span = this.helper.buildSpan("evalsha", (Object[])keys);
        try {
            Object object = this.commands.evalsha(digest, type, (Object[])keys, (Object[])values);
            return (T)object;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<Boolean> scriptExists(String ... digests) {
        Span span = this.helper.buildSpan("scriptExists");
        try {
            List list = this.commands.scriptExists(digests);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String scriptFlush() {
        Span span = this.helper.buildSpan("scriptFlush");
        try {
            String string = this.commands.scriptFlush();
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String scriptKill() {
        Span span = this.helper.buildSpan("scriptKill");
        try {
            String string = this.commands.scriptKill();
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String scriptLoad(V script) {
        Span span = this.helper.buildSpan("scriptLoad");
        try {
            String string = this.commands.scriptLoad(script);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String digest(V script) {
        Span span = this.helper.buildSpan("digest");
        try {
            String string = this.commands.digest(script);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String bgrewriteaof() {
        Span span = this.helper.buildSpan("bgrewriteaof");
        try {
            String string = this.commands.bgrewriteaof();
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String bgsave() {
        Span span = this.helper.buildSpan("bgsave");
        try {
            String string = this.commands.bgsave();
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public K clientGetname() {
        Span span = this.helper.buildSpan("clientGetname");
        try {
            Object object = this.commands.clientGetname();
            return (K)object;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String clientSetname(K name) {
        Span span = this.helper.buildSpan("clientSetname");
        try {
            String string = this.commands.clientSetname(name);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String clientKill(String addr) {
        Span span = this.helper.buildSpan("clientKill");
        span.setTag("addr", addr);
        try {
            String string = this.commands.clientKill(addr);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long clientKill(KillArgs killArgs) {
        Span span = this.helper.buildSpan("clientKill");
        try {
            Long l = this.commands.clientKill(killArgs);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long clientUnblock(long id, UnblockType type) {
        Span span = this.helper.buildSpan("clientUnblock");
        span.setTag("id", (Number)id);
        span.setTag("type", TracingHelper.nullable((Object)type));
        return (Long)this.helper.decorate(span, () -> this.commands.clientUnblock(id, type));
    }

    public String clientPause(long timeout) {
        Span span = this.helper.buildSpan("clientPause");
        span.setTag("timeout", (Number)timeout);
        try {
            String string = this.commands.clientPause(timeout);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String clientList() {
        Span span = this.helper.buildSpan("clientList");
        try {
            String string = this.commands.clientList();
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<Object> command() {
        Span span = this.helper.buildSpan("command");
        try {
            List list = this.commands.command();
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<Object> commandInfo(String ... commands) {
        Span span = this.helper.buildSpan("commandInfo");
        try {
            List list = this.commands.commandInfo(commands);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<Object> commandInfo(CommandType ... commands) {
        Span span = this.helper.buildSpan("commandInfo");
        try {
            List list = this.commands.commandInfo(commands);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long commandCount() {
        Span span = this.helper.buildSpan("commandCount");
        try {
            Long l = this.commands.commandCount();
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Map<String, String> configGet(String parameter) {
        Span span = this.helper.buildSpan("configGet");
        span.setTag("parameter", parameter);
        try {
            Map map = this.commands.configGet(parameter);
            return map;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String configResetstat() {
        Span span = this.helper.buildSpan("configResetstat");
        try {
            String string = this.commands.configResetstat();
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String configRewrite() {
        Span span = this.helper.buildSpan("configRewrite");
        try {
            String string = this.commands.configRewrite();
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String configSet(String parameter, String value) {
        Span span = this.helper.buildSpan("configSet");
        span.setTag("parameter", parameter);
        try {
            String string = this.commands.configSet(parameter, value);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long dbsize() {
        Span span = this.helper.buildSpan("dbsize");
        try {
            Long l = this.commands.dbsize();
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String debugCrashAndRecover(Long delay) {
        Span span = this.helper.buildSpan("debugCrashAndRecover");
        span.setTag("delay", TracingHelper.nullable((Object)delay));
        try {
            String string = this.commands.debugCrashAndRecover(delay);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String debugHtstats(int db) {
        Span span = this.helper.buildSpan("debugHtstats");
        span.setTag("db", (Number)db);
        try {
            String string = this.commands.debugHtstats(db);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String debugObject(K key) {
        Span span = this.helper.buildSpan("debugObject", key);
        try {
            String string = this.commands.debugObject(key);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public void debugOom() {
        Span span = this.helper.buildSpan("debugOom");
        try {
            this.commands.debugOom();
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public void debugSegfault() {
        Span span = this.helper.buildSpan("debugSegfault");
        try {
            this.commands.debugSegfault();
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String debugReload() {
        Span span = this.helper.buildSpan("debugReload");
        try {
            String string = this.commands.debugReload();
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String debugRestart(Long delay) {
        Span span = this.helper.buildSpan("debugRestart");
        span.setTag("delay", TracingHelper.nullable((Object)delay));
        try {
            String string = this.commands.debugRestart(delay);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String debugSdslen(K key) {
        Span span = this.helper.buildSpan("debugSdslen", key);
        try {
            String string = this.commands.debugSdslen(key);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String flushall() {
        Span span = this.helper.buildSpan("flushall");
        try {
            String string = this.commands.flushall();
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String flushallAsync() {
        Span span = this.helper.buildSpan("flushallAsync");
        try {
            String string = this.commands.flushallAsync();
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String flushdb() {
        Span span = this.helper.buildSpan("flushdb");
        try {
            String string = this.commands.flushdb();
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String flushdbAsync() {
        Span span = this.helper.buildSpan("flushdbAsync");
        try {
            String string = this.commands.flushdbAsync();
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String info() {
        Span span = this.helper.buildSpan("info");
        try {
            String string = this.commands.info();
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String info(String section) {
        Span span = this.helper.buildSpan("info");
        span.setTag("section", section);
        try {
            String string = this.commands.info(section);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Date lastsave() {
        Span span = this.helper.buildSpan("lastsave");
        try {
            Date date = this.commands.lastsave();
            return date;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String save() {
        Span span = this.helper.buildSpan("save");
        try {
            String string = this.commands.save();
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public void shutdown(boolean save) {
        Span span = this.helper.buildSpan("save");
        span.setTag("save", save);
        try {
            this.commands.shutdown(save);
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String slaveof(String host, int port) {
        Span span = this.helper.buildSpan("slaveof");
        span.setTag("host", host);
        span.setTag("port", (Number)port);
        try {
            String string = this.commands.slaveof(host, port);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String slaveofNoOne() {
        Span span = this.helper.buildSpan("slaveofNoOne");
        try {
            String string = this.commands.slaveofNoOne();
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<Object> slowlogGet() {
        Span span = this.helper.buildSpan("slowlogGet");
        try {
            List list = this.commands.slowlogGet();
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<Object> slowlogGet(int count) {
        Span span = this.helper.buildSpan("slowlogGet");
        span.setTag("count", (Number)count);
        try {
            List list = this.commands.slowlogGet(count);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long slowlogLen() {
        Span span = this.helper.buildSpan("slowlogLen");
        try {
            Long l = this.commands.slowlogLen();
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String slowlogReset() {
        Span span = this.helper.buildSpan("slowlogReset");
        try {
            String string = this.commands.slowlogReset();
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<V> time() {
        Span span = this.helper.buildSpan("time");
        try {
            List list = this.commands.time();
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long pfadd(K key, V ... values) {
        Span span = this.helper.buildSpan("pfadd", key);
        try {
            Long l = this.commands.pfadd(key, (Object[])values);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String pfmerge(K destkey, K ... sourcekeys) {
        Span span = this.helper.buildSpan("pfmerge");
        try {
            String string = this.commands.pfmerge(destkey, (Object[])sourcekeys);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long pfcount(K ... keys) {
        Span span = this.helper.buildSpan("pfcount", (Object[])keys);
        try {
            Long l = this.commands.pfcount((Object[])keys);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long publish(K channel, V message) {
        Span span = this.helper.buildSpan("publish");
        try {
            Long l = this.commands.publish(channel, message);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<K> pubsubChannels() {
        Span span = this.helper.buildSpan("pubsubChannels");
        try {
            List list = this.commands.pubsubChannels();
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<K> pubsubChannels(K channel) {
        Span span = this.helper.buildSpan("pubsubChannels");
        try {
            List list = this.commands.pubsubChannels(channel);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Map<K, Long> pubsubNumsub(K ... channels) {
        Span span = this.helper.buildSpan("pubsubNumsub");
        try {
            Map map = this.commands.pubsubNumsub((Object[])channels);
            return map;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long pubsubNumpat() {
        Span span = this.helper.buildSpan("pubsubNumpat");
        try {
            Long l = this.commands.pubsubNumpat();
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public V echo(V msg) {
        Span span = this.helper.buildSpan("echo");
        try {
            Object object = this.commands.echo(msg);
            return (V)object;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<Object> role() {
        Span span = this.helper.buildSpan("role");
        try {
            List list = this.commands.role();
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String ping() {
        Span span = this.helper.buildSpan("ping");
        try {
            String string = this.commands.ping();
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String readOnly() {
        Span span = this.helper.buildSpan("readOnly");
        try {
            String string = this.commands.readOnly();
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String readWrite() {
        Span span = this.helper.buildSpan("readWrite");
        try {
            String string = this.commands.readWrite();
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String quit() {
        Span span = this.helper.buildSpan("quit");
        try {
            String string = this.commands.quit();
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long waitForReplication(int replicas, long timeout) {
        Span span = this.helper.buildSpan("waitForReplication");
        span.setTag("replicas", (Number)replicas);
        span.setTag("timeout", (Number)timeout);
        try {
            Long l = this.commands.waitForReplication(replicas, timeout);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public <T> T dispatch(ProtocolKeyword type, CommandOutput<K, V, T> output) {
        Span span = this.helper.buildSpan("dispatch");
        try {
            Object object = this.commands.dispatch(type, output);
            return (T)object;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public <T> T dispatch(ProtocolKeyword type, CommandOutput<K, V, T> output, CommandArgs<K, V> args) {
        Span span = this.helper.buildSpan("dispatch");
        try {
            Object object = this.commands.dispatch(type, output, args);
            return (T)object;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public boolean isOpen() {
        Span span = this.helper.buildSpan("isOpen");
        try {
            boolean bl = this.commands.isOpen();
            return bl;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public void reset() {
        Span span = this.helper.buildSpan("reset");
        try {
            this.commands.reset();
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public void setTimeout(Duration timeout) {
        Span span = this.helper.buildSpan("setTimeout");
        span.setTag("timeout", TracingHelper.nullable((Object)timeout));
        try {
            this.commands.setTimeout(timeout);
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    @Deprecated
    public void setTimeout(long timeout, TimeUnit unit) {
        Span span = this.helper.buildSpan("setTimeout");
        span.setTag("timeout", (Number)timeout);
        span.setTag("unit", TracingHelper.nullable((Object)((Object)unit)));
        try {
            this.commands.setTimeout(timeout, unit);
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String clusterBumpepoch() {
        Span span = this.helper.buildSpan("clusterBumpepoch");
        try {
            String string = this.commands.clusterBumpepoch();
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String clusterMeet(String ip, int port) {
        Span span = this.helper.buildSpan("clusterMeet");
        span.setTag("ip", ip);
        span.setTag("port", (Number)port);
        try {
            String string = this.commands.clusterMeet(ip, port);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String clusterForget(String nodeId) {
        Span span = this.helper.buildSpan("clusterForget");
        span.setTag("nodeId", nodeId);
        try {
            String string = this.commands.clusterForget(nodeId);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String clusterAddSlots(int ... slots) {
        Span span = this.helper.buildSpan("clusterAddSlots");
        span.setTag("slots", Arrays.toString(slots));
        try {
            String string = this.commands.clusterAddSlots(slots);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String clusterDelSlots(int ... slots) {
        Span span = this.helper.buildSpan("clusterDelSlots");
        span.setTag("slots", Arrays.toString(slots));
        try {
            String string = this.commands.clusterDelSlots(slots);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String clusterSetSlotNode(int slot, String nodeId) {
        Span span = this.helper.buildSpan("clusterSetSlotNode");
        span.setTag("slot", (Number)slot);
        span.setTag("nodeId", nodeId);
        try {
            String string = this.commands.clusterSetSlotNode(slot, nodeId);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String clusterSetSlotStable(int slot) {
        Span span = this.helper.buildSpan("clusterSetSlotStable");
        span.setTag("slot", (Number)slot);
        try {
            String string = this.commands.clusterSetSlotStable(slot);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String clusterSetSlotMigrating(int slot, String nodeId) {
        Span span = this.helper.buildSpan("clusterSetSlotMigrating");
        span.setTag("slot", (Number)slot);
        span.setTag("nodeId", nodeId);
        try {
            String string = this.commands.clusterSetSlotMigrating(slot, nodeId);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String clusterSetSlotImporting(int slot, String nodeId) {
        Span span = this.helper.buildSpan("clusterSetSlotImporting");
        span.setTag("slot", (Number)slot);
        span.setTag("nodeId", nodeId);
        try {
            String string = this.commands.clusterSetSlotImporting(slot, nodeId);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String clusterInfo() {
        Span span = this.helper.buildSpan("clusterInfo");
        try {
            String string = this.commands.clusterInfo();
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String clusterMyId() {
        Span span = this.helper.buildSpan("clusterMyId");
        try {
            String string = this.commands.clusterMyId();
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String clusterNodes() {
        Span span = this.helper.buildSpan("clusterNodes");
        try {
            String string = this.commands.clusterNodes();
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<String> clusterSlaves(String nodeId) {
        Span span = this.helper.buildSpan("clusterSlaves");
        span.setTag("nodeId", nodeId);
        try {
            List list = this.commands.clusterSlaves(nodeId);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<K> clusterGetKeysInSlot(int slot, int count) {
        Span span = this.helper.buildSpan("clusterGetKeysInSlot");
        span.setTag("slot", (Number)slot);
        span.setTag("count", (Number)count);
        try {
            List list = this.commands.clusterGetKeysInSlot(slot, count);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long clusterCountKeysInSlot(int slot) {
        Span span = this.helper.buildSpan("clusterCountKeysInSlot");
        span.setTag("slot", (Number)slot);
        try {
            Long l = this.commands.clusterCountKeysInSlot(slot);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long clusterCountFailureReports(String nodeId) {
        Span span = this.helper.buildSpan("clusterCountFailureReports");
        span.setTag("nodeId", nodeId);
        try {
            Long l = this.commands.clusterCountFailureReports(nodeId);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long clusterKeyslot(K key) {
        Span span = this.helper.buildSpan("clusterKeyslot");
        try {
            Long l = this.commands.clusterKeyslot(key);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String clusterSaveconfig() {
        Span span = this.helper.buildSpan("clusterSaveconfig");
        try {
            String string = this.commands.clusterSaveconfig();
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String clusterSetConfigEpoch(long configEpoch) {
        Span span = this.helper.buildSpan("clusterSetConfigEpoch");
        span.setTag("configEpoch", (Number)configEpoch);
        try {
            String string = this.commands.clusterSetConfigEpoch(configEpoch);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<Object> clusterSlots() {
        Span span = this.helper.buildSpan("clusterSlots");
        try {
            List list = this.commands.clusterSlots();
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String asking() {
        Span span = this.helper.buildSpan("asking");
        try {
            String string = this.commands.asking();
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String clusterReplicate(String nodeId) {
        Span span = this.helper.buildSpan("clusterReplicate");
        span.setTag("nodeId", nodeId);
        try {
            String string = this.commands.clusterReplicate(nodeId);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String clusterFailover(boolean force) {
        Span span = this.helper.buildSpan("clusterFailover");
        span.setTag("force", force);
        try {
            String string = this.commands.clusterFailover(force);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String clusterReset(boolean hard) {
        Span span = this.helper.buildSpan("clusterReset");
        span.setTag("hard", hard);
        try {
            String string = this.commands.clusterReset(hard);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String clusterFlushslots() {
        Span span = this.helper.buildSpan("clusterFlushslots");
        try {
            String string = this.commands.clusterFlushslots();
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long geoadd(K key, double longitude, double latitude, V member) {
        Span span = this.helper.buildSpan("geoadd", key);
        span.setTag("longitude", (Number)longitude);
        span.setTag("latitude", (Number)latitude);
        try {
            Long l = this.commands.geoadd(key, longitude, latitude, member);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long geoadd(K key, Object ... lngLatMember) {
        Span span = this.helper.buildSpan("geoadd", key);
        try {
            Long l = this.commands.geoadd(key, lngLatMember);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<Value<String>> geohash(K key, V ... members) {
        Span span = this.helper.buildSpan("geohash", key);
        try {
            List list = this.commands.geohash(key, (Object[])members);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Set<V> georadius(K key, double longitude, double latitude, double distance, GeoArgs.Unit unit) {
        Span span = this.helper.buildSpan("georadius", key);
        span.setTag("longitude", (Number)longitude);
        span.setTag("latitude", (Number)latitude);
        span.setTag("distance", (Number)distance);
        span.setTag("unit", TracingHelper.nullable((Object)unit));
        try {
            Set set = this.commands.georadius(key, longitude, latitude, distance, unit);
            return set;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<GeoWithin<V>> georadius(K key, double longitude, double latitude, double distance, GeoArgs.Unit unit, GeoArgs geoArgs) {
        Span span = this.helper.buildSpan("georadius", key);
        span.setTag("longitude", (Number)longitude);
        span.setTag("latitude", (Number)latitude);
        span.setTag("distance", (Number)distance);
        span.setTag("unit", TracingHelper.nullable((Object)unit));
        try {
            List list = this.commands.georadius(key, longitude, latitude, distance, unit, geoArgs);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long georadius(K key, double longitude, double latitude, double distance, GeoArgs.Unit unit, GeoRadiusStoreArgs<K> geoRadiusStoreArgs) {
        Span span = this.helper.buildSpan("georadius", key);
        span.setTag("longitude", (Number)longitude);
        span.setTag("latitude", (Number)latitude);
        span.setTag("distance", (Number)distance);
        span.setTag("unit", TracingHelper.nullable((Object)unit));
        try {
            Long l = this.commands.georadius(key, longitude, latitude, distance, unit, geoRadiusStoreArgs);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Set<V> georadiusbymember(K key, V member, double distance, GeoArgs.Unit unit) {
        Span span = this.helper.buildSpan("georadiusbymember", key);
        span.setTag("distance", (Number)distance);
        span.setTag("unit", TracingHelper.nullable((Object)unit));
        try {
            Set set = this.commands.georadiusbymember(key, member, distance, unit);
            return set;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<GeoWithin<V>> georadiusbymember(K key, V member, double distance, GeoArgs.Unit unit, GeoArgs geoArgs) {
        Span span = this.helper.buildSpan("georadiusbymember", key);
        span.setTag("distance", (Number)distance);
        span.setTag("unit", TracingHelper.nullable((Object)unit));
        try {
            List list = this.commands.georadiusbymember(key, member, distance, unit, geoArgs);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Long georadiusbymember(K key, V member, double distance, GeoArgs.Unit unit, GeoRadiusStoreArgs<K> geoRadiusStoreArgs) {
        Span span = this.helper.buildSpan("georadiusbymember", key);
        span.setTag("distance", (Number)distance);
        span.setTag("unit", TracingHelper.nullable((Object)unit));
        try {
            Long l = this.commands.georadiusbymember(key, member, distance, unit, geoRadiusStoreArgs);
            return l;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public List<GeoCoordinates> geopos(K key, V ... members) {
        Span span = this.helper.buildSpan("geopos", key);
        try {
            List list = this.commands.geopos(key, (Object[])members);
            return list;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public Double geodist(K key, V from, V to, GeoArgs.Unit unit) {
        Span span = this.helper.buildSpan("geodist", key);
        span.setTag("unit", TracingHelper.nullable((Object)unit));
        try {
            Double d = this.commands.geodist(key, from, to, unit);
            return d;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }
}

