/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.openshift.decorator;

import io.dekorate.doc.Description;
import io.dekorate.kubernetes.decorator.NamedResourceDecorator;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.openshift.api.model.DeploymentConfigSpecFluent;

@Description(value="Apply the number of replicas to the DeploymentConfigSpec.")
public class ApplyReplicasDecorator
extends NamedResourceDecorator<DeploymentConfigSpecFluent> {
    private final int replicas;

    public ApplyReplicasDecorator(int replicas) {
        super(ANY);
        this.replicas = replicas;
    }

    public ApplyReplicasDecorator(String deploymentName, int replicas) {
        super(deploymentName);
        this.replicas = replicas;
    }

    public void andThenVisit(DeploymentConfigSpecFluent deploymentSpec, ObjectMeta resourceMeta) {
        if (this.replicas > 0) {
            deploymentSpec.withReplicas(Integer.valueOf(this.replicas));
        }
    }
}

