/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.footnotes.internal;

import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ext.footnotes.Footnote;
import com.vladsch.flexmark.ext.footnotes.FootnoteBlock;
import com.vladsch.flexmark.ext.footnotes.FootnoteExtension;
import com.vladsch.flexmark.ext.footnotes.internal.FootnoteRepository;
import com.vladsch.flexmark.ext.footnotes.internal.FormatOptions;
import com.vladsch.flexmark.formatter.CustomNodeFormatter;
import com.vladsch.flexmark.formatter.internal.MarkdownWriter;
import com.vladsch.flexmark.formatter.internal.NodeFormatter;
import com.vladsch.flexmark.formatter.internal.NodeFormatterContext;
import com.vladsch.flexmark.formatter.internal.NodeFormatterFactory;
import com.vladsch.flexmark.formatter.internal.NodeFormattingHandler;
import com.vladsch.flexmark.formatter.internal.NodeRepositoryFormatter;
import com.vladsch.flexmark.util.format.options.ElementPlacement;
import com.vladsch.flexmark.util.format.options.ElementPlacementSort;
import com.vladsch.flexmark.util.options.DataHolder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class FootnoteNodeFormatter
extends NodeRepositoryFormatter<FootnoteRepository, FootnoteBlock, Footnote> {
    private final FormatOptions options;

    public FootnoteNodeFormatter(DataHolder options) {
        super(options);
        this.options = new FormatOptions(options);
    }

    public FootnoteRepository getRepository(DataHolder options) {
        return (FootnoteRepository)((Object)FootnoteExtension.FOOTNOTES.getFrom(options));
    }

    public ElementPlacement getReferencePlacement() {
        return this.options.footnotePlacement;
    }

    public ElementPlacementSort getReferenceSort() {
        return this.options.footnoteSort;
    }

    public void renderReferenceBlock(FootnoteBlock node, NodeFormatterContext context, MarkdownWriter markdown) {
        markdown.blankLine().append((CharSequence)"[^").append((CharSequence)node.getText()).append((CharSequence)"]: ");
        markdown.pushPrefix().addPrefix((CharSequence)"    ");
        context.renderChildren((Node)node);
        markdown.popPrefix();
        markdown.blankLine();
    }

    public Set<NodeFormattingHandler<?>> getNodeFormattingHandlers() {
        return new HashSet(Arrays.asList(new NodeFormattingHandler(Footnote.class, (CustomNodeFormatter)new CustomNodeFormatter<Footnote>(){

            public void render(Footnote node, NodeFormatterContext context, MarkdownWriter markdown) {
                FootnoteNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler(FootnoteBlock.class, (CustomNodeFormatter)new CustomNodeFormatter<FootnoteBlock>(){

            public void render(FootnoteBlock node, NodeFormatterContext context, MarkdownWriter markdown) {
                FootnoteNodeFormatter.this.render(node, context, markdown);
            }
        })));
    }

    public Set<Class<?>> getNodeClasses() {
        if (this.options.footnotePlacement != ElementPlacement.AS_IS && this.options.footnoteSort != ElementPlacementSort.SORT_UNUSED_LAST) {
            return null;
        }
        return new HashSet(Arrays.asList(Footnote.class));
    }

    private void render(FootnoteBlock node, NodeFormatterContext context, MarkdownWriter markdown) {
        this.renderReference((Node)node, context, markdown);
    }

    private void render(Footnote node, NodeFormatterContext context, MarkdownWriter markdown) {
        markdown.append((CharSequence)"[^");
        context.renderChildren((Node)node);
        markdown.append((CharSequence)"]");
    }

    public static class Factory
    implements NodeFormatterFactory {
        public NodeFormatter create(DataHolder options) {
            return new FootnoteNodeFormatter(options);
        }
    }
}

