/*
 * Decompiled with CFR 0.152.
 */
package com.rudikershaw.gitbuildhook.validation;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;

public abstract class GitRepositoryValidator
extends AbstractMojo {
    protected void validateGitRepository(MavenProject project) throws MojoFailureException {
        FileRepositoryBuilder repoBuilder = new FileRepositoryBuilder();
        repoBuilder.findGitDir(project.getBasedir());
        if (repoBuilder.getGitDir() != null) {
            try (Git git = Git.open((File)repoBuilder.getGitDir());){
                this.getLog().info((CharSequence)"Found the local git repository.");
            }
            catch (IOException e) {
                this.failBuildBecauseRepoCouldNotBeFound(e);
            }
        } else {
            this.failBuildBecauseRepoCouldNotBeFound(null);
        }
    }

    protected void failBuildBecauseRepoCouldNotBeFound(Exception e) throws MojoFailureException {
        String message = "Could not find or initialise a local git repository. A repository is required.";
        throw new MojoFailureException("Could not find or initialise a local git repository. A repository is required.", (Throwable)e);
    }
}

