/*
 * Decompiled with CFR 0.152.
 */
package com.rudikershaw.gitbuildhook;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;

@Mojo(name="initialize", defaultPhase=LifecyclePhase.INITIALIZE, threadSafe=true)
public class InitialiseMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;

    public void execute() throws MojoFailureException {
        if (!this.isGitRepoInitialised()) {
            this.initialiseGitRepository();
        } else {
            this.getLog().info((CharSequence)"A Git repository is already initialized.");
        }
    }

    private boolean isGitRepoInitialised() {
        FileRepositoryBuilder repoBuilder = new FileRepositoryBuilder();
        repoBuilder.findGitDir(this.project.getBasedir());
        return repoBuilder.getGitDir() != null;
    }

    private void initialiseGitRepository() throws MojoFailureException {
        try {
            Git.init().setDirectory(this.project.getBasedir()).call();
        }
        catch (GitAPIException e) {
            if (!this.isGitRepoInitialised()) {
                throw new MojoFailureException("Could not initialise a local git repository.", (Throwable)e);
            }
            this.getLog().warn((CharSequence)"Tried to initialize a Git repository, but a repository already exists.");
        }
    }
}

