/*
 * Decompiled with CFR 0.152.
 */
package com.rudikershaw.gitbuildhook;

import com.rudikershaw.gitbuildhook.validation.GitRepositoryValidator;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;

@Mojo(name="configure", defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true)
public class GitConfigMojo
extends GitRepositoryValidator {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(readonly=true)
    private Map<String, String> gitConfig;

    public void execute() throws MojoFailureException {
        this.validateGitRepository(this.project);
        FileRepositoryBuilder repoBuilder = new FileRepositoryBuilder();
        repoBuilder.findGitDir(this.project.getBasedir());
        try (Git git = Git.open((File)repoBuilder.getGitDir());){
            StoredConfig config = git.getRepository().getConfig();
            for (Map.Entry<String, String> entry : this.gitConfig.entrySet()) {
                String[] conf = this.stringToConfigArray(entry.getKey());
                config.setString(conf[0], conf[1], conf[2], entry.getValue());
                this.getLog().info((CharSequence)("Git config '" + entry.getKey() + "' set to - " + entry.getValue()));
            }
            config.save();
        }
        catch (IOException ioe) {
            this.failBuildBecauseRepoCouldNotBeFound(ioe);
        }
    }

    private String[] stringToConfigArray(String string) throws MojoFailureException {
        String[] split = string.split("\\.");
        int sections = 3;
        if (split.length > 3 || split.length < 2) {
            throw new MojoFailureException("Git config '" + string + "' must include 1-2 sections separated by stops.");
        }
        String name = split[split.length - 1];
        String subsection = split.length == 3 ? split[1] : null;
        String section = split[0];
        return new String[]{section, subsection, name};
    }
}

