/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.jmeter;

import com.lazerycode.jmeter.UtilityFunctions;
import com.lazerycode.jmeter.configuration.JMeterArgumentsArray;
import com.lazerycode.jmeter.configuration.JMeterPlugins;
import com.lazerycode.jmeter.configuration.JMeterProcessJVMSettings;
import com.lazerycode.jmeter.configuration.ProxyConfiguration;
import com.lazerycode.jmeter.configuration.RemoteConfiguration;
import com.lazerycode.jmeter.properties.PropertyHandler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.joda.time.format.DateTimeFormat;

public abstract class JMeterAbstractMojo
extends AbstractMojo {
    @Parameter
    protected List<String> testFilesIncluded;
    @Parameter
    protected List<String> testFilesExcluded;
    @Parameter(defaultValue="${basedir}/src/test/jmeter")
    protected File testFilesDirectory;
    @Parameter(defaultValue="true")
    protected boolean testResultsTimestamp;
    @Parameter(defaultValue="false")
    protected boolean appendResultsTimestamp;
    @Parameter
    protected String resultsFileNameDateFormat;
    @Parameter(defaultValue="xml")
    protected String resultsFileFormat;
    @Parameter
    protected String resultsDirectory;
    @Parameter
    protected Map<String, String> propertiesJMeter = new HashMap<String, String>();
    @Parameter
    protected Map<String, String> propertiesSaveService = new HashMap<String, String>();
    @Parameter
    protected Map<String, String> propertiesUpgrade = new HashMap<String, String>();
    @Parameter
    protected Map<String, String> propertiesUser = new HashMap<String, String>();
    @Parameter
    protected Map<String, String> propertiesGlobal = new HashMap<String, String>();
    @Parameter
    protected Map<String, String> propertiesSystem = new HashMap<String, String>();
    @Parameter
    protected File customPropertiesFile;
    @Parameter(defaultValue="true")
    protected boolean propertiesReplacedByCustomFiles;
    @Parameter
    protected ProxyConfiguration proxyConfig;
    @Parameter
    protected RemoteConfiguration remoteConfig;
    @Parameter
    protected Set<JMeterPlugins> jmeterPlugins;
    @Parameter
    protected JMeterProcessJVMSettings jMeterProcessJVMSettings;
    @Parameter
    protected String overrideRootLogLevel;
    @Parameter(defaultValue="logkit.xml")
    protected String logConfigFilename;
    @Parameter(defaultValue="false")
    protected boolean ignoreResultFailures;
    @Parameter(defaultValue="true")
    protected boolean suppressJMeterOutput;
    @Parameter(defaultValue="${plugin.artifacts}", required=true, readonly=true)
    protected List<Artifact> pluginArtifacts;
    @Parameter(defaultValue="${mojoExecution}", required=true, readonly=true)
    protected MojoExecution mojoExecution;
    @Parameter(defaultValue="false")
    protected boolean skipTests;
    @Parameter(defaultValue="${project.build.directory}/jmeter")
    protected transient File workDir;
    protected File binDir;
    protected File libDir;
    protected File libExtDir;
    protected File logsDir;
    protected File resultsDir;
    protected final String jmeterConfigArtifact = "ApacheJMeter_config";
    protected JMeterArgumentsArray testArgs;
    protected PropertyHandler pluginProperties;
    protected boolean resultsOutputIsCSVFormat = false;

    protected void generateJMeterDirectoryTree() {
        this.logsDir = new File(this.workDir, "logs");
        this.logsDir.mkdirs();
        this.binDir = new File(this.workDir, "bin");
        this.binDir.mkdirs();
        this.resultsDir = null != this.resultsDirectory ? new File(this.resultsDirectory.replaceAll("\\|/", File.separator)) : new File(this.workDir, "results");
        this.resultsDir.mkdirs();
        this.libDir = new File(this.workDir, "lib");
        this.libExtDir = new File(this.libDir, "ext");
        this.libExtDir.mkdirs();
        new File(this.libDir, "junit").mkdirs();
    }

    protected void propertyConfiguration() throws MojoExecutionException {
        this.pluginProperties = new PropertyHandler(this.testFilesDirectory, this.binDir, this.getArtifactNamed("ApacheJMeter_config"), this.propertiesReplacedByCustomFiles);
        this.pluginProperties.setJMeterProperties(this.propertiesJMeter);
        this.pluginProperties.setJMeterGlobalProperties(this.propertiesGlobal);
        this.pluginProperties.setJMeterSaveServiceProperties(this.propertiesSaveService);
        this.pluginProperties.setJMeterUpgradeProperties(this.propertiesUpgrade);
        this.pluginProperties.setJmeterUserProperties(this.propertiesUser);
        this.pluginProperties.setJMeterSystemProperties(this.propertiesSystem);
        this.pluginProperties.configureJMeterPropertiesFiles();
        this.pluginProperties.setDefaultPluginProperties(this.binDir.getAbsolutePath());
    }

    protected void populateJMeterDirectoryTree() throws MojoExecutionException {
        for (Artifact artifact : this.pluginArtifacts) {
            try {
                if (!"compile".equals(artifact.getScope()) && !"runtime".equals(artifact.getScope())) continue;
                if (artifact.getArtifactId().equals("ApacheJMeter_config")) {
                    this.extractConfigSettings(artifact);
                    continue;
                }
                if (artifact.getArtifactId().equals("ApacheJMeter")) {
                    FileUtils.copyFile((File)artifact.getFile(), (File)new File(this.binDir + File.separator + artifact.getArtifactId() + ".jar"));
                    continue;
                }
                if (artifact.getArtifactId().startsWith("ApacheJMeter_")) {
                    FileUtils.copyFile((File)artifact.getFile(), (File)new File(this.libExtDir + File.separator + artifact.getFile().getName()));
                    continue;
                }
                if (this.isArtifactAJMeterDependency(artifact)) {
                    FileUtils.copyFile((File)artifact.getFile(), (File)new File(this.libDir + File.separator + artifact.getFile().getName()));
                    continue;
                }
                if (!this.isArtifactAnExplicitDependency(artifact)) continue;
                if (this.isArtifactMarkedAsAJMeterPlugin(artifact)) {
                    FileUtils.copyFile((File)artifact.getFile(), (File)new File(this.libExtDir + File.separator + artifact.getFile().getName()));
                    continue;
                }
                FileUtils.copyFile((File)artifact.getFile(), (File)new File(this.libDir + File.separator + artifact.getFile().getName()));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to populate the JMeter directory tree: " + e);
            }
        }
    }

    private void extractConfigSettings(Artifact artifact) throws IOException {
        JarFile configSettings = new JarFile(artifact.getFile());
        Enumeration<JarEntry> entries = configSettings.entries();
        while (entries.hasMoreElements()) {
            JarEntry jarFileEntry = entries.nextElement();
            if (jarFileEntry.isDirectory() || !jarFileEntry.getName().startsWith("bin") || jarFileEntry.getName().endsWith(".properties")) continue;
            File fileToCreate = new File(this.workDir.getCanonicalPath() + File.separator + jarFileEntry.getName());
            if (jarFileEntry.getName().endsWith(this.logConfigFilename) && fileToCreate.exists()) break;
            FileUtils.copyInputStreamToFile((InputStream)configSettings.getInputStream(jarFileEntry), (File)fileToCreate);
        }
        configSettings.close();
    }

    protected boolean isArtifactMarkedAsAJMeterPlugin(Artifact artifact) {
        if (null != this.jmeterPlugins) {
            for (JMeterPlugins identifiedPlugin : this.jmeterPlugins) {
                if (!identifiedPlugin.toString().equals(artifact.getGroupId() + ":" + artifact.getArtifactId())) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isArtifactAnExplicitDependency(Artifact artifact) {
        try {
            List pluginDependencies = this.mojoExecution.getPlugin().getDependencies();
            for (Dependency dependency : pluginDependencies) {
                for (String parent : artifact.getDependencyTrail()) {
                    if (!parent.contains(dependency.getGroupId() + ":" + dependency.getArtifactId()) || !parent.contains(dependency.getVersion())) continue;
                    return true;
                }
            }
        }
        catch (NoSuchMethodError ignored) {
            Set pluginDependentArtifacts = this.mojoExecution.getMojoDescriptor().getPluginDescriptor().getIntroducedDependencyArtifacts();
            for (Artifact dependency : pluginDependentArtifacts) {
                for (String parent : artifact.getDependencyTrail()) {
                    if (!parent.contains(dependency.getGroupId() + ":" + dependency.getArtifactId()) || !parent.contains(dependency.getBaseVersion())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean isArtifactAJMeterDependency(Artifact artifact) {
        for (String dependency : artifact.getDependencyTrail()) {
            if (!dependency.contains("org.apache.jmeter")) continue;
            return true;
        }
        return false;
    }

    protected Artifact getArtifactNamed(String artifactName) throws MojoExecutionException {
        for (Artifact artifact : this.pluginArtifacts) {
            if (!artifact.getArtifactId().equals(artifactName)) continue;
            return artifact;
        }
        throw new MojoExecutionException("Unable to find artifact '" + artifactName + "'!");
    }

    protected void initialiseJMeterArgumentsArray(boolean disableGUI) throws MojoExecutionException {
        this.testArgs = new JMeterArgumentsArray(disableGUI, this.workDir.getAbsolutePath());
        this.testArgs.setResultsDirectory(this.resultsDir.getAbsolutePath());
        this.testArgs.setResultFileOutputFormatIsCSV(this.resultsOutputIsCSVFormat);
        if (this.testResultsTimestamp) {
            this.testArgs.setResultsTimestamp(this.testResultsTimestamp);
            this.testArgs.appendTimestamp(this.appendResultsTimestamp);
            if (UtilityFunctions.isSet(this.resultsFileNameDateFormat).booleanValue()) {
                try {
                    this.testArgs.setResultsFileNameDateFormat(DateTimeFormat.forPattern((String)this.resultsFileNameDateFormat));
                }
                catch (Exception ex) {
                    this.getLog().error((CharSequence)("'" + this.resultsFileNameDateFormat + "' is an invalid DateTimeFormat.  Defaulting to Standard ISO_8601."));
                }
            }
        }
        this.testArgs.setProxyConfig(this.proxyConfig);
        this.testArgs.setACustomPropertiesFile(this.customPropertiesFile);
        this.testArgs.setLogRootOverride(this.overrideRootLogLevel);
        this.testArgs.setLogsDirectory(this.logsDir.getAbsolutePath());
    }

    protected void setJMeterResultFileFormat() {
        if (this.resultsFileFormat.toLowerCase().equals("csv")) {
            this.propertiesJMeter.put("jmeter.save.saveservice.output_format", "csv");
            this.resultsOutputIsCSVFormat = true;
        } else {
            this.propertiesJMeter.put("jmeter.save.saveservice.output_format", "xml");
            this.resultsOutputIsCSVFormat = false;
        }
    }

    protected void configureAdvancedLogging() throws MojoFailureException {
        File advancedLoggingSetting = new File(this.testFilesDirectory + File.separator + this.logConfigFilename);
        if (advancedLoggingSetting.exists()) {
            try {
                FileUtils.copyFile((File)advancedLoggingSetting, (File)new File(this.binDir + File.separator + this.logConfigFilename));
            }
            catch (IOException ex) {
                throw new MojoFailureException(ex.getMessage());
            }
            this.propertiesJMeter.put("log_config", this.logConfigFilename);
        }
    }
}

