/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.internal.path;

import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.internal.CharacterIndex;
import com.jayway.jsonpath.internal.Path;
import com.jayway.jsonpath.internal.filter.FilterCompiler;
import com.jayway.jsonpath.internal.path.ArrayIndexOperation;
import com.jayway.jsonpath.internal.path.ArraySliceOperation;
import com.jayway.jsonpath.internal.path.CompiledPath;
import com.jayway.jsonpath.internal.path.PathTokenAppender;
import com.jayway.jsonpath.internal.path.PathTokenFactory;
import com.jayway.jsonpath.internal.path.RootPathToken;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;

public class PathCompiler {
    private static final char DOC_CONTEXT = '$';
    private static final char EVAL_CONTEXT = '@';
    private static final char OPEN_SQUARE_BRACKET = '[';
    private static final char CLOSE_SQUARE_BRACKET = ']';
    private static final char OPEN_BRACKET = '(';
    private static final char WILDCARD = '*';
    private static final char PERIOD = '.';
    private static final char SPACE = ' ';
    private static final char QUESTIONMARK = '?';
    private static final char COMMA = ',';
    private static final char SPLIT = ':';
    private static final char MINUS = '-';
    private static final char TICK = '\'';
    private final LinkedList<Predicate> filterStack;
    private final CharacterIndex path;

    private PathCompiler(String path, LinkedList<Predicate> filterStack) {
        this.filterStack = filterStack;
        this.path = new CharacterIndex(path);
    }

    private Path compile() {
        RootPathToken root = this.readContextToken();
        return new CompiledPath(root, root.getPathFragment().equals("$"));
    }

    public static Path compile(String path, Predicate ... filters) {
        try {
            path = path.trim();
            if (!path.startsWith("$") && !path.startsWith("@")) {
                path = "$." + path;
            }
            if (path.endsWith("..")) {
                PathCompiler.fail("Path must not end wid a scan operation '..'");
            }
            LinkedList<Predicate> filterStack = new LinkedList<Predicate>(Arrays.asList(filters));
            Path p = new PathCompiler(path.trim(), filterStack).compile();
            return p;
        }
        catch (Exception e) {
            InvalidPathException ipe = e instanceof InvalidPathException ? (InvalidPathException)e : new InvalidPathException(e);
            throw ipe;
        }
    }

    private RootPathToken readContextToken() {
        if (!this.path.currentCharIs('$') && !this.path.currentCharIs('@')) {
            throw new InvalidPathException("Path must start with '$' or '@'");
        }
        RootPathToken pathToken = PathTokenFactory.createRootPathToken(this.path.currentChar());
        PathTokenAppender appender = pathToken.getPathTokenAppender();
        if (this.path.currentIsTail()) {
            return pathToken;
        }
        this.path.incrementPosition(1);
        if (this.path.currentChar() != '.' && this.path.currentChar() != '[') {
            PathCompiler.fail("Illegal character at position " + this.path.position() + " expected '.' or '[");
        }
        this.readNextToken(appender);
        return pathToken;
    }

    private boolean readNextToken(PathTokenAppender appender) {
        char c = this.path.currentChar();
        switch (c) {
            case '[': {
                return this.readBracketPropertyToken(appender) || this.readArrayToken(appender) || this.readWildCardToken(appender) || this.readFilterToken(appender) || this.readPlaceholderToken(appender) || PathCompiler.fail("Could not parse token starting at position " + this.path.position() + ". Expected ?, ', 0-9, * ");
            }
            case '.': {
                return this.readDotToken(appender) || PathCompiler.fail("Could not parse token starting at position " + this.path.position());
            }
            case '*': {
                return this.readWildCardToken(appender) || PathCompiler.fail("Could not parse token starting at position " + this.path.position());
            }
        }
        return this.readPropertyOrFunctionToken(appender) || PathCompiler.fail("Could not parse token starting at position " + this.path.position());
    }

    private boolean readDotToken(PathTokenAppender appender) {
        if (this.path.currentCharIs('.') && this.path.nextCharIs('.')) {
            appender.appendPathToken(PathTokenFactory.crateScanToken());
            this.path.incrementPosition(2);
        } else {
            if (!this.path.hasMoreCharacters()) {
                throw new InvalidPathException("Path must not end with a '.");
            }
            this.path.incrementPosition(1);
        }
        if (this.path.currentCharIs('.')) {
            throw new InvalidPathException("Character '.' on position " + this.path.position() + " is not valid.");
        }
        return this.readNextToken(appender);
    }

    private boolean readPropertyOrFunctionToken(PathTokenAppender appender) {
        int startPosition;
        if (this.path.currentCharIs('[') || this.path.currentCharIs('*') || this.path.currentCharIs('.') || this.path.currentCharIs(' ')) {
            return false;
        }
        int readPosition = startPosition = this.path.position();
        int endPosition = 0;
        while (this.path.inBounds(readPosition)) {
            char c = this.path.charAt(readPosition);
            if (c == ' ') {
                throw new InvalidPathException("Use bracket notion ['my prop'] if your property contains blank characters. position: " + this.path.position());
            }
            if (c == '.' || c == '[') {
                endPosition = readPosition;
                break;
            }
            ++readPosition;
        }
        if (endPosition == 0) {
            endPosition = this.path.length();
        }
        this.path.setPosition(endPosition);
        String property = this.path.subSequence(startPosition, endPosition).toString();
        if (property.endsWith("()")) {
            appender.appendPathToken(PathTokenFactory.createFunctionPathToken(property));
        } else {
            appender.appendPathToken(PathTokenFactory.createSinglePropertyPathToken(property));
        }
        return this.path.currentIsTail() || this.readNextToken(appender);
    }

    private boolean readPlaceholderToken(PathTokenAppender appender) {
        if (!this.path.currentCharIs('[')) {
            return false;
        }
        int questionmarkIndex = this.path.indexOfNextSignificantChar('?');
        if (questionmarkIndex == -1) {
            return false;
        }
        char nextSignificantChar = this.path.nextSignificantChar(questionmarkIndex);
        if (nextSignificantChar != ']' && nextSignificantChar != ',') {
            return false;
        }
        int expressionBeginIndex = this.path.position() + 1;
        int expressionEndIndex = this.path.nextIndexOf(expressionBeginIndex, ']');
        if (expressionEndIndex == -1) {
            return false;
        }
        String expression = this.path.subSequence(expressionBeginIndex, expressionEndIndex).toString();
        String[] tokens = expression.split(",");
        if (this.filterStack.size() < tokens.length) {
            throw new InvalidPathException("Not enough predicates supplied for filter [" + expression + "] at position " + this.path.position());
        }
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        for (String token : tokens) {
            token = token != null ? token.trim() : token;
            if (!"?".equals(token == null ? "" : token)) {
                throw new InvalidPathException("Expected '?' but found " + token);
            }
            predicates.add(this.filterStack.pop());
        }
        appender.appendPathToken(PathTokenFactory.createPredicatePathToken(predicates));
        this.path.setPosition(expressionEndIndex + 1);
        return this.path.currentIsTail() || this.readNextToken(appender);
    }

    private boolean readFilterToken(PathTokenAppender appender) {
        if (!this.path.currentCharIs('[') && !this.path.nextSignificantCharIs('?')) {
            return false;
        }
        int openStatementBracketIndex = this.path.position();
        int questionMarkIndex = this.path.indexOfNextSignificantChar('?');
        if (questionMarkIndex == -1) {
            return false;
        }
        int openBracketIndex = this.path.indexOfNextSignificantChar(questionMarkIndex, '(');
        if (openBracketIndex == -1) {
            return false;
        }
        int closeBracketIndex = this.path.indexOfClosingBracket(openBracketIndex, true, true);
        if (closeBracketIndex == -1) {
            return false;
        }
        if (!this.path.nextSignificantCharIs(closeBracketIndex, ']')) {
            return false;
        }
        int closeStatementBracketIndex = this.path.indexOfNextSignificantChar(closeBracketIndex, ']');
        String criteria = this.path.subSequence(openStatementBracketIndex, closeStatementBracketIndex + 1).toString();
        Filter predicate = FilterCompiler.compile(criteria);
        appender.appendPathToken(PathTokenFactory.createPredicatePathToken(predicate));
        this.path.setPosition(closeStatementBracketIndex + 1);
        return this.path.currentIsTail() || this.readNextToken(appender);
    }

    private boolean readWildCardToken(PathTokenAppender appender) {
        boolean inBracket = this.path.currentCharIs('[');
        if (inBracket && !this.path.nextSignificantCharIs('*')) {
            return false;
        }
        if (!this.path.currentCharIs('*') && this.path.isOutOfBounds(this.path.position() + 1)) {
            return false;
        }
        if (inBracket) {
            int wildCardIndex = this.path.indexOfNextSignificantChar('*');
            if (!this.path.nextSignificantCharIs(wildCardIndex, ']')) {
                throw new InvalidPathException("Expected wildcard token to end with ']' on position " + wildCardIndex + 1);
            }
            int bracketCloseIndex = this.path.indexOfNextSignificantChar(wildCardIndex, ']');
            this.path.setPosition(bracketCloseIndex + 1);
        } else {
            this.path.incrementPosition(1);
        }
        appender.appendPathToken(PathTokenFactory.createWildCardPathToken());
        return this.path.currentIsTail() || this.readNextToken(appender);
    }

    private boolean readArrayToken(PathTokenAppender appender) {
        if (!this.path.currentCharIs('[')) {
            return false;
        }
        char nextSignificantChar = this.path.nextSignificantChar();
        if (!Character.isDigit(nextSignificantChar) && nextSignificantChar != '-' && nextSignificantChar != ':') {
            return false;
        }
        int expressionBeginIndex = this.path.position() + 1;
        int expressionEndIndex = this.path.nextIndexOf(expressionBeginIndex, ']');
        if (expressionEndIndex == -1) {
            return false;
        }
        String expression = this.path.subSequence(expressionBeginIndex, expressionEndIndex).toString().replace(" ", "");
        if ("*".equals(expression)) {
            return false;
        }
        for (int i = 0; i < expression.length(); ++i) {
            char c = expression.charAt(i);
            if (Character.isDigit(c) || c == ',' || c == '-' || c == ':') continue;
            return false;
        }
        boolean isSliceOperation = expression.contains(":");
        if (isSliceOperation) {
            ArraySliceOperation arraySliceOperation = ArraySliceOperation.parse(expression);
            appender.appendPathToken(PathTokenFactory.createSliceArrayPathToken(arraySliceOperation));
        } else {
            ArrayIndexOperation arrayIndexOperation = ArrayIndexOperation.parse(expression);
            appender.appendPathToken(PathTokenFactory.createIndexArrayPathToken(arrayIndexOperation));
        }
        this.path.setPosition(expressionEndIndex + 1);
        return this.path.currentIsTail() || this.readNextToken(appender);
    }

    private boolean readBracketPropertyToken(PathTokenAppender appender) {
        char c;
        int startPosition;
        if (!this.path.currentCharIs('[') || !this.path.nextSignificantCharIs('\'')) {
            return false;
        }
        ArrayList<String> properties = new ArrayList<String>();
        int readPosition = startPosition = this.path.position() + 1;
        int endPosition = 0;
        boolean inProperty = false;
        while (this.path.inBounds(readPosition) && ((c = this.path.charAt(readPosition)) != ']' || inProperty)) {
            if (c == '\'') {
                if (inProperty) {
                    endPosition = readPosition;
                    properties.add(this.path.subSequence(startPosition, endPosition).toString());
                    inProperty = false;
                } else {
                    startPosition = readPosition + 1;
                    inProperty = true;
                }
            }
            ++readPosition;
        }
        int endBracketIndex = this.path.indexOfNextSignificantChar(endPosition, ']') + 1;
        this.path.setPosition(endBracketIndex);
        appender.appendPathToken(PathTokenFactory.createPropertyPathToken(properties));
        return this.path.currentIsTail() || this.readNextToken(appender);
    }

    public static boolean fail(String message) {
        throw new InvalidPathException(message);
    }
}

