/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.web.security.shiro;

import com.ifourthwall.common.CacheKeyDecorator;
import com.ifourthwall.common.base.IFWModule;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.common.security.TokenUtils;
import com.ifourthwall.web.security.shiro.AuthToken;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.dao.InvalidResourceUsageException;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.data.redis.core.RedisTemplate;

public class AuthRealm
extends AuthorizingRealm {
    private static final Logger log = LoggerFactory.getLogger(AuthRealm.class);
    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private Environment env;
    private static final long DEFAULT_EXPIRED_TIME = 30L;
    public static final String MATCH_ALL_URIS = "/*";
    private String[] excludeUrls;

    public boolean supports(AuthenticationToken token) {
        return token instanceof AuthToken;
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        return null;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken tokenObj) throws AuthenticationException {
        String tokenStr = (String)tokenObj.getPrincipal();
        String token = TokenUtils.getTokenFromBasicToken((String)tokenStr);
        Object userInfo = this.redisTemplate.opsForValue().get((Object)CacheKeyDecorator.getUserInfoKey((String)token));
        if (userInfo == null) {
            log.warn("\u5f53\u524d\u8bbf\u95ee\u7528\u6237:{}\u767b\u9646\u8fc7\u671f\u6216\u672a\u767b\u9646", (Object)token);
            throw new IncorrectCredentialsException("\u767b\u9646\u8fc7\u671f\u6216\u672a\u767b\u9646.");
        }
        if (!this.auditURI(((AuthToken)tokenObj).getUri(), (IFWUser)userInfo)) {
            log.warn("\u5f53\u524d\u8bbf\u95ee\u7528\u6237\u672a\u88ab\u6388\u6743\uff0c\u65e0\u8bbf\u95ee{}\u6743\u9650", (Object)((AuthToken)tokenObj).getUri());
            throw new InvalidResourceUsageException("\u65e0\u63a5\u53e3\u8bbf\u95ee\u6743\u9650");
        }
        log.info("\u5f53\u524d\u8bbf\u95ee\u7528\u6237\u5df2\u88ab\u6388\u6743");
        return new SimpleAuthenticationInfo((Object)token, (Object)tokenStr, this.getName());
    }

    private boolean auditURI(String uri, IFWUser user) {
        if (this.isExclude(uri)) {
            return true;
        }
        Object obj = this.redisTemplate.opsForValue().get((Object)CacheKeyDecorator.getModulesAuthenticationKey((String)user.getUserId()));
        if (obj == null) {
            return false;
        }
        List moduleList = (List)obj;
        if (!CollectionUtils.isEmpty((Collection)moduleList)) {
            for (IFWModule ifwModule : moduleList) {
                if (!StringUtils.equals((CharSequence)ifwModule.getModuleUrl(), (CharSequence)uri)) continue;
                return true;
            }
        }
        log.warn("{}\u65e0\u8bbf\u95ee{}\u7684\u6743\u9650.", (Object)user.getLoginName(), (Object)uri);
        return false;
    }

    private boolean isExclude(String uri) {
        if (this.excludeUrls == null) {
            String excludeUrlsStr = this.env.getProperty("ifw.auth.exclude.urls");
            this.excludeUrls = StringUtils.split((String)excludeUrlsStr, (String)",");
        }
        if (ArrayUtils.contains((Object[])this.excludeUrls, (Object)uri)) {
            return true;
        }
        if (this.excludeUrls != null) {
            for (String excludeUrl : this.excludeUrls) {
                String subStr;
                if (StringUtils.equals((CharSequence)excludeUrl, (CharSequence)MATCH_ALL_URIS)) {
                    return true;
                }
                if (!StringUtils.endsWith((CharSequence)excludeUrl, (CharSequence)MATCH_ALL_URIS) || !StringUtils.startsWith((CharSequence)uri, (CharSequence)(subStr = StringUtils.substringBefore((String)excludeUrl, (String)MATCH_ALL_URIS)))) continue;
                return true;
            }
        }
        return false;
    }
}

