/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.web.config;

import com.ifourthwall.web.DomainArgumentResolver;
import com.ifourthwall.web.filter.ShiroAuthFilter;
import com.ifourthwall.web.security.shiro.AuthRealm;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.shiro.mgt.DefaultSessionStorageEvaluator;
import org.apache.shiro.mgt.DefaultSubjectDAO;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.mgt.SessionStorageEvaluator;
import org.apache.shiro.mgt.SubjectDAO;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.spring.web.ShiroFilterFactoryBean;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.springframework.aop.framework.autoproxy.DefaultAdvisorAutoProxyCreator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.ParameterBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Parameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@Order(value=-2147483648)
public class WebConfig
implements WebMvcConfigurer {
    @Autowired
    private RedisTemplate redisTemplate;

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> resolvers) {
        resolvers.add(new DomainArgumentResolver(this.redisTemplate));
    }

    @Configuration
    @EnableSwagger2
    public class SwaggerUIAutoConfig {
        public static final String ENV_PROD = "prod";
        @Autowired
        private Environment environment;

        @Bean
        public Docket api() {
            if (ArrayUtils.contains((Object[])this.environment.getActiveProfiles(), (Object)ENV_PROD)) {
                return new Docket(DocumentationType.SWAGGER_2).enable(false);
            }
            ParameterBuilder ticketPar = new ParameterBuilder();
            ArrayList<Parameter> pars = new ArrayList<Parameter>();
            ticketPar.name("Authorization").description("\u767b\u9646\u4ee4\u724c").modelRef((ModelReference)new ModelRef("string")).parameterType("header").required(true).build();
            pars.add(ticketPar.build());
            return new Docket(DocumentationType.SWAGGER_2).apiInfo(this.apiInfo()).select().apis(RequestHandlerSelectors.basePackage((String)this.environment.getProperty("ifw.swagger.config.scanPackage"))).paths(PathSelectors.any()).build().globalOperationParameters(pars);
        }

        private ApiInfo apiInfo() {
            return new ApiInfoBuilder().title(this.environment.getProperty("ifw.swagger.config.title")).description(this.environment.getProperty("ifw.swagger.config.description")).termsOfServiceUrl(this.environment.getProperty("ifw.swagger.config.termsOfServiceUrl")).version(this.environment.getProperty("ifw.swagger.config.version")).build();
        }

        @Bean
        public AuthRealm godzillaAuthRealm() {
            return new AuthRealm();
        }

        @Configuration
        public class ShiroConfig {
            @Autowired
            private DefaultAdvisorAutoProxyCreator defaultAdvisorAutoProxyCreator;

            @PostConstruct
            public void init() {
                this.defaultAdvisorAutoProxyCreator.setProxyTargetClass(true);
            }

            @Bean
            public DefaultWebSecurityManager securityManager(AuthRealm shiroRealm) {
                DefaultWebSecurityManager securityManager = new DefaultWebSecurityManager();
                securityManager.setRealm((Realm)shiroRealm);
                DefaultSubjectDAO subjectDAO = new DefaultSubjectDAO();
                DefaultSessionStorageEvaluator defaultSessionStorageEvaluator = new DefaultSessionStorageEvaluator();
                defaultSessionStorageEvaluator.setSessionStorageEnabled(false);
                subjectDAO.setSessionStorageEvaluator((SessionStorageEvaluator)defaultSessionStorageEvaluator);
                securityManager.setSubjectDAO((SubjectDAO)subjectDAO);
                return securityManager;
            }

            @Bean
            public ShiroFilterFactoryBean shiroFilter(AuthRealm shiroRealm) {
                ShiroFilterFactoryBean shiroFilter = new ShiroFilterFactoryBean();
                shiroFilter.setSecurityManager((SecurityManager)this.securityManager(shiroRealm));
                HashMap<String, ShiroAuthFilter> filterMap = new HashMap<String, ShiroAuthFilter>();
                filterMap.put("baseHttpFilter", new ShiroAuthFilter());
                shiroFilter.setFilters(filterMap);
                String shiroFilterUri = SwaggerUIAutoConfig.this.environment.getProperty("ifw.common.web.shiro.filter.uri");
                LinkedHashMap<String, String> filterRuleMap = new LinkedHashMap<String, String>();
                filterRuleMap.put(shiroFilterUri, "baseHttpFilter");
                shiroFilter.setFilterChainDefinitionMap(filterRuleMap);
                return shiroFilter;
            }
        }
    }
}

