/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.job.redis.scheduler.config;

import io.lettuce.core.internal.HostAndPort;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="ifw.job.config.redis.lettuce")
public class RedisSchedulerJobProperty
implements InitializingBean {
    public static final long DEFAULT_TIMEOUT = 60L;
    public static final TimeUnit DEFAULT_TIMEOUT_UNIT = TimeUnit.SECONDS;
    public static final Duration DEFAULT_TIMEOUT_DURATION = Duration.ofSeconds(60L);
    public static final int MAX_RETRIES_ON_CONNECTION_FAILURE = 3;
    private String applicationName;
    private String host;
    private String socket;
    private String sentinelMasterId;
    private int port;
    private int database;
    private String clientName;
    private String password;
    private boolean ssl = false;
    private boolean verifyPeer = true;
    private boolean startTls = false;
    private Duration timeout = DEFAULT_TIMEOUT_DURATION;
    private int pollingDelayMillis = 10000;
    private final List<HostAndPort> sentinels = new ArrayList<HostAndPort>();
    private int maxRetriesOnConnectionFailure = 3;

    public void afterPropertiesSet() throws Exception {
        this.throwException(StringUtils.isEmpty((CharSequence)this.host), this.acquireAllName("host") + "\u4e0d\u80fd\u4e3a\u7a7a");
        this.throwException(StringUtils.isEmpty((CharSequence)this.password), this.acquireAllName("password") + "\u4e0d\u80fd\u4e3a\u7a7a");
        this.throwException(StringUtils.isEmpty((CharSequence)this.host), this.acquireAllName("applicationName") + "\u4e0d\u80fd\u4e3a\u7a7a");
    }

    private String acquireAllName(String propertyName) {
        return StringUtils.joinWith((String)".", (Object[])new Object[]{"ifw.job.config.redis.lettuce", propertyName});
    }

    private void throwException(boolean isThrown, String message) {
        if (isThrown) {
            throw new IllegalArgumentException(message);
        }
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getHost() {
        return this.host;
    }

    public String getSocket() {
        return this.socket;
    }

    public String getSentinelMasterId() {
        return this.sentinelMasterId;
    }

    public int getPort() {
        return this.port;
    }

    public int getDatabase() {
        return this.database;
    }

    public String getClientName() {
        return this.clientName;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public boolean isVerifyPeer() {
        return this.verifyPeer;
    }

    public boolean isStartTls() {
        return this.startTls;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public int getPollingDelayMillis() {
        return this.pollingDelayMillis;
    }

    public List<HostAndPort> getSentinels() {
        return this.sentinels;
    }

    public int getMaxRetriesOnConnectionFailure() {
        return this.maxRetriesOnConnectionFailure;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setSocket(String socket) {
        this.socket = socket;
    }

    public void setSentinelMasterId(String sentinelMasterId) {
        this.sentinelMasterId = sentinelMasterId;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setDatabase(int database) {
        this.database = database;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public void setVerifyPeer(boolean verifyPeer) {
        this.verifyPeer = verifyPeer;
    }

    public void setStartTls(boolean startTls) {
        this.startTls = startTls;
    }

    public void setTimeout(Duration timeout) {
        this.timeout = timeout;
    }

    public void setPollingDelayMillis(int pollingDelayMillis) {
        this.pollingDelayMillis = pollingDelayMillis;
    }

    public void setMaxRetriesOnConnectionFailure(int maxRetriesOnConnectionFailure) {
        this.maxRetriesOnConnectionFailure = maxRetriesOnConnectionFailure;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RedisSchedulerJobProperty)) {
            return false;
        }
        RedisSchedulerJobProperty other = (RedisSchedulerJobProperty)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$applicationName = this.getApplicationName();
        String other$applicationName = other.getApplicationName();
        if (this$applicationName == null ? other$applicationName != null : !this$applicationName.equals(other$applicationName)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$socket = this.getSocket();
        String other$socket = other.getSocket();
        if (this$socket == null ? other$socket != null : !this$socket.equals(other$socket)) {
            return false;
        }
        String this$sentinelMasterId = this.getSentinelMasterId();
        String other$sentinelMasterId = other.getSentinelMasterId();
        if (this$sentinelMasterId == null ? other$sentinelMasterId != null : !this$sentinelMasterId.equals(other$sentinelMasterId)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        if (this.getDatabase() != other.getDatabase()) {
            return false;
        }
        String this$clientName = this.getClientName();
        String other$clientName = other.getClientName();
        if (this$clientName == null ? other$clientName != null : !this$clientName.equals(other$clientName)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        if (this.isSsl() != other.isSsl()) {
            return false;
        }
        if (this.isVerifyPeer() != other.isVerifyPeer()) {
            return false;
        }
        if (this.isStartTls() != other.isStartTls()) {
            return false;
        }
        Duration this$timeout = this.getTimeout();
        Duration other$timeout = other.getTimeout();
        if (this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout)) {
            return false;
        }
        if (this.getPollingDelayMillis() != other.getPollingDelayMillis()) {
            return false;
        }
        List<HostAndPort> this$sentinels = this.getSentinels();
        List<HostAndPort> other$sentinels = other.getSentinels();
        if (this$sentinels == null ? other$sentinels != null : !((Object)this$sentinels).equals(other$sentinels)) {
            return false;
        }
        return this.getMaxRetriesOnConnectionFailure() == other.getMaxRetriesOnConnectionFailure();
    }

    protected boolean canEqual(Object other) {
        return other instanceof RedisSchedulerJobProperty;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $applicationName = this.getApplicationName();
        result = result * 59 + ($applicationName == null ? 43 : $applicationName.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $socket = this.getSocket();
        result = result * 59 + ($socket == null ? 43 : $socket.hashCode());
        String $sentinelMasterId = this.getSentinelMasterId();
        result = result * 59 + ($sentinelMasterId == null ? 43 : $sentinelMasterId.hashCode());
        result = result * 59 + this.getPort();
        result = result * 59 + this.getDatabase();
        String $clientName = this.getClientName();
        result = result * 59 + ($clientName == null ? 43 : $clientName.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        result = result * 59 + (this.isSsl() ? 79 : 97);
        result = result * 59 + (this.isVerifyPeer() ? 79 : 97);
        result = result * 59 + (this.isStartTls() ? 79 : 97);
        Duration $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
        result = result * 59 + this.getPollingDelayMillis();
        List<HostAndPort> $sentinels = this.getSentinels();
        result = result * 59 + ($sentinels == null ? 43 : ((Object)$sentinels).hashCode());
        result = result * 59 + this.getMaxRetriesOnConnectionFailure();
        return result;
    }

    public String toString() {
        return "RedisSchedulerJobProperty(applicationName=" + this.getApplicationName() + ", host=" + this.getHost() + ", socket=" + this.getSocket() + ", sentinelMasterId=" + this.getSentinelMasterId() + ", port=" + this.getPort() + ", database=" + this.getDatabase() + ", clientName=" + this.getClientName() + ", password=" + this.getPassword() + ", ssl=" + this.isSsl() + ", verifyPeer=" + this.isVerifyPeer() + ", startTls=" + this.isStartTls() + ", timeout=" + this.getTimeout() + ", pollingDelayMillis=" + this.getPollingDelayMillis() + ", sentinels=" + this.getSentinels() + ", maxRetriesOnConnectionFailure=" + this.getMaxRetriesOnConnectionFailure() + ")";
    }
}

