/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.job.redis.scheduler.config;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.davidmarquis.redisscheduler.RedisDriver;
import com.github.davidmarquis.redisscheduler.RedisTaskScheduler;
import com.github.davidmarquis.redisscheduler.TaskTriggerListener;
import com.github.davidmarquis.redisscheduler.drivers.spring.RedisTemplateDriver;
import com.ifourthwall.job.redis.scheduler.IFWJob;
import com.ifourthwall.job.redis.scheduler.IFWTaskTriggerListener;
import com.ifourthwall.job.redis.scheduler.config.RedisSchedulerJobProperty;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.util.CollectionUtils;

@Configuration
@ConditionalOnProperty(prefix="ifw.job.config", value={"enable"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={RedisSchedulerJobProperty.class})
public class IFWRedisSchedulerAutoConfiguration
implements ApplicationListener<ContextClosedEvent> {
    private static final Logger log = LoggerFactory.getLogger(IFWRedisSchedulerAutoConfiguration.class);
    @Autowired
    private RedisSchedulerJobProperty redisSchedulerJobProperty;
    @Autowired
    private List<IFWJob> ifwJobs;
    private List<RedisTaskScheduler> redisTaskSchedulers = new ArrayList<RedisTaskScheduler>();

    @PostConstruct
    public void init() {
        if (CollectionUtils.isEmpty(this.ifwJobs)) {
            log.warn("There is no job need to start.");
            return;
        }
        RedisTemplate redisTemplate = this.createRedisTemplate();
        RedisTaskScheduler scheduler = new RedisTaskScheduler((RedisDriver)new RedisTemplateDriver(redisTemplate), (TaskTriggerListener)new IFWTaskTriggerListener(this.ifwJobs));
        scheduler.setMaxRetriesOnConnectionFailure(this.redisSchedulerJobProperty.getMaxRetriesOnConnectionFailure());
        scheduler.setSchedulerName(this.redisSchedulerJobProperty.getApplicationName());
        scheduler.setPollingDelayMillis(this.redisSchedulerJobProperty.getPollingDelayMillis());
        scheduler.start();
        log.info("Succeed to Start job client.");
        this.redisTaskSchedulers.add(scheduler);
    }

    @Bean(value={"jobRedisTemplate"})
    public RedisTemplate createRedisTemplate() {
        JedisConnectionFactory redisConnectionFactory = new JedisConnectionFactory();
        redisConnectionFactory.setHostName(this.redisSchedulerJobProperty.getHost());
        redisConnectionFactory.setPort(this.redisSchedulerJobProperty.getPort());
        redisConnectionFactory.setDatabase(this.redisSchedulerJobProperty.getDatabase());
        redisConnectionFactory.setPassword(this.redisSchedulerJobProperty.getPassword());
        RedisTemplate template = new RedisTemplate();
        Jackson2JsonRedisSerializer jackson2JsonRedisSerializer = new Jackson2JsonRedisSerializer(Object.class);
        ObjectMapper om = new ObjectMapper();
        om.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        om.enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL);
        jackson2JsonRedisSerializer.setObjectMapper(om);
        template.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        template.setHashKeySerializer((RedisSerializer)new StringRedisSerializer());
        template.setValueSerializer((RedisSerializer)jackson2JsonRedisSerializer);
        template.setHashValueSerializer((RedisSerializer)jackson2JsonRedisSerializer);
        template.setConnectionFactory((RedisConnectionFactory)redisConnectionFactory);
        return template;
    }

    public void onApplicationEvent(ContextClosedEvent event) {
        if (!CollectionUtils.isEmpty(this.redisTaskSchedulers)) {
            this.redisTaskSchedulers.stream().forEach(redisTaskScheduler -> redisTaskScheduler.stop());
        }
    }
}

