/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.job.redis.scheduler;

import com.github.davidmarquis.redisscheduler.TaskTriggerListener;
import com.ifourthwall.job.redis.scheduler.IFWJob;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class IFWTaskTriggerListener
implements TaskTriggerListener {
    private static final Logger log = LoggerFactory.getLogger(IFWTaskTriggerListener.class);
    private List<IFWJob> ifwJobs;
    private ExecutorService executorService = Executors.newFixedThreadPool(2);

    public IFWTaskTriggerListener(List<IFWJob> ifwJobs) {
        this.ifwJobs = ifwJobs;
    }

    public void taskTriggered(String taskId) {
        if (!CollectionUtils.isEmpty(this.ifwJobs)) {
            for (IFWJob ifwJob : this.ifwJobs) {
                if (!StringUtils.equals((CharSequence)taskId, (CharSequence)ifwJob.getTaskId())) continue;
                this.executorService.submit(() -> {
                    try {
                        log.info("Start to execute task. The taskId is {}", (Object)taskId);
                        ifwJob.handle();
                        log.info("Succeed to execute task. The taskId is {}", (Object)taskId);
                    }
                    catch (Exception e) {
                        log.warn("Failed to execute task. The taskId is {},the error message is {}", (Object)taskId, (Object)e.getMessage());
                    }
                });
            }
        }
    }
}

