/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.oss.aliyun;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.DeleteObjectsRequest;
import com.aliyun.oss.model.PutObjectRequest;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.aliyuncs.sts.model.v20150401.AssumeRoleRequest;
import com.aliyuncs.sts.model.v20150401.AssumeRoleResponse;
import com.ifourthwall.oss.aliyun.config.AliyunOSSProperties;
import com.ifourthwall.oss.core.OSSOperator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class AliyunOperator
implements OSSOperator {
    private static final Logger log = LoggerFactory.getLogger(AliyunOperator.class);
    private OSS ossClient;
    private AliyunOSSProperties aliyunOSSProperties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean uploadFile(MultipartFile multipartFile, String bucketName, String objectName) {
        boolean responseResult = false;
        try {
            PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, objectName, (InputStream)new ByteArrayInputStream(multipartFile.getBytes()));
            this.ossClient.putObject(putObjectRequest);
            responseResult = true;
        }
        catch (OSSException oe) {
            log.error("Caught an OSSException, which means your request made it to OSS, but was rejected with an error response for some reason.");
            log.error("Error Message:" + oe.getErrorMessage());
            log.error("Error Code:" + oe.getErrorCode());
            log.error("Request ID:" + oe.getRequestId());
            log.error("Host ID:" + oe.getHostId());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (this.ossClient != null) {
                this.ossClient.shutdown();
            }
        }
        log.info("uoloadFile success");
        return responseResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String downloadFile(String bucketName, String objectName) {
        String responseResult = null;
        try {
            DefaultProfile.addEndpoint((String)"", (String)"", (String)"Sts", (String)this.aliyunOSSProperties.getStsEndpoint());
            DefaultProfile profile = DefaultProfile.getProfile((String)"", (String)this.aliyunOSSProperties.getAccessKeyId(), (String)this.aliyunOSSProperties.getAccessKeySecret());
            DefaultAcsClient client = new DefaultAcsClient((IClientProfile)profile);
            AssumeRoleRequest request = new AssumeRoleRequest();
            request.setMethod(MethodType.POST);
            request.setRoleArn(this.aliyunOSSProperties.getRoleArn());
            request.setRoleSessionName(this.aliyunOSSProperties.getRoleSessionName());
            request.setPolicy(this.aliyunOSSProperties.getPolicy());
            AssumeRoleResponse response = (AssumeRoleResponse)client.getAcsResponse((AcsRequest)request);
            String stsAccessKeyId = response.getCredentials().getAccessKeyId();
            String stsAccessKeySecret = response.getCredentials().getAccessKeySecret();
            String stsSecurityToken = response.getCredentials().getSecurityToken();
            OSS ossClientSTS = new OSSClientBuilder().build(this.aliyunOSSProperties.getEndpoint(), stsAccessKeyId, stsAccessKeySecret, stsSecurityToken);
            String exprationProperty = this.aliyunOSSProperties.getExpiration();
            Date expiration = new Date(System.currentTimeMillis() + (long)Integer.parseInt(exprationProperty) * 1000L);
            URL url = ossClientSTS.generatePresignedUrl(this.aliyunOSSProperties.getBucketName(), this.aliyunOSSProperties.getObjectName(), expiration);
            responseResult = url.toString();
        }
        catch (OSSException oe) {
            log.error("Caught an OSSException, which means your request made it to OSS, but was rejected with an error response for some reason.");
            log.error("Error Message:" + oe.getErrorMessage());
            log.error("Error Code:" + oe.getErrorCode());
            log.error("Request ID:" + oe.getRequestId());
            log.error("Host ID:" + oe.getHostId());
        }
        catch (ClientException ce) {
            log.error("Caught an ClientException, which means the client encountered a serious internal problem while trying to communicate with OSS, such as not being able to access the network.");
            log.error("Error Message:" + ce.getMessage());
        }
        finally {
            if (this.ossClient != null) {
                this.ossClient.shutdown();
            }
        }
        log.info("Aliyun_OSS_downloadFile_success");
        return responseResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeFile(String backetName, List<String> objectPaths) {
        boolean responseResult = false;
        try {
            this.ossClient.deleteObjects(new DeleteObjectsRequest(backetName).withKeys(objectPaths));
            responseResult = true;
        }
        catch (OSSException oe) {
            log.error("Caught an OSSException, which means your request made it to OSS, but was rejected with an error response for some reason.");
            log.error("Error Message:" + oe.getErrorMessage());
            log.error("Error Code:" + oe.getErrorCode());
            log.error("Request ID:" + oe.getRequestId());
            log.error("Host ID:" + oe.getHostId());
        }
        finally {
            if (this.ossClient != null) {
                this.ossClient.shutdown();
            }
        }
        log.info("Aliyun_OSS_removeFile_success");
        return responseResult;
    }

    public AliyunOperator(OSS ossClient, AliyunOSSProperties aliyunOSSProperties) {
        this.ossClient = ossClient;
        this.aliyunOSSProperties = aliyunOSSProperties;
    }
}

