/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.monitor.collector.autoConfig;

import com.ifourthwall.monitor.collector.autoConfig.RedisClientMonitorConfig;
import io.jaegertracing.Configuration;
import io.opentracing.Tracer;
import io.opentracing.util.GlobalTracer;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;

@Configuration
@ConditionalOnProperty(prefix="ifw.monitor.config", name={"enable"}, havingValue="true", matchIfMissing=true)
@Import(value={RedisClientMonitorConfig.class})
@AutoConfigureOrder(value=-2147482648)
public class RegistTracerConfig {
    @Autowired
    private Environment environment;

    @Bean
    public Tracer tracer() {
        String serviceName = this.environment.getProperty("jaegertracing.app.name");
        String endpoint = this.environment.getProperty("jaegertracing.endpoint");
        if (StringUtils.isBlank((CharSequence)serviceName) || StringUtils.isBlank((CharSequence)endpoint)) {
            throw new IllegalArgumentException("jaegertracing.app.name\u6216jaegertracing.endpoint\u672a\u914d\u7f6e");
        }
        io.jaegertracing.Configuration config = new io.jaegertracing.Configuration(serviceName);
        Configuration.SenderConfiguration sender = new Configuration.SenderConfiguration();
        sender.withEndpoint(endpoint);
        config.withSampler(new Configuration.SamplerConfiguration().withType("const").withParam((Number)1));
        config.withReporter(new Configuration.ReporterConfiguration().withSender(sender).withMaxQueueSize(Integer.valueOf(10000)));
        GlobalTracer.register((Tracer)config.getTracer());
        return GlobalTracer.get();
    }
}

