/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.monitor.collector.dubbo;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMapAdapter;
import io.opentracing.tag.Tag;
import io.opentracing.tag.Tags;
import io.opentracing.util.GlobalTracer;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ReflectUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.ListenableFilter;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.service.GenericService;

@Activate(group={"provider", "consumer"}, order=-1)
public class ProviderMonitorFilter
extends ListenableFilter {
    Tracer tracer = GlobalTracer.get();
    volatile boolean isInit = true;

    public ProviderMonitorFilter() {
        this.listener = new MonitorExceptionListener();
    }

    /*
     * Exception decompiling
     */
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private SpanContext getActiveSpanContext() {
        if (this.tracer.activeSpan() != null) {
            return this.tracer.activeSpan().context();
        }
        return null;
    }

    private Span createSpanFromParent(SpanContext parentSpanContext, String operationName) {
        Tracer.SpanBuilder spanBuilder = parentSpanContext == null ? this.tracer.buildSpan(operationName) : this.tracer.buildSpan(operationName).asChildOf(parentSpanContext);
        return spanBuilder.withTag(Tags.SPAN_KIND.getKey(), "client").start();
    }

    private Span getSpanFromHeaders(Map<String, String> attachments, String operationName) {
        Map fields = null;
        Tracer.SpanBuilder spanBuilder = this.tracer.buildSpan(operationName);
        try {
            SpanContext parentSpanCtx = this.tracer.extract(Format.Builtin.TEXT_MAP, (Object)new TextMapAdapter(attachments));
            if (parentSpanCtx != null) {
                spanBuilder = spanBuilder.asChildOf(parentSpanCtx);
            }
        }
        catch (IllegalArgumentException iae) {
            spanBuilder = spanBuilder.withTag((Tag)Tags.ERROR, (Object)Boolean.TRUE);
        }
        Span span = spanBuilder.withTag(Tags.SPAN_KIND.getKey(), "server").withTag(Tags.COMPONENT.getKey(), "java-dubbo").start();
        if (fields != null) {
            span.log(fields);
        }
        return span;
    }

    static void onError(Throwable throwable, Span span) {
        Tags.ERROR.set(span, Boolean.TRUE);
        if (throwable != null) {
            span.log(ProviderMonitorFilter.errorLogs(throwable));
        }
    }

    static Map<String, Object> errorLogs(Throwable throwable) {
        HashMap<String, Object> errorLogs = new HashMap<String, Object>(2);
        errorLogs.put("event", Tags.ERROR.getKey());
        errorLogs.put("error.object", throwable);
        errorLogs.put("error.kind", throwable.getClass().getName());
        return errorLogs;
    }

    static final class FinishSpanCallback
    implements BiFunction {
        final Span span;

        FinishSpanCallback(Span span) {
            this.span = span;
        }

        public Object apply(Object result, Object exception) {
            this.span.finish();
            return null;
        }
    }

    static class MonitorExceptionListener
    implements Filter.Listener {
        private Logger logger = LoggerFactory.getLogger(MonitorExceptionListener.class);

        MonitorExceptionListener() {
        }

        public void onResponse(Result appResponse, Invoker<?> invoker, Invocation invocation) {
            if (appResponse.hasException() && GenericService.class != invoker.getInterface()) {
                try {
                    Throwable exception = appResponse.getException();
                    if (!(exception instanceof RuntimeException) && exception instanceof Exception) {
                        return;
                    }
                    try {
                        Class<?>[] exceptionClassses;
                        Method method = invoker.getInterface().getMethod(invocation.getMethodName(), invocation.getParameterTypes());
                        for (Class<?> exceptionClass : exceptionClassses = method.getExceptionTypes()) {
                            if (!exception.getClass().equals(exceptionClass)) continue;
                            return;
                        }
                    }
                    catch (NoSuchMethodException e) {
                        return;
                    }
                    this.logger.error("Got unchecked and undeclared exception which called by " + RpcContext.getContext().getRemoteHost() + ". service: " + invoker.getInterface().getName() + ", method: " + invocation.getMethodName() + ", exception: " + exception.getClass().getName() + ": " + exception.getMessage(), exception);
                    String serviceFile = ReflectUtils.getCodeBase((Class)invoker.getInterface());
                    String exceptionFile = ReflectUtils.getCodeBase(exception.getClass());
                    if (serviceFile == null || exceptionFile == null || serviceFile.equals(exceptionFile)) {
                        return;
                    }
                    String className = exception.getClass().getName();
                    if (className.startsWith("java.") || className.startsWith("javax.")) {
                        return;
                    }
                    if (exception instanceof RpcException) {
                        return;
                    }
                    appResponse.setException((Throwable)new RuntimeException(StringUtils.toString((Throwable)exception)));
                    return;
                }
                catch (Throwable e) {
                    this.logger.warn("Fail to ExceptionFilter when called by " + RpcContext.getContext().getRemoteHost() + ". service: " + invoker.getInterface().getName() + ", method: " + invocation.getMethodName() + ", exception: " + e.getClass().getName() + ": " + e.getMessage(), e);
                    return;
                }
            }
        }

        public void onError(Throwable e, Invoker<?> invoker, Invocation invocation) {
            this.logger.error("Got unchecked and undeclared exception which called by " + RpcContext.getContext().getRemoteHost() + ". service: " + invoker.getInterface().getName() + ", method: " + invocation.getMethodName() + ", exception: " + e.getClass().getName() + ": " + e.getMessage(), e);
        }

        public void setLogger(Logger logger) {
            this.logger = logger;
        }
    }

    static enum Kind {
        CLIENT,
        SERVER,
        PRODUCER,
        CONSUMER;

    }
}

