/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.mobile.push.aliyun;

import com.aliyun.push20160801.Client;
import com.aliyun.push20160801.models.PushRequest;
import com.aliyun.push20160801.models.PushResponse;
import com.ifourthwall.common.utils.JSONUtils;
import com.ifourthwall.mobile.push.aliyun.AliyunMobilePusherProperty;
import com.ifourthwall.mobile.push.core.IFWMsgPushRequest;
import com.ifourthwall.mobile.push.core.IFWMsgPushResult;
import com.ifourthwall.mobile.push.core.MobilePusher;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class AliyunMobilePusher
implements MobilePusher {
    private static final Logger log = LoggerFactory.getLogger(AliyunMobilePusher.class);
    private Client client;
    private AliyunMobilePusherProperty mobilePusherProperty;

    public IFWMsgPushResult sendMsg(IFWMsgPushRequest ifwMsgPushRequest) {
        log.info("AliyunMobilePusher\u63a5\u6536\u5230\u63a8\u9001\u8bf7\u6c42:{}", (Object)ifwMsgPushRequest);
        IFWMsgPushResult ifwMsgPushResult = new IFWMsgPushResult();
        IFWMsgPushResult androidIfwMsgPushResult = this.sendAndroidMsg(ifwMsgPushRequest);
        IFWMsgPushResult iOSIfwMsgPushResult = this.sendIOSMsg(ifwMsgPushRequest);
        ifwMsgPushResult.setAndroidErrorCode(androidIfwMsgPushResult.getAndroidErrorCode());
        ifwMsgPushResult.setAndroidErrorMsg(androidIfwMsgPushResult.getAndroidErrorMsg());
        ifwMsgPushResult.setAndroidMessageId(androidIfwMsgPushResult.getAndroidMessageId());
        ifwMsgPushResult.setIOSErrorCode(iOSIfwMsgPushResult.getIOSErrorCode());
        ifwMsgPushResult.setIOSMessageId(iOSIfwMsgPushResult.getIOSMessageId());
        ifwMsgPushResult.setIOSErrorMsg(iOSIfwMsgPushResult.getIOSErrorMsg());
        return ifwMsgPushResult;
    }

    private IFWMsgPushResult sendIOSMsg(IFWMsgPushRequest ifwMsgPushRequest) {
        IFWMsgPushResult ifwMsgPushResult = new IFWMsgPushResult();
        try {
            PushRequest pushRequest = new PushRequest();
            pushRequest.setAppKey(this.mobilePusherProperty.getIOSAppKey()).setPushType("NOTICE").setDeviceType("iOS").setStoreOffline(Boolean.valueOf(true)).setIOSRemind(Boolean.valueOf(true)).setIOSApnsEnv(this.mobilePusherProperty.getIOSApnsEnv()).setIOSBadge(Integer.valueOf(1)).setIOSMusic("order_notice.caf").setIOSRemindBody(this.getBody(ifwMsgPushRequest)).setIOSExtParameters(this.getContent(ifwMsgPushRequest));
            pushRequest.setTitle(this.getTitle(ifwMsgPushRequest));
            pushRequest.setBody(this.getBody(ifwMsgPushRequest));
            if (!CollectionUtils.isEmpty((Collection)ifwMsgPushRequest.getAliaList())) {
                String accountStr = StringUtils.join((Object[])ifwMsgPushRequest.getAliaList().toArray(), (String)",");
                pushRequest.setTarget("ACCOUNT");
                pushRequest.setTargetValue(accountStr);
            } else {
                pushRequest.setTarget("ALL");
            }
            PushResponse pushResponse = this.client.push(pushRequest);
            log.info("IOSRequestId: " + pushResponse.body.requestId + ", IOSMessageId: " + pushResponse.body.messageId);
            ifwMsgPushResult.setIOSMessageId(pushResponse.body.messageId);
        }
        catch (Exception e) {
            log.error("Ios\u963f\u91cc\u63a8\u9001\u5f02\u5e38\uff1a", (Throwable)e);
            ifwMsgPushResult.setAndroidErrorCode("7777");
            ifwMsgPushResult.setAndroidErrorMsg(e.getMessage());
        }
        return ifwMsgPushResult;
    }

    private String getTitle(IFWMsgPushRequest ifwMsgPushRequest) {
        String content = ifwMsgPushRequest.getContent();
        String taskName = "";
        HashMap hashMap = (HashMap)JSONUtils.jacksonFromJson((String)content, HashMap.class);
        if (hashMap.containsKey("taskName")) {
            taskName = hashMap.get("taskName").toString();
        }
        return taskName;
    }

    private String getContent(IFWMsgPushRequest ifwMsgPushRequest) {
        String content = ifwMsgPushRequest.getContent();
        HashMap hashMap = (HashMap)JSONUtils.jacksonFromJson((String)content, HashMap.class);
        return JSONUtils.jacksonToJson((Object)hashMap);
    }

    private String getBody(IFWMsgPushRequest ifwMsgPushRequest) {
        String content = ifwMsgPushRequest.getContent();
        HashMap hashMap = (HashMap)JSONUtils.jacksonFromJson((String)content, HashMap.class);
        String taskTypeName = "";
        if (hashMap.containsKey("taskTypeId")) {
            String taskTypeId = hashMap.get("taskTypeId").toString();
            if (taskTypeId.equals("1")) {
                taskTypeName = "\u4e34\u65f6\u4efb\u52a1";
            } else if (taskTypeId.equals("2")) {
                taskTypeName = "\u56fa\u5b9a\u4efb\u52a1";
            } else if (taskTypeId.equals("3")) {
                taskTypeName = "\u5de1\u89c6\u4efb\u52a1";
            } else if (taskTypeId.equals("4")) {
                taskTypeName = "\u8ba1\u5212\u4efb\u52a1";
            } else if (taskTypeId.equals("5")) {
                taskTypeName = "\u65e5\u7a0b\u4efb\u52a1";
            } else if (taskTypeId.equals("6")) {
                taskTypeName = "\u65b0\u8ba1\u5212\u4efb\u52a1";
            }
        }
        String worksheetStatusName = "";
        if (hashMap.containsKey("worksheetStatusId")) {
            String worksheetStatusId = hashMap.get("worksheetStatusId").toString();
            if (worksheetStatusId.equals("1")) {
                worksheetStatusName = "\u672a\u5904\u7406";
            } else if (worksheetStatusId.equals("2")) {
                worksheetStatusName = "\u5904\u7406\u4e2d";
            } else if (worksheetStatusId.equals("3")) {
                worksheetStatusName = "\u5904\u7406\u5b8c\u6210\u5f85\u53cd\u9988";
            } else if (worksheetStatusId.equals("4")) {
                worksheetStatusName = "\u5904\u7406\u5b8c\u6210\u5f85\u9a8c\u6536";
            } else if (worksheetStatusId.equals("5")) {
                worksheetStatusName = "\u9a8c\u6536\u5b8c\u6210\u5f85\u53cd\u9988";
            } else if (worksheetStatusId.equals("6")) {
                worksheetStatusName = "\u5904\u7406\u5b8c\u6210";
            } else if (worksheetStatusId.equals("7")) {
                worksheetStatusName = "\u6302\u8d77";
            } else if (worksheetStatusId.equals("8")) {
                worksheetStatusName = "\u65e0\u9700\u5904\u7406";
            } else if (worksheetStatusId.equals("9")) {
                worksheetStatusName = "\u6682\u505c";
            } else if (worksheetStatusId.equals("10")) {
                worksheetStatusName = "\u672a\u7b7e\u5230";
            } else if (worksheetStatusId.equals("11")) {
                worksheetStatusName = "\u65e0\u9700\u5904\u7406\u5f85\u9a8c\u6536";
            }
        }
        return "\u60a8\u6709\u4e00\u4e2a\u65b0\u7684[" + taskTypeName + "]" + worksheetStatusName;
    }

    private IFWMsgPushResult sendAndroidMsg(IFWMsgPushRequest ifwMsgPushRequest) {
        IFWMsgPushResult ifwMsgPushResult = new IFWMsgPushResult();
        try {
            PushRequest pushRequest = new PushRequest();
            pushRequest.setAppKey(this.mobilePusherProperty.getAppKey()).setPushType("MESSAGE").setDeviceType("ALL").setStoreOffline(Boolean.valueOf(true)).setAndroidRemind(Boolean.valueOf(true)).setAndroidNotificationHonorChannel("NORMAL").setAndroidNotificationXiaomiChannel("137560").setAndroidNotificationVivoChannel("1").setAndroidMessageVivoCategory("ORDER").setAndroidMessageOppoCategory("ORDER").setAndroidMessageOppoNotifyLevel(Integer.valueOf(16)).setAndroidNotificationHuaweiChannel("NORMAL").setAndroidMessageHuaweiCategory("WORK").setAndroidHuaweiReceiptId("RCPC61C4151").setAndroidMusic("order_notice").setAndroidNotifyType("BOTH").setTitle(this.getTitle(ifwMsgPushRequest)).setBody(this.getBody(ifwMsgPushRequest)).setAndroidNotificationChannel("worksheet_channel").setAndroidPopupActivity("com.aliyun.ams.push.PopupPushActivity").setAndroidPopupTitle(this.getTitle(ifwMsgPushRequest) + "\u5382\u5546").setAndroidPopupBody(this.getBody(ifwMsgPushRequest)).setAndroidExtParameters(this.getContent(ifwMsgPushRequest));
            if (!CollectionUtils.isEmpty((Collection)ifwMsgPushRequest.getAliaList())) {
                String accountStr = StringUtils.join((Object[])ifwMsgPushRequest.getAliaList().toArray(), (String)",");
                pushRequest.setTarget("ACCOUNT");
                pushRequest.setTargetValue(accountStr);
            } else {
                pushRequest.setTarget("ALL");
            }
            PushResponse pushResponse = this.client.push(pushRequest);
            log.info("AndroidRequestId: " + pushResponse.body.requestId + ", AndroidMessageID: " + pushResponse.body.messageId);
            ifwMsgPushResult.setAndroidMessageId(pushResponse.body.messageId);
        }
        catch (Exception e) {
            log.error("Android\u963f\u91cc\u63a8\u9001\u5f02\u5e38\uff1a", (Throwable)e);
            ifwMsgPushResult.setAndroidErrorCode("8888");
            ifwMsgPushResult.setAndroidErrorMsg(e.getMessage());
        }
        return ifwMsgPushResult;
    }

    public AliyunMobilePusher(Client client, AliyunMobilePusherProperty mobilePusherProperty) {
        this.client = client;
        this.mobilePusherProperty = mobilePusherProperty;
    }
}

