/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.mobile.push.aliyun;

import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.exceptions.ServerException;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.http.ProtocolType;
import com.aliyuncs.push.model.v20160801.PushRequest;
import com.aliyuncs.push.model.v20160801.PushResponse;
import com.aliyuncs.utils.ParameterHelper;
import com.ifourthwall.mobile.push.aliyun.AliyunMobilePusherProperty;
import com.ifourthwall.mobile.push.core.IFWMsgPushRequest;
import com.ifourthwall.mobile.push.core.IFWMsgPushResult;
import com.ifourthwall.mobile.push.core.MobilePusher;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class AliyunMobilePusher
implements MobilePusher {
    private static final Logger log = LoggerFactory.getLogger(AliyunMobilePusher.class);
    private DefaultAcsClient client;
    private AliyunMobilePusherProperty mobilePusherProperty;

    public IFWMsgPushResult sendMsg(IFWMsgPushRequest ifwMsgPushRequest) {
        log.info("AliyunMobilePusher\u63a5\u6536\u5230\u63a8\u9001\u8bf7\u6c42:{}", (Object)ifwMsgPushRequest);
        IFWMsgPushResult ifwMsgPushResult = new IFWMsgPushResult();
        try {
            PushRequest pushRequest = new PushRequest();
            pushRequest.setProtocol(ProtocolType.HTTPS);
            pushRequest.setMethod(MethodType.POST);
            pushRequest.setAppKey(this.mobilePusherProperty.getAppKey());
            if (!CollectionUtils.isEmpty((Collection)ifwMsgPushRequest.getAliaList())) {
                String accountStr = StringUtils.join((Object[])ifwMsgPushRequest.getAliaList().toArray(), (String)",");
                pushRequest.setTarget("ACCOUNT");
                pushRequest.setTargetValue(accountStr);
            } else {
                pushRequest.setTarget("ALL");
            }
            pushRequest.setPushType(this.mobilePusherProperty.getPushType());
            pushRequest.setDeviceType(this.mobilePusherProperty.getDeviceType());
            pushRequest.setTitle(this.mobilePusherProperty.getTitle());
            pushRequest.setBody(ifwMsgPushRequest.getContent());
            pushRequest.setAndroidNotifyType(this.mobilePusherProperty.getAndroidNotifyType());
            pushRequest.setAndroidNotificationBarType(Integer.valueOf(1));
            pushRequest.setAndroidNotificationBarPriority(Integer.valueOf(1));
            pushRequest.setAndroidMusic("default");
            if (ifwMsgPushRequest.getTimingDate() != null) {
                String pushTime = ParameterHelper.getISO8601Time((Date)ifwMsgPushRequest.getTimingDate());
                pushRequest.setPushTime(pushTime);
            }
            String expireTime = ParameterHelper.getISO8601Time((Date)new Date(System.currentTimeMillis() + 43200000L));
            pushRequest.setExpireTime(expireTime);
            pushRequest.setStoreOffline(Boolean.valueOf(true));
            PushResponse pushResponse = (PushResponse)this.client.getAcsResponse((AcsRequest)pushRequest);
            log.info("RequestId: " + pushResponse.getRequestId() + ", MessageID: " + pushResponse.getMessageId());
            ifwMsgPushResult.setMessageId(pushResponse.getMessageId());
        }
        catch (ServerException e) {
            log.error("\u963f\u91cc\u63a8\u9001\u5f02\u5e38\uff1a", (Throwable)e);
            ifwMsgPushResult.setErrorCode(e.getErrCode());
            ifwMsgPushResult.setMessageId(e.getErrMsg());
        }
        catch (ClientException e) {
            log.error("\u963f\u91cc\u63a8\u9001\u5f02\u5e38\uff1a", (Throwable)e);
            ifwMsgPushResult.setErrorCode(e.getErrCode());
            ifwMsgPushResult.setMessageId(e.getErrMsg());
        }
        return ifwMsgPushResult;
    }

    public AliyunMobilePusher(DefaultAcsClient client, AliyunMobilePusherProperty mobilePusherProperty) {
        this.client = client;
        this.mobilePusherProperty = mobilePusherProperty;
    }
}

