/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.message.sms.aliyun;

import com.aliyuncs.CommonRequest;
import com.aliyuncs.CommonResponse;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.ifourthwall.common.utils.JSONUtils;
import com.ifourthwall.message.sms.aliyun.SendSMSCallBack;
import com.ifourthwall.message.sms.aliyun.config.AliyunSMSProperties;
import com.ifourthwall.message.sms.core.AbstractSendSMSService;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliyunSendSMSService
extends AbstractSendSMSService<AliyunSMSProperties> {
    private static final Logger log = LoggerFactory.getLogger(AliyunSendSMSService.class);
    public static final String EN_COUNTRY_CODE = "+1";

    public AliyunSendSMSService(Map<String, List<AliyunSMSProperties>> smsPropertiesMap, List<AliyunSMSProperties> defaultSMSProperties) {
        super(smsPropertiesMap, defaultSMSProperties);
    }

    public boolean sendSMS(String phoneNos, String index, String messageJson) {
        return this.sendSMS(phoneNos, index, messageJson, null);
    }

    public boolean sendSMS(String phoneNos, String index, Map<String, String> msg) {
        throw new UnsupportedOperationException();
    }

    public boolean sendSMS(String phoneNos, String index, String[] msgParam) {
        throw new UnsupportedOperationException();
    }

    public boolean sendSMS(String phoneNos, String index, String messageJson, SendSMSCallBack sendSMSCallBack) {
        AliyunSMSProperties smsProperties = (AliyunSMSProperties)this.chooseSMSProperties(phoneNos, index);
        String finalPhoneNo = phoneNos.replace("+", "");
        DefaultProfile profile = DefaultProfile.getProfile((String)smsProperties.getRegionId(), (String)smsProperties.getAccessKeyId(), (String)smsProperties.getSecret());
        DefaultAcsClient client = new DefaultAcsClient((IClientProfile)profile);
        CommonRequest request = new CommonRequest();
        request.setMethod(MethodType.POST);
        request.setDomain(smsProperties.getDomain());
        request.setVersion(smsProperties.getVersion());
        request.setAction(smsProperties.getAction());
        request.putQueryParameter("RegionId", smsProperties.getRegionId());
        request.putQueryParameter("PhoneNumbers", finalPhoneNo);
        request.putQueryParameter("SignName", new String(smsProperties.getSignature().getBytes()));
        request.putQueryParameter("TemplateCode", smsProperties.getTemplateCode());
        request.putQueryParameter("TemplateParam", messageJson);
        try {
            CommonResponse response;
            Map data;
            if (sendSMSCallBack != null) {
                sendSMSCallBack.beforeSend((IAcsClient)client, smsProperties, messageJson);
            }
            if ((data = (Map)JSONUtils.jacksonFromJson((String)(response = client.getCommonResponse(request)).getData(), Map.class)) != null && ((String)data.get("Code")).equals("OK")) {
                log.info("\u53d1\u9001\u4fe1\u606f\u6210\u529fok\uff1a" + finalPhoneNo + " message:" + messageJson + " return:" + response.getData());
                if (sendSMSCallBack != null) {
                    sendSMSCallBack.onSuccess(data);
                }
            } else {
                log.error("\u53d1\u9001\u4fe1\u606f\u5931\u8d25\uff1a" + finalPhoneNo + " message:" + messageJson + " return:" + response.getData());
                if (sendSMSCallBack != null) {
                    sendSMSCallBack.onFailed(data);
                }
            }
            return true;
        }
        catch (ClientException e) {
            log.error("\u53d1\u9001\u4fe1\u606f\u5931\u8d25\uff1a" + finalPhoneNo + " message:" + messageJson);
            log.error("ErrCode:" + e.getErrCode());
            log.error("ErrMsg:" + e.getErrMsg());
            log.error("RequestId:" + e.getRequestId());
            if (sendSMSCallBack != null) {
                sendSMSCallBack.onException(e);
            }
            return false;
        }
    }

    public String index(AliyunSMSProperties aliyunSMSProperties) {
        return aliyunSMSProperties.getIndex();
    }

    public boolean isDefault(AliyunSMSProperties aliyunSMSProperties) {
        return aliyunSMSProperties.isAsDefaultTemplate();
    }
}

