/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.kafka.config;

import com.ifourthwall.kafka.DataHandler;
import com.ifourthwall.kafka.KafkaDataConsumer;
import com.ifourthwall.kafka.config.IFWKafkaConsumerProperty;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.kafka.config.ConcurrentKafkaListenerContainerFactory;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;
import org.springframework.kafka.listener.ConcurrentMessageListenerContainer;
import org.springframework.kafka.listener.ContainerProperties;
import org.springframework.util.CollectionUtils;

@Configuration
@ConditionalOnProperty(prefix="ifw.kafka.consumer", name={"enable"}, havingValue="true", matchIfMissing=false)
@EnableConfigurationProperties(value={IFWKafkaConsumerProperty.class})
@AutoConfigureOrder(value=-2147480648)
public class IFWKafkaConsumerConfig {
    @Autowired
    private IFWKafkaConsumerProperty ifwKafkaConsumerProperty;
    @Autowired
    private List<DataHandler> dataHandlerList;
    @Autowired
    private GenericApplicationContext applicationContext;

    @PostConstruct
    public void initKafkaConsumer() {
        if (!CollectionUtils.isEmpty(this.ifwKafkaConsumerProperty.getConfig())) {
            this.ifwKafkaConsumerProperty.getConfig().stream().forEach(consumerConfigProp -> {
                HashMap<String, Object> configs = new HashMap<String, Object>();
                configs.put("bootstrap.servers", consumerConfigProp.getBootstrapServers());
                configs.put("group.id", consumerConfigProp.getConsumerGroupId());
                configs.put("enable.auto.commit", consumerConfigProp.getConsumerEnableAutoCommit());
                configs.put("auto.commit.interval.ms", consumerConfigProp.getConsumerAutoCommitIntervalMs());
                configs.put("session.timeout.ms", consumerConfigProp.getConsumerSessionTimeoutMs());
                configs.put("max.poll.records", consumerConfigProp.getConsumerMaxPollRecords());
                configs.put("auto.offset.reset", consumerConfigProp.getConsumerAutoOffsetReset());
                configs.put("key.deserializer", StringDeserializer.class);
                configs.put("value.deserializer", StringDeserializer.class);
                DefaultKafkaConsumerFactory defaultKafkaConsumerFactory = new DefaultKafkaConsumerFactory(configs);
                this.applicationContext.registerBean(StringUtils.joinWith((String)"-", (Object[])new Object[]{ConcurrentMessageListenerContainer.class, consumerConfigProp.getKafkaTopic(), consumerConfigProp.getConsumerGroupId()}), ConcurrentMessageListenerContainer.class, () -> {
                    ContainerProperties containerProps = new ContainerProperties(new String[]{consumerConfigProp.getKafkaTopic()});
                    containerProps.setGroupId(consumerConfigProp.getConsumerGroupId());
                    containerProps.setMessageListener((Object)new KafkaDataConsumer(this.dataHandlerList));
                    ConcurrentKafkaListenerContainerFactory factory = new ConcurrentKafkaListenerContainerFactory();
                    factory.setConsumerFactory((ConsumerFactory)defaultKafkaConsumerFactory);
                    ConcurrentMessageListenerContainer container = new ConcurrentMessageListenerContainer((ConsumerFactory)defaultKafkaConsumerFactory, containerProps);
                    container.setConcurrency(consumerConfigProp.getConcurrency());
                    return container;
                }, new BeanDefinitionCustomizer[0]);
            });
        }
    }
}

