package com.ifourthwall.kafka;

import lombok.extern.slf4j.Slf4j;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.kafka.listener.AcknowledgingConsumerAwareMessageListener;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * @Author: hao.dai
 * @Date: 2019/12/25 17:31
 * @Description:
 */
@KafkaListener(containerFactory = "MessageListenerContainer")
@Slf4j
public class KafkaDataConsumer implements AcknowledgingConsumerAwareMessageListener {

    private List<DataHandler> dataHandlerList;

    public KafkaDataConsumer(List<DataHandler> dataHandlerList) {
        this.dataHandlerList = dataHandlerList;
    }

    @Override
    public void onMessage(ConsumerRecord data, Acknowledgment acknowledgment, Consumer consumer) {
        log.info("kafka消费接受到数据:{}", data.value());
        consumer.commitSync();
        try {
            if (!CollectionUtils.isEmpty(dataHandlerList)) {
                for (DataHandler dataHandler : dataHandlerList) {
                    if (dataHandler.judge(data.topic())) {
                        dataHandler.handle(data.value().toString());
                    }
                }
            }
            consumer.commitSync();
            log.info("处理数据成功");
        } catch (Exception e) {
            log.error("kafka消费数据失败，失败原因:", e);
        }
    }

    /**
     * Invoked with data from kafka.
     *
     * @param data the data to be processed.
     */
    @Override
    public void onMessage(Object data) {

    }
}
