package com.ifourthwall.kafka;

import lombok.extern.slf4j.Slf4j;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.support.SendResult;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;

import java.util.concurrent.TimeUnit;

/**
 * @Author: hao.dai
 * @Date: 2019/12/24 15:28
 * @Description:
 */
@Slf4j
public class IFWKafkaClient {

    private KafkaTemplate<String, Object> kafkaTemplate;
    private String topic;

    public IFWKafkaClient(KafkaTemplate<String, Object> kafkaTemplate, String topic) {
        this.kafkaTemplate = kafkaTemplate;
        this.topic = topic;
    }

    public boolean produce(final String alertMsg, KafkaProducerCallBack callBack) {
        //数据上传
        log.info("写入kafka produce data=" + alertMsg);
        ListenableFuture<SendResult<String, Object>> future = kafkaTemplate.send(topic, alertMsg);
        future.addCallback(new ListenableFutureCallback<SendResult<String, Object>>() {
            @Override
            public void onSuccess(SendResult<String, Object> result) {
                //记录发送成功次数
                callBack.succeed(result);
            }

            @Override
            public void onFailure(Throwable ex) {
                callBack.failed(alertMsg, ex);
            }
        });
        return true;
    }

    /**
     * 同步写
     */
    public void syncProduce(String data) {
        //数据上传
        log.info("同步写入kafka produce data={}", data);
        try {
            //目前设计为同步，10秒超时
            kafkaTemplate.send(topic, data).get(10, TimeUnit.SECONDS);
        } catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}
