/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.config;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.exception.NacosException;
import java.io.IOException;
import java.io.StringReader;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;

public class IFWApplicationContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext>,
EnvironmentPostProcessor,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(IFWApplicationContextInitializer.class);
    public static final int DEFAULT_ORDER = 0;
    public static final String PROPERTY_SOURCE_NAME = "configCenterComposite";

    public void initialize(ConfigurableApplicationContext applicationContext) {
        log.info("handle initialize environment........");
        this.initEnvironment(applicationContext.getEnvironment());
    }

    private void initEnvironment(ConfigurableEnvironment environment) {
        String enable = environment.getProperty("nacos.config.bootstrap.enable");
        if (enable == null || !StringUtils.equals((CharSequence)"true", (CharSequence)enable)) {
            return;
        }
        if (environment.getPropertySources().contains(PROPERTY_SOURCE_NAME)) {
            return;
        }
        CompositePropertySource source = new CompositePropertySource(PROPERTY_SOURCE_NAME);
        String configContent = this.acquireConfigContent(environment);
        if (StringUtils.isBlank((CharSequence)configContent)) {
            log.warn("nacos\u83b7\u53d6\u521d\u59cb\u5316\u5185\u5bb9\u5931\u8d25\uff0c\u8fd4\u56de\u4e3a\u7a7a");
            return;
        }
        Properties properties = new Properties();
        try {
            properties.load(new StringReader(configContent));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        PropertiesPropertySource propertySource = new PropertiesPropertySource("configCenter", properties);
        source.addPropertySource((PropertySource)propertySource);
        environment.getPropertySources().addFirst((PropertySource)source);
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    private String acquireConfigContent(ConfigurableEnvironment environment) {
        String dataId = environment.getProperty("nacos.config.data-id");
        String group = environment.getProperty("nacos.config.group");
        String type = environment.getProperty("nacos.config.type");
        String serverAddr = environment.getProperty("nacos.config.serverAddr");
        String namespace = environment.getProperty("nacos.config.namespace");
        String accessKey = environment.getProperty("nacos.config.access-key");
        String secretKey = environment.getProperty("nacos.config.secret-key");
        if (!"properties".equals(type)) {
            throw new IllegalArgumentException("Not support type. Supported type include [properties].");
        }
        Properties properties = new Properties();
        properties.put("serverAddr", serverAddr);
        properties.put("namespace", namespace);
        properties.put("accessKey", accessKey);
        properties.put("secretKey", secretKey);
        try {
            ConfigService configService = NacosFactory.createConfigService((Properties)properties);
            return configService.getConfig(dataId, group, 5000L);
        }
        catch (NacosException e) {
            throw new RuntimeException(e);
        }
    }

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        log.info("handle postProcessEnvironment........");
        this.initEnvironment(environment);
    }
}

