package com.ifourthwall.config;

import com.alibaba.boot.nacos.config.autoconfigure.NacosConfigAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;

/**
 * @Author: hao.dai
 * @Project: ifourthwall-parent
 * @Date: 2020/4/8 18:56
 * @Description:
 * @Godzilla.tech
 */
@Configuration
@ConditionalOnProperty(prefix = "nacos.config.bootstrap", name = "enable", havingValue = "true", matchIfMissing = false)
@ImportAutoConfiguration(value = {NacosConfigAutoConfiguration.class})
@AutoConfigureOrder(value = Ordered.HIGHEST_PRECEDENCE)
public class ConfigCenterAutoConfiguration {

}
