/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.common.utils;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.TimeZone;

public class IFWTimeUtils {
    private static final int FRACTION_MIN_WIDTH = 0;
    private static final int FRACTION_MAX_WIDTH = 9;
    private static final boolean ADD_DECIMAL_POINT = true;
    public static final String ASIA_TOKYO = "JST";
    public static final String ASIA_SHANGHAI = "CTT";
    public static final String EUROPE_PARIS = "CST";
    public static final DateTimeFormatter RFC3339_FORMATTER = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd'T'HH:mm:ss").appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).appendZoneOrOffsetId().toFormatter();
    public static final DateTimeFormatter NORMAL_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withZone(TimeZone.getDefault().toZoneId());

    public static String formatRCF3339(String rfc3339Format, String zoneId) {
        ZonedDateTime zonedDateTime = ZonedDateTime.parse(rfc3339Format, RFC3339_FORMATTER);
        return zonedDateTime.withZoneSameInstant(ZoneId.of(zoneId, ZoneId.SHORT_IDS)).toString();
    }

    public static String formatNormal(String normal, String zoneId) {
        ZonedDateTime zonedDateTime = ZonedDateTime.parse(normal, NORMAL_FORMATTER);
        return zonedDateTime.withZoneSameInstant(ZoneId.of(zoneId, ZoneId.SHORT_IDS)).toString();
    }

    public static void main(String[] args) {
        System.out.println(IFWTimeUtils.formatRCF3339("2020-11-03T18:30:23.124824973+08:00", ASIA_TOKYO));
        System.out.println(IFWTimeUtils.formatRCF3339("2020-11-03T18:30:23.124824973+08:00", ASIA_SHANGHAI));
        System.out.println(IFWTimeUtils.formatRCF3339("2020-11-03T18:30:23.124824973+08:00", EUROPE_PARIS));
        System.out.println(IFWTimeUtils.formatNormal("2020-10-10 23:11:00", ASIA_TOKYO));
    }
}

