package com.ifourthwall.common.utils;

import com.ifourthwall.common.PlatformCodeEnum;
import com.ifourthwall.common.exception.BizException;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import java.util.Set;

/**
 * @Author: hao.dai
 * @Date: 2019/8/9 13:07
 * @Description:
 */
public class IFWValidator {
    private static final Validator validator;

    static {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        validator = factory.getValidator();
    }

    public static <T> void validate(T t) {
        Set<ConstraintViolation<T>> constraintViolations =
                validator.validate(t);

        if (constraintViolations == null || constraintViolations.size() < 1) {
            return;
        }

        ConstraintViolation<T> constraintViolation = constraintViolations.stream().findFirst().get();
        throw new BizException(constraintViolation.getMessage(), PlatformCodeEnum.VALIDATION_ERROR.getCode());
    }

}
