package com.ifourthwall.common.utils;

import com.ifourthwall.common.PlatformCodeEnum;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.common.exception.BizException;
import org.apache.commons.lang3.StringUtils;

/**
 * @author: fpc
 * @data: 2020/3/5 11:37
 * @Description:
 */
public class CheckAccessUtils {

    /**
     * 判断租户id是否合法
     * @Author: YangPeng
     * @Date: 2020/3/5 18:01
     * @param jugeId 租户id
     * @param user user对象
     * @return java.lang.String
     * @throws
     */
    public static String judgeTenantId(String jugeId, IFWUser user) {
        //如果user角色为null
        if (StringUtils.isEmpty(user.getRoleType())){
            throw new BizException("无权访问！","020");
        }
        String tenantId = null;
        //判断是否有租户id
        //判断角色身份
        if ("0".equals(user.getRoleType())) { // 超级管理员
            //查询全部租户信息
            if (StringUtils.isEmpty(jugeId)) {
                return tenantId;
            }
            if (!StringUtils.isEmpty(jugeId)) {
                tenantId = jugeId;
                return tenantId;
            }

        } else if("1".equals(user.getRoleType())){ //普通用户
            //判断用户传的租户id和token中的是否一样
            if (!StringUtils.isEmpty(jugeId)) {
                if (!jugeId.equals(user.getTenantId())) {
                    throw new BizException("无权访问！","020");
                }
                tenantId = jugeId;
                return tenantId;
            }
            if (StringUtils.isEmpty(jugeId)) {
                tenantId = user.getTenantId();
            }
        }
        return tenantId;
    }

    /**
     * 校验租户id是否为空
     * @Author: YangPeng
     * @Date: 2020/3/6 11:35
     * @param tenantId
     * @return void
     * @throws
     */
    public static void tenantIdIsNull(String tenantId){
        if (StringUtils.isEmpty(tenantId)){
            throw new BizException("租户id不能为空！", PlatformCodeEnum.SYS_ERROR.getCode());
        }
    }
}
