package com.ifourthwall.common.base;

import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.List;

/**
 * @Author: hao.dai
 * @Date: 2019/11/25 09:44
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class IFWUser implements Serializable {
    /**
     * 用户id
     */
    private String userId;
    /**
     * 登录名
     */
    private String loginName;
    /**
     * 电话号码
     */
    private String phone;
    /**
     * 电邮
     */
    private String email;
    /**
     * 头像
     */
    private String iconUrl;
    /**
     * 背景图片
     */
    private String backgroundUrl;
    /**
     * 备注
     */
    private String remark;
    /**
     * 租户id
     */
    private String tenantId;
    /**
     * 组织id
     */
    private String organizationId;
    /**
     * 组织名称
     */
    private String organizationName;

    /**
     * 岗位
     */
    private List<IFWPosition> positions;
    /**
     * 雇员信息
     */
    private IFWEmployee employee;

    /**
     * 角色类型 0-代表平台管理员 1-代表租户
     */
    private String roleType;

    /**
     * 角色
     */
    private List<IFWRole> roles;

    /**
     * 部门ids
     */
    private List<String> deptIds;

}
