package com.ifourthwall.common.base;

import com.ifourthwall.common.PlatformCodeEnum;
import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.TimeZone;

/**
 * @Author: hao.dai
 * @Date: 2019/8/8 15:50
 * @Description:
 */
@Data
@ToString
public class BaseResponse<T> implements Serializable {
    private String retCode;
    private String retMsg;
    //true - success  false - failure
    private boolean flag;
    private T data;
    private String timeZone = TimeZone.getDefault().getID();

    public BaseResponse() {
        this.flag = true;
    }

    public boolean isSuccess() {
        return flag && PlatformCodeEnum.EXECUTE_SUCCESS.getCode().equals(retCode);
    }

    public BaseResponse(String retCode, String retMsg, T data) {
        super();
        this.retCode = retCode;
        this.retMsg = retMsg;
        this.data = data;
    }

    public BaseResponse(String retCode, T data) {
        super();
        this.retCode = retCode;
        this.data = data;
    }

    public BaseResponse(String retCode, String retMsg, boolean flag, T data) {
        this.retCode = retCode;
        this.retMsg = retMsg;
        this.flag = flag;
        this.data = data;
    }

    public static BaseResponse success(String retCode, String retMsg) {
        return new BaseResponse(retCode, retMsg, true);
    }

    public static <T> BaseResponse success(String retCode, String retMsg, T data) {
        return new BaseResponse(retCode, retMsg, true, data);
    }
}
