/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.camera.aliyun;

import com.aliyuncs.AcsRequest;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.vs.model.v20181212.ContinuousMoveRequest;
import com.aliyuncs.vs.model.v20181212.ContinuousMoveResponse;
import com.aliyuncs.vs.model.v20181212.StopMoveRequest;
import com.aliyuncs.vs.model.v20181212.StopMoveResponse;
import com.ifourthwall.camera.core.IFWCameraOperation;
import com.ifourthwall.camera.core.model.CameraOpsResponse;
import org.springframework.beans.factory.annotation.Autowired;

public class AliyunCameraOperation
implements IFWCameraOperation {
    public static final String DEFAULT_PAN_LEFT = "0.5";
    public static final String DEFAULT_TILT_UP = "0.5";
    public static final String DEFAULT_PAN_RIGHT = "-0.5";
    public static final String DEFAULT_TILT_DOWN = "-0.5";
    public static final String DEFAULT_ZOOM_OUT = "-0.5";
    public static final String DEFAULT_ZOOM_IN = "0.5";
    @Autowired
    private IAcsClient client;

    public CameraOpsResponse horizontalLeftContinuousMove(String cameraId) {
        return this.continuousMove(cameraId, "0.5", null, null);
    }

    public CameraOpsResponse verticalUpContinuousMove(String cameraId) {
        return this.continuousMove(cameraId, null, "0.5", null);
    }

    public CameraOpsResponse horizontalRightContinuousMove(String cameraId) {
        return this.continuousMove(cameraId, "-0.5", null, null);
    }

    public CameraOpsResponse verticalDownContinuousMove(String cameraId) {
        return this.continuousMove(cameraId, null, "-0.5", null);
    }

    public CameraOpsResponse continuousMove(String cameraId, String pan, String tilt) {
        return this.continuousMove(cameraId, pan, tilt, null);
    }

    public CameraOpsResponse continuousZoomIn(String cameraId) {
        return this.continuousMove(cameraId, null, null, "0.5");
    }

    public CameraOpsResponse continuousZoomOut(String cameraId) {
        return this.continuousMove(cameraId, null, null, "-0.5");
    }

    public CameraOpsResponse continuousMove(String cameraId, String pan, String tilt, String zoom) {
        try {
            ContinuousMoveRequest request = new ContinuousMoveRequest();
            request.setId(cameraId);
            request.setActionName("ContinuousMove");
            request.setPan(pan);
            request.setTilt(tilt);
            request.setZoom(zoom);
            ContinuousMoveResponse resp = (ContinuousMoveResponse)this.client.getAcsResponse((AcsRequest)request);
            return new CameraOpsResponse(resp.getRequestId(), resp.getId());
        }
        catch (ClientException e) {
            throw new RuntimeException(e);
        }
    }

    public CameraOpsResponse stopMove(String cameraId, boolean pan, boolean tilt, boolean zoom) {
        try {
            StopMoveRequest request = new StopMoveRequest();
            request.setId(cameraId);
            request.setActionName("StopMove");
            request.setPan(Boolean.valueOf(pan));
            request.setTilt(Boolean.valueOf(tilt));
            request.setZoom(Boolean.valueOf(zoom));
            StopMoveResponse rsp = (StopMoveResponse)this.client.getAcsResponse((AcsRequest)request);
            return new CameraOpsResponse(rsp.getRequestId(), rsp.getId());
        }
        catch (ClientException e) {
            throw new RuntimeException(e);
        }
    }

    public CameraOpsResponse stopMovePan(String cameraId) {
        return this.stopMove(cameraId, true, false, false);
    }

    public CameraOpsResponse stopMoveTilt(String cameraId) {
        return this.stopMove(cameraId, false, true, false);
    }

    public CameraOpsResponse stopMoveZoom(String cameraId) {
        return this.stopMove(cameraId, false, false, true);
    }

    public CameraOpsResponse stopMove(String cameraId) {
        return this.stopMove(cameraId, true, true, true);
    }
}

