package com.ifourthwall.dbm.user.facade;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.dbm.user.dto.UserWechatDTO;

import java.util.List;

/**
 * @Author: daixingqiang
 * @Description:
 * @Date: Created in 16:14 2019/10/31
 * @Modified By:
 */
public interface UserWechatFacade {

    /**
     * 新增微信用户信息
     * @Param: [userWechatDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.user.dto.UserWechatDTO>
     * @Author: daixingqiang
     * @Date: 2019/11/1 11:35
     */

    BaseResponse<UserWechatDTO> saveUserWechat(UserWechatDTO userWechatDTO);
    /**
     * 查询微信用户
     * @Param: [userWechatDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.user.dto.UserWechatDTO>
     * @Author: daixingqiang
     * @Date: 2019/11/1 11:54
     */
    BaseResponse<UserWechatDTO> queryUserwechat(UserWechatDTO userWechatDTO);

    /**
     * 查询微信用户列表
     * @Param: [userWechatDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.user.dto.UserWechatDTO>
     * @Author: daixingqiang
     * @Date: 2019/11/1 15:24
     */
    BaseResponse<List<UserWechatDTO>> queryListUserWechat(UserWechatDTO userWechatDTO);

  /*  *//**
     * 删除微信用户
     * @Param: [userWechatDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.user.dto.UserWechatDTO>
     * @Author: daixingqiang
     * @Date: 2019/11/1 15:36
     *//*
    BaseResponse<UserWechatDTO> deleteUserWechat(UserWechatDTO userWechatDTO);*/


    /**
     * 更新微信用户openid
     * @Param: [userWechatDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.user.dto.UserWechatDTO>
     * @Author: daixingqiang
     * @Date: 2019/11/1 16:08
     */
    BaseResponse<UserWechatDTO> updateUserWechat(UserWechatDTO userWechatDTO);


}
