package com.ifourthwall.dbm.user.facade;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.dbm.user.dto.*;

import java.time.ZonedDateTime;
import java.util.List;

/**
 * @Author: daixingqiang
 * @Description:
 * @Date: Created in 13:43 2019/10/28
 * @Modified By:
 */
public interface UserFacade {
    /**
     * 创建用户
     * @Param: [userDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse<java.lang.Integer>
     * @Author: daixingqiang
     * @Date: 2019/10/28 14:53
     */
    BaseResponse<InsertUserResDTO> saveUser(InsertUserDTO insertUserDTO);

    /**
     * 删除用户
     *
     * @Param: [deleteUserDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse<java.lang.Integer>
     * @Author: daixingqiang
     * @Date: 2019/10/28 14:55
     */
    BaseResponse<DeleteUserDTO> deleteUser(DeleteUserDTO deleteUserDTO);

    /**
     * 修改用户
     * @Param: updateUserDTO
     * @Return: com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.user.dto.UpdateUserDTO>
     * @Author: tanglei
     * @Date: 2020/1/8 17:25
     */
    BaseResponse<UpdateUserDTO> updateUser(UpdateUserDTO updateUserDTO);

    /**
     * 回显用户的信息
     * @Param: [getUserDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse <  com.ifourthwall.dbm.user.dto.UserInformationDTO>>
     * @Author: tanglei
     * @Date: 2020/1/8 14:39
     */
    BaseResponse<List<UserInformationDTO>> queryUser(GetUserDTO getUserDTO);

    /**
     * 修改用户密码
     * @Param: [updatePaswordDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse <com.ifourthwall.dbm.user.dto.UpdatePaswordDTO>
     * @Author: tanglei
     * @Date: 2020/1/3 11:00
     */
    BaseResponse<UpdatePaswordDTO> updateUserPassword(UpdatePaswordDTO updatePaswordDTO);


    /**
     * 通过邮箱或者手机找回用户密码
     *
     * @Param: [phone, newPassword, code]
     * @Return: com.ifourthwall.common.base.BaseResponse<java.lang.Integer>
     * @Author: tanglei
     * @Date: 2020/1/14 17:56
     */
    void findUserPassword(UsernameAndPasswordDTO usernameAndPasswordDTO);


    /**
     * 根据用户id查询微信用户
     *
     * @Param: [userId]
     * @Return: com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.user.dto.UserWechat>
     * @Author: daixingqiang
     * @Date: 2019/10/29 17:30
     */
    BaseResponse<UserWechatDTO> queryUserWechatByUserId(UserDTO userDTO);


    /**
     * 用户列表和用户搜索
     * @Param: [pageReqDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse < com.ifourthwall.dbm.user.dto.PageUserResponseDTO>
     * @Author: tanglei
     * @Date: 2020/1/8 14:396
     */
    BaseResponse<PageUserResponseDTO> queryListUserAndFindUser(PageUserReqDTO pageUserReqDTO);


    /**
     * 根据多个用户Ids查询多个用户信息
     * @Param: [userDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse<java.util.List<com.ifourthwall.dbm.user.dto.UserDTO>>
     * @Author: daixingqiang
     * @Date: 2019/11/25 18:42
     */
    BaseResponse<List<UserDTO>> queryListUserDTO(UserDTO userDTO);

    /**
     * 根据邮箱注册用户
     * @Param: [registerEmailDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.user.dto.RegisterEmailDTO>
     * @Author: tanglei
     * @Date: 2019/11/29 16:56
     */
    BaseResponse<RegisterEmailDTO> registerUser(RegisterEmailDTO registerEmailDTO);


    /**
     * 根据手机注册用户
     * @Param: [registerPhoneDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.user.dto.RegisterPhoneDTO>
     * @Author: tanglei
     * @Date: 2019/12/26 18:03
     */
    BaseResponse<RegisterPhoneDTO> registerPhoneUser(RegisterPhoneDTO registerPhoneDTO);


    /**
     * 重置密码
     *
     * @Param: [resetPasswordDTO]
     * @Return: org.springframework.http.ResponseEntity<com.ifourthwall.common.base.BaseResponse <  com.ifourthwall.dbm.user.dto.ResetPasswordDTO>>
     * @Author: tangelei
     * @Date: 2020/1/3 11:24
     */
    BaseResponse<ResetPasswordDTO> resetPassword(ResetPasswordDTO resetPasswordDTO);

    /**
     * 获取用户的信息
     * @Param: [userInfoDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.user.dto.UserInfoDTO>
     * @Author: tanglei
     * @Date: 2019/12/30 11:12
     */
    BaseResponse<UserInfoDTO> findUserInfoUserId(UserInfoInDTO userInfoInDTO);


    /**
     * 根据用户ids获取用户的真实的真实姓名
     * @Param: [userDeatilInfoDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse<java.util.List< com.ifourthwall.dbm.user.dto.UserDeatilInfoDTO>>
     * @Author: tanglei
     * @Date: 2019/12/31 14:40
     */
    BaseResponse<List<UserDeatilInfoDTO>> queryUserDetailByUserId(UserDeatilInfoInDTO userDeatilInfoInDTO);

    /**
     * 项目的人员信息和部门信息
     * @Param: [deptUserInfoInDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse<java.util.List<com.ifourthwall.dbm.user.dto.DeptUserInfoDTO>>
     * @Author: tanglei
     * @Date: 2020/1/2 14:28
     */
    BaseResponse<List<DeptUserInfoDTO>> queryProjectUserDeptIds(DeptUserInfoInDTO deptUserInfoInDTO);

    /**
     * 岗位树
     * @Param: queryPositionTreeReqDTO
     * @Return: com.ifourthwall.common.base.BaseResponse< java.util.List< com.ifourthwall.dbm.user.dto.QueryPositionTreeResDTO>>>
     * @Author: tanglei
     * @Date: 2020/1/11 18:07
     */
    BaseResponse<List<QueryPositionTreeResDTO>> queryPositionTree(QueryPositionTreeReqDTO queryPositionReqDTO);


    /**
     * 登录
     * @Param: [loginReqDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.user.dto.LoginResDTO>
     * @Author: tanglei
     * @Date: 2020/1/16 11:49
     */
    BaseResponse<LoginResDTO> login(LoginReqDTO loginReqDTO);


    /**
     * 查询部门下的人员信息
     * @Param: [deptUserInfoInDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.user.dto.FindDeptUserResDTO>
     * @Author: tanglei
     * @Date: 2020/1/2 14:28
     */
    BaseResponse<FindDeptUserResDTO> queryDeptUser(FindDeptUserReqDTO findDeptUserReqDTO);


    /**
     * 绑定手机或者修改手机
     * @Param: updateUserPhoneDTO
     * @Return: com.ifourthwall.common.base.BaseResponse< com.ifourthwall.dbm.user.dto.UpdateUserPhoneDTO>
     * @Author: tanglei
     * @Date: 2020/1/20 17:26
     */
    BaseResponse<UpdateUserPhoneDTO> bindingAndUpdatePhone(UpdateUserPhoneDTO updateUserPhoneDTO);

    BaseResponse<UpdateUserEmailDTO> bindingAndUpdateEmail(UpdateUserEmailDTO updateUserEmailDTO);

    /**
     * 根据员工的姓名查询用户的id集合
     * @Param: [deptUserInfoInDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse<  com.ifourthwall.dbm.user.dto.QueryUserIdsResDTO>>
     * @Author: tanglei
     * @Date: 2020/2/10 17:28
     */
    BaseResponse<QueryUserIdsResDTO> queryUserIdsByEmployeeName(QueryUserIdsReqDTO queryUserIdsReqDTO);

    /**
     * 根据用户id查询角色模块的信息
     * @Param: [queryRoleModuleServiceReqDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse<   com.ifourthwall.dbm.user.dto.QueryRoleModuleServiceResDTO>>>
     * @Author: tanglei
     * @Date: 2020/2/17 17:28
     */
    BaseResponse<List<QueryRoleModuleServiceResDTO>> queryRoleModuleServiceByUserId(QueryRoleModuleServiceReqDTO queryRoleModuleServiceReqDTO);

    /**
     * 显示分页的人员信息并且可以通过部门id进行筛选
     * @Param: [pageUserDeptReqDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.user.dto.PageUserDeptResDTO>>
     * @Author: tanglei
     * @Date: 2020/2/21 14:38
     */
    BaseResponse<PageUserDeptResDTO> queryUserDeptPosition(PageUserDeptReqDTO pageUserDeptReqDTO);

    /**
     * 组织结构下人员和部门信息
     * @Param: [deptUserReqDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse< java.until.List<com.ifourthwall.dbm.user.dto.DeptUserResDTO>>
     * @Author: tanglei
     * @Date: 2020/2/24 14:38
     */
    BaseResponse<DeptUserResDTO> queryProjectDeptUser(DeptUserReqDTO deptUserReqDTO);

    /**
     * 修改用户的基本信息
     * @Param: [updateUserBaseInfoDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.user.dto.UpdateUserBaseInfoDTO>
     * @Author: tanglei
     * @Date: 2020/3/25 14:38
     */
    BaseResponse updateUserBaseInfo(UpdateUserBaseInfoDTO updateUserBaseInfoDTO);


    /**
     * 联系我们
     * @Param: [insertContactUsDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse< com.ifourthwall.dbm.user.dto.InsertContactUsDTO>
     * @Author: tanglei
     * @Date: 2020/3/25 14:38
     */
    BaseResponse saveContactUs(InsertContactUsDTO insertContactUsDTO);

    BaseResponse<UserBaseInfoDTO> selectBaseInfo(ValidateEmailAndPhoneDTO validateEmailAndPhoneDTO);

    /**
     * 根据用户ids查询真实姓名
     * @Param: [queryRealNameReqDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse< java.util.List<  com.ifourthwall.dbm.user.dto.QueryRealNameResDTO>
     * @Author: tanglei
     * @Date: 2020/3/31 14:38
     */
    BaseResponse<List<QueryRealNameResDTO>> queryRealNameByUserIds(QueryRealNameReqDTO queryRealNameReqDTO);

    /**
     * 验证用户名和手机号
     * @Param: validateLoginNameAndPhoneDTO
     * @Return: com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.user.dto.ValidateLoginNameAndPhoneDTO>
     * @Author: tanglei
     * @Date: 2020/4/17 14:21
     */
    BaseResponse<ValidateLoginNameAndPhoneDTO> verifyLoginNameAndPhone(ValidateLoginNameAndPhoneDTO validateLoginNameAndPhoneDTO);


}
