package com.ifourthwall.dbm.user.facade;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.dbm.user.dto.EmployeeDTO;
import com.ifourthwall.dbm.user.dto.IFWEmployeeDTO;

/**
 * @Author: daixingqiang
 * @Description:
 * @Date: Created in 15:46 2019/11/7
 * @Modified By:
 */
public interface EmployeeFacade {
    /**
     * 新增雇员信息
     *
     * @Param: [employeeDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.user.dto.EmployeeDTO>
     * @Author: daixingqiang
     * @Date: 2019/11/7 15:48
     */
    BaseResponse<EmployeeDTO> saveEmployee(EmployeeDTO employeeDTO);

    /**
     * 查询雇员信息
     *
     * @Param: [employeeDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.user.dto.EmployeeDTO>
     * @Author: daixingqiang
     * @Date: 2019/11/7 15:56
     */
    BaseResponse<EmployeeDTO> queryEmployee(EmployeeDTO employeeDTO);

    /**
     * 编辑雇员信息
     *
     * @Param: [employeeDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.user.dto.EmployeeDTO>
     * @Author: daixingqiang
     * @Date: 2019/11/7 15:56
     */
    BaseResponse<EmployeeDTO> updateEmployee(EmployeeDTO employeeDTO);

    /**
     * 根据userId查询雇员的信息
     * @Param: [ifwEmployeeDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.user.dto.IFWEmployeeDTO>
     * @Author: tanglei
     * @Date: 2019/12/30 17:00
     */
    BaseResponse<IFWEmployeeDTO> findEmployeeId(IFWEmployeeDTO ifwEmployeeDTO);
}