package com.ifourthwall.dbm.user.facade;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.dbm.user.dto.InsertAuthenticationDTO;
import com.ifourthwall.dbm.user.dto.QueryAuthenticationReqDTO;
import com.ifourthwall.dbm.user.dto.QueryAuthenticationResDTO;
import com.ifourthwall.dbm.user.dto.UpdateAuthenticationResDTO;

/**
 * @Author: tanglei
 * @Date: 2020-01-03 17:51
 * @Description:
 */
public interface AuthenticationFacade {

    /**
     * 企业认证
     * @Param: [insertAuthenticationDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse< com.ifourthwall.dbm.user.dto.InsertAuthenticationDTO>
     * @Author: tanglei
     * @Date: 2020/1/3 18:28
     */
    BaseResponse<InsertAuthenticationDTO> saveAuthentication(InsertAuthenticationDTO insertAuthenticationDTO);


    /**
     *  查询企业认证信息
     * @Param: [queryAuthenticationReqDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse<  com.ifourthwall.dbm.user.dto.QueryAuthenticationResDTO>
     * @Author: tanglei
     * @Date: 2020/3/16 10:03
     */
    BaseResponse<QueryAuthenticationResDTO> queryAuthentication(QueryAuthenticationReqDTO queryAuthenticationReqDTO);

    /**
     * 修改企业认证
     * @Param: updateAuthenticationResDTO
     * @Return:  com.ifourthwall.common.base.BaseResponse<  com.ifourthwall.dbm.user.dto.UpdateAuthenticationResDTO>>
     * @Author: tanglei
     * @Date: 2020/3/25 10:41
     */
    BaseResponse<UpdateAuthenticationResDTO> updateAuthentication(UpdateAuthenticationResDTO updateAuthenticationResDTO);
}
