package com.ifourthwall.dbm.user.dto;

import com.ifourthwall.common.base.BaseReqDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import java.util.List;

/**
 * @author tanglei
 */
@Data
@ToString(callSuper = true)
public class UpdateCustomerResDTO extends BaseReqDTO {
    @ApiModelProperty("用户id")
    private String userId;

    @ApiModelProperty("客户名称")
    private String loginName;

    @ApiModelProperty("租户名称")
    private String tenantName;

    @ApiModelProperty("主账号密码")
    private String userPassword;

    @ApiModelProperty("邮箱")
    private String email;

    @ApiModelProperty("手机号码")
    private String phone;

    @ApiModelProperty("注册日期")
    private String createTime;

    @ApiModelProperty("认证id")
    private String authenticationId;

    @ApiModelProperty("注册方式")
    private String registrationMethod;

    @ApiModelProperty("公司名称")
    private String authenticationCompanyName;

    @ApiModelProperty("统一社会信用代码")
    private String authenticationCompanyCode;

    @ApiModelProperty("营业执照")
    private String authenticationLicenseUrl;

    @ApiModelProperty("企业状态")
    private String valid;

    @ApiModelProperty("认证状态")
    private String authenticationStatus;

    @ApiModelProperty("公司logo")
    private String authenticationLogoUrl;

    @ApiModelProperty("公司类型")
    private String authenticationCompanyType;

    @ApiModelProperty("公司规模")
    private String authenticationCompanyScale;

    @ApiModelProperty("公司地址")
    private String authenticationCompanyAddress;

    @ApiModelProperty("公司详细地址")
    private String authenticationCompanyDetailAddress;

    @ApiModelProperty("服务")
    private List<UpdateServiceDTO> serviceList;

}
