package com.ifourthwall.dbm.user.dto;

import com.ifourthwall.common.base.BaseReqDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import java.util.List;

/**
 * @Author: tanglei
 * @Date: 2020-01-04 17:59
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class QueryTreeDeptDTO extends BaseReqDTO {


    /**
     * 部门id
     */
    @ApiModelProperty("部门id")
    private String deptId;

    /**
     * 部门名字
     */
    @ApiModelProperty("部门名字")
    private String deptName;

    /**
     * 父级部门id
     */
    @ApiModelProperty("父级部门id")
    private String parentDeptId;


    /**
     * 岗位名字
     */
    @ApiModelProperty("岗位名字")
    private List<PositionNameDTO> positionNames;

    /**
     * 子级部门
     */
    @ApiModelProperty("子级部门")
    private List<QueryTreeDeptDTO> children;

}
