package com.ifourthwall.dbm.user.dto;

import com.ifourthwall.common.base.BaseReqDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.Email;

/**
 * @Author: tanglei
 * @Date: 2020-01-16 11:23
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class LoginReqDTO extends BaseReqDTO {

    /**
     * 登录名
     */
    @ApiModelProperty("账号密码登录时使用的字段 登录名")
    private String loginName;

    /**
     * 密码
     */
    @ApiModelProperty("账号密码登录时使用的字段 密码")
    private String userPassword;

    /**
     * 手机号码
     */
    @ApiModelProperty("使用手机登录的时候使用 手机号")
    @Length(min = 11)
    private String phone;

    /**
     * 电子邮箱
     */
    @ApiModelProperty("使用邮箱登录的时候使用 电子邮箱")
    @Email
    private String email;

    /**
     * 验证码
     */
    @ApiModelProperty("使用的手机登录或邮箱登录的时候使用")
    private String code;

    @ApiModelProperty("0 前台 1 后台")
    private String type;



}