package com.ifourthwall.dbm.user.dto;

import com.ifourthwall.common.base.IFWEmployee;
import com.ifourthwall.common.base.IFWPosition;
import com.ifourthwall.common.base.IFWRole;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @Author: tanglei
 * @Date: 2020-03-25 13:47
 * @Description:
 */
@Data
@ToString
public class IFUserDTO implements Serializable {

    /**
     * 用户id
     */
    private String userId;
    /**
     * 登录名
     */
    private String loginName;
    /**
     * 电话号码
     */
    private String phone;
    /**
     * 电邮
     */
    private String email;
    /**
     * 头像
     */
    private String iconUrl;
    /**
     * 背景图片
     */
    private String backgroundUrl;
    /**
     * 备注
     */
    private String remark;

    /**
     * 创建时间
     */
    private Date creatTime;

    /**
     * 租户id
     */
    private String tenantId;
    /**
     * 组织id
     */
    private String organizationId;
    /**
     * 组织名称
     */
    private String organizationName;


    @ApiModelProperty("0 - 未认证  1 - 认证通过 2 - 认证失败")
    private String authenticationStatus;

    /**
     * 岗位
     */
    private List<IFWPosition> positions;
    /**
     * 雇员信息
     */
    private IFWEmployee employee;

    /**
     * 角色类型 0-代表平台管理员 1-代表租户
     */
    private String roleType;

    /**
     * 角色
     */
    private List<IFWRole> roles;

    /**
     * 部门ids
     */
    private List<String> deptIds;


    @ApiModelProperty("0普通租户  1超级管理员")
    private String isAdminTenant;



}
