/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.tracker.utils;

import com.ifourthwall.common.PlatformCodeEnum;
import com.ifourthwall.common.exception.BizException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

/*
 * Exception performing whole class analysis ignored.
 */
public class ExcelUtils {
    private static final Logger log = LoggerFactory.getLogger(ExcelUtils.class);

    public static void exportExcelData(Workbook wb, String fileName, HttpServletResponse response) {
        fileName = wb instanceof XSSFWorkbook ? fileName + ".xlsx" : fileName + ".xls";
        response.reset();
        response.setContentType("application/vnd.ms-excel;charset=utf-8");
        try {
            response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "utf-8"));
            response.setHeader("Access-Control-Allow-Origin", "*");
            ServletOutputStream os = response.getOutputStream();
            wb.write((OutputStream)os);
            os.flush();
            os.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static List<Object[]> importExcel(MultipartFile file) {
        log.info("\u5bfc\u5165\u89e3\u6790\u5f00\u59cb\uff0cfileName:{}");
        try {
            ArrayList<Object[]> list = new ArrayList<Object[]>();
            Workbook workbook = WorkbookFactory.create((InputStream)file.getInputStream());
            Sheet sheet = workbook.getSheetAt(0);
            int rows = sheet.getPhysicalNumberOfRows();
            for (int i = 0; i < rows; ++i) {
                Row row;
                if (i == 0 || (row = sheet.getRow(i)) == null) continue;
                Object[] objects = new Object[row.getPhysicalNumberOfCells()];
                int index = 0;
                if (objects != null && objects.length >= 5) {
                    for (Cell cell : row) {
                        String value = null;
                        value = ExcelUtils.getCellValue((Cell)cell);
                        if ((index == 0 || index == 1 || index == 2 || index == 3 || index == 4) && StringUtils.isEmpty((CharSequence)value)) {
                            throw new BizException("\u8bf7\u786e\u8ba4\u5fc5\u586b\u4fe1\u606f\u5df2\u5b8c\u5584|Please confirm that the required information is complete|\u5fc5\u9808\u60c5\u5831\u304c\u6574\u3063\u3066\u3044\u308b\u3053\u3068\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044", "2251");
                        }
                        objects[index] = value;
                        ++index;
                    }
                } else {
                    throw new BizException("\u8bf7\u786e\u8ba4\u5fc5\u586b\u4fe1\u606f\u5df2\u5b8c\u5584|Please confirm that the required information is complete|\u5fc5\u9808\u60c5\u5831\u304c\u6574\u3063\u3066\u3044\u308b\u3053\u3068\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044", "2251");
                }
                list.add(objects);
            }
            log.info("\u5bfc\u5165\u6587\u4ef6\u89e3\u6790\u6210\u529f\uff01");
            return list;
        }
        catch (BizException biz) {
            throw new BizException(biz.getMessage(), biz.getCode());
        }
        catch (Exception e) {
            log.error("\u5bfc\u5165\u6587\u4ef6\u89e3\u6790\u5931\u8d25", (Throwable)e);
            throw new BizException("\u5bfc\u5165\u6587\u4ef6\u89e3\u6790\u5931\u8d25\uff01", PlatformCodeEnum.SYS_ERROR.getCode());
        }
    }

    public static List<Object[]> importTaskTransferExcel(MultipartFile file) {
        log.info("\u5bfc\u5165\u89e3\u6790\u5f00\u59cb\uff0cfileName:{}");
        try {
            ArrayList<Object[]> list = new ArrayList<Object[]>();
            Workbook workbook = WorkbookFactory.create((InputStream)file.getInputStream());
            Sheet sheet = workbook.getSheetAt(0);
            int rows = sheet.getPhysicalNumberOfRows();
            for (int i = 0; i < rows; ++i) {
                Row row;
                if (i == 0 || (row = sheet.getRow(i)) == null) continue;
                Object[] objects = new Object[row.getPhysicalNumberOfCells()];
                int index = 0;
                if (objects != null && objects.length >= 3) {
                    for (Cell cell : row) {
                        String value = null;
                        value = ExcelUtils.getCellValue((Cell)cell);
                        objects[index] = value;
                        ++index;
                    }
                } else {
                    log.info("\u7b2c" + (i + 1) + "\u884c\u6570\u636e\u6709\u8bef");
                    continue;
                }
                list.add(objects);
            }
            log.info("\u5bfc\u5165\u6587\u4ef6\u89e3\u6790\u6210\u529f\uff01");
            return list;
        }
        catch (BizException biz) {
            throw new BizException(biz.getMessage(), biz.getCode());
        }
        catch (Exception e) {
            log.error("\u5bfc\u5165\u6587\u4ef6\u89e3\u6790\u5931\u8d25", (Throwable)e);
            throw new BizException("\u5bfc\u5165\u6587\u4ef6\u89e3\u6790\u5931\u8d25\uff01", PlatformCodeEnum.SYS_ERROR.getCode());
        }
    }

    public static String getCellValue(Cell cell) {
        String cellValue = "";
        if (cell == null) {
            return "";
        }
        switch (cell.getCellType()) {
            case 0: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    cellValue = sdf.format(DateUtil.getJavaDate((double)cell.getNumericCellValue())).toString();
                    break;
                }
                DataFormatter dataFormatter = new DataFormatter();
                cellValue = dataFormatter.formatCellValue(cell);
                break;
            }
            case 1: {
                cellValue = cell.getStringCellValue();
                break;
            }
            case 4: {
                cellValue = cell.getBooleanCellValue() + "";
                break;
            }
            case 2: {
                cellValue = cell.getRichStringCellValue().toString() + "";
                break;
            }
            case 3: {
                cellValue = "";
                break;
            }
            case 5: {
                cellValue = "\u975e\u6cd5\u5b57\u7b26";
                break;
            }
            default: {
                cellValue = "\u672a\u77e5\u7c7b\u578b";
            }
        }
        return cellValue;
    }
}

