/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.tracker.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/*
 * Exception performing whole class analysis ignored.
 */
public class DateUtils {
    public static Date getFirstDateOfMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(5, c.getActualMinimum(5));
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static Date getLastDateOfMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(5, c.getActualMaximum(5));
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        c.set(14, 0);
        return c.getTime();
    }

    public static boolean isSameDay(Date date1, Date date2) {
        if (date1 != null && date2 != null) {
            Calendar cal1 = Calendar.getInstance();
            cal1.setTime(date1);
            Calendar cal2 = Calendar.getInstance();
            cal2.setTime(date2);
            return DateUtils.isSameDay((Calendar)cal1, (Calendar)cal2);
        }
        throw new IllegalArgumentException("The date must not be null");
    }

    public static boolean isSameDay(Calendar cal1, Calendar cal2) {
        if (cal1 != null && cal2 != null) {
            return cal1.get(0) == cal2.get(0) && cal1.get(1) == cal2.get(1) && cal1.get(6) == cal2.get(6);
        }
        throw new IllegalArgumentException("The date must not be null");
    }

    public static Date getFirstDateOfDay(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static Date getLastDateOfDay(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        c.set(14, 0);
        return c.getTime();
    }

    public static Date getYearFirst(int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, year);
        Date currYearFirst = calendar.getTime();
        return currYearFirst;
    }

    public static Date getYearLast(int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, year);
        calendar.roll(6, -1);
        Date currYearLast = calendar.getTime();
        return currYearLast;
    }

    public static Date getStartDayOfWeekNo(int year, int weekNo) {
        Calendar c = DateUtils.getCalendarFormYear((int)year);
        c.setFirstDayOfWeek(2);
        c.setMinimalDaysInFirstWeek(7);
        c.set(3, weekNo);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        Date time = c.getTime();
        return time;
    }

    public static Date getEndDayOfWeekNo(int year, int weekNo) {
        Calendar c = DateUtils.getCalendarFormYear((int)year);
        c.setFirstDayOfWeek(2);
        c.setMinimalDaysInFirstWeek(7);
        c.set(3, weekNo);
        c.add(7, 6);
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        c.set(14, 0);
        Date time = c.getTime();
        return time;
    }

    public static Date getStartDayOfMonthNo(int year, int monthNo) {
        Calendar c = DateUtils.getCalendarFormYear((int)year);
        c.set(2, monthNo - 1);
        c.set(5, c.getActualMinimum(5));
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        Date time = c.getTime();
        return time;
    }

    public static Date getEndDayOfMonth(int year, int monthNo) {
        Calendar c = Calendar.getInstance();
        c.set(1, year);
        c.set(2, monthNo - 1);
        int lastDay = c.getActualMaximum(5);
        c.set(5, lastDay);
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        c.set(14, 0);
        Date time = c.getTime();
        return time;
    }

    public static void main(String[] args) {
        Date endDayOfMonth = DateUtils.getEndDayOfMonth((int)2020, (int)5);
        System.out.println(endDayOfMonth);
    }

    private static Calendar getCalendarFormYear(int year) {
        Calendar cal = Calendar.getInstance();
        cal.set(7, 2);
        cal.set(1, year);
        return cal;
    }

    public static int getWeekNo(Date date) {
        Calendar c = Calendar.getInstance();
        c.setFirstDayOfWeek(2);
        c.setMinimalDaysInFirstWeek(7);
        c.setTime(date);
        int weekNo = c.get(3);
        return weekNo;
    }

    public static int getYear() {
        Calendar c = Calendar.getInstance();
        int year = c.get(1);
        return year;
    }

    public static int getYearByDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(1);
    }

    public static int getMonthByDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(2) + 1;
    }

    public static Date convertStringToDate(String dateStr) {
        Date date = null;
        try {
            date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(dateStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public static int getDiffHour(Date leftDate, Date rightDate) {
        long milliseconds = Math.abs(leftDate.getTime() - rightDate.getTime());
        return (int)(milliseconds / 1000L / 60L / 60L);
    }

    public static Date addTimeToDate(Date date, long milliseconds) {
        long time = date.getTime() + milliseconds;
        Date result = new Date();
        result.setTime(time);
        return result;
    }
}

