/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.tracker.utils;

import com.ifourthwall.common.PlatformCodeEnum;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.common.exception.BizException;
import java.util.List;
import org.apache.dubbo.common.utils.StringUtils;

public class CheckAccessUtils {
    public static void checkAccess(IFWUser ifwUser, String tenantId) {
        if (!StringUtils.isEquals((String)ifwUser.getRoleType(), (String)"0")) {
            if (StringUtils.isBlank((String)tenantId)) {
                throw new BizException(PlatformCodeEnum.TENANT_ID_NOT_NULL.getDesc(), PlatformCodeEnum.TENANT_ID_NOT_NULL.getCode());
            }
            if (!StringUtils.isEquals((String)tenantId, (String)ifwUser.getTenantId())) {
                throw new BizException(PlatformCodeEnum.NO_POSITION_ACCESS.getDesc(), PlatformCodeEnum.NO_POSITION_ACCESS.getCode());
            }
        } else if (StringUtils.isBlank((String)tenantId)) {
            throw new BizException(PlatformCodeEnum.TENANT_ID_NOT_NULL.getDesc(), PlatformCodeEnum.TENANT_ID_NOT_NULL.getCode());
        }
    }

    public static void checkIFWUserPosition(IFWUser ifwUser) {
        if (ifwUser == null) {
            throw new BizException(PlatformCodeEnum.USER_INFO_IS_NULL.getDesc(), PlatformCodeEnum.USER_INFO_IS_NULL.getCode());
        }
        List positions = ifwUser.getPositions();
        if (positions == null || positions.isEmpty()) {
            throw new BizException(PlatformCodeEnum.USER_POSITION_INFO_IS_NULL.getDesc(), PlatformCodeEnum.USER_POSITION_INFO_IS_NULL.getCode());
        }
    }
}

