/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.tracker.service.impl;

import com.ifourthwall.common.PlatformCodeEnum;
import com.ifourthwall.common.base.BaseReqDTO;
import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWPageInfo;
import com.ifourthwall.common.base.IFWPosition;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.common.cache.RedisKeyPrefixUtil;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.common.utils.IFWBeanCopyUtil;
import com.ifourthwall.common.utils.IFWValidator;
import com.ifourthwall.dbm.asset.dto.QueryCheckPointByDeptDTO;
import com.ifourthwall.dbm.project.dto.ProjectSpacePathDTO;
import com.ifourthwall.dbm.project.dto.QueryAllDeptDTO;
import com.ifourthwall.dbm.tracker.bo.AddConsumptionInputBO;
import com.ifourthwall.dbm.tracker.bo.AddWorksheetContentInputBO;
import com.ifourthwall.dbm.tracker.bo.AllWorksheetListQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.AllWorksheetNumOutputBO;
import com.ifourthwall.dbm.tracker.bo.AssetCheckRecordInputBO;
import com.ifourthwall.dbm.tracker.bo.AssignWorksheetInputBO;
import com.ifourthwall.dbm.tracker.bo.CheckPointScanInfoQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.CheckWorksheetInputBO;
import com.ifourthwall.dbm.tracker.bo.CommonWorksheetDetailOutputBO;
import com.ifourthwall.dbm.tracker.bo.ContactQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.DailyTaskWorkSheetListOutputBO;
import com.ifourthwall.dbm.tracker.bo.DailyTaskWorkSheetListQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.DailyTaskWorkSheetWrapOutputBO;
import com.ifourthwall.dbm.tracker.bo.DailyWorksheetListQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.DeleteWorksheetInputBO;
import com.ifourthwall.dbm.tracker.bo.EventConsumptionInputBO;
import com.ifourthwall.dbm.tracker.bo.ExportDailyWorksheetQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.ExportTemporaryWorksheetOutputBO;
import com.ifourthwall.dbm.tracker.bo.ExportTemporaryWorksheetQueryBO;
import com.ifourthwall.dbm.tracker.bo.ExportTemporaryWorksheetQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.FeedBackWorksheetInputBO;
import com.ifourthwall.dbm.tracker.bo.FinishWorksheetInputBO;
import com.ifourthwall.dbm.tracker.bo.HangUpWorksheetInputBO;
import com.ifourthwall.dbm.tracker.bo.OperateWorksheetKnowledgeInputBO;
import com.ifourthwall.dbm.tracker.bo.PatrolCheckInputBO;
import com.ifourthwall.dbm.tracker.bo.PatrolInputBO;
import com.ifourthwall.dbm.tracker.bo.QueryCheckPointListOutputBO;
import com.ifourthwall.dbm.tracker.bo.QueryCheckPointListQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.QueryResEmployeeOutputBO;
import com.ifourthwall.dbm.tracker.bo.QuerySpecialListBySpaceInputBO;
import com.ifourthwall.dbm.tracker.bo.QueryTempWorksheetByCheckpointInputBO;
import com.ifourthwall.dbm.tracker.bo.RemindWorksheetInputBO;
import com.ifourthwall.dbm.tracker.bo.ScanDetailInfoOutputBO;
import com.ifourthwall.dbm.tracker.bo.ScanQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.ScanSimpleInfoOutputBO;
import com.ifourthwall.dbm.tracker.bo.SeerWorksheetQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.TaskAssetOutputBO;
import com.ifourthwall.dbm.tracker.bo.TaskCheckPointRelationInsertBO;
import com.ifourthwall.dbm.tracker.bo.TaskCheckPointRelationInsertInputBO;
import com.ifourthwall.dbm.tracker.bo.TaskExecutorInsertInputBO;
import com.ifourthwall.dbm.tracker.bo.TaskInsertInputBO;
import com.ifourthwall.dbm.tracker.bo.TaskOperationQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.TaskSpaceInsertInputBO;
import com.ifourthwall.dbm.tracker.bo.TaskTemplateListQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.TaskTemplateOutputBO;
import com.ifourthwall.dbm.tracker.bo.TaskTemplateTagOutputBO;
import com.ifourthwall.dbm.tracker.bo.TaskTemplateTagQueryDetailInputBO;
import com.ifourthwall.dbm.tracker.bo.TaskWorksheetOutputBO;
import com.ifourthwall.dbm.tracker.bo.TaskWorksheetUpdateInputBO;
import com.ifourthwall.dbm.tracker.bo.TaskWrapInsertInputBO;
import com.ifourthwall.dbm.tracker.bo.TemporaryTaskWorksheetWrapOutputBO;
import com.ifourthwall.dbm.tracker.bo.UpgradeWorksheetInputBO;
import com.ifourthwall.dbm.tracker.bo.UploadScanResultOutputBO;
import com.ifourthwall.dbm.tracker.bo.UploadScanWrapInputBO;
import com.ifourthwall.dbm.tracker.bo.UserDeatilInfoOutputBO;
import com.ifourthwall.dbm.tracker.bo.UserDeptBO;
import com.ifourthwall.dbm.tracker.bo.UserInformationOutputBO;
import com.ifourthwall.dbm.tracker.bo.WorksheetAssignListQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.WorksheetDetailQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.WorksheetEventCheckpointInputBO;
import com.ifourthwall.dbm.tracker.bo.WorksheetEventInputBO;
import com.ifourthwall.dbm.tracker.bo.WorksheetEventPictureInputBO;
import com.ifourthwall.dbm.tracker.bo.WorksheetEventPositionInputBO;
import com.ifourthwall.dbm.tracker.bo.WorksheetEventPositionOutputBO;
import com.ifourthwall.dbm.tracker.bo.WorksheetEventSupperWrapOutputBO;
import com.ifourthwall.dbm.tracker.bo.WorksheetEventUserInputBO;
import com.ifourthwall.dbm.tracker.bo.WorksheetEventUserOutputBO;
import com.ifourthwall.dbm.tracker.bo.WorksheetExecutorOutputBO;
import com.ifourthwall.dbm.tracker.bo.WorksheetFinishQueryByMonthInputBO;
import com.ifourthwall.dbm.tracker.bo.WorksheetKnowledgeInputBO;
import com.ifourthwall.dbm.tracker.bo.WorksheetOperateInputBO;
import com.ifourthwall.dbm.tracker.bo.WorksheetQueryByAssetInputBO;
import com.ifourthwall.dbm.tracker.bo.WorksheetScanQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.WorksheetUpdateTagInputBO;
import com.ifourthwall.dbm.tracker.config.TranslationBean;
import com.ifourthwall.dbm.tracker.config.TranslationConfig;
import com.ifourthwall.dbm.tracker.domain.ConfigRepository;
import com.ifourthwall.dbm.tracker.domain.OrganizationRepository;
import com.ifourthwall.dbm.tracker.domain.TaskRepository;
import com.ifourthwall.dbm.tracker.domain.TaskTemplateRepository;
import com.ifourthwall.dbm.tracker.domain.WorksheetRepository;
import com.ifourthwall.dbm.tracker.dto.AllWorksheetNumOutputDTO;
import com.ifourthwall.dbm.tracker.dto.DailyTaskWorkSheetListOutputDTO;
import com.ifourthwall.dbm.tracker.dto.DailyTaskWorkSheetWrapOutputDTO;
import com.ifourthwall.dbm.tracker.dto.ExportDailyWorksheetOutputDTO;
import com.ifourthwall.dbm.tracker.dto.ExportTemporaryWorksheetOutputDTO;
import com.ifourthwall.dbm.tracker.dto.PatrolCheckResultOutputDTO;
import com.ifourthwall.dbm.tracker.dto.QueryResEmployeeOutputDTO;
import com.ifourthwall.dbm.tracker.dto.ScanDetailInfoOutputDTO;
import com.ifourthwall.dbm.tracker.dto.SpecialWorksheetOutputDTO;
import com.ifourthwall.dbm.tracker.dto.TaskAssignExecutorOutputDTO;
import com.ifourthwall.dbm.tracker.dto.TaskSpaceInsertInputDTO;
import com.ifourthwall.dbm.tracker.dto.TempTaskWorksheetQueryInputBO;
import com.ifourthwall.dbm.tracker.dto.TemporaryTaskWorksheetWrapOutputDTO;
import com.ifourthwall.dbm.tracker.dto.TemporyTaskWorkSheetListOutputDTO;
import com.ifourthwall.dbm.tracker.dto.UploadScanResultOutpuDTO;
import com.ifourthwall.dbm.tracker.dto.WorksheetEventSupperWrapOutputDTO;
import com.ifourthwall.dbm.tracker.dto.WorksheetExecutorOutputDTO;
import com.ifourthwall.dbm.tracker.dto.WorksheetListForSeerOutputDTO;
import com.ifourthwall.dbm.tracker.service.WorksheetService;
import com.ifourthwall.dbm.tracker.utils.BaseResponseUtils;
import com.ifourthwall.dbm.tracker.utils.CheckAccessUtils;
import com.ifourthwall.dbm.tracker.utils.DateUtils;
import com.ifourthwall.dbm.user.dto.FindPostitionByTenantIdDTO;
import com.ifourthwall.dbm.user.dto.QuDeptInfoDTO;
import com.ifourthwall.dbm.user.dto.QueryDeptInfosReqDTO;
import com.ifourthwall.dbm.user.dto.QueryDeptInfosResDTO;
import com.ifourthwall.dbm.user.dto.QueryPositionNameResDTO;
import com.ifourthwall.dbm.user.dto.QueryReqEmployeeDTO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service(value="worksheetServiceImpl")
public class WorksheetServiceImpl
implements WorksheetService {
    private static final Logger log = LoggerFactory.getLogger(WorksheetServiceImpl.class);
    @Resource(name="worksheetRepository")
    WorksheetRepository worksheetRepository;
    @Resource(name="taskRepository")
    TaskRepository taskRepository;
    @Resource(name="organizationRepository")
    OrganizationRepository organizationRepository;
    @Resource(name="taskTemplateRepository")
    TaskTemplateRepository taskTemplateRepository;
    @Resource(name="configRepository")
    ConfigRepository configRepository;
    @Autowired
    RedisTemplate redisTemplate;
    @Autowired
    private TranslationConfig translationConfig;
    @Value(value="${robot.system.id}")
    private String robotId;

    public List<DailyTaskWorkSheetListOutputBO> canExecute(List<DailyTaskWorkSheetListOutputBO> dailyTaskWorkSheetListOutputBOList, IFWUser ifwUser) {
        List<Object> result = new ArrayList<DailyTaskWorkSheetListOutputBO>();
        if (dailyTaskWorkSheetListOutputBOList != null && !dailyTaskWorkSheetListOutputBOList.isEmpty()) {
            result = dailyTaskWorkSheetListOutputBOList.stream().filter(new /* Unavailable Anonymous Inner Class!! */).collect(Collectors.toList());
        }
        return result;
    }

    public boolean isExecutor(List<WorksheetExecutorOutputBO> worksheetExecutorOutputBOList, IFWUser ifwUser) {
        if (worksheetExecutorOutputBOList != null && !worksheetExecutorOutputBOList.isEmpty()) {
            if (ifwUser.getPositions() == null || ifwUser.getPositions().isEmpty()) {
                throw new BizException(PlatformCodeEnum.USER_POSITION_INFO_IS_NULL.getDesc(), PlatformCodeEnum.USER_POSITION_INFO_IS_NULL.getCode());
            }
            List collect = ifwUser.getPositions().stream().map(IFWPosition::getPositionId).collect(Collectors.toList());
            for (WorksheetExecutorOutputBO bo : worksheetExecutorOutputBOList) {
                if (!StringUtils.isEquals((String)bo.getExecutorUserId(), (String)ifwUser.getUserId()) || !collect.contains(bo.getExecutorPositionId())) continue;
                return true;
            }
        }
        return false;
    }

    public BaseResponse<AllWorksheetNumOutputDTO> getAllWorksheetListSum(IFWUser ifwUser, AllWorksheetListQueryInputBO allWorksheetListQueryInputBO) {
        BaseResponse response;
        try {
            List list;
            if (StringUtils.isBlank((String)allWorksheetListQueryInputBO.getTenantId())) {
                allWorksheetListQueryInputBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)allWorksheetListQueryInputBO.getTenantId());
            }
            if (StringUtils.isBlank((String)allWorksheetListQueryInputBO.getUserId())) {
                allWorksheetListQueryInputBO.setUserId(ifwUser.getUserId());
                if (ifwUser.getPositions() == null || ifwUser.getPositions().isEmpty()) {
                    return BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.USER_POSITION_INFO_IS_NULL.getCode(), (String)PlatformCodeEnum.USER_POSITION_INFO_IS_NULL.getDesc());
                }
                allWorksheetListQueryInputBO.setPermissionSubjectPositionIdList(ifwUser.getPositions().stream().map(IFWPosition::getPositionId).collect(Collectors.toList()));
                if (StringUtils.isBlank((String)allWorksheetListQueryInputBO.getProjectId())) {
                    return BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.PROJECT_ID_CANNOT_NULL.getDesc(), (String)PlatformCodeEnum.PROJECT_ID_CANNOT_NULL.getCode());
                }
            } else {
                List permissionSubjectPositionIdList = allWorksheetListQueryInputBO.getPermissionSubjectPositionIdList();
                if (permissionSubjectPositionIdList == null || permissionSubjectPositionIdList.isEmpty()) {
                    return BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.USER_POSITION_INFO_IS_NULL.getCode(), (String)PlatformCodeEnum.USER_POSITION_INFO_IS_NULL.getDesc());
                }
                ifwUser.setUserId(allWorksheetListQueryInputBO.getUserId());
                ArrayList<IFWPosition> positionList = new ArrayList<IFWPosition>();
                for (String id : permissionSubjectPositionIdList) {
                    IFWPosition position = new IFWPosition();
                    position.setPositionId(id);
                    positionList.add(position);
                }
                ifwUser.setPositions(positionList);
            }
            IFWValidator.validate((Object)allWorksheetListQueryInputBO);
            AllWorksheetNumOutputDTO allWorksheetNumOutputDTO = new AllWorksheetNumOutputDTO();
            String key = RedisKeyPrefixUtil.getTrackerQueryHomeDataPrefix((String)(allWorksheetListQueryInputBO.getProjectId() + ":" + allWorksheetListQueryInputBO.getUserId()));
            int tempNum = 0;
            int planNum = 0;
            TempTaskWorksheetQueryInputBO tempTaskWorksheetQueryInputBO = new TempTaskWorksheetQueryInputBO();
            tempTaskWorksheetQueryInputBO.setProjectId(allWorksheetListQueryInputBO.getProjectId());
            tempTaskWorksheetQueryInputBO.setQueryFunctionType("1");
            ArrayList<String> taskTypeIdList = new ArrayList<String>();
            taskTypeIdList.add("1");
            taskTypeIdList.add("4");
            tempTaskWorksheetQueryInputBO.setTaskTypeIdList(taskTypeIdList);
            tempTaskWorksheetQueryInputBO.setTenantId(tempTaskWorksheetQueryInputBO.getTenantId());
            tempTaskWorksheetQueryInputBO.setLanguageCode(allWorksheetListQueryInputBO.getLanguageCode());
            BaseResponse tempTaskWorksheetList = this.getTempTaskWorksheetList(ifwUser, tempTaskWorksheetQueryInputBO);
            IFWPageInfo data = (IFWPageInfo)tempTaskWorksheetList.getData();
            if (data != null && !CollectionUtils.isEmpty((Collection)(list = data.getList()))) {
                Map<String, List<TemporyTaskWorkSheetListOutputDTO>> map = list.stream().collect(Collectors.groupingBy(TemporyTaskWorkSheetListOutputDTO::getTaskTypeId));
                if (map != null) {
                    tempNum = map.containsKey("1") ? map.get("1").size() : 0;
                    planNum = map.containsKey("4") ? map.get("4").size() : 0;
                } else {
                    tempNum = 0;
                    planNum = 0;
                }
            }
            allWorksheetNumOutputDTO.setTemporaryWorksheetNum(Integer.valueOf(tempNum));
            allWorksheetNumOutputDTO.setPlanWorksheetNum(Integer.valueOf(planNum));
            WorksheetFinishQueryByMonthInputBO worksheetFinishQueryByMonthInputBO = new WorksheetFinishQueryByMonthInputBO();
            worksheetFinishQueryByMonthInputBO.setTenantId(allWorksheetListQueryInputBO.getTenantId());
            worksheetFinishQueryByMonthInputBO.setProjectId(allWorksheetListQueryInputBO.getProjectId());
            worksheetFinishQueryByMonthInputBO.setUserId(allWorksheetListQueryInputBO.getUserId());
            worksheetFinishQueryByMonthInputBO.setWorksheetStatusId("6");
            worksheetFinishQueryByMonthInputBO.setStartDate(DateUtils.getFirstDateOfMonth((Date)new Date()));
            worksheetFinishQueryByMonthInputBO.setEndDate(DateUtils.getLastDateOfMonth((Date)new Date()));
            AllWorksheetNumOutputBO allWorksheetFinishSum = this.worksheetRepository.getAllWorksheetFinishSum(worksheetFinishQueryByMonthInputBO);
            allWorksheetNumOutputDTO.setTemporaryWorksheetFinishNum(Integer.valueOf(allWorksheetFinishSum.getTemporaryWorksheetFinishNum() != null ? allWorksheetFinishSum.getTemporaryWorksheetFinishNum() : 0));
            allWorksheetNumOutputDTO.setStaticWorksheetFinishNum(Integer.valueOf(allWorksheetFinishSum.getStaticWorksheetFinishNum() != null ? allWorksheetFinishSum.getStaticWorksheetFinishNum() : 0));
            allWorksheetNumOutputDTO.setPatrolWorksheetFinishNum(Integer.valueOf(allWorksheetFinishSum.getPatrolWorksheetFinishNum() != null ? allWorksheetFinishSum.getPatrolWorksheetFinishNum() : 0));
            allWorksheetNumOutputDTO.setPlanWorksheetFinishNum(Integer.valueOf(allWorksheetFinishSum.getPlanWorksheetFinishNum() != null ? allWorksheetFinishSum.getPlanWorksheetFinishNum() : 0));
            allWorksheetNumOutputDTO.setDate(new Date());
            allWorksheetNumOutputDTO.setProjectId(allWorksheetListQueryInputBO.getProjectId());
            AllWorksheetNumOutputDTO storedDTO = (AllWorksheetNumOutputDTO)this.redisTemplate.opsForValue().get((Object)key);
            if (storedDTO != null && DateUtils.isSameDay((Date)storedDTO.getDate(), (Date)new Date())) {
                allWorksheetNumOutputDTO.setPatrolWorksheetNum(storedDTO.getPatrolWorksheetNum());
                allWorksheetNumOutputDTO.setStaticWorksheetNum(storedDTO.getStaticWorksheetNum());
            } else {
                DailyWorksheetListQueryInputBO dailyQueryInputBO = new DailyWorksheetListQueryInputBO();
                dailyQueryInputBO.setPermissionSubjectPositionIdList(allWorksheetListQueryInputBO.getPermissionSubjectPositionIdList());
                dailyQueryInputBO.setUserId(allWorksheetListQueryInputBO.getUserId());
                dailyQueryInputBO.setProjectId(allWorksheetListQueryInputBO.getProjectId());
                dailyQueryInputBO.setTenantId(allWorksheetListQueryInputBO.getTenantId());
                dailyQueryInputBO.setLanguageCode(allWorksheetListQueryInputBO.getLanguageCode());
                dailyQueryInputBO.setTaskTypeId("2");
                IFWPageInfo staticPageInfo = this.worksheetRepository.getDailyWorksheetListForApp(dailyQueryInputBO);
                if (staticPageInfo != null) {
                    int statisticNum = staticPageInfo.getList() != null ? staticPageInfo.getList().size() : 0;
                    allWorksheetNumOutputDTO.setStaticWorksheetNum(Integer.valueOf(statisticNum));
                }
                dailyQueryInputBO.setTaskTypeId("3");
                IFWPageInfo patrolPageInfo = this.worksheetRepository.getDailyWorksheetListForApp(dailyQueryInputBO);
                if (patrolPageInfo != null) {
                    int patrolNum = patrolPageInfo.getList() != null ? patrolPageInfo.getList().size() : 0;
                    allWorksheetNumOutputDTO.setPatrolWorksheetNum(Integer.valueOf(patrolNum));
                }
                this.redisTemplate.opsForValue().set((Object)key, (Object)allWorksheetNumOutputDTO, 48L, TimeUnit.HOURS);
            }
            response = BaseResponseUtils.getSuccessResponse((Object)allWorksheetNumOutputDTO, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    public BaseResponse<IFWPageInfo<DailyTaskWorkSheetListOutputDTO>> getDailyWorksheetListForApp(IFWUser ifwUser, DailyWorksheetListQueryInputBO dailyWorksheetListQueryInputBO) {
        BaseResponse response;
        try {
            if (StringUtils.isBlank((String)dailyWorksheetListQueryInputBO.getTenantId())) {
                dailyWorksheetListQueryInputBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)dailyWorksheetListQueryInputBO.getTenantId());
            }
            CheckAccessUtils.checkIFWUserPosition((IFWUser)ifwUser);
            dailyWorksheetListQueryInputBO.setPermissionSubjectPositionIdList(ifwUser.getPositions().stream().map(IFWPosition::getPositionId).collect(Collectors.toList()));
            dailyWorksheetListQueryInputBO.setUserId(ifwUser.getUserId());
            IFWValidator.validate((Object)dailyWorksheetListQueryInputBO);
            IFWPageInfo pageInfo = this.worksheetRepository.getDailyWorksheetListForApp(dailyWorksheetListQueryInputBO);
            List list = new ArrayList();
            if (pageInfo.getList() != null && !pageInfo.getList().isEmpty()) {
                list.addAll(IFWBeanCopyUtil.mapAsList((Iterable)pageInfo.getList(), DailyTaskWorkSheetListOutputDTO.class));
            }
            list = this.addExecutorNames(list, dailyWorksheetListQueryInputBO.getTenantId(), dailyWorksheetListQueryInputBO.getLanguageCode());
            IFWPageInfo result = new IFWPageInfo();
            result.setPageSize(pageInfo.getPageSize());
            result.setPageNum(pageInfo.getPageNum());
            result.setTotal(pageInfo.getTotal());
            result.setList(list);
            response = BaseResponseUtils.getSuccessResponse((Object)result, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    private List<DailyTaskWorkSheetListOutputDTO> addExecutorNames(List<DailyTaskWorkSheetListOutputDTO> dailyTaskWorkSheetListOutputDTOList, String tenantId, String languageCode) {
        if (dailyTaskWorkSheetListOutputDTOList != null && !dailyTaskWorkSheetListOutputDTOList.isEmpty()) {
            ArrayList<String> userIdList = new ArrayList<String>();
            for (DailyTaskWorkSheetListOutputDTO dto : dailyTaskWorkSheetListOutputDTOList) {
                List worksheetExecutorList = dto.getWorksheetExecutorList();
                userIdList.add(dto.getCreateBy());
                if (worksheetExecutorList == null || worksheetExecutorList.isEmpty()) continue;
                userIdList.addAll(worksheetExecutorList.stream().map(WorksheetExecutorOutputDTO::getExecutorUserId).collect(Collectors.toList()));
            }
            List collect = userIdList.stream().distinct().collect(Collectors.toList());
            List userDeatilInfoOutputBOList = this.organizationRepository.queryUserDetailByUserId(collect, tenantId, languageCode);
            if (userDeatilInfoOutputBOList != null && !userDeatilInfoOutputBOList.isEmpty()) {
                for (DailyTaskWorkSheetListOutputDTO dto : dailyTaskWorkSheetListOutputDTOList) {
                    for (UserDeatilInfoOutputBO bo : userDeatilInfoOutputBOList) {
                        List worksheetExecutorList;
                        if (StringUtils.isEquals((String)bo.getUserId(), (String)dto.getCreateBy())) {
                            dto.setCreateName(bo.getRealName());
                        }
                        if ((worksheetExecutorList = dto.getWorksheetExecutorList()) == null || worksheetExecutorList.isEmpty()) continue;
                        for (WorksheetExecutorOutputDTO worksheetExecutorOutputDTO : worksheetExecutorList) {
                            if (!StringUtils.isEquals((String)worksheetExecutorOutputDTO.getExecutorUserId(), (String)bo.getUserId())) continue;
                            worksheetExecutorOutputDTO.setName(bo.getRealName());
                        }
                    }
                }
            }
        }
        return dailyTaskWorkSheetListOutputDTOList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BaseResponse<IFWPageInfo<DailyTaskWorkSheetListOutputDTO>> getDailyTaskWorkSheetList(IFWUser ifwUser, DailyTaskWorkSheetListQueryInputBO dailyTaskWorkSheetListQueryInputBO) {
        IFWPageInfo result = new IFWPageInfo();
        try {
            if (StringUtils.isBlank((String)dailyTaskWorkSheetListQueryInputBO.getTenantId())) {
                dailyTaskWorkSheetListQueryInputBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)dailyTaskWorkSheetListQueryInputBO.getTenantId());
            }
            CheckAccessUtils.checkIFWUserPosition((IFWUser)ifwUser);
            if (!StringUtils.isEmpty((String)dailyTaskWorkSheetListQueryInputBO.getUserId())) {
                List listPositionByTenant = this.organizationRepository.findListPositionByTenant(dailyTaskWorkSheetListQueryInputBO.getTenantId(), dailyTaskWorkSheetListQueryInputBO.getUserId());
                if (CollectionUtils.isEmpty((Collection)listPositionByTenant)) return BaseResponseUtils.getSuccessResponse(null, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
                List collect = listPositionByTenant.stream().map(FindPostitionByTenantIdDTO::getPositionId).distinct().collect(Collectors.toList());
                dailyTaskWorkSheetListQueryInputBO.setPermissionSubjectPositionIdList(collect);
            } else {
                dailyTaskWorkSheetListQueryInputBO.setPermissionSubjectPositionIdList(ifwUser.getPositions().stream().map(IFWPosition::getPositionId).collect(Collectors.toList()));
            }
            if (!StringUtils.isBlank((String)dailyTaskWorkSheetListQueryInputBO.getExecutorName())) {
                List userInformationList = this.organizationRepository.queryListUserAndFindUser(dailyTaskWorkSheetListQueryInputBO.getExecutorName(), dailyTaskWorkSheetListQueryInputBO.getTenantId(), dailyTaskWorkSheetListQueryInputBO.getLanguageCode());
                if (CollectionUtils.isEmpty((Collection)userInformationList)) return BaseResponseUtils.getSuccessResponse((Object)result, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
                List userIdList = userInformationList.stream().map(UserInformationOutputBO::getUserId).filter(item -> !StringUtils.isBlank((String)item)).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(userIdList)) {
                    return BaseResponseUtils.getSuccessResponse((Object)result, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
                }
                dailyTaskWorkSheetListQueryInputBO.setExecutorUserIdList(userIdList);
            }
            IFWValidator.validate((Object)dailyTaskWorkSheetListQueryInputBO);
            if (StringUtils.isEquals((String)ifwUser.getRoleType(), (String)"0") && !StringUtils.isEquals((String)ifwUser.getTenantId(), (String)dailyTaskWorkSheetListQueryInputBO.getTenantId())) {
                dailyTaskWorkSheetListQueryInputBO.setIsSuper("0");
            }
            if (StringUtils.isBlank((String)dailyTaskWorkSheetListQueryInputBO.getQueryType())) {
                dailyTaskWorkSheetListQueryInputBO.setQueryType("1");
            }
            IFWPageInfo pageInfo = this.worksheetRepository.getDailyTaskWorkSheetList(dailyTaskWorkSheetListQueryInputBO);
            List dailyTaskWorkSheetListOutputDTOList = IFWBeanCopyUtil.mapAsList((Iterable)pageInfo.getList(), DailyTaskWorkSheetListOutputDTO.class);
            dailyTaskWorkSheetListOutputDTOList = this.addExecutorNames(dailyTaskWorkSheetListOutputDTOList, dailyTaskWorkSheetListQueryInputBO.getTenantId(), dailyTaskWorkSheetListQueryInputBO.getLanguageCode());
            result.setTotal(pageInfo.getTotal());
            result.setPageNum(pageInfo.getPageNum());
            result.setPageSize(pageInfo.getPageSize());
            result.setList(dailyTaskWorkSheetListOutputDTOList);
            return BaseResponseUtils.getSuccessResponse((Object)result, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            return BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            return BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
    }

    public BaseResponse<IFWPageInfo<TemporyTaskWorkSheetListOutputDTO>> getTempTaskWorksheetList(IFWUser ifwUser, TempTaskWorksheetQueryInputBO tempTaskWorksheetQueryInputBO) {
        BaseResponse response;
        try {
            IFWPageInfo pageInfo;
            List temporyTaskWorkSheetListOutputDTOList;
            if (StringUtils.isBlank((String)tempTaskWorksheetQueryInputBO.getTenantId())) {
                tempTaskWorksheetQueryInputBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)tempTaskWorksheetQueryInputBO.getTenantId());
            }
            CheckAccessUtils.checkIFWUserPosition((IFWUser)ifwUser);
            IFWPageInfo result = new IFWPageInfo();
            if (StringUtils.isEquals((String)tempTaskWorksheetQueryInputBO.getQueryFunctionType(), (String)"1") || StringUtils.isEquals((String)tempTaskWorksheetQueryInputBO.getQueryFunctionType(), (String)"2") || StringUtils.isEquals((String)tempTaskWorksheetQueryInputBO.getQueryFunctionType(), (String)"3")) {
                // empty if block
            }
            IFWValidator.validate((Object)tempTaskWorksheetQueryInputBO);
            if (!StringUtils.isEquals((String)ifwUser.getRoleType(), (String)"0") || StringUtils.isEquals((String)ifwUser.getTenantId(), (String)tempTaskWorksheetQueryInputBO.getTenantId())) {
                List list;
                if (StringUtils.isEmpty((String)tempTaskWorksheetQueryInputBO.getUserId())) {
                    tempTaskWorksheetQueryInputBO.setUserId(ifwUser.getUserId());
                }
                tempTaskWorksheetQueryInputBO.setPermissionSubjectPositionIdList(ifwUser.getPositions().stream().map(IFWPosition::getPositionId).collect(Collectors.toList()));
                if (StringUtils.isEquals((String)tempTaskWorksheetQueryInputBO.getQueryFunctionType(), (String)"2")) {
                    TaskTemplateListQueryInputBO taskTemplateListQueryInputBO = new TaskTemplateListQueryInputBO();
                    taskTemplateListQueryInputBO.setTenantId(tempTaskWorksheetQueryInputBO.getTenantId());
                    taskTemplateListQueryInputBO.setProjectId(tempTaskWorksheetQueryInputBO.getProjectId());
                    ArrayList<String> typeIdList = new ArrayList<String>();
                    typeIdList.add("1");
                    taskTemplateListQueryInputBO.setTaskTypeIdList(typeIdList);
                    taskTemplateListQueryInputBO.setPermissionSubjectPositionIdList(tempTaskWorksheetQueryInputBO.getPermissionSubjectPositionIdList());
                    taskTemplateListQueryInputBO.setPermissionTaskOperationId("2");
                    taskTemplateListQueryInputBO.setLanguageCode(tempTaskWorksheetQueryInputBO.getLanguageCode());
                    List taskTemplateList = this.taskTemplateRepository.selectTaskTemplateWithInvalidList(taskTemplateListQueryInputBO);
                    if (!CollectionUtils.isEmpty((Collection)taskTemplateList)) {
                        List collect = taskTemplateList.stream().map(TaskTemplateOutputBO::getTaskTemplateId).distinct().collect(Collectors.toList());
                        List taskTemplateIdList = tempTaskWorksheetQueryInputBO.getTaskTemplateIdList();
                        if (CollectionUtils.isEmpty((Collection)taskTemplateIdList)) {
                            tempTaskWorksheetQueryInputBO.setWatchTemplateIdList(collect);
                        } else {
                            ArrayList<String> filterTaskTemplateList = new ArrayList<String>();
                            for (Object id : taskTemplateIdList) {
                                if (!collect.contains(id)) continue;
                                filterTaskTemplateList.add((String)id);
                            }
                            tempTaskWorksheetQueryInputBO.setWatchTemplateIdList(filterTaskTemplateList);
                        }
                    }
                } else if (StringUtils.isEquals((String)tempTaskWorksheetQueryInputBO.getQueryFunctionType(), (String)"3") && CollectionUtils.isEmpty((Collection)(list = tempTaskWorksheetQueryInputBO.getWorksheetStatusIdList()))) {
                    ArrayList<String> worksheetStatusIdList = new ArrayList<String>();
                    worksheetStatusIdList.add("6");
                    worksheetStatusIdList.add("8");
                    tempTaskWorksheetQueryInputBO.setWorksheetStatusIdList(worksheetStatusIdList);
                }
            }
            if ((temporyTaskWorkSheetListOutputDTOList = IFWBeanCopyUtil.mapAsList((Iterable)(pageInfo = this.worksheetRepository.getTempTaskWorksheetList(tempTaskWorksheetQueryInputBO)).getList(), TemporyTaskWorkSheetListOutputDTO.class)) != null && !temporyTaskWorkSheetListOutputDTOList.isEmpty()) {
                List spaceList;
                List spaceIdList;
                List userDeatilInfoOutputBOList;
                List collect = temporyTaskWorkSheetListOutputDTOList.stream().map(TemporyTaskWorkSheetListOutputDTO::getCreateBy).distinct().collect(Collectors.toList());
                List executorUserIdList = temporyTaskWorkSheetListOutputDTOList.stream().map(TemporyTaskWorkSheetListOutputDTO::getWorksheetExecutorList).filter((Predicate<List>)new /* Unavailable Anonymous Inner Class!! */).flatMap(Collection::stream).map(WorksheetExecutorOutputDTO::getExecutorUserId).filter((Predicate<String>)new /* Unavailable Anonymous Inner Class!! */).distinct().collect(Collectors.toList());
                List executorPositionIdList = temporyTaskWorkSheetListOutputDTOList.stream().map(TemporyTaskWorkSheetListOutputDTO::getWorksheetExecutorList).filter((Predicate<List>)new /* Unavailable Anonymous Inner Class!! */).flatMap(Collection::stream).filter(new /* Unavailable Anonymous Inner Class!! */).map(WorksheetExecutorOutputDTO::getExecutorPositionId).filter((Predicate<String>)new /* Unavailable Anonymous Inner Class!! */).distinct().collect(Collectors.toList());
                List<Object> userIdList = new ArrayList();
                if (executorUserIdList != null && !executorUserIdList.isEmpty()) {
                    collect.addAll(executorUserIdList);
                }
                if (!CollectionUtils.isEmpty(collect)) {
                    userIdList = collect.stream().distinct().collect(Collectors.toList());
                }
                if ((userDeatilInfoOutputBOList = this.organizationRepository.queryUserDetailByUserId(userIdList, tempTaskWorksheetQueryInputBO.getTenantId(), tempTaskWorksheetQueryInputBO.getLanguageCode())) != null && !userDeatilInfoOutputBOList.isEmpty()) {
                    for (TemporyTaskWorkSheetListOutputDTO dto : temporyTaskWorkSheetListOutputDTOList) {
                        Object bo2;
                        for (Object bo2 : userDeatilInfoOutputBOList) {
                            if (!StringUtils.isEquals((String)dto.getCreateBy(), (String)bo2.getUserId())) continue;
                            dto.setCreateName(bo2.getRealName());
                        }
                        List worksheetExecutorList = dto.getWorksheetExecutorList();
                        if (worksheetExecutorList == null || worksheetExecutorList.isEmpty()) continue;
                        bo2 = worksheetExecutorList.iterator();
                        while (bo2.hasNext()) {
                            WorksheetExecutorOutputDTO executorDTO = (WorksheetExecutorOutputDTO)bo2.next();
                            for (UserDeatilInfoOutputBO bo3 : userDeatilInfoOutputBOList) {
                                if (StringUtils.isEmpty((String)executorDTO.getExecutorUserId()) || !StringUtils.isEquals((String)bo3.getUserId(), (String)executorDTO.getExecutorUserId())) continue;
                                executorDTO.setName(bo3.getRealName());
                            }
                        }
                    }
                }
                if (executorPositionIdList != null && !executorPositionIdList.isEmpty()) {
                    QueryDeptInfosReqDTO queryDeptInfosReqDTO = new QueryDeptInfosReqDTO();
                    queryDeptInfosReqDTO.setTenantId(tempTaskWorksheetQueryInputBO.getTenantId());
                    queryDeptInfosReqDTO.setLanguageCode(tempTaskWorksheetQueryInputBO.getLanguageCode());
                    queryDeptInfosReqDTO.setPositionIds(executorPositionIdList);
                    List quDeptInfoList = this.organizationRepository.queryDeptByPositionIds(queryDeptInfosReqDTO);
                    if (!CollectionUtils.isEmpty((Collection)quDeptInfoList)) {
                        for (TemporyTaskWorkSheetListOutputDTO dto : temporyTaskWorkSheetListOutputDTOList) {
                            List worksheetExecutorList = dto.getWorksheetExecutorList();
                            if (worksheetExecutorList == null || worksheetExecutorList.isEmpty()) continue;
                            for (WorksheetExecutorOutputDTO executorDTO : worksheetExecutorList) {
                                for (QuDeptInfoDTO positionDTO : quDeptInfoList) {
                                    if (!StringUtils.isEmpty((String)executorDTO.getExecutorUserId()) || StringUtils.isEmpty((String)executorDTO.getExecutorPositionId()) || !StringUtils.isEquals((String)executorDTO.getExecutorPositionId(), (String)positionDTO.getPositionId())) continue;
                                    executorDTO.setName(positionDTO.getPositionName());
                                    executorDTO.setDeptList(positionDTO.getDeptList());
                                }
                            }
                        }
                    }
                }
                if (!CollectionUtils.isEmpty(spaceIdList = temporyTaskWorkSheetListOutputDTOList.stream().map(TemporyTaskWorkSheetListOutputDTO::getTaskSpaceList).filter((Predicate<List>)new /* Unavailable Anonymous Inner Class!! */).flatMap(Collection::stream).filter(new /* Unavailable Anonymous Inner Class!! */).map(TaskSpaceInsertInputDTO::getSpaceId).filter((Predicate<String>)new /* Unavailable Anonymous Inner Class!! */).distinct().collect(Collectors.toList())) && !CollectionUtils.isEmpty((Collection)(spaceList = this.configRepository.querySpaceNameBySpaceList(spaceIdList, tempTaskWorksheetQueryInputBO.getTenantId(), tempTaskWorksheetQueryInputBO.getLanguageCode(), tempTaskWorksheetQueryInputBO.getProjectId())))) {
                    for (TemporyTaskWorkSheetListOutputDTO dto : temporyTaskWorkSheetListOutputDTOList) {
                        List taskSpaceList = dto.getTaskSpaceList();
                        if (CollectionUtils.isEmpty((Collection)taskSpaceList)) continue;
                        for (TaskSpaceInsertInputDTO taskSpaceInsertInputDTO : taskSpaceList) {
                            for (ProjectSpacePathDTO projectSpacePathDTO : spaceList) {
                                if (!StringUtils.isEquals((String)taskSpaceInsertInputDTO.getSpaceId(), (String)projectSpacePathDTO.getId())) continue;
                                taskSpaceInsertInputDTO.setTaskSpaceDescription(projectSpacePathDTO.getNameStr());
                            }
                        }
                    }
                }
            }
            result.setPageSize(pageInfo.getPageSize());
            result.setPageNum(pageInfo.getPageNum());
            result.setTotal(pageInfo.getTotal());
            result.setList(temporyTaskWorkSheetListOutputDTOList);
            response = BaseResponseUtils.getSuccessResponse((Object)result, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    public BaseResponse<IFWPageInfo<TemporyTaskWorkSheetListOutputDTO>> getTempWorksheetListByCheckpointId(IFWUser ifwUser, QueryTempWorksheetByCheckpointInputBO queryTempWorksheetByCheckpointInputBO) {
        BaseResponse response;
        try {
            if (StringUtils.isBlank((String)queryTempWorksheetByCheckpointInputBO.getTenantId())) {
                queryTempWorksheetByCheckpointInputBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)queryTempWorksheetByCheckpointInputBO.getTenantId());
            }
            CheckAccessUtils.checkIFWUserPosition((IFWUser)ifwUser);
            IFWPageInfo result = new IFWPageInfo();
            IFWValidator.validate((Object)queryTempWorksheetByCheckpointInputBO);
            IFWPageInfo pageInfo = this.worksheetRepository.getTempWorksheetListByCheckpointId(queryTempWorksheetByCheckpointInputBO);
            List temporyTaskWorkSheetListOutputDTOList = IFWBeanCopyUtil.mapAsList((Iterable)pageInfo.getList(), TemporyTaskWorkSheetListOutputDTO.class);
            if (temporyTaskWorkSheetListOutputDTOList != null && !temporyTaskWorkSheetListOutputDTOList.isEmpty()) {
                List userDeatilInfoOutputBOList;
                List collect = temporyTaskWorkSheetListOutputDTOList.stream().map(TemporyTaskWorkSheetListOutputDTO::getCreateBy).distinct().collect(Collectors.toList());
                List executorUserIdList = temporyTaskWorkSheetListOutputDTOList.stream().map(TemporyTaskWorkSheetListOutputDTO::getWorksheetExecutorList).filter((Predicate<List>)new /* Unavailable Anonymous Inner Class!! */).flatMap(Collection::stream).map(WorksheetExecutorOutputDTO::getExecutorUserId).filter((Predicate<String>)new /* Unavailable Anonymous Inner Class!! */).distinct().collect(Collectors.toList());
                List executorPositionIdList = temporyTaskWorkSheetListOutputDTOList.stream().map(TemporyTaskWorkSheetListOutputDTO::getWorksheetExecutorList).filter((Predicate<List>)new /* Unavailable Anonymous Inner Class!! */).flatMap(Collection::stream).filter(new /* Unavailable Anonymous Inner Class!! */).map(WorksheetExecutorOutputDTO::getExecutorPositionId).filter((Predicate<String>)new /* Unavailable Anonymous Inner Class!! */).distinct().collect(Collectors.toList());
                List<Object> userIdList = new ArrayList();
                if (executorUserIdList != null && !executorUserIdList.isEmpty()) {
                    collect.addAll(executorUserIdList);
                }
                if (!CollectionUtils.isEmpty(collect)) {
                    userIdList = collect.stream().distinct().collect(Collectors.toList());
                }
                if ((userDeatilInfoOutputBOList = this.organizationRepository.queryUserDetailByUserId(userIdList, queryTempWorksheetByCheckpointInputBO.getTenantId(), queryTempWorksheetByCheckpointInputBO.getLanguageCode())) != null && !userDeatilInfoOutputBOList.isEmpty()) {
                    for (TemporyTaskWorkSheetListOutputDTO dto : temporyTaskWorkSheetListOutputDTOList) {
                        Object bo2;
                        for (Object bo2 : userDeatilInfoOutputBOList) {
                            if (!StringUtils.isEquals((String)dto.getCreateBy(), (String)bo2.getUserId())) continue;
                            dto.setCreateName(bo2.getRealName());
                        }
                        List worksheetExecutorList = dto.getWorksheetExecutorList();
                        if (worksheetExecutorList == null || worksheetExecutorList.isEmpty()) continue;
                        bo2 = worksheetExecutorList.iterator();
                        while (bo2.hasNext()) {
                            WorksheetExecutorOutputDTO executorDTO = (WorksheetExecutorOutputDTO)bo2.next();
                            for (UserDeatilInfoOutputBO bo3 : userDeatilInfoOutputBOList) {
                                if (StringUtils.isEmpty((String)executorDTO.getExecutorUserId()) || !StringUtils.isEquals((String)bo3.getUserId(), (String)executorDTO.getExecutorUserId())) continue;
                                executorDTO.setName(bo3.getRealName());
                            }
                        }
                    }
                }
                if (executorPositionIdList != null && !executorPositionIdList.isEmpty()) {
                    QueryDeptInfosReqDTO queryDeptInfosReqDTO = new QueryDeptInfosReqDTO();
                    queryDeptInfosReqDTO.setTenantId(queryTempWorksheetByCheckpointInputBO.getTenantId());
                    queryDeptInfosReqDTO.setLanguageCode(queryTempWorksheetByCheckpointInputBO.getLanguageCode());
                    queryDeptInfosReqDTO.setPositionIds(executorPositionIdList);
                    List quDeptInfoList = this.organizationRepository.queryDeptByPositionIds(queryDeptInfosReqDTO);
                    if (!CollectionUtils.isEmpty((Collection)quDeptInfoList)) {
                        for (TemporyTaskWorkSheetListOutputDTO dto : temporyTaskWorkSheetListOutputDTOList) {
                            List worksheetExecutorList = dto.getWorksheetExecutorList();
                            if (worksheetExecutorList == null || worksheetExecutorList.isEmpty()) continue;
                            for (WorksheetExecutorOutputDTO executorDTO : worksheetExecutorList) {
                                for (QuDeptInfoDTO positionDTO : quDeptInfoList) {
                                    if (!StringUtils.isEmpty((String)executorDTO.getExecutorUserId()) || StringUtils.isEmpty((String)executorDTO.getExecutorPositionId()) || !StringUtils.isEquals((String)executorDTO.getExecutorPositionId(), (String)positionDTO.getPositionId())) continue;
                                    executorDTO.setName(positionDTO.getPositionName());
                                    executorDTO.setDeptList(positionDTO.getDeptList());
                                }
                            }
                        }
                    }
                }
            }
            result.setPageSize(pageInfo.getPageSize());
            result.setPageNum(pageInfo.getPageNum());
            result.setTotal(pageInfo.getTotal());
            result.setList(temporyTaskWorkSheetListOutputDTOList);
            response = BaseResponseUtils.getSuccessResponse((Object)result, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    public BaseResponse<TemporaryTaskWorksheetWrapOutputDTO> getTemporaryTaskWorksheetDetail(IFWUser ifwUser, WorksheetDetailQueryInputBO worksheetDetailQueryInputBO) {
        BaseResponse response;
        try {
            if (StringUtils.isBlank((String)worksheetDetailQueryInputBO.getTenantId())) {
                worksheetDetailQueryInputBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)worksheetDetailQueryInputBO.getTenantId());
            }
            if (StringUtils.isBlank((String)worksheetDetailQueryInputBO.getTaskId()) && StringUtils.isBlank((String)worksheetDetailQueryInputBO.getTaskWorksheetId())) {
                throw new BizException(PlatformCodeEnum.TASK_WORKSHEET_ID_CANNOT_NULL.getDesc(), PlatformCodeEnum.TASK_WORKSHEET_ID_CANNOT_NULL.getCode());
            }
            IFWValidator.validate((Object)worksheetDetailQueryInputBO);
            TemporaryTaskWorksheetWrapOutputBO temporaryTaskWorksheetDetail = this.worksheetRepository.getTemporaryTaskWorksheetDetail(worksheetDetailQueryInputBO);
            if (temporaryTaskWorksheetDetail != null) {
                List positionIdCollect;
                List userIdCollect;
                List worksheetExecutorList;
                List spaceList;
                List spaceIdList;
                List taskSpaceList;
                List taskAssetList;
                if (temporaryTaskWorksheetDetail.getTaskWorksheet() != null && !StringUtils.isBlank((String)temporaryTaskWorksheetDetail.getTaskWorksheet().getTaskTemplateTagId())) {
                    TaskTemplateTagQueryDetailInputBO taskTemplateTagQueryDetailInputBO = new TaskTemplateTagQueryDetailInputBO();
                    taskTemplateTagQueryDetailInputBO.setTaskTemplateTagId(temporaryTaskWorksheetDetail.getTaskWorksheet().getTaskTemplateTagId());
                    taskTemplateTagQueryDetailInputBO.setTenantId(worksheetDetailQueryInputBO.getTenantId());
                    taskTemplateTagQueryDetailInputBO.setProjectId(worksheetDetailQueryInputBO.getProjectId());
                    TaskTemplateTagOutputBO taskTemplateTagOutputBO = this.taskTemplateRepository.queryTaskTemplateTagDetail(taskTemplateTagQueryDetailInputBO);
                    if (taskTemplateTagOutputBO != null) {
                        temporaryTaskWorksheetDetail.getTaskWorksheet().setTaskTemplateTagName(taskTemplateTagOutputBO.getTaskTemplateTagName());
                    }
                }
                if (!CollectionUtils.isEmpty((Collection)(taskAssetList = temporaryTaskWorksheetDetail.getTaskAssetList()))) {
                    List collect = taskAssetList.stream().map(TaskAssetOutputBO::getAssetId).distinct().collect(Collectors.toList());
                    List assetName = this.configRepository.getAssetName(worksheetDetailQueryInputBO.getTenantId(), worksheetDetailQueryInputBO.getProjectId(), worksheetDetailQueryInputBO.getLanguageCode(), collect);
                    if (!CollectionUtils.isEmpty((Collection)assetName)) {
                        for (Object bo : taskAssetList) {
                            for (Object dto : assetName) {
                                if (!StringUtils.isEquals((String)bo.getAssetId(), (String)dto.getAssetId())) continue;
                                bo.setAssetName(dto.getAssetName());
                            }
                        }
                    }
                }
                if (!(CollectionUtils.isEmpty((Collection)(taskSpaceList = temporaryTaskWorksheetDetail.getTaskSpaceList())) || CollectionUtils.isEmpty(spaceIdList = taskSpaceList.stream().filter(item -> !StringUtils.isBlank((String)item.getSpaceId())).map(TaskSpaceInsertInputBO::getSpaceId).distinct().collect(Collectors.toList())) || CollectionUtils.isEmpty((Collection)(spaceList = this.configRepository.querySpaceNameBySpaceList(spaceIdList, worksheetDetailQueryInputBO.getTenantId(), worksheetDetailQueryInputBO.getLanguageCode(), worksheetDetailQueryInputBO.getProjectId()))))) {
                    for (TaskSpaceInsertInputBO bo : taskSpaceList) {
                        for (ProjectSpacePathDTO dto : spaceList) {
                            if (!StringUtils.isEquals((String)bo.getSpaceId(), (String)dto.getId())) continue;
                            bo.setTaskSpaceDescription(dto.getNameStr());
                        }
                    }
                }
                List worksheetEventSupperWrapList = temporaryTaskWorksheetDetail.getWorksheetEventSupperWrapList();
                ArrayList positionIdList = new ArrayList();
                ArrayList<String> userIdList = new ArrayList<String>();
                if (worksheetEventSupperWrapList != null && !worksheetEventSupperWrapList.isEmpty()) {
                    for (WorksheetEventSupperWrapOutputBO bo : worksheetEventSupperWrapList) {
                        Iterator worksheetEventUserList;
                        List worksheetEventPositionList = bo.getWorksheetEventPositionList();
                        if (worksheetEventPositionList != null && !worksheetEventPositionList.isEmpty()) {
                            positionIdList.addAll(worksheetEventPositionList.stream().map(WorksheetEventPositionOutputBO::getPositionId).collect(Collectors.toList()));
                        }
                        if ((worksheetEventUserList = bo.getWorksheetEventUserList()) == null || worksheetEventUserList.isEmpty()) continue;
                        userIdList.addAll(worksheetEventUserList.stream().map(WorksheetEventUserOutputBO::getUserId).collect(Collectors.toList()));
                    }
                    userIdList.addAll(worksheetEventSupperWrapList.stream().map(WorksheetEventSupperWrapOutputBO::getCreateBy).collect(Collectors.toList()));
                }
                if ((worksheetExecutorList = temporaryTaskWorksheetDetail.getWorksheetExecutorList()) != null && !worksheetExecutorList.isEmpty()) {
                    userIdList.addAll(worksheetExecutorList.stream().filter(new /* Unavailable Anonymous Inner Class!! */).map(WorksheetExecutorOutputBO::getExecutorUserId).collect(Collectors.toList()));
                }
                if (temporaryTaskWorksheetDetail.getTaskWorksheet() != null && temporaryTaskWorksheetDetail.getTaskWorksheet().getCreateBy() != null && !StringUtils.isEmpty((String)temporaryTaskWorksheetDetail.getTaskWorksheet().getCreateBy())) {
                    userIdList.add(temporaryTaskWorksheetDetail.getTaskWorksheet().getCreateBy());
                }
                if ((userIdCollect = userIdList.stream().distinct().collect(Collectors.toList())) != null && !userIdCollect.isEmpty()) {
                    List userDeatilInfoOutputBOList = this.organizationRepository.queryUserDetailByUserId(userIdCollect, worksheetDetailQueryInputBO.getTenantId(), worksheetDetailQueryInputBO.getLanguageCode());
                    if (!CollectionUtils.isEmpty((Collection)userDeatilInfoOutputBOList)) {
                        for (UserDeatilInfoOutputBO bo : userDeatilInfoOutputBOList) {
                            if (!StringUtils.isEquals((String)bo.getUserId(), (String)temporaryTaskWorksheetDetail.getTaskWorksheet().getCreateBy())) continue;
                            temporaryTaskWorksheetDetail.getTaskWorksheet().setCreateName(bo.getRealName());
                            break;
                        }
                    }
                    if (userDeatilInfoOutputBOList != null && !userDeatilInfoOutputBOList.isEmpty()) {
                        if (worksheetExecutorList != null && !worksheetExecutorList.isEmpty()) {
                            for (WorksheetExecutorOutputBO dto : worksheetExecutorList) {
                                for (UserDeatilInfoOutputBO bo : userDeatilInfoOutputBOList) {
                                    if (!StringUtils.isEquals((String)dto.getExecutorUserId(), (String)bo.getUserId())) continue;
                                    dto.setName(bo.getRealName());
                                }
                            }
                        }
                        if (worksheetEventSupperWrapList != null && !worksheetEventSupperWrapList.isEmpty()) {
                            for (UserDeatilInfoOutputBO bo : worksheetEventSupperWrapList) {
                                for (UserDeatilInfoOutputBO userDeatilInfoOutputBO : userDeatilInfoOutputBOList) {
                                    Object worksheetEventUserList;
                                    if (StringUtils.isEquals((String)bo.getCreateBy(), (String)userDeatilInfoOutputBO.getUserId())) {
                                        bo.setCreateName(userDeatilInfoOutputBO.getRealName());
                                    }
                                    if ((worksheetEventUserList = bo.getWorksheetEventUserList()) == null || worksheetEventUserList.isEmpty()) continue;
                                    Iterator iterator = worksheetEventUserList.iterator();
                                    while (iterator.hasNext()) {
                                        WorksheetEventUserOutputBO worksheetEventUserOutputBO = (WorksheetEventUserOutputBO)iterator.next();
                                        if (!StringUtils.isEquals((String)worksheetEventUserOutputBO.getUserId(), (String)userDeatilInfoOutputBO.getUserId())) continue;
                                        worksheetEventUserOutputBO.setUserName(userDeatilInfoOutputBO.getRealName());
                                    }
                                }
                            }
                        }
                    }
                }
                if (!CollectionUtils.isEmpty((Collection)worksheetExecutorList)) {
                    positionIdList.addAll(worksheetExecutorList.stream().filter(new /* Unavailable Anonymous Inner Class!! */).map(WorksheetExecutorOutputBO::getExecutorPositionId).collect(Collectors.toList()));
                }
                if ((positionIdCollect = positionIdList.stream().distinct().collect(Collectors.toList())) != null && !positionIdCollect.isEmpty()) {
                    QueryDeptInfosReqDTO queryDeptInfosReqDTO = new QueryDeptInfosReqDTO();
                    queryDeptInfosReqDTO.setPositionIds(positionIdCollect);
                    queryDeptInfosReqDTO.setLanguageCode(worksheetDetailQueryInputBO.getLanguageCode());
                    queryDeptInfosReqDTO.setTenantId(worksheetDetailQueryInputBO.getTenantId());
                    List quDeptInfoDTOList = this.organizationRepository.queryDeptByPositionIds(queryDeptInfosReqDTO);
                    if (!CollectionUtils.isEmpty((Collection)quDeptInfoDTOList)) {
                        if (worksheetExecutorList != null && !worksheetExecutorList.isEmpty()) {
                            for (WorksheetExecutorOutputBO dto : worksheetExecutorList) {
                                for (QuDeptInfoDTO bo : quDeptInfoDTOList) {
                                    if (!StringUtils.isBlank((String)dto.getExecutorUserId()) || !StringUtils.isEquals((String)dto.getExecutorPositionId(), (String)bo.getPositionId())) continue;
                                    dto.setName(bo.getPositionName());
                                }
                            }
                        }
                        if (worksheetEventSupperWrapList != null && !worksheetEventSupperWrapList.isEmpty()) {
                            for (UserDeatilInfoOutputBO bo : worksheetEventSupperWrapList) {
                                List worksheetEventPositionList = bo.getWorksheetEventPositionList();
                                if (worksheetEventPositionList == null || worksheetEventPositionList.isEmpty()) continue;
                                for (WorksheetEventPositionOutputBO worksheetEventPositionOutputBO : worksheetEventPositionList) {
                                    for (QuDeptInfoDTO queryResEmployeeOutputBO : quDeptInfoDTOList) {
                                        if (!StringUtils.isEquals((String)worksheetEventPositionOutputBO.getPositionId(), (String)queryResEmployeeOutputBO.getPositionId())) continue;
                                        worksheetEventPositionOutputBO.setPositionName(queryResEmployeeOutputBO.getPositionName());
                                        worksheetEventPositionOutputBO.setDeptList(queryResEmployeeOutputBO.getDeptList());
                                    }
                                }
                            }
                        }
                    }
                }
            }
            TemporaryTaskWorksheetWrapOutputDTO map = (TemporaryTaskWorksheetWrapOutputDTO)IFWBeanCopyUtil.map((Object)temporaryTaskWorksheetDetail, TemporaryTaskWorksheetWrapOutputDTO.class);
            response = BaseResponseUtils.getSuccessResponse((Object)map, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    public BaseResponse<DailyTaskWorkSheetWrapOutputDTO> getDailyTaskWorksheetDetail(IFWUser ifwUser, WorksheetDetailQueryInputBO worksheetDetailQueryInputBO) {
        BaseResponse response;
        try {
            List taskCheckPointRelationList;
            List collect;
            if (StringUtils.isBlank((String)worksheetDetailQueryInputBO.getTenantId())) {
                worksheetDetailQueryInputBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)worksheetDetailQueryInputBO.getTenantId());
            }
            IFWValidator.validate((Object)worksheetDetailQueryInputBO);
            DailyTaskWorkSheetWrapOutputBO dailyTaskWorksheetDetail = this.worksheetRepository.getDailyTaskWorksheetDetail(worksheetDetailQueryInputBO);
            TaskWorksheetOutputBO taskWorksheet = dailyTaskWorksheetDetail.getTaskWorksheet();
            List worksheetExecutorList = dailyTaskWorksheetDetail.getWorksheetExecutorList();
            if (worksheetExecutorList != null && !worksheetExecutorList.isEmpty()) {
                List userDeatilInfoOutputBOList;
                List userIdList = worksheetExecutorList.stream().map(WorksheetExecutorOutputBO::getExecutorUserId).collect(Collectors.toList());
                userIdList.add(taskWorksheet.getCreateBy());
                if (!StringUtils.isBlank((String)taskWorksheet.getHangUpBy())) {
                    userIdList.add(taskWorksheet.getHangUpBy());
                }
                if ((userDeatilInfoOutputBOList = this.organizationRepository.queryUserDetailByUserId(collect = userIdList.stream().distinct().collect(Collectors.toList()), worksheetDetailQueryInputBO.getTenantId(), worksheetDetailQueryInputBO.getLanguageCode())) != null && !userDeatilInfoOutputBOList.isEmpty()) {
                    for (UserDeatilInfoOutputBO bo : userDeatilInfoOutputBOList) {
                        if (StringUtils.isEquals((String)bo.getUserId(), (String)taskWorksheet.getCreateBy())) {
                            taskWorksheet.setCreateName(bo.getRealName());
                        }
                        if (StringUtils.isEquals((String)bo.getUserId(), (String)taskWorksheet.getHangUpBy())) {
                            taskWorksheet.setHangUpByName(bo.getRealName());
                        }
                        for (WorksheetExecutorOutputBO dto : worksheetExecutorList) {
                            if (!StringUtils.isEquals((String)dto.getExecutorUserId(), (String)bo.getUserId())) continue;
                            dto.setName(bo.getRealName());
                        }
                    }
                }
            }
            if ((taskCheckPointRelationList = dailyTaskWorksheetDetail.getTaskCheckPointRelationList()) != null && !taskCheckPointRelationList.isEmpty() && (collect = taskCheckPointRelationList.stream().map(TaskCheckPointRelationInsertInputBO::getCheckPointId).filter((Predicate<String>)new /* Unavailable Anonymous Inner Class!! */).distinct().collect(Collectors.toList())) != null && !collect.isEmpty()) {
                List list;
                QueryCheckPointListQueryInputBO queryCheckPointListQueryInputBO = new QueryCheckPointListQueryInputBO();
                queryCheckPointListQueryInputBO.setCheckPointId(collect);
                queryCheckPointListQueryInputBO.setTenantId(worksheetDetailQueryInputBO.getTenantId());
                queryCheckPointListQueryInputBO.setProjectId(worksheetDetailQueryInputBO.getProjectId());
                queryCheckPointListQueryInputBO.setLanguageCode(worksheetDetailQueryInputBO.getLanguageCode());
                IFWPageInfo checkpointList = this.configRepository.getCheckpointList(queryCheckPointListQueryInputBO);
                if (checkpointList != null && (list = checkpointList.getList()) != null && !list.isEmpty()) {
                    for (TaskCheckPointRelationInsertInputBO bo : taskCheckPointRelationList) {
                        for (QueryCheckPointListOutputBO checkPointListOutputBO : list) {
                            if (!StringUtils.isEquals((String)bo.getCheckPointId(), (String)checkPointListOutputBO.getCheckPointId())) continue;
                            bo.setCheckPointName(checkPointListOutputBO.getCheckPointName());
                        }
                    }
                }
            }
            response = BaseResponseUtils.getSuccessResponse((Object)IFWBeanCopyUtil.map((Object)dailyTaskWorksheetDetail, DailyTaskWorkSheetWrapOutputDTO.class), (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    public BaseResponse<Object> deleteWorksheet(IFWUser ifwUser, DeleteWorksheetInputBO deleteWorksheetInputBO) {
        BaseResponse response;
        try {
            if (StringUtils.isBlank((String)deleteWorksheetInputBO.getTenantId())) {
                deleteWorksheetInputBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)deleteWorksheetInputBO.getTenantId());
            }
            WorksheetDetailQueryInputBO worksheetDetailQueryInputBO = (WorksheetDetailQueryInputBO)IFWBeanCopyUtil.map((Object)deleteWorksheetInputBO, WorksheetDetailQueryInputBO.class);
            CommonWorksheetDetailOutputBO commonWorksheetDetailOutputBO = this.getCommonWorksheetDetail(worksheetDetailQueryInputBO);
            WorksheetOperateInputBO worksheetOperateInputBO = this.getWorksheetOperateInputBO(ifwUser, deleteWorksheetInputBO.getTenantId(), deleteWorksheetInputBO.getTaskWorksheetId(), deleteWorksheetInputBO.getProjectId(), deleteWorksheetInputBO.getLanguageCode(), commonWorksheetDetailOutputBO);
            worksheetOperateInputBO.getWorksheetEvent().setWorksheetEventContent(deleteWorksheetInputBO.getWorksheetEventContent());
            IFWValidator.validate((Object)worksheetOperateInputBO);
            this.worksheetRepository.deleteWorksheet(worksheetOperateInputBO);
            response = BaseResponseUtils.getSuccessResponse(null, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    public BaseResponse<List<TaskAssignExecutorOutputDTO>> getWorksheetAssignPositionList(IFWUser ifwUser, WorksheetAssignListQueryInputBO worksheetAssignListQueryInputBO) {
        if (StringUtils.isBlank((String)worksheetAssignListQueryInputBO.getTenantId())) {
            worksheetAssignListQueryInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)worksheetAssignListQueryInputBO.getTenantId());
        }
        CheckAccessUtils.checkIFWUserPosition((IFWUser)ifwUser);
        worksheetAssignListQueryInputBO.setPermissionSubjectPositionIdList(ifwUser.getPositions().stream().map(IFWPosition::getPositionId).collect(Collectors.toList()));
        IFWValidator.validate((Object)worksheetAssignListQueryInputBO);
        List taskExecutorList = this.worksheetRepository.getWorksheetAssignList(worksheetAssignListQueryInputBO);
        ArrayList<TaskAssignExecutorOutputDTO> taskAssignExecutorOutputDTOList = new ArrayList<TaskAssignExecutorOutputDTO>();
        if (taskExecutorList != null && !taskExecutorList.isEmpty()) {
            List deptIdList;
            ContactQueryInputBO contactQueryInputBO = new ContactQueryInputBO();
            contactQueryInputBO.setProjectId(worksheetAssignListQueryInputBO.getProjectId());
            contactQueryInputBO.setLanguageCode(worksheetAssignListQueryInputBO.getLanguageCode());
            contactQueryInputBO.setTenantId(worksheetAssignListQueryInputBO.getTenantId());
            List deptInfoList = this.organizationRepository.getDeptInfoList(contactQueryInputBO);
            if (!CollectionUtils.isEmpty((Collection)deptInfoList) && !CollectionUtils.isEmpty(deptIdList = deptInfoList.stream().filter(item -> StringUtils.isEquals((String)"0", (String)item.getObserverId())).map(QueryAllDeptDTO::getDeptId).distinct().collect(Collectors.toList()))) {
                List collect = taskExecutorList.stream().map(TaskExecutorInsertInputBO::getTaskExecutorPositionId).collect(Collectors.toList());
                QueryReqEmployeeDTO queryReqEmployeeDTO = new QueryReqEmployeeDTO();
                queryReqEmployeeDTO.setDeptIds(deptIdList);
                queryReqEmployeeDTO.setPositionIds(collect);
                queryReqEmployeeDTO.setLanguageCode(worksheetAssignListQueryInputBO.getLanguageCode());
                queryReqEmployeeDTO.setTenantId(worksheetAssignListQueryInputBO.getTenantId());
                List queryResEmployeeOutputBOList = this.organizationRepository.querySharePosition(queryReqEmployeeDTO);
                if (!CollectionUtils.isEmpty((Collection)queryResEmployeeOutputBOList)) {
                    Map<String, List<QueryResEmployeeOutputBO>> mapResult = queryResEmployeeOutputBOList.stream().collect(Collectors.groupingBy(QueryResEmployeeOutputBO::getPositionId));
                    for (String key : mapResult.keySet()) {
                        TaskAssignExecutorOutputDTO taskAssignExecutorOutputDTO = new TaskAssignExecutorOutputDTO();
                        taskAssignExecutorOutputDTO.setPositionId(key);
                        List<QueryResEmployeeOutputBO> employeeList = mapResult.get(key);
                        ArrayList deptNameList = new ArrayList();
                        if (!CollectionUtils.isEmpty(employeeList)) {
                            taskAssignExecutorOutputDTO.setPositionName(employeeList.get(0).getPositionName());
                            Map<String, List<QueryResEmployeeOutputBO>> deptMap = employeeList.stream().collect(Collectors.groupingBy(QueryResEmployeeOutputBO::getDeptId));
                            for (String deptId : deptMap.keySet()) {
                                List<QueryResEmployeeOutputBO> list = deptMap.get(deptId);
                                if (CollectionUtils.isEmpty(list)) continue;
                                deptNameList.addAll(list.stream().map(QueryResEmployeeOutputBO::getDeptName).distinct().collect(Collectors.toList()));
                            }
                        }
                        taskAssignExecutorOutputDTO.setDeptNameList(deptNameList);
                        taskAssignExecutorOutputDTOList.add(taskAssignExecutorOutputDTO);
                    }
                }
            }
        }
        BaseResponse response = BaseResponseUtils.getSuccessResponse(taskAssignExecutorOutputDTOList, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    public BaseResponse<List<QueryResEmployeeOutputDTO>> getWorksheetAssignUserList(IFWUser ifwUser, WorksheetAssignListQueryInputBO worksheetAssignListQueryInputBO) {
        if (StringUtils.isBlank((String)worksheetAssignListQueryInputBO.getTenantId())) {
            worksheetAssignListQueryInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)worksheetAssignListQueryInputBO.getTenantId());
        }
        CheckAccessUtils.checkIFWUserPosition((IFWUser)ifwUser);
        worksheetAssignListQueryInputBO.setPermissionSubjectPositionIdList(ifwUser.getPositions().stream().map(IFWPosition::getPositionId).collect(Collectors.toList()));
        IFWValidator.validate((Object)worksheetAssignListQueryInputBO);
        List taskExecutorList = this.worksheetRepository.getWorksheetAssignList(worksheetAssignListQueryInputBO);
        List queryResEmployeeOutputDTOList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)taskExecutorList)) {
            List deptIdList;
            ContactQueryInputBO contactQueryInputBO = new ContactQueryInputBO();
            contactQueryInputBO.setProjectId(worksheetAssignListQueryInputBO.getProjectId());
            contactQueryInputBO.setLanguageCode(worksheetAssignListQueryInputBO.getLanguageCode());
            contactQueryInputBO.setTenantId(worksheetAssignListQueryInputBO.getTenantId());
            List deptInfoList = this.organizationRepository.getDeptInfoList(contactQueryInputBO);
            if (deptInfoList != null && !CollectionUtils.isEmpty(deptIdList = deptInfoList.stream().filter(item -> StringUtils.isEquals((String)"0", (String)item.getObserverId())).map(QueryAllDeptDTO::getDeptId).distinct().collect(Collectors.toList()))) {
                List collect = taskExecutorList.stream().map(TaskExecutorInsertInputBO::getTaskExecutorPositionId).collect(Collectors.toList());
                QueryReqEmployeeDTO queryReqEmployeeDTO = new QueryReqEmployeeDTO();
                queryReqEmployeeDTO.setDeptIds(deptIdList);
                queryReqEmployeeDTO.setPositionIds(collect);
                queryReqEmployeeDTO.setLanguageCode(worksheetAssignListQueryInputBO.getLanguageCode());
                queryReqEmployeeDTO.setTenantId(worksheetAssignListQueryInputBO.getTenantId());
                List queryResEmployeeOutputBOList = this.organizationRepository.querySharePosition(queryReqEmployeeDTO);
                if (!CollectionUtils.isEmpty((Collection)queryResEmployeeOutputBOList)) {
                    ArrayList result = new ArrayList();
                    queryResEmployeeOutputBOList.stream().collect(Collectors.groupingBy(item -> item.getUserId() + "#" + item.getPositionId())).forEach((BiConsumer<String, List<QueryResEmployeeOutputBO>>)new /* Unavailable Anonymous Inner Class!! */);
                    queryResEmployeeOutputDTOList = IFWBeanCopyUtil.mapAsList(result, QueryResEmployeeOutputDTO.class);
                }
            }
        }
        BaseResponse response = BaseResponseUtils.getSuccessResponse(queryResEmployeeOutputDTOList, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    public BaseResponse<List<String>> getWorksheetOperationList(IFWUser ifwUser, TaskOperationQueryInputBO taskOperationQueryInputBO) {
        BaseResponse response;
        try {
            if (StringUtils.isBlank((String)taskOperationQueryInputBO.getTenantId())) {
                taskOperationQueryInputBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)taskOperationQueryInputBO.getTenantId());
            }
            WorksheetDetailQueryInputBO worksheetDetailQueryInputBO = new WorksheetDetailQueryInputBO();
            worksheetDetailQueryInputBO.setTenantId(taskOperationQueryInputBO.getTenantId());
            worksheetDetailQueryInputBO.setProjectId(taskOperationQueryInputBO.getProjectId());
            worksheetDetailQueryInputBO.setTaskWorksheetId(taskOperationQueryInputBO.getTaskWorksheetId());
            worksheetDetailQueryInputBO.setLanguageCode(taskOperationQueryInputBO.getLanguageCode());
            IFWValidator.validate((Object)worksheetDetailQueryInputBO);
            if (StringUtils.isBlank((String)worksheetDetailQueryInputBO.getTaskWorksheetId())) {
                throw new BizException(PlatformCodeEnum.TASK_WORKSHEET_ID_CANNOT_NULL.getDesc(), PlatformCodeEnum.TASK_WORKSHEET_ID_CANNOT_NULL.getCode());
            }
            CommonWorksheetDetailOutputBO commonWorksheetDetailOutputBO = this.worksheetRepository.getCommonWorksheetDetail(worksheetDetailQueryInputBO);
            if (commonWorksheetDetailOutputBO == null) {
                throw new BizException(PlatformCodeEnum.WORKSHEET_INFO_IS_NULL.getDesc(), PlatformCodeEnum.WORKSHEET_INFO_IS_NULL.getCode());
            }
            CheckAccessUtils.checkIFWUserPosition((IFWUser)ifwUser);
            taskOperationQueryInputBO.setPermissionSubjectPositionIdList(ifwUser.getPositions().stream().map(IFWPosition::getPositionId).collect(Collectors.toList()));
            taskOperationQueryInputBO.setTenantId(taskOperationQueryInputBO.getTenantId());
            taskOperationQueryInputBO.setTaskTemplateId(commonWorksheetDetailOutputBO.getTaskTemplateId());
            taskOperationQueryInputBO.setPermissionObjectPositionId(commonWorksheetDetailOutputBO.getCreateByPositionId());
            taskOperationQueryInputBO.setUserId(ifwUser.getUserId());
            IFWValidator.validate((Object)taskOperationQueryInputBO);
            List worksheetOperationList = this.worksheetRepository.getWorksheetOperationList(taskOperationQueryInputBO);
            response = BaseResponseUtils.getSuccessResponse((Object)worksheetOperationList, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    public BaseResponse<Object> shareWorksheet(IFWUser ifwUser, AssignWorksheetInputBO assignWorksheetInputBO) {
        BaseResponse response;
        try {
            if (StringUtils.isBlank((String)assignWorksheetInputBO.getTenantId())) {
                assignWorksheetInputBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)assignWorksheetInputBO.getTenantId());
            }
            WorksheetDetailQueryInputBO worksheetDetailQueryInputBO = (WorksheetDetailQueryInputBO)IFWBeanCopyUtil.map((Object)assignWorksheetInputBO, WorksheetDetailQueryInputBO.class);
            CommonWorksheetDetailOutputBO commonWorksheetDetailOutputBO = this.getCommonWorksheetDetail(worksheetDetailQueryInputBO);
            WorksheetOperateInputBO worksheetOperateInputBO = this.getWorksheetOperateInputBO(ifwUser, assignWorksheetInputBO.getTenantId(), assignWorksheetInputBO.getTaskWorksheetId(), assignWorksheetInputBO.getProjectId(), assignWorksheetInputBO.getLanguageCode(), commonWorksheetDetailOutputBO);
            if (assignWorksheetInputBO.getExpireMinute() != null && assignWorksheetInputBO.getExpireMinute() != 0L) {
                long time = new Date().getTime();
                long endTime = time + assignWorksheetInputBO.getExpireMinute() * 60L * 1000L;
                Date expireTime = new Date();
                expireTime.setTime(endTime);
                worksheetOperateInputBO.getTaskWorksheet().setExpireTime(expireTime);
            }
            List positionList = assignWorksheetInputBO.getWorksheetEventPositionList();
            List userList = assignWorksheetInputBO.getWorksheetEventUserList();
            if ((positionList == null || positionList.isEmpty()) && (userList == null || userList.isEmpty())) {
                throw new BizException(PlatformCodeEnum.SHARE_USER_INFO_IS_NULL.getDesc(), PlatformCodeEnum.SHARE_USER_INFO_IS_NULL.getCode());
            }
            worksheetOperateInputBO.setWorksheetEventPositionList(positionList);
            if (userList != null && !userList.isEmpty()) {
                userList.stream().forEach(new /* Unavailable Anonymous Inner Class!! */);
            }
            worksheetOperateInputBO.setWorksheetEventUserList(userList);
            IFWValidator.validate((Object)worksheetOperateInputBO);
            this.worksheetRepository.shareWorksheet(worksheetOperateInputBO);
            response = BaseResponseUtils.getSuccessResponse(null, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    public BaseResponse<Object> upgradeWorksheet(IFWUser ifwUser, UpgradeWorksheetInputBO upgradeWorksheetInputBO) {
        BaseResponse response;
        try {
            List worksheetEventPositionList;
            if (StringUtils.isBlank((String)upgradeWorksheetInputBO.getTenantId())) {
                upgradeWorksheetInputBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)upgradeWorksheetInputBO.getTenantId());
            }
            WorksheetDetailQueryInputBO worksheetDetailQueryInputBO = (WorksheetDetailQueryInputBO)IFWBeanCopyUtil.map((Object)upgradeWorksheetInputBO, WorksheetDetailQueryInputBO.class);
            CommonWorksheetDetailOutputBO commonWorksheetDetailOutputBO = this.getCommonWorksheetDetail(worksheetDetailQueryInputBO);
            WorksheetOperateInputBO worksheetOperateInputBO = this.getWorksheetOperateInputBO(ifwUser, upgradeWorksheetInputBO.getTenantId(), upgradeWorksheetInputBO.getTaskWorksheetId(), upgradeWorksheetInputBO.getProjectId(), upgradeWorksheetInputBO.getLanguageCode(), commonWorksheetDetailOutputBO);
            if (upgradeWorksheetInputBO.getExpireMinute() != null && upgradeWorksheetInputBO.getExpireMinute() != 0L) {
                long time = new Date().getTime();
                long endTime = time + upgradeWorksheetInputBO.getExpireMinute() * 60L * 1000L;
                Date expireTime = new Date();
                expireTime.setTime(endTime);
                worksheetOperateInputBO.getTaskWorksheet().setExpireTime(expireTime);
            }
            worksheetOperateInputBO.getWorksheetEvent().setWorksheetEventContent(upgradeWorksheetInputBO.getWorksheetEventContent());
            List worksheetEventUserList = upgradeWorksheetInputBO.getWorksheetEventUserList();
            if (!CollectionUtils.isEmpty((Collection)worksheetEventUserList)) {
                worksheetOperateInputBO.setWorksheetEventUserList(IFWBeanCopyUtil.mapAsList((Iterable)worksheetEventUserList, WorksheetEventUserInputBO.class));
            }
            if (!CollectionUtils.isEmpty((Collection)(worksheetEventPositionList = upgradeWorksheetInputBO.getWorksheetEventPositionList()))) {
                worksheetOperateInputBO.setWorksheetEventPositionList(IFWBeanCopyUtil.mapAsList((Iterable)worksheetEventPositionList, WorksheetEventPositionInputBO.class));
            }
            if (CollectionUtils.isEmpty((Collection)worksheetEventUserList) && CollectionUtils.isEmpty((Collection)worksheetEventPositionList)) {
                throw new BizException(PlatformCodeEnum.WORKSHEET_EXECUTOR_INFO_CANNOT_NULL.getDesc(), PlatformCodeEnum.WORKSHEET_EXECUTOR_INFO_CANNOT_NULL.getCode());
            }
            IFWValidator.validate((Object)worksheetOperateInputBO);
            this.worksheetRepository.upgradeWorksheet(worksheetOperateInputBO);
            response = BaseResponseUtils.getSuccessResponse(null, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    public BaseResponse<Object> updateWorksheetLabel(IFWUser ifwUser, WorksheetUpdateTagInputBO worksheetUpdateTagInputBO) {
        BaseResponse response;
        try {
            if (StringUtils.isBlank((String)worksheetUpdateTagInputBO.getTenantId())) {
                worksheetUpdateTagInputBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)worksheetUpdateTagInputBO.getTenantId());
            }
            WorksheetDetailQueryInputBO worksheetDetailQueryInputBO = (WorksheetDetailQueryInputBO)IFWBeanCopyUtil.map((Object)worksheetUpdateTagInputBO, WorksheetDetailQueryInputBO.class);
            IFWValidator.validate((Object)worksheetDetailQueryInputBO);
            CommonWorksheetDetailOutputBO commonWorksheetDetailOutputBO = this.worksheetRepository.getCommonWorksheetDetail(worksheetDetailQueryInputBO);
            if (commonWorksheetDetailOutputBO == null) {
                throw new BizException(PlatformCodeEnum.WORKSHEET_INFO_IS_NULL.getDesc(), PlatformCodeEnum.WORKSHEET_INFO_IS_NULL.getCode());
            }
            WorksheetOperateInputBO worksheetOperateInputBO = this.getWorksheetOperateInputBO(ifwUser, worksheetUpdateTagInputBO.getTenantId(), worksheetUpdateTagInputBO.getTaskWorksheetId(), worksheetUpdateTagInputBO.getProjectId(), worksheetUpdateTagInputBO.getLanguageCode(), commonWorksheetDetailOutputBO);
            worksheetOperateInputBO.getTaskWorksheet().setTaskTemplateTagId(worksheetUpdateTagInputBO.getTaskTemplateTagId());
            IFWValidator.validate((Object)worksheetOperateInputBO);
            this.worksheetRepository.updateWorksheetLabel(worksheetOperateInputBO);
            response = BaseResponseUtils.getSuccessResponse(null, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    public BaseResponse<Object> addConsumption(IFWUser ifwUser, AddConsumptionInputBO addConsumptionInputBO) {
        BaseResponse response;
        try {
            if (StringUtils.isBlank((String)addConsumptionInputBO.getTenantId())) {
                addConsumptionInputBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)addConsumptionInputBO.getTenantId());
            }
            WorksheetDetailQueryInputBO worksheetDetailQueryInputBO = (WorksheetDetailQueryInputBO)IFWBeanCopyUtil.map((Object)addConsumptionInputBO, WorksheetDetailQueryInputBO.class);
            CommonWorksheetDetailOutputBO commonWorksheetDetailOutputBO = this.getCommonWorksheetDetail(worksheetDetailQueryInputBO);
            WorksheetOperateInputBO worksheetOperateInputBO = this.getWorksheetOperateInputBO(ifwUser, addConsumptionInputBO.getTenantId(), addConsumptionInputBO.getTaskWorksheetId(), addConsumptionInputBO.getProjectId(), addConsumptionInputBO.getLanguageCode(), commonWorksheetDetailOutputBO);
            EventConsumptionInputBO eventConsumptionInputBO = (EventConsumptionInputBO)IFWBeanCopyUtil.map((Object)addConsumptionInputBO, EventConsumptionInputBO.class);
            worksheetOperateInputBO.setEventConsumption(eventConsumptionInputBO);
            IFWValidator.validate((Object)worksheetOperateInputBO);
            this.worksheetRepository.addConsumption(worksheetOperateInputBO);
            response = BaseResponseUtils.getSuccessResponse(null, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    public WorksheetOperateInputBO getWorksheetOperateInputBO(IFWUser ifwUser, String tenantId, String taskWorksheetId, String projectId, String languageCode, CommonWorksheetDetailOutputBO commonWorksheetDetailOutputBO) {
        WorksheetOperateInputBO worksheetOperateInputBO = new WorksheetOperateInputBO();
        TaskWorksheetUpdateInputBO taskWorksheet = new TaskWorksheetUpdateInputBO();
        WorksheetEventInputBO worksheetEventInputBO = new WorksheetEventInputBO();
        worksheetEventInputBO.setTenantId(tenantId);
        worksheetEventInputBO.setProjectId(projectId);
        worksheetEventInputBO.setWorksheetId(taskWorksheetId);
        taskWorksheet.setTenantId(tenantId);
        taskWorksheet.setUpdateBy(ifwUser.getUserId());
        taskWorksheet.setTaskWorksheetId(taskWorksheetId);
        taskWorksheet.setProjectId(projectId);
        worksheetOperateInputBO.setLanguageCode(languageCode);
        worksheetOperateInputBO.setProjectId(projectId);
        worksheetOperateInputBO.setTaskWorksheetId(taskWorksheetId);
        taskWorksheet.setCreateBy(commonWorksheetDetailOutputBO.getCreateBy());
        taskWorksheet.setTaskId(commonWorksheetDetailOutputBO.getTaskId());
        CheckAccessUtils.checkIFWUserPosition((IFWUser)ifwUser);
        worksheetOperateInputBO.setSubjectPermissionPositionIdList(ifwUser.getPositions().stream().map(IFWPosition::getPositionId).collect(Collectors.toList()));
        worksheetOperateInputBO.setTaskTemplateId(commonWorksheetDetailOutputBO.getTaskTemplateId());
        worksheetOperateInputBO.setPermissionObjectPositionId(commonWorksheetDetailOutputBO.getCreateByPositionId());
        worksheetOperateInputBO.setTaskWorksheet(taskWorksheet);
        worksheetOperateInputBO.setWorksheetEvent(worksheetEventInputBO);
        return worksheetOperateInputBO;
    }

    public CommonWorksheetDetailOutputBO getCommonWorksheetDetail(WorksheetDetailQueryInputBO worksheetDetailQueryInputBO) {
        IFWValidator.validate((Object)worksheetDetailQueryInputBO);
        CommonWorksheetDetailOutputBO commonWorksheetDetailOutputBO = this.worksheetRepository.getCommonWorksheetDetail(worksheetDetailQueryInputBO);
        if (commonWorksheetDetailOutputBO == null) {
            throw new BizException(PlatformCodeEnum.WORKSHEET_INFO_IS_NULL.getDesc(), PlatformCodeEnum.WORKSHEET_INFO_IS_NULL.getCode());
        }
        return commonWorksheetDetailOutputBO;
    }

    public BaseResponse<Object> addFeedback(IFWUser ifwUser, FeedBackWorksheetInputBO feedBackWorksheetInputBO) {
        BaseResponse response;
        try {
            if (StringUtils.isBlank((String)feedBackWorksheetInputBO.getTenantId())) {
                feedBackWorksheetInputBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)feedBackWorksheetInputBO.getTenantId());
            }
            WorksheetDetailQueryInputBO worksheetDetailQueryInputBO = (WorksheetDetailQueryInputBO)IFWBeanCopyUtil.map((Object)feedBackWorksheetInputBO, WorksheetDetailQueryInputBO.class);
            CommonWorksheetDetailOutputBO commonWorksheetDetailOutputBO = this.getCommonWorksheetDetail(worksheetDetailQueryInputBO);
            WorksheetOperateInputBO worksheetOperateInputBO = this.getWorksheetOperateInputBO(ifwUser, feedBackWorksheetInputBO.getTenantId(), feedBackWorksheetInputBO.getTaskWorksheetId(), feedBackWorksheetInputBO.getProjectId(), feedBackWorksheetInputBO.getLanguageCode(), commonWorksheetDetailOutputBO);
            if (feedBackWorksheetInputBO.getWorksheetEventPictureList() != null) {
                worksheetOperateInputBO.setWorksheetEventPictureList(IFWBeanCopyUtil.mapAsList((Iterable)feedBackWorksheetInputBO.getWorksheetEventPictureList(), WorksheetEventPictureInputBO.class));
            }
            worksheetOperateInputBO.getWorksheetEvent().setWorksheetEventContent(feedBackWorksheetInputBO.getWorksheetEventContent());
            worksheetOperateInputBO.getWorksheetEvent().setWorksheetEventResult(feedBackWorksheetInputBO.getWorksheetEventResult());
            IFWValidator.validate((Object)worksheetOperateInputBO);
            this.worksheetRepository.addFeedback(worksheetOperateInputBO);
            response = BaseResponseUtils.getSuccessResponse(null, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    public BaseResponse<Object> addWorksheetContent(IFWUser ifwUser, AddWorksheetContentInputBO addWorksheetContentInputBO) {
        BaseResponse response;
        try {
            if (StringUtils.isBlank((String)addWorksheetContentInputBO.getTenantId())) {
                addWorksheetContentInputBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)addWorksheetContentInputBO.getTenantId());
            }
            WorksheetDetailQueryInputBO worksheetDetailQueryInputBO = (WorksheetDetailQueryInputBO)IFWBeanCopyUtil.map((Object)addWorksheetContentInputBO, WorksheetDetailQueryInputBO.class);
            CommonWorksheetDetailOutputBO commonWorksheetDetailOutputBO = this.getCommonWorksheetDetail(worksheetDetailQueryInputBO);
            WorksheetOperateInputBO worksheetOperateInputBO = this.getWorksheetOperateInputBO(ifwUser, addWorksheetContentInputBO.getTenantId(), addWorksheetContentInputBO.getTaskWorksheetId(), addWorksheetContentInputBO.getProjectId(), addWorksheetContentInputBO.getLanguageCode(), commonWorksheetDetailOutputBO);
            if (addWorksheetContentInputBO.getWorksheetEventPictureList() != null) {
                worksheetOperateInputBO.setWorksheetEventPictureList(IFWBeanCopyUtil.mapAsList((Iterable)addWorksheetContentInputBO.getWorksheetEventPictureList(), WorksheetEventPictureInputBO.class));
            }
            worksheetOperateInputBO.getWorksheetEvent().setWorksheetEventContent(addWorksheetContentInputBO.getWorksheetEventContent());
            IFWValidator.validate((Object)worksheetOperateInputBO);
            this.worksheetRepository.addWorksheetContent(worksheetOperateInputBO);
            response = BaseResponseUtils.getSuccessResponse(null, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    public BaseResponse<Object> finishWorksheet(IFWUser ifwUser, FinishWorksheetInputBO finishWorksheetInputBO) {
        BaseResponse response;
        try {
            if (StringUtils.isBlank((String)finishWorksheetInputBO.getTenantId())) {
                finishWorksheetInputBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)finishWorksheetInputBO.getTenantId());
            }
            WorksheetDetailQueryInputBO worksheetDetailQueryInputBO = (WorksheetDetailQueryInputBO)IFWBeanCopyUtil.map((Object)finishWorksheetInputBO, WorksheetDetailQueryInputBO.class);
            CommonWorksheetDetailOutputBO commonWorksheetDetailOutputBO = this.getCommonWorksheetDetail(worksheetDetailQueryInputBO);
            WorksheetOperateInputBO worksheetOperateInputBO = this.getWorksheetOperateInputBO(ifwUser, finishWorksheetInputBO.getTenantId(), finishWorksheetInputBO.getTaskWorksheetId(), finishWorksheetInputBO.getProjectId(), finishWorksheetInputBO.getLanguageCode(), commonWorksheetDetailOutputBO);
            if (finishWorksheetInputBO.getWorksheetEventPictureList() != null && !finishWorksheetInputBO.getWorksheetEventPictureList().isEmpty()) {
                worksheetOperateInputBO.setWorksheetEventPictureList(IFWBeanCopyUtil.mapAsList((Iterable)finishWorksheetInputBO.getWorksheetEventPictureList(), WorksheetEventPictureInputBO.class));
            }
            if (StringUtils.isBlank((String)finishWorksheetInputBO.getTreatmentType())) {
                worksheetOperateInputBO.setTreatmentType("0");
            } else {
                worksheetOperateInputBO.setTreatmentType(finishWorksheetInputBO.getTreatmentType());
            }
            worksheetOperateInputBO.getWorksheetEvent().setWorksheetEventContent(finishWorksheetInputBO.getWorksheetEventContent());
            IFWValidator.validate((Object)worksheetOperateInputBO);
            this.worksheetRepository.finishWorksheet(worksheetOperateInputBO);
            response = BaseResponseUtils.getSuccessResponse(null, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    public BaseResponse<Object> competeWorksheet(IFWUser ifwUser, WorksheetOperateInputBO worksheetOperateInputBO) {
        BaseResponse response;
        try {
            if (StringUtils.isBlank((String)worksheetOperateInputBO.getTenantId())) {
                worksheetOperateInputBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)worksheetOperateInputBO.getTenantId());
            }
            WorksheetDetailQueryInputBO worksheetDetailQueryInputBO = new WorksheetDetailQueryInputBO();
            worksheetDetailQueryInputBO.setTenantId(worksheetOperateInputBO.getTenantId());
            worksheetDetailQueryInputBO.setProjectId(worksheetOperateInputBO.getProjectId());
            worksheetDetailQueryInputBO.setTaskWorksheetId(worksheetOperateInputBO.getTaskWorksheetId());
            IFWValidator.validate((Object)worksheetDetailQueryInputBO);
            CommonWorksheetDetailOutputBO commonWorksheetDetailOutputBO = this.worksheetRepository.getCommonWorksheetDetail(worksheetDetailQueryInputBO);
            if (commonWorksheetDetailOutputBO == null) {
                throw new BizException(PlatformCodeEnum.WORKSHEET_INFO_IS_NULL.getDesc(), PlatformCodeEnum.WORKSHEET_INFO_IS_NULL.getCode());
            }
            TaskWorksheetUpdateInputBO taskWorksheet = worksheetOperateInputBO.getTaskWorksheet();
            taskWorksheet.setTenantId(worksheetOperateInputBO.getTenantId());
            taskWorksheet.setUpdateBy(ifwUser.getUserId());
            taskWorksheet.setTaskWorksheetId(worksheetOperateInputBO.getTaskWorksheetId());
            taskWorksheet.setProjectId(worksheetOperateInputBO.getProjectId());
            taskWorksheet.setCreateBy(commonWorksheetDetailOutputBO.getCreateBy());
            taskWorksheet.setTaskId(commonWorksheetDetailOutputBO.getTaskId());
            if (ifwUser.getPositions() == null || ifwUser.getPositions().isEmpty()) {
                return BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.USER_POSITION_INFO_IS_NULL.getCode(), (String)PlatformCodeEnum.USER_POSITION_INFO_IS_NULL.getDesc());
            }
            worksheetOperateInputBO.setSubjectPermissionPositionIdList(ifwUser.getPositions().stream().map(IFWPosition::getPositionId).collect(Collectors.toList()));
            worksheetOperateInputBO.setTaskTemplateId(commonWorksheetDetailOutputBO.getTaskTemplateId());
            worksheetOperateInputBO.setPermissionObjectPositionId(commonWorksheetDetailOutputBO.getCreateByPositionId());
            IFWValidator.validate((Object)worksheetOperateInputBO);
            this.worksheetRepository.competeWorksheet(worksheetOperateInputBO);
            response = BaseResponseUtils.getSuccessResponse(null, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    public BaseResponse<Object> checkWorksheet(IFWUser ifwUser, CheckWorksheetInputBO checkWorksheetInputBO) {
        BaseResponse response;
        try {
            if (StringUtils.isBlank((String)checkWorksheetInputBO.getTenantId())) {
                checkWorksheetInputBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)checkWorksheetInputBO.getTenantId());
            }
            WorksheetDetailQueryInputBO worksheetDetailQueryInputBO = (WorksheetDetailQueryInputBO)IFWBeanCopyUtil.map((Object)checkWorksheetInputBO, WorksheetDetailQueryInputBO.class);
            CommonWorksheetDetailOutputBO commonWorksheetDetailOutputBO = this.getCommonWorksheetDetail(worksheetDetailQueryInputBO);
            WorksheetOperateInputBO worksheetOperateInputBO = this.getWorksheetOperateInputBO(ifwUser, checkWorksheetInputBO.getTenantId(), checkWorksheetInputBO.getTaskWorksheetId(), checkWorksheetInputBO.getProjectId(), checkWorksheetInputBO.getLanguageCode(), commonWorksheetDetailOutputBO);
            if (checkWorksheetInputBO.getWorksheetEventPictureList() != null) {
                worksheetOperateInputBO.setWorksheetEventPictureList(IFWBeanCopyUtil.mapAsList((Iterable)checkWorksheetInputBO.getWorksheetEventPictureList(), WorksheetEventPictureInputBO.class));
            }
            worksheetOperateInputBO.getWorksheetEvent().setWorksheetEventContent(checkWorksheetInputBO.getWorksheetEventContent());
            worksheetOperateInputBO.setCheckPass(checkWorksheetInputBO.getCheckPass());
            IFWValidator.validate((Object)worksheetOperateInputBO);
            this.worksheetRepository.checkWorksheet(worksheetOperateInputBO);
            response = BaseResponseUtils.getSuccessResponse(null, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    public BaseResponse<Object> operateWorksheetKnowledge(IFWUser ifwUser, OperateWorksheetKnowledgeInputBO operateWorksheetKnowledgeInputBO) {
        BaseResponse response;
        try {
            if (StringUtils.isBlank((String)operateWorksheetKnowledgeInputBO.getTenantId())) {
                operateWorksheetKnowledgeInputBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)operateWorksheetKnowledgeInputBO.getTenantId());
            }
            WorksheetDetailQueryInputBO worksheetDetailQueryInputBO = (WorksheetDetailQueryInputBO)IFWBeanCopyUtil.map((Object)operateWorksheetKnowledgeInputBO, WorksheetDetailQueryInputBO.class);
            CommonWorksheetDetailOutputBO commonWorksheetDetailOutputBO = this.getCommonWorksheetDetail(worksheetDetailQueryInputBO);
            WorksheetOperateInputBO worksheetOperateInputBO = this.getWorksheetOperateInputBO(ifwUser, operateWorksheetKnowledgeInputBO.getTenantId(), operateWorksheetKnowledgeInputBO.getTaskWorksheetId(), operateWorksheetKnowledgeInputBO.getProjectId(), operateWorksheetKnowledgeInputBO.getLanguageCode(), commonWorksheetDetailOutputBO);
            WorksheetEventInputBO worksheetEvent = worksheetOperateInputBO.getWorksheetEvent();
            worksheetEvent.setTaskOperationId(operateWorksheetKnowledgeInputBO.getOperateId());
            if (operateWorksheetKnowledgeInputBO.getWorksheetKnowledgeList() != null) {
                worksheetOperateInputBO.setWorksheetKnowledgeList(IFWBeanCopyUtil.mapAsList((Iterable)operateWorksheetKnowledgeInputBO.getWorksheetKnowledgeList(), WorksheetKnowledgeInputBO.class));
            }
            IFWValidator.validate((Object)worksheetOperateInputBO);
            this.worksheetRepository.operateWorksheetKnowledge(worksheetOperateInputBO);
            response = BaseResponseUtils.getSuccessResponse(null, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    public BaseResponse<Object> remindWorksheet(IFWUser ifwUser, RemindWorksheetInputBO remindWorksheetInputBO) {
        BaseResponse response;
        try {
            if (StringUtils.isBlank((String)remindWorksheetInputBO.getTenantId())) {
                remindWorksheetInputBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)remindWorksheetInputBO.getTenantId());
            }
            WorksheetDetailQueryInputBO worksheetDetailQueryInputBO = (WorksheetDetailQueryInputBO)IFWBeanCopyUtil.map((Object)remindWorksheetInputBO, WorksheetDetailQueryInputBO.class);
            CommonWorksheetDetailOutputBO commonWorksheetDetailOutputBO = this.getCommonWorksheetDetail(worksheetDetailQueryInputBO);
            WorksheetOperateInputBO worksheetOperateInputBO = this.getWorksheetOperateInputBO(ifwUser, remindWorksheetInputBO.getTenantId(), remindWorksheetInputBO.getTaskWorksheetId(), remindWorksheetInputBO.getProjectId(), remindWorksheetInputBO.getLanguageCode(), commonWorksheetDetailOutputBO);
            IFWValidator.validate((Object)worksheetOperateInputBO);
            this.worksheetRepository.remindWorksheet(worksheetOperateInputBO);
            response = BaseResponseUtils.getSuccessResponse(null, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    public BaseResponse<List<WorksheetEventSupperWrapOutputDTO>> checkPointScanInfoBOList(IFWUser ifwUser, CheckPointScanInfoQueryInputBO checkPointScanInfoQueryInputBO) {
        if (StringUtils.isBlank((String)checkPointScanInfoQueryInputBO.getTenantId())) {
            checkPointScanInfoQueryInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)checkPointScanInfoQueryInputBO.getTenantId());
        }
        IFWValidator.validate((Object)checkPointScanInfoQueryInputBO);
        List bo = this.worksheetRepository.checkPointScanInfoBOList(checkPointScanInfoQueryInputBO);
        if (bo != null && !bo.isEmpty()) {
            List collect = bo.stream().filter(new /* Unavailable Anonymous Inner Class!! */).map(WorksheetEventSupperWrapOutputBO::getCheckpointId).collect(Collectors.toList());
            QueryCheckPointListQueryInputBO queryCheckPointListQueryInputBO = new QueryCheckPointListQueryInputBO();
            queryCheckPointListQueryInputBO.setCheckPointId(collect);
            queryCheckPointListQueryInputBO.setLanguageCode(checkPointScanInfoQueryInputBO.getLanguageCode());
            queryCheckPointListQueryInputBO.setProjectId(checkPointScanInfoQueryInputBO.getProjectId());
            queryCheckPointListQueryInputBO.setTenantId(checkPointScanInfoQueryInputBO.getTenantId());
            List checkpointList = this.configRepository.getCheckpointList(queryCheckPointListQueryInputBO).getList();
            if (checkpointList != null && !checkpointList.isEmpty()) {
                for (WorksheetEventSupperWrapOutputBO outputBO : bo) {
                    for (QueryCheckPointListOutputBO checkPointListOutputBO : checkpointList) {
                        if (!StringUtils.isEquals((String)outputBO.getCheckpointId(), (String)checkPointListOutputBO.getCheckPointId())) continue;
                        outputBO.setCheckpointName(checkPointListOutputBO.getCheckPointName());
                    }
                }
            }
        }
        BaseResponse response = BaseResponseUtils.getSuccessResponse((Object)IFWBeanCopyUtil.mapAsList((Iterable)bo, WorksheetEventSupperWrapOutputDTO.class), (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    public BaseResponse<UploadScanResultOutpuDTO> uploadScanInfo(IFWUser ifwUser, UploadScanWrapInputBO uploadScanWrapInputBO) {
        List assetCheckRecordList;
        if (StringUtils.isBlank((String)uploadScanWrapInputBO.getTenantId())) {
            uploadScanWrapInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)uploadScanWrapInputBO.getTenantId());
        }
        WorksheetEventInputBO worksheetEvent = uploadScanWrapInputBO.getWorksheetEvent();
        worksheetEvent.setTenantId(uploadScanWrapInputBO.getTenantId());
        worksheetEvent.setCreateBy(ifwUser.getUserId());
        if (ifwUser.getPositions() == null || ifwUser.getPositions().isEmpty()) {
            return BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.USER_POSITION_INFO_IS_NULL.getCode(), (String)PlatformCodeEnum.USER_POSITION_INFO_IS_NULL.getDesc());
        }
        uploadScanWrapInputBO.setSubjectPermissionPositionIdList(ifwUser.getPositions().stream().map(IFWPosition::getPositionId).collect(Collectors.toList()));
        IFWValidator.validate((Object)uploadScanWrapInputBO);
        WorksheetEventCheckpointInputBO worksheetEventCheckpoint = uploadScanWrapInputBO.getWorksheetEventCheckpoint();
        if (worksheetEventCheckpoint != null && !CollectionUtils.isEmpty((Collection)(assetCheckRecordList = worksheetEventCheckpoint.getAssetCheckRecordList()))) {
            for (AssetCheckRecordInputBO bo : assetCheckRecordList) {
                TaskInsertInputBO task;
                TaskWrapInsertInputBO taskWrap = bo.getTaskWrap();
                if (taskWrap == null || (task = taskWrap.getTask()) == null) continue;
                task.setTaskSource("2");
            }
        }
        UploadScanResultOutputBO uploadScanResultOutputBO = this.worksheetRepository.uploadScanInfo(uploadScanWrapInputBO);
        BaseResponse response = BaseResponseUtils.getSuccessResponse((Object)IFWBeanCopyUtil.map((Object)uploadScanResultOutputBO, UploadScanResultOutpuDTO.class), (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    public BaseResponse<IFWPageInfo<ExportTemporaryWorksheetOutputDTO>> getExportTemporaryWorksheetList(IFWUser ifwUser, ExportTemporaryWorksheetQueryInputBO exportTemporaryWorksheetQueryInputBO) {
        BaseResponse response;
        try {
            List deptIdList;
            if (StringUtils.isBlank((String)exportTemporaryWorksheetQueryInputBO.getTenantId())) {
                exportTemporaryWorksheetQueryInputBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)exportTemporaryWorksheetQueryInputBO.getTenantId());
            }
            ArrayList<String> taskTypeIdList = new ArrayList<String>();
            taskTypeIdList.add("1");
            taskTypeIdList.add("4");
            exportTemporaryWorksheetQueryInputBO.setTaskTypeIdList(taskTypeIdList);
            IFWValidator.validate((Object)exportTemporaryWorksheetQueryInputBO);
            IFWPageInfo result = new IFWPageInfo();
            ArrayList createUserIdList = new ArrayList();
            if (!StringUtils.isBlank((String)exportTemporaryWorksheetQueryInputBO.getCreateName())) {
                List createUserId = this.organizationRepository.queryUserIdsByEmployeeName(exportTemporaryWorksheetQueryInputBO.getCreateName(), exportTemporaryWorksheetQueryInputBO.getLanguageCode(), exportTemporaryWorksheetQueryInputBO.getTenantId());
                if (createUserId != null) {
                    createUserIdList.addAll(createUserId);
                } else {
                    return BaseResponseUtils.getSuccessResponse((Object)result, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
                }
            }
            ArrayList executeIdList = new ArrayList();
            if (!StringUtils.isBlank((String)exportTemporaryWorksheetQueryInputBO.getExecutorName())) {
                List executeId = this.organizationRepository.queryUserIdsByEmployeeName(exportTemporaryWorksheetQueryInputBO.getExecutorName(), exportTemporaryWorksheetQueryInputBO.getLanguageCode(), exportTemporaryWorksheetQueryInputBO.getTenantId());
                if (executeId != null) {
                    executeIdList.addAll(executeId);
                } else {
                    return BaseResponseUtils.getSuccessResponse((Object)result, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
                }
            }
            ArrayList positionIdList = new ArrayList();
            ArrayList userIdList = new ArrayList();
            if (!CollectionUtils.isEmpty(executeIdList)) {
                userIdList.addAll(executeIdList);
            }
            if ((deptIdList = exportTemporaryWorksheetQueryInputBO.getDeptId()) != null && !deptIdList.isEmpty()) {
                List contactList = this.organizationRepository.getContactList(deptIdList, exportTemporaryWorksheetQueryInputBO.getLanguageCode(), exportTemporaryWorksheetQueryInputBO.getTenantId());
                if (contactList == null || contactList.isEmpty()) {
                    return BaseResponseUtils.getSuccessResponse(null, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
                }
                HashSet positionSet = new HashSet();
                contactList.forEach(new /* Unavailable Anonymous Inner Class!! */);
                positionIdList.addAll(positionSet);
            }
            ExportTemporaryWorksheetQueryBO exportTemporaryWorksheetQueryBO = (ExportTemporaryWorksheetQueryBO)IFWBeanCopyUtil.map((Object)exportTemporaryWorksheetQueryInputBO, ExportTemporaryWorksheetQueryBO.class);
            exportTemporaryWorksheetQueryBO.setCreateUserIdList(createUserIdList);
            exportTemporaryWorksheetQueryBO.setExecutePositionIdList(positionIdList);
            exportTemporaryWorksheetQueryBO.setExecuteUserIdList(userIdList);
            IFWPageInfo pageInfo = this.worksheetRepository.getExportTemporaryWorksheetList(exportTemporaryWorksheetQueryBO);
            List list = pageInfo.getList();
            if (list != null && !list.isEmpty()) {
                List spaceList;
                HashSet<String> userSet = new HashSet<String>();
                HashSet positionSet = new HashSet();
                HashSet spaceIdSet = new HashSet();
                for (ExportTemporaryWorksheetOutputBO bo : list) {
                    List taskSpaceList;
                    userSet.add(bo.getCreateBy());
                    List executorList = bo.getExecutorList();
                    if (executorList != null && !executorList.isEmpty()) {
                        executorList.forEach(new /* Unavailable Anonymous Inner Class!! */);
                    }
                    if (CollectionUtils.isEmpty((Collection)(taskSpaceList = bo.getTaskSpaceList()))) continue;
                    List spaceIdList = taskSpaceList.stream().filter(item -> !StringUtils.isBlank((String)item.getSpaceId())).map(TaskSpaceInsertInputBO::getSpaceId).distinct().collect(Collectors.toList());
                    spaceIdSet.addAll(spaceIdList);
                }
                ArrayList spaceIdList = new ArrayList(spaceIdSet);
                if (!CollectionUtils.isEmpty(spaceIdList) && !CollectionUtils.isEmpty((Collection)(spaceList = this.configRepository.querySpaceNameBySpaceList(spaceIdList, exportTemporaryWorksheetQueryInputBO.getTenantId(), exportTemporaryWorksheetQueryInputBO.getLanguageCode(), exportTemporaryWorksheetQueryInputBO.getProjectId())))) {
                    for (ProjectSpacePathDTO dto : spaceList) {
                        for (ExportTemporaryWorksheetOutputBO bo : list) {
                            List taskSpaceList = bo.getTaskSpaceList();
                            if (CollectionUtils.isEmpty((Collection)taskSpaceList)) continue;
                            for (TaskSpaceInsertInputBO spaceInsertInputBO : taskSpaceList) {
                                if (!StringUtils.isEquals((String)dto.getId(), (String)spaceInsertInputBO.getSpaceId())) continue;
                                spaceInsertInputBO.setTaskSpaceDescription(dto.getNameStr());
                            }
                        }
                    }
                }
                ArrayList executorPositionList = new ArrayList(positionSet);
                List employeePositionList = new ArrayList();
                if (executorPositionList != null && !executorPositionList.isEmpty()) {
                    QueryDeptInfosReqDTO queryDeptInfosReqDTO = new QueryDeptInfosReqDTO();
                    queryDeptInfosReqDTO.setPositionIds(executorPositionList);
                    queryDeptInfosReqDTO.setTenantId(exportTemporaryWorksheetQueryInputBO.getTenantId());
                    queryDeptInfosReqDTO.setLanguageCode(exportTemporaryWorksheetQueryInputBO.getLanguageCode());
                    employeePositionList = this.organizationRepository.queryDeptByPositionIds(queryDeptInfosReqDTO);
                }
                ArrayList executorUserIdList = new ArrayList(userSet);
                List userResList = this.organizationRepository.queryUserDetailByUserId(executorUserIdList, exportTemporaryWorksheetQueryInputBO.getTenantId(), exportTemporaryWorksheetQueryInputBO.getLanguageCode());
                for (ExportTemporaryWorksheetOutputBO bo : list) {
                    for (UserDeatilInfoOutputBO userBO : userResList) {
                        if (StringUtils.isEquals((String)userBO.getUserId(), (String)bo.getCreateBy())) {
                            bo.setCreateName(userBO.getRealName());
                        }
                        if (!StringUtils.isEquals((String)userBO.getUserId(), (String)bo.getUpdateBy())) continue;
                        bo.setUpdateName(userBO.getRealName());
                    }
                    List executorList = bo.getExecutorList();
                    if (executorList == null || executorList.isEmpty()) continue;
                    for (WorksheetExecutorOutputBO executorBO : executorList) {
                        if (!StringUtils.isBlank((String)executorBO.getExecutorUserId())) {
                            for (UserDeatilInfoOutputBO userBO : userResList) {
                                if (!StringUtils.isEquals((String)userBO.getUserId(), (String)executorBO.getExecutorUserId())) continue;
                                executorBO.setName(userBO.getRealName());
                            }
                            continue;
                        }
                        if (employeePositionList == null || employeePositionList.isEmpty()) continue;
                        for (QuDeptInfoDTO positionBO : employeePositionList) {
                            if (!StringUtils.isEquals((String)positionBO.getPositionId(), (String)executorBO.getExecutorPositionId())) continue;
                            executorBO.setName(positionBO.getPositionName());
                            executorBO.setDeptList(positionBO.getDeptList());
                        }
                    }
                }
            }
            result.setPageSize(pageInfo.getPageSize());
            result.setPageNum(pageInfo.getPageNum());
            result.setTotal(pageInfo.getTotal());
            result.setList(IFWBeanCopyUtil.mapAsList((Iterable)pageInfo.getList(), ExportTemporaryWorksheetOutputDTO.class));
            response = BaseResponseUtils.getSuccessResponse((Object)result, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    public BaseResponse<Workbook> exportTemporaryWorksheetList(IFWUser ifwUser, ExportTemporaryWorksheetQueryInputBO exportTemporaryWorksheetQueryInputBO) {
        BaseResponse response;
        try {
            if (StringUtils.isBlank((String)exportTemporaryWorksheetQueryInputBO.getTenantId())) {
                exportTemporaryWorksheetQueryInputBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)exportTemporaryWorksheetQueryInputBO.getTenantId());
            }
            BaseResponse data = this.getExportTemporaryWorksheetList(ifwUser, exportTemporaryWorksheetQueryInputBO);
            IFWPageInfo pageInfo = (IFWPageInfo)data.getData();
            List list = pageInfo.getList();
            TranslationBean translationBean = StringUtils.isEquals((String)exportTemporaryWorksheetQueryInputBO.getLanguageCode(), (String)"CN") ? (TranslationBean)this.translationConfig.getList().get(0) : (StringUtils.isEquals((String)exportTemporaryWorksheetQueryInputBO.getLanguageCode(), (String)"JP") ? (TranslationBean)this.translationConfig.getList().get(2) : (TranslationBean)this.translationConfig.getList().get(1));
            HSSFWorkbook sheets = new HSSFWorkbook();
            Sheet sheet = sheets.createSheet(translationBean.getTempWorksheet());
            int rowNum = 0;
            int cellNum = 0;
            Row row = sheet.createRow(rowNum++);
            row.createCell(cellNum++).setCellValue(translationBean.getTaskName());
            row.createCell(cellNum++).setCellValue(translationBean.getTaskSpace());
            row.createCell(cellNum++).setCellValue(translationBean.getWorksheetStatus());
            row.createCell(cellNum++).setCellValue(translationBean.getTaskTemplate());
            row.createCell(cellNum++).setCellValue(translationBean.getTaskTag());
            row.createCell(cellNum++).setCellValue(translationBean.getCreator());
            row.createCell(cellNum++).setCellValue(translationBean.getExecutor());
            row.createCell(cellNum++).setCellValue(translationBean.getExecutePosition());
            row.createCell(cellNum++).setCellValue(translationBean.getCheck());
            row.createCell(cellNum++).setCellValue(translationBean.getCheckResult());
            row.createCell(cellNum++).setCellValue(translationBean.getRemark());
            row.createCell(cellNum++).setCellValue(translationBean.getCreateTime());
            row.createCell(cellNum++).setCellValue(translationBean.getFinishTime());
            row.createCell(cellNum++).setCellValue(translationBean.getDuration());
            row.createCell(cellNum++).setCellValue(translationBean.getWorksheetNo());
            row.createCell(cellNum++).setCellValue(translationBean.getIsSpecial());
            row.createCell(cellNum++).setCellValue(translationBean.getPictureFiles());
            if (list != null && !list.isEmpty()) {
                for (ExportTemporaryWorksheetOutputDTO dto : list) {
                    row = sheet.createRow(rowNum++);
                    cellNum = 0;
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    row.createCell(cellNum++).setCellValue(dto.getTaskName());
                    row.createCell(cellNum++).setCellValue(((TaskSpaceInsertInputDTO)dto.getTaskSpaceList().get(0)).getTaskSpaceDescription());
                    Cell cell = row.createCell(cellNum++);
                    cell.setCellValue(dto.getWorksheetStatusName());
                    row.createCell(cellNum++).setCellValue(dto.getTaskTemplateName());
                    row.createCell(cellNum++).setCellValue(dto.getTaskTemplateTagName());
                    row.createCell(cellNum++).setCellValue(dto.getCreateName());
                    cell = row.createCell(cellNum++);
                    List executorList = dto.getExecutorList();
                    if (executorList != null && !executorList.isEmpty()) {
                        cell.setCellValue(StringUtils.join((Collection)executorList.stream().filter(new /* Unavailable Anonymous Inner Class!! */).map(WorksheetExecutorOutputDTO::getName).collect(Collectors.toList()), (String)","));
                    }
                    cell = row.createCell(cellNum++);
                    if (executorList != null && !executorList.isEmpty()) {
                        cell.setCellValue(StringUtils.join((Collection)executorList.stream().filter(new /* Unavailable Anonymous Inner Class!! */).map(item -> {
                            StringBuffer stringBuffer = new StringBuffer();
                            List deptList = item.getDeptList();
                            if (!CollectionUtils.isEmpty((Collection)deptList)) {
                                String join = StringUtils.join((Collection)deptList.stream().filter(a -> !StringUtils.isEmpty((String)a.getDeptName())).map(QueryDeptInfosResDTO::getDeptName).collect(Collectors.toList()), (String)"/");
                                stringBuffer.append(join);
                            }
                            return stringBuffer.append("/" + item.getName()).toString();
                        }).collect(Collectors.toList()), (String)","));
                    }
                    row.createCell(cellNum++).setCellValue(dto.getUpdateName());
                    cell = row.createCell(cellNum++);
                    if (dto.getWorksheetEventResult() != null) {
                        switch (dto.getWorksheetEventResult()) {
                            case "1": {
                                cell.setCellValue("A");
                                break;
                            }
                            case "2": {
                                cell.setCellValue("B");
                                break;
                            }
                            case "3": {
                                cell.setCellValue("C");
                                break;
                            }
                        }
                    }
                    row.createCell(cellNum++).setCellValue(dto.getWorksheetEventContent());
                    row.createCell(cellNum++).setCellValue(sdf.format(dto.getCreateTime()));
                    cell = row.createCell(cellNum++);
                    if (StringUtils.isEquals((String)dto.getWorksheetStatusId(), (String)"6")) {
                        cell.setCellValue(sdf.format(dto.getUpdateTime()));
                    }
                    cell = row.createCell(cellNum++);
                    if (dto.getUpdateTime() != null) {
                        String minutesCN;
                        int minutes = (int)((dto.getUpdateTime().getTime() - dto.getCreateTime().getTime()) / 60000L);
                        if (minutes == 0) {
                            minutesCN = translationBean.getZeroTime();
                        } else {
                            int hour = (int)Math.floor(minutes / 60);
                            int minute = minutes % 60;
                            minutesCN = hour + translationBean.getHour() + minute + translationBean.getMinute();
                        }
                        cell.setCellValue(minutesCN);
                    }
                    row.createCell(cellNum++).setCellValue(dto.getWorksheetNo());
                    row.createCell(cellNum++).setCellValue(StringUtils.isEquals((String)dto.getSpecicalFlag(), (String)"0") ? translationBean.getYes() : translationBean.getNo());
                    List taskWorksheetPictureList = dto.getTaskWorksheetPictureList();
                    String pictureStr = !CollectionUtils.isEmpty((Collection)taskWorksheetPictureList) ? CollectionUtils.join((List)taskWorksheetPictureList, (String)";") : "";
                    row.createCell(cellNum++).setCellValue(pictureStr);
                }
            }
            sheet.setColumnWidth(0, 2000);
            sheet.autoSizeColumn(1);
            sheet.autoSizeColumn(2);
            sheet.autoSizeColumn(3);
            sheet.autoSizeColumn(4);
            sheet.autoSizeColumn(5);
            sheet.autoSizeColumn(6);
            sheet.autoSizeColumn(7);
            sheet.autoSizeColumn(8);
            response = BaseResponseUtils.getSuccessResponse((Object)sheets, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    public BaseResponse<IFWPageInfo<ExportDailyWorksheetOutputDTO>> getExportDailyWorksheetList(IFWUser ifwUser, ExportDailyWorksheetQueryInputBO exportDailyWorksheetQueryInputBO) {
        BaseResponse response;
        try {
            if (StringUtils.isBlank((String)exportDailyWorksheetQueryInputBO.getTenantId())) {
                exportDailyWorksheetQueryInputBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)exportDailyWorksheetQueryInputBO.getTenantId());
            }
            IFWValidator.validate((Object)exportDailyWorksheetQueryInputBO);
            IFWPageInfo pageInfo = this.worksheetRepository.getExportDailyWorksheetList(exportDailyWorksheetQueryInputBO);
            List dailyTaskWorkSheetListOutputDTOList = IFWBeanCopyUtil.mapAsList((Iterable)pageInfo.getList(), DailyTaskWorkSheetListOutputDTO.class);
            dailyTaskWorkSheetListOutputDTOList = this.addExecutorNames(dailyTaskWorkSheetListOutputDTOList, exportDailyWorksheetQueryInputBO.getTenantId(), exportDailyWorksheetQueryInputBO.getLanguageCode());
            List exportDailyWorksheetList = IFWBeanCopyUtil.mapAsList((Iterable)dailyTaskWorkSheetListOutputDTOList, ExportDailyWorksheetOutputDTO.class);
            IFWPageInfo result = new IFWPageInfo();
            result.setTotal(pageInfo.getTotal());
            result.setPageNum(pageInfo.getPageNum());
            result.setPageSize(pageInfo.getPageSize());
            result.setList(exportDailyWorksheetList);
            response = BaseResponseUtils.getSuccessResponse((Object)result, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    public BaseResponse<Workbook> exportDailyWorksheetList(IFWUser ifwUser, ExportDailyWorksheetQueryInputBO exportDailyWorksheetQueryInputBO) {
        BaseResponse response;
        try {
            if (StringUtils.isBlank((String)exportDailyWorksheetQueryInputBO.getTenantId())) {
                exportDailyWorksheetQueryInputBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)exportDailyWorksheetQueryInputBO.getTenantId());
            }
            BaseResponse data = this.getExportDailyWorksheetList(ifwUser, exportDailyWorksheetQueryInputBO);
            IFWPageInfo pageInfo = (IFWPageInfo)data.getData();
            List list = pageInfo.getList();
            TranslationBean translationBean = StringUtils.isEquals((String)exportDailyWorksheetQueryInputBO.getLanguageCode(), (String)"CN") ? (TranslationBean)this.translationConfig.getList().get(0) : (StringUtils.isEquals((String)exportDailyWorksheetQueryInputBO.getLanguageCode(), (String)"JP") ? (TranslationBean)this.translationConfig.getList().get(2) : (TranslationBean)this.translationConfig.getList().get(1));
            HSSFWorkbook sheets = new HSSFWorkbook();
            Sheet sheet = sheets.createSheet(translationBean.getDailyWorksheet());
            int rowNum = 0;
            int cellNum = 0;
            Row row = sheet.createRow(rowNum++);
            row.createCell(cellNum++).setCellValue(translationBean.getWorksheetNo());
            row.createCell(cellNum++).setCellValue(translationBean.getTaskName());
            row.createCell(cellNum++).setCellValue(translationBean.getTaskType());
            row.createCell(cellNum++).setCellValue(translationBean.getWorksheetStatus());
            row.createCell(cellNum++).setCellValue(translationBean.getTaskTemplate());
            row.createCell(cellNum++).setCellValue(translationBean.getCreator());
            row.createCell(cellNum++).setCellValue(translationBean.getExecutor());
            if (StringUtils.isEquals((String)exportDailyWorksheetQueryInputBO.getTaskTypeId(), (String)"2")) {
                row.createCell(cellNum++).setCellValue(translationBean.getWorkTime());
                row.createCell(cellNum++).setCellValue(translationBean.getActualWorkTime());
            } else {
                row.createCell(cellNum++).setCellValue(translationBean.getPatrolTimes());
                row.createCell(cellNum++).setCellValue(translationBean.getActualPatrolTimes());
            }
            row.createCell(cellNum++).setCellValue(translationBean.getRemark());
            row.createCell(cellNum++).setCellValue(translationBean.getCreateTime());
            row.createCell(cellNum++).setCellValue(translationBean.getUpdateTime());
            if (list != null && !list.isEmpty()) {
                for (ExportDailyWorksheetOutputDTO dto : list) {
                    row = sheet.createRow(rowNum++);
                    cellNum = 0;
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    row.createCell(cellNum++).setCellValue(dto.getWorksheetNo());
                    row.createCell(cellNum++).setCellValue(dto.getTaskName());
                    row.createCell(cellNum++).setCellValue(StringUtils.isEquals((String)dto.getTaskTypeId(), (String)"2") ? translationBean.getStaticTask() : translationBean.getPatrolTask());
                    Cell cell = row.createCell(cellNum++);
                    if (StringUtils.isEquals((String)dto.getWorksheetStatusId(), (String)"6")) {
                        cell.setCellValue(translationBean.getFinishStatus());
                    } else if (dto.getWorkingMinuteActual() > 0 || dto.getPatrolCountActual() > 0) {
                        cell.setCellValue(translationBean.getUnFinishStatus());
                    } else {
                        cell.setCellValue(translationBean.getNoRecords());
                    }
                    row.createCell(cellNum++).setCellValue(dto.getTaskTemplateName());
                    row.createCell(cellNum++).setCellValue(dto.getCreateName());
                    cell = row.createCell(cellNum++);
                    List executorList = dto.getWorksheetExecutorList();
                    if (executorList != null && !executorList.isEmpty()) {
                        cell.setCellValue(StringUtils.join((Collection)executorList.stream().filter(new /* Unavailable Anonymous Inner Class!! */).map(WorksheetExecutorOutputDTO::getName).collect(Collectors.toList()), (String)","));
                    }
                    if (StringUtils.isEquals((String)exportDailyWorksheetQueryInputBO.getTaskTypeId(), (String)"2")) {
                        int minute;
                        int hour;
                        cell = row.createCell(cellNum++);
                        if (StringUtils.isEquals((String)dto.getTaskTypeId(), (String)"2")) {
                            if (dto.getWorkingMiniute() > 0) {
                                hour = (int)Math.floor(dto.getWorkingMiniute() / 60);
                                minute = dto.getWorkingMiniute() % 60;
                                cell.setCellValue(hour + translationBean.getHour() + minute + translationBean.getMinute());
                            } else {
                                cell.setCellValue(translationBean.getZeroTime());
                            }
                        } else {
                            cell.setCellValue("");
                        }
                        cell = row.createCell(cellNum++);
                        if (StringUtils.isEquals((String)dto.getTaskTypeId(), (String)"2")) {
                            if (dto.getWorkingMinuteActual() > 0) {
                                hour = (int)Math.floor(dto.getWorkingMinuteActual() / 60);
                                minute = dto.getWorkingMinuteActual() % 60;
                                cell.setCellValue(hour + translationBean.getHour() + minute + translationBean.getMinute());
                            } else {
                                cell.setCellValue(translationBean.getZeroTime());
                            }
                        } else {
                            cell.setCellValue("");
                        }
                    } else {
                        row.createCell(cellNum++).setCellValue(StringUtils.isEquals((String)dto.getTaskTypeId(), (String)"3") ? dto.getPatrolCount() + "" : "");
                        row.createCell(cellNum++).setCellValue(StringUtils.isEquals((String)dto.getTaskTypeId(), (String)"3") ? dto.getPatrolCountActual() + "" : "");
                    }
                    row.createCell(cellNum++).setCellValue(dto.getTaskDescription());
                    row.createCell(cellNum++).setCellValue(sdf.format(dto.getCreateTime()));
                    if (dto.getUpdateTime() == null) continue;
                    row.createCell(cellNum++).setCellValue(sdf.format(dto.getUpdateTime()));
                }
            }
            sheet.setColumnWidth(0, 2000);
            sheet.autoSizeColumn(1);
            sheet.autoSizeColumn(2);
            sheet.autoSizeColumn(3);
            sheet.autoSizeColumn(4);
            sheet.autoSizeColumn(5);
            sheet.autoSizeColumn(6);
            sheet.autoSizeColumn(7);
            sheet.autoSizeColumn(8);
            response = BaseResponseUtils.getSuccessResponse((Object)sheets, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    public BaseResponse<IFWPageInfo<WorksheetListForSeerOutputDTO>> getWorksheetListBySpaceForSeer(IFWUser ifwUser, SeerWorksheetQueryInputBO seerWorksheetQueryInputBO) {
        if (StringUtils.isBlank((String)seerWorksheetQueryInputBO.getTenantId())) {
            seerWorksheetQueryInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)seerWorksheetQueryInputBO.getTenantId());
        }
        IFWValidator.validate((Object)seerWorksheetQueryInputBO);
        if (seerWorksheetQueryInputBO.getSpaceId() != null) {
            List sonSpace = this.configRepository.getSonSpace(seerWorksheetQueryInputBO.getSpaceId());
            seerWorksheetQueryInputBO.setSpaceIdList(sonSpace);
        }
        Date startDate = null;
        Date endDate = null;
        if (StringUtils.isEquals((String)seerWorksheetQueryInputBO.getQueryType(), (String)"1")) {
            startDate = DateUtils.getFirstDateOfDay((Date)seerWorksheetQueryInputBO.getCurrentDate());
            endDate = DateUtils.getLastDateOfDay((Date)seerWorksheetQueryInputBO.getCurrentDate());
        } else if (StringUtils.isEquals((String)seerWorksheetQueryInputBO.getQueryType(), (String)"2")) {
            startDate = DateUtils.getStartDayOfWeekNo((int)seerWorksheetQueryInputBO.getYear(), (int)seerWorksheetQueryInputBO.getIndex());
            endDate = DateUtils.getEndDayOfWeekNo((int)seerWorksheetQueryInputBO.getYear(), (int)seerWorksheetQueryInputBO.getIndex());
        } else {
            startDate = DateUtils.getStartDayOfMonthNo((int)seerWorksheetQueryInputBO.getYear(), (int)seerWorksheetQueryInputBO.getIndex());
            endDate = DateUtils.getEndDayOfMonth((int)seerWorksheetQueryInputBO.getYear(), (int)seerWorksheetQueryInputBO.getIndex());
        }
        seerWorksheetQueryInputBO.setStartDate(startDate);
        seerWorksheetQueryInputBO.setEndDate(endDate);
        IFWPageInfo pageInfo = this.worksheetRepository.getWorksheetListForSeer(seerWorksheetQueryInputBO);
        List worksheetList = IFWBeanCopyUtil.mapAsList((Iterable)pageInfo.getList(), WorksheetListForSeerOutputDTO.class);
        if (worksheetList != null && !worksheetList.isEmpty()) {
            ArrayList collect = new ArrayList();
            worksheetList.stream().forEach(new /* Unavailable Anonymous Inner Class!! */);
            HashSet positionSet = new HashSet();
            HashSet userSet = new HashSet();
            collect.stream().forEach(new /* Unavailable Anonymous Inner Class!! */);
            ArrayList positionIdList = new ArrayList(positionSet);
            ArrayList userIdList = new ArrayList(userSet);
            List positionDetailList = null;
            List userDetailList = null;
            if (positionIdList != null && !positionIdList.isEmpty()) {
                positionDetailList = this.organizationRepository.queryPositionNameList(positionIdList, seerWorksheetQueryInputBO.getTenantId(), seerWorksheetQueryInputBO.getLanguageCode());
            }
            if (userIdList != null && !userIdList.isEmpty()) {
                userDetailList = this.organizationRepository.queryUserDetailByUserId(userIdList, seerWorksheetQueryInputBO.getTenantId(), seerWorksheetQueryInputBO.getLanguageCode());
            }
            for (WorksheetListForSeerOutputDTO dto : worksheetList) {
                List executorList = dto.getExecutorList();
                if (executorList == null || executorList.isEmpty()) continue;
                for (WorksheetExecutorOutputDTO executorDTO : executorList) {
                    if (!StringUtils.isBlank((String)executorDTO.getExecutorUserId())) {
                        if (userDetailList == null || userDetailList.isEmpty()) continue;
                        for (UserDeatilInfoOutputBO userBO : userDetailList) {
                            if (!StringUtils.isEquals((String)userBO.getUserId(), (String)executorDTO.getExecutorUserId())) continue;
                            executorDTO.setName(userBO.getRealName());
                        }
                        continue;
                    }
                    if (StringUtils.isBlank((String)executorDTO.getExecutorPositionId()) || positionDetailList == null || positionDetailList.isEmpty()) continue;
                    for (QueryPositionNameResDTO positionBO : positionDetailList) {
                        if (!StringUtils.isEquals((String)positionBO.getPositionId(), (String)executorDTO.getExecutorPositionId())) continue;
                        executorDTO.setName(positionBO.getPositionName());
                    }
                }
            }
        }
        IFWPageInfo pageResult = new IFWPageInfo();
        pageResult.setTotal(pageInfo.getTotal());
        pageResult.setPageNum(pageInfo.getPageNum());
        pageResult.setPageSize(pageInfo.getPageSize());
        pageResult.setList(worksheetList);
        BaseResponse response = BaseResponseUtils.getSuccessResponse((Object)pageResult, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    public BaseResponse<IFWPageInfo<WorksheetListForSeerOutputDTO>> getWorksheetByAssetIdForSeer(IFWUser ifwUser, WorksheetQueryByAssetInputBO worksheetQueryByAssetInputBO) {
        BaseResponse response;
        try {
            if (StringUtils.isBlank((String)worksheetQueryByAssetInputBO.getTenantId())) {
                worksheetQueryByAssetInputBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)worksheetQueryByAssetInputBO.getTenantId());
            }
            IFWValidator.validate((Object)worksheetQueryByAssetInputBO);
            IFWPageInfo pageInfo = this.worksheetRepository.getWorksheetByAssetIdForSeer(worksheetQueryByAssetInputBO);
            List worksheetList = IFWBeanCopyUtil.mapAsList((Iterable)pageInfo.getList(), WorksheetListForSeerOutputDTO.class);
            if (worksheetList != null && !worksheetList.isEmpty()) {
                ArrayList collect = new ArrayList();
                worksheetList.stream().forEach(new /* Unavailable Anonymous Inner Class!! */);
                HashSet positionSet = new HashSet();
                HashSet userSet = new HashSet();
                collect.stream().forEach(new /* Unavailable Anonymous Inner Class!! */);
                ArrayList positionIdList = new ArrayList(positionSet);
                ArrayList userIdList = new ArrayList(userSet);
                List positionDetailList = null;
                List userDetailList = null;
                if (positionIdList != null && !positionIdList.isEmpty()) {
                    positionDetailList = this.organizationRepository.queryPositionNameList(positionIdList, worksheetQueryByAssetInputBO.getTenantId(), worksheetQueryByAssetInputBO.getLanguageCode());
                }
                if (userIdList != null && !userIdList.isEmpty()) {
                    userDetailList = this.organizationRepository.queryUserDetailByUserId(userIdList, worksheetQueryByAssetInputBO.getTenantId(), worksheetQueryByAssetInputBO.getLanguageCode());
                }
                for (WorksheetListForSeerOutputDTO dto : worksheetList) {
                    List executorList = dto.getExecutorList();
                    if (executorList == null || executorList.isEmpty()) continue;
                    for (WorksheetExecutorOutputDTO executorDTO : executorList) {
                        if (!StringUtils.isBlank((String)executorDTO.getExecutorUserId())) {
                            if (userDetailList == null || userDetailList.isEmpty()) continue;
                            for (UserDeatilInfoOutputBO userBO : userDetailList) {
                                if (!StringUtils.isEquals((String)userBO.getUserId(), (String)executorDTO.getExecutorUserId())) continue;
                                executorDTO.setName(userBO.getRealName());
                            }
                            continue;
                        }
                        if (StringUtils.isBlank((String)executorDTO.getExecutorPositionId()) || positionDetailList == null || positionDetailList.isEmpty()) continue;
                        for (QueryPositionNameResDTO positionBO : positionDetailList) {
                            if (!StringUtils.isEquals((String)positionBO.getPositionId(), (String)executorDTO.getExecutorPositionId())) continue;
                            executorDTO.setName(positionBO.getPositionName());
                        }
                    }
                }
            }
            IFWPageInfo pageResult = new IFWPageInfo();
            pageResult.setTotal(pageInfo.getTotal());
            pageResult.setPageNum(pageInfo.getPageNum());
            pageResult.setPageSize(pageInfo.getPageSize());
            pageResult.setList(worksheetList);
            response = BaseResponseUtils.getSuccessResponse((Object)pageResult, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    public BaseResponse<IFWPageInfo<SpecialWorksheetOutputDTO>> getSpecialListBySpace(IFWUser ifwUser, QuerySpecialListBySpaceInputBO querySpecialListBySpaceInputBO) {
        if (StringUtils.isBlank((String)querySpecialListBySpaceInputBO.getTenantId())) {
            querySpecialListBySpaceInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)querySpecialListBySpaceInputBO.getTenantId());
        }
        List areaSpaceIdList = querySpecialListBySpaceInputBO.getSpaceIdList();
        if (StringUtils.isBlank((String)querySpecialListBySpaceInputBO.getSpaceId()) && (areaSpaceIdList == null || areaSpaceIdList.isEmpty())) {
            throw new BizException(PlatformCodeEnum.SPACE_ID_CANNOT_NULL.getDesc(), PlatformCodeEnum.SPACE_ID_CANNOT_NULL.getCode());
        }
        IFWValidator.validate((Object)querySpecialListBySpaceInputBO);
        List spaceIdList = new ArrayList();
        spaceIdList = !StringUtils.isBlank((String)querySpecialListBySpaceInputBO.getSpaceId()) ? this.configRepository.getSonSpace(querySpecialListBySpaceInputBO.getSpaceId()) : querySpecialListBySpaceInputBO.getSpaceIdList();
        if (CollectionUtils.isEmpty(spaceIdList)) {
            throw new BizException(PlatformCodeEnum.SPACE_ID_LIST_CANNOT_NULL.getDesc(), PlatformCodeEnum.SPACE_ID_LIST_CANNOT_NULL.getCode());
        }
        querySpecialListBySpaceInputBO.setSpaceIdList(spaceIdList);
        IFWPageInfo pageInfo = this.worksheetRepository.getSpecialListBySpace(querySpecialListBySpaceInputBO);
        List worksheetList = new ArrayList();
        if (pageInfo != null && !CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            worksheetList = IFWBeanCopyUtil.mapAsList((Iterable)pageInfo.getList(), SpecialWorksheetOutputDTO.class);
            List spaceList = this.configRepository.querySpaceNameBySpaceList(spaceIdList, querySpecialListBySpaceInputBO.getTenantId(), querySpecialListBySpaceInputBO.getLanguageCode(), querySpecialListBySpaceInputBO.getProjectId());
            if (!CollectionUtils.isEmpty((Collection)spaceList)) {
                for (SpecialWorksheetOutputDTO dto : worksheetList) {
                    for (ProjectSpacePathDTO spacePathDTO : spaceList) {
                        if (!StringUtils.isEquals((String)dto.getSpaceId(), (String)spacePathDTO.getId())) continue;
                        dto.setSpaceName(spacePathDTO.getNameStr());
                    }
                }
            }
        }
        IFWPageInfo pageResult = new IFWPageInfo();
        pageResult.setTotal(pageInfo.getTotal());
        pageResult.setPageNum(pageInfo.getPageNum());
        pageResult.setPageSize(pageInfo.getPageSize());
        pageResult.setList(worksheetList);
        BaseResponse response = BaseResponseUtils.getSuccessResponse((Object)pageResult, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    public BaseResponse<List<ScanDetailInfoOutputDTO>> getScanInfoByWorksheetId(IFWUser ifwUser, WorksheetDetailQueryInputBO worksheetDetailQueryInputBO) {
        if (StringUtils.isBlank((String)worksheetDetailQueryInputBO.getTenantId())) {
            worksheetDetailQueryInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)worksheetDetailQueryInputBO.getTenantId());
        }
        if (StringUtils.isBlank((String)worksheetDetailQueryInputBO.getTaskWorksheetId())) {
            throw new BizException(PlatformCodeEnum.TASK_WORKSHEET_ID_CANNOT_NULL.getDesc(), PlatformCodeEnum.TASK_WORKSHEET_ID_CANNOT_NULL.getCode());
        }
        IFWValidator.validate((Object)worksheetDetailQueryInputBO);
        List scanDetailInfoList = this.worksheetRepository.getScanInfoByWorksheetId(worksheetDetailQueryInputBO);
        if (!CollectionUtils.isEmpty((Collection)scanDetailInfoList)) {
            List userDetailInfoList;
            List userIdList;
            List list;
            List checkpointIdList = scanDetailInfoList.stream().map(ScanDetailInfoOutputBO::getCheckPointId).collect(Collectors.toList());
            QueryCheckPointListQueryInputBO queryCheckPointListQueryInputBO = new QueryCheckPointListQueryInputBO();
            queryCheckPointListQueryInputBO.setCheckPointId(checkpointIdList);
            queryCheckPointListQueryInputBO.setTenantId(worksheetDetailQueryInputBO.getTenantId());
            queryCheckPointListQueryInputBO.setProjectId(worksheetDetailQueryInputBO.getProjectId());
            queryCheckPointListQueryInputBO.setLanguageCode(worksheetDetailQueryInputBO.getLanguageCode());
            IFWPageInfo checkpointPageInfo = this.configRepository.getCheckpointList(queryCheckPointListQueryInputBO);
            if (checkpointPageInfo != null && !CollectionUtils.isEmpty((Collection)(list = checkpointPageInfo.getList()))) {
                for (ScanDetailInfoOutputBO bo : scanDetailInfoList) {
                    for (QueryCheckPointListOutputBO queryCheckPointListOutputBO : list) {
                        if (!StringUtils.isEquals((String)bo.getCheckPointId(), (String)queryCheckPointListOutputBO.getCheckPointId())) continue;
                        bo.setCheckPointName(queryCheckPointListOutputBO.getCheckPointName());
                        bo.setAssetEnableCheckMeter(queryCheckPointListOutputBO.getAssetEnableCheckMeter());
                    }
                }
            }
            if (!CollectionUtils.isEmpty(userIdList = scanDetailInfoList.stream().filter(item -> !CollectionUtils.isEmpty((Collection)item.getSimpleInfoList())).map(ScanDetailInfoOutputBO::getSimpleInfoList).flatMap(Collection::stream).map(ScanSimpleInfoOutputBO::getCreateBy).distinct().collect(Collectors.toList())) && !CollectionUtils.isEmpty((Collection)(userDetailInfoList = this.organizationRepository.queryUserDetailByUserId(userIdList, worksheetDetailQueryInputBO.getTenantId(), worksheetDetailQueryInputBO.getLanguageCode())))) {
                for (ScanDetailInfoOutputBO bo : scanDetailInfoList) {
                    List simpleInfoList = bo.getSimpleInfoList();
                    if (CollectionUtils.isEmpty((Collection)simpleInfoList)) continue;
                    for (ScanSimpleInfoOutputBO scanSimpleInfoOutputBO : simpleInfoList) {
                        for (UserDeatilInfoOutputBO userDeatilInfoOutputBO : userDetailInfoList) {
                            if (!StringUtils.isEquals((String)scanSimpleInfoOutputBO.getCreateBy(), (String)userDeatilInfoOutputBO.getUserId())) continue;
                            scanSimpleInfoOutputBO.setCreateName(userDeatilInfoOutputBO.getRealName());
                        }
                    }
                }
            }
        }
        BaseResponse response = BaseResponseUtils.getSuccessResponse((Object)IFWBeanCopyUtil.mapAsList((Iterable)scanDetailInfoList, ScanDetailInfoOutputDTO.class), (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    public BaseResponse hangUpWorksheet(IFWUser ifwUser, HangUpWorksheetInputBO hangUpWorksheetInputBO) {
        BaseResponse response;
        try {
            if (StringUtils.isBlank((String)hangUpWorksheetInputBO.getTenantId())) {
                hangUpWorksheetInputBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)hangUpWorksheetInputBO.getTenantId());
            }
            hangUpWorksheetInputBO.setCreateBy(ifwUser.getUserId());
            if (ifwUser.getPositions() != null) {
                hangUpWorksheetInputBO.setSubjectPermissionPositionIdList(ifwUser.getPositions().stream().map(IFWPosition::getPositionId).collect(Collectors.toList()));
            }
            IFWValidator.validate((Object)hangUpWorksheetInputBO);
            this.worksheetRepository.hangUpWorksheet(hangUpWorksheetInputBO);
            response = BaseResponseUtils.getSuccessResponse(null, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    public BaseResponse<List<DailyTaskWorkSheetListOutputDTO>> patrolOnLine(IFWUser ifwUser, PatrolInputBO patrolInputBO) {
        BaseResponse response;
        try {
            List checkpointIdList;
            if (StringUtils.isBlank((String)patrolInputBO.getTenantId())) {
                patrolInputBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)patrolInputBO.getTenantId());
            }
            IFWValidator.validate((Object)patrolInputBO);
            List<Object> positionIdList = new ArrayList();
            if (ifwUser.getPositions() != null && ifwUser.getPositions().size() > 0) {
                positionIdList = ifwUser.getPositions().stream().map(IFWPosition::getPositionId).collect(Collectors.toList());
            }
            List result = new ArrayList();
            List<Object> deptIdList = new ArrayList();
            ContactQueryInputBO contactQueryInputBO = new ContactQueryInputBO();
            contactQueryInputBO.setTenantId(patrolInputBO.getTenantId());
            contactQueryInputBO.setProjectId(patrolInputBO.getProjectId());
            contactQueryInputBO.setLanguageCode(patrolInputBO.getLanguageCode());
            List allDeptIdList = this.organizationRepository.getDeptIdList(contactQueryInputBO);
            if (!CollectionUtils.isEmpty((Collection)allDeptIdList)) {
                List collect;
                ArrayList<String> userIdList = new ArrayList<String>();
                userIdList.add(ifwUser.getUserId());
                List userDeatilInfoOutputBOList = this.organizationRepository.queryUserDetailByUserId(userIdList, patrolInputBO.getTenantId(), patrolInputBO.getLanguageCode());
                if (!CollectionUtils.isEmpty((Collection)userDeatilInfoOutputBOList) && !CollectionUtils.isEmpty(collect = userDeatilInfoOutputBOList.stream().filter(item -> !CollectionUtils.isEmpty((Collection)item.getList())).map(UserDeatilInfoOutputBO::getList).flatMap(Collection::stream).map(UserDeptBO::getDeptId).collect(Collectors.toList()))) {
                    collect.retainAll(allDeptIdList);
                    deptIdList = collect;
                }
            }
            if (CollectionUtils.isEmpty(deptIdList)) {
                return BaseResponseUtils.getSuccessResponse(null, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
            }
            ScanQueryInputBO scanQueryInputBO = new ScanQueryInputBO();
            scanQueryInputBO.setDeptIds(deptIdList);
            scanQueryInputBO.setProjectId(patrolInputBO.getProjectId());
            scanQueryInputBO.setLanguageCode(patrolInputBO.getLanguageCode());
            scanQueryInputBO.setBindingDeviceId(patrolInputBO.getMacAddress());
            scanQueryInputBO.setTenantId(patrolInputBO.getTenantId());
            List checkPointIdListByScanList = this.worksheetRepository.getCheckPointIdListByScan(scanQueryInputBO);
            if (!CollectionUtils.isEmpty((Collection)checkPointIdListByScanList) && !CollectionUtils.isEmpty(checkpointIdList = checkPointIdListByScanList.stream().map(QueryCheckPointByDeptDTO::getCheckpointId).distinct().collect(Collectors.toList()))) {
                WorksheetScanQueryInputBO worksheetScanQueryInputBO = new WorksheetScanQueryInputBO();
                worksheetScanQueryInputBO.setCheckpointIdList(checkpointIdList);
                worksheetScanQueryInputBO.setProjectId(scanQueryInputBO.getProjectId());
                worksheetScanQueryInputBO.setTenantId(scanQueryInputBO.getTenantId());
                worksheetScanQueryInputBO.setUserId(ifwUser.getUserId());
                worksheetScanQueryInputBO.setPermissionSubjectPositionIdList(positionIdList);
                IFWValidator.validate((Object)worksheetScanQueryInputBO);
                List worksheetList = this.taskRepository.getTaskListByCheckpointId(worksheetScanQueryInputBO);
                ArrayList<DailyTaskWorkSheetListOutputBO> resultList = new ArrayList<DailyTaskWorkSheetListOutputBO>();
                if (!CollectionUtils.isEmpty((Collection)worksheetList)) {
                    for (DailyTaskWorkSheetListOutputBO bo : worksheetList) {
                        List taskCheckPointRelationList = bo.getTaskCheckPointRelationList();
                        if (!CollectionUtils.isEmpty((Collection)taskCheckPointRelationList)) {
                            block4: for (TaskCheckPointRelationInsertBO taskCheckPointRelationInsertBO : taskCheckPointRelationList) {
                                for (QueryCheckPointByDeptDTO queryCheckPointByDeptDTO : checkPointIdListByScanList) {
                                    if (!StringUtils.isEquals((String)taskCheckPointRelationInsertBO.getCheckPointId(), (String)queryCheckPointByDeptDTO.getCheckpointId())) continue;
                                    taskCheckPointRelationInsertBO.setCheckPointName(queryCheckPointByDeptDTO.getCheckpointName());
                                    continue block4;
                                }
                            }
                        }
                        resultList.add(bo);
                    }
                }
                result = IFWBeanCopyUtil.mapAsList(resultList, DailyTaskWorkSheetListOutputDTO.class);
            }
            response = BaseResponseUtils.getSuccessResponse(result, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    public BaseResponse<PatrolCheckResultOutputDTO> patrolOnLineCheckPatrol(IFWUser ifwUser, PatrolCheckInputBO patrolCheckInputBO) {
        BaseResponse response;
        try {
            if (StringUtils.isBlank((String)patrolCheckInputBO.getTenantId())) {
                patrolCheckInputBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)patrolCheckInputBO.getTenantId());
            }
            IFWValidator.validate((Object)patrolCheckInputBO);
            PatrolCheckResultOutputDTO patrolCheckResultDTO = this.worksheetRepository.patrolOnLineCheckPatrol(patrolCheckInputBO);
            response = BaseResponseUtils.getSuccessResponse((Object)patrolCheckResultDTO, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    public BaseResponse<Object> repairWorksheetStatusKafka(IFWUser ifwUser, BaseReqDTO baseReqDTO) {
        BaseResponse response;
        try {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)baseReqDTO.getTenantId());
            this.worksheetRepository.repairWorksheetStatusKafka();
            response = BaseResponseUtils.getSuccessResponse(null, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }
}

