/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.tracker.service.impl;

import com.ifourthwall.common.PlatformCodeEnum;
import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWPageInfo;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.common.utils.IFWBeanCopyUtil;
import com.ifourthwall.common.utils.IFWValidator;
import com.ifourthwall.dbm.tracker.bo.CheckpointScanResultOutputBO;
import com.ifourthwall.dbm.tracker.bo.QueryCheckPointListOutputBO;
import com.ifourthwall.dbm.tracker.bo.QueryCheckPointListQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.QueryScanResultByCheckpointIdInputBO;
import com.ifourthwall.dbm.tracker.bo.UserDeatilInfoOutputBO;
import com.ifourthwall.dbm.tracker.bo.UserDeptBO;
import com.ifourthwall.dbm.tracker.bo.WorksheetEventDetailQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.WorksheetEventWrapOutputBO;
import com.ifourthwall.dbm.tracker.config.TranslationBean;
import com.ifourthwall.dbm.tracker.config.TranslationConfig;
import com.ifourthwall.dbm.tracker.domain.ConfigRepository;
import com.ifourthwall.dbm.tracker.domain.OrganizationRepository;
import com.ifourthwall.dbm.tracker.domain.WorksheetEventRepository;
import com.ifourthwall.dbm.tracker.dto.CheckpointScanResultOutputDTO;
import com.ifourthwall.dbm.tracker.dto.TaskWorksheetOutputDTO;
import com.ifourthwall.dbm.tracker.dto.WorksheetEventWrapOutputDTO;
import com.ifourthwall.dbm.tracker.service.WorksheetEventService;
import com.ifourthwall.dbm.tracker.utils.BaseResponseUtils;
import com.ifourthwall.dbm.tracker.utils.CheckAccessUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="worksheetEventServiceImpl")
public class WorksheetEventServiceImpl
implements WorksheetEventService {
    @Resource(name="worksheetEventRepository")
    WorksheetEventRepository worksheetEventRepository;
    @Resource(name="organizationRepository")
    OrganizationRepository organizationRepository;
    @Resource(name="configRepository")
    ConfigRepository configRepository;
    @Autowired
    private TranslationConfig translationConfig;

    public BaseResponse<WorksheetEventWrapOutputDTO> getWorksheetEventDetail(IFWUser ifwUser, WorksheetEventDetailQueryInputBO worksheetEventDetailQueryInputBO) {
        if (StringUtils.isBlank((String)worksheetEventDetailQueryInputBO.getTenantId())) {
            worksheetEventDetailQueryInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)worksheetEventDetailQueryInputBO.getTenantId());
        }
        IFWValidator.validate((Object)worksheetEventDetailQueryInputBO);
        WorksheetEventWrapOutputBO worksheetEventDetail = this.worksheetEventRepository.getWorksheetEventDetail(worksheetEventDetailQueryInputBO);
        WorksheetEventWrapOutputDTO worksheetEventWrapOutputDTO = (WorksheetEventWrapOutputDTO)IFWBeanCopyUtil.map((Object)worksheetEventDetail, WorksheetEventWrapOutputDTO.class);
        BaseResponse response = BaseResponseUtils.getSuccessResponse((Object)worksheetEventWrapOutputDTO, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    public BaseResponse<IFWPageInfo<CheckpointScanResultOutputDTO>> getScanInfoByCheckpoint(IFWUser ifwUser, QueryScanResultByCheckpointIdInputBO queryScanResultByCheckpointIdInputBO) {
        BaseResponse response;
        try {
            List collect;
            if (StringUtils.isBlank((String)queryScanResultByCheckpointIdInputBO.getTenantId())) {
                queryScanResultByCheckpointIdInputBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)queryScanResultByCheckpointIdInputBO.getTenantId());
            }
            IFWValidator.validate((Object)queryScanResultByCheckpointIdInputBO);
            IFWPageInfo data = this.worksheetEventRepository.getScanInfoByCheckpoint(queryScanResultByCheckpointIdInputBO);
            List list = data.getList();
            if (list != null && !list.isEmpty() && (collect = list.stream().map(CheckpointScanResultOutputBO::getCreateBy).collect(Collectors.toList())) != null && !collect.isEmpty()) {
                QueryCheckPointListQueryInputBO queryCheckPointListQueryInputBO = new QueryCheckPointListQueryInputBO();
                queryCheckPointListQueryInputBO.setProjectId(queryScanResultByCheckpointIdInputBO.getProjectId());
                queryCheckPointListQueryInputBO.setTenantId(queryScanResultByCheckpointIdInputBO.getTenantId());
                queryCheckPointListQueryInputBO.setLanguageCode(queryScanResultByCheckpointIdInputBO.getLanguageCode());
                ArrayList<String> checkpointIdList = new ArrayList<String>();
                checkpointIdList.add(queryScanResultByCheckpointIdInputBO.getCheckpointId());
                queryCheckPointListQueryInputBO.setCheckPointId(checkpointIdList);
                IFWPageInfo checkpointPageInfo = this.configRepository.getCheckpointList(queryCheckPointListQueryInputBO);
                List checkpointNameList = checkpointPageInfo.getList();
                String checkpointName = null;
                if (checkpointNameList != null && !checkpointNameList.isEmpty()) {
                    checkpointName = ((QueryCheckPointListOutputBO)checkpointNameList.get(0)).getCheckPointName();
                }
                List userDeatilInfoOutputBOS = this.organizationRepository.queryUserDetailByUserId(collect, queryScanResultByCheckpointIdInputBO.getTenantId(), queryScanResultByCheckpointIdInputBO.getLanguageCode());
                for (CheckpointScanResultOutputBO bo : list) {
                    bo.setCheckpointName(checkpointName);
                    for (UserDeatilInfoOutputBO userBO : userDeatilInfoOutputBOS) {
                        if (!StringUtils.isEquals((String)bo.getCreateBy(), (String)userBO.getUserId())) continue;
                        bo.setCreateName(userBO.getRealName());
                        if (userBO.getList() != null && !userBO.getList().isEmpty()) {
                            bo.setDeptName(StringUtils.join((Collection)userBO.getList().stream().map(UserDeptBO::getDeptName).collect(Collectors.toList()), (String)","));
                            continue;
                        }
                        bo.setDeptName("");
                    }
                }
            }
            IFWPageInfo result = new IFWPageInfo();
            if (data != null) {
                result.setTotal(data.getTotal());
                result.setPageNum(data.getPageNum());
                result.setPageSize(data.getPageSize());
                if (list != null) {
                    result.setList(IFWBeanCopyUtil.mapAsList((Iterable)list, CheckpointScanResultOutputDTO.class));
                }
            }
            response = BaseResponseUtils.getSuccessResponse((Object)result, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    public BaseResponse<Workbook> exportScanInfoByCheckpoint(IFWUser ifwUser, QueryScanResultByCheckpointIdInputBO queryScanResultByCheckpointIdInputBO) {
        BaseResponse response;
        try {
            if (StringUtils.isBlank((String)queryScanResultByCheckpointIdInputBO.getTenantId())) {
                queryScanResultByCheckpointIdInputBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)queryScanResultByCheckpointIdInputBO.getTenantId());
            }
            BaseResponse data = this.getScanInfoByCheckpoint(ifwUser, queryScanResultByCheckpointIdInputBO);
            IFWPageInfo pageInfo = (IFWPageInfo)data.getData();
            List list = pageInfo.getList();
            TranslationBean translationBean = StringUtils.isEquals((String)queryScanResultByCheckpointIdInputBO.getLanguageCode(), (String)"CN") ? (TranslationBean)this.translationConfig.getList().get(0) : (StringUtils.isEquals((String)queryScanResultByCheckpointIdInputBO.getLanguageCode(), (String)"JP") ? (TranslationBean)this.translationConfig.getList().get(2) : (TranslationBean)this.translationConfig.getList().get(1));
            HSSFWorkbook sheets = new HSSFWorkbook();
            Sheet sheet = sheets.createSheet(translationBean.getCheckpointPatrolInfo());
            int rowNum = 0;
            int cellNum = 0;
            Row row = sheet.createRow(rowNum++);
            row.createCell(cellNum++).setCellValue(translationBean.getCheckpointName());
            row.createCell(cellNum++).setCellValue(translationBean.getPatrolMan());
            row.createCell(cellNum++).setCellValue(translationBean.getPatrolDept());
            row.createCell(cellNum++).setCellValue(translationBean.getPatrolDate());
            row.createCell(cellNum++).setCellValue(translationBean.getIsFault());
            row.createCell(cellNum++).setCellValue(translationBean.getRelationWorksheetNo());
            if (list != null && !list.isEmpty()) {
                for (CheckpointScanResultOutputDTO dto : list) {
                    row = sheet.createRow(rowNum++);
                    cellNum = 0;
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    row.createCell(cellNum++).setCellValue(dto.getCheckpointName() != null ? dto.getCheckpointName() : "");
                    row.createCell(cellNum++).setCellValue(dto.getCreateName());
                    row.createCell(cellNum++).setCellValue(dto.getDeptName());
                    row.createCell(cellNum++).setCellValue(sdf.format(dto.getCreateTime()));
                    List taskWorksheetList = dto.getTaskWorksheetList();
                    if (taskWorksheetList != null && !taskWorksheetList.isEmpty()) {
                        row.createCell(cellNum++).setCellValue(translationBean.getYes());
                        row.createCell(cellNum++).setCellValue(StringUtils.join((Collection)taskWorksheetList.stream().map(TaskWorksheetOutputDTO::getWorksheetNo).collect(Collectors.toList()), (String)","));
                        continue;
                    }
                    row.createCell(cellNum++).setCellValue(translationBean.getNo());
                    row.createCell(cellNum++).setCellValue("");
                }
            }
            response = BaseResponseUtils.getSuccessResponse((Object)sheets, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }
}

