/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.tracker.service.impl;

import com.ifourthwall.common.cache.RedisKeyPrefixUtil;
import com.ifourthwall.common.utils.JSONUtils;
import com.ifourthwall.dbm.project.dto.ProjectSpaceBaseDTO;
import com.ifourthwall.dbm.project.dto.QuerySpaceInfoQueryDTO;
import com.ifourthwall.dbm.tracker.bo.SpaceSpecialWorksheetNumBO;
import com.ifourthwall.dbm.tracker.domain.ConfigRepository;
import com.ifourthwall.kafka.DataHandler;
import com.ifourthwall.kafka.IFWKafkaClient;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class UpdateSpaceWorksheetDataHandler
implements DataHandler {
    private static final Logger log = LoggerFactory.getLogger(UpdateSpaceWorksheetDataHandler.class);
    @Autowired
    RedisTemplate redisTemplate;
    @Resource(name="configRepository")
    ConfigRepository configRepository;
    @Resource(name="IFWKafkaClient-dbm_tracker_update_space_special_worksheet_num")
    private IFWKafkaClient updateSpaceWorksheetKafkaClient;

    public void handle(String jsonStrData) {
        String parentProjectSpaceId;
        log.info("UpdateSpaceWorksheetDataHandler\u63a5\u53d7\u5230kafka\u4f20\u53c2\uff1a" + jsonStrData);
        SpaceSpecialWorksheetNumBO spaceSpecialWorksheetNumBO = (SpaceSpecialWorksheetNumBO)JSONUtils.jacksonFromJson((String)jsonStrData, SpaceSpecialWorksheetNumBO.class);
        String spaceId = spaceSpecialWorksheetNumBO.getSpaceId();
        if (spaceSpecialWorksheetNumBO.getType() == 0) {
            if (this.redisTemplate.hasKey((Object)RedisKeyPrefixUtil.getTrackerUpdateSpaceSpecialWorksheetPrefix((String)spaceId)).booleanValue()) {
                this.redisTemplate.opsForValue().increment((Object)RedisKeyPrefixUtil.getTrackerUpdateSpaceSpecialWorksheetPrefix((String)spaceId), 1L);
            } else {
                this.redisTemplate.opsForValue().set((Object)RedisKeyPrefixUtil.getTrackerUpdateSpaceSpecialWorksheetPrefix((String)spaceId), (Object)1);
            }
        } else if (this.redisTemplate.hasKey((Object)RedisKeyPrefixUtil.getTrackerUpdateSpaceSpecialWorksheetPrefix((String)spaceId)).booleanValue()) {
            int num = (Integer)this.redisTemplate.opsForValue().get((Object)RedisKeyPrefixUtil.getTrackerUpdateSpaceSpecialWorksheetPrefix((String)spaceId));
            if (num > 0) {
                this.redisTemplate.opsForValue().decrement((Object)RedisKeyPrefixUtil.getTrackerUpdateSpaceSpecialWorksheetPrefix((String)spaceId), 1L);
            }
        } else {
            log.info("UpdateSpaceWorksheetDataHandler\u7279\u6b8a\u5de5\u5355\u51cf1\u5f02\u5e38\uff1a" + jsonStrData);
        }
        QuerySpaceInfoQueryDTO dto = new QuerySpaceInfoQueryDTO();
        dto.setSpcaeId(spaceId);
        dto.setLanguageCode("CN");
        ProjectSpaceBaseDTO projectSpaceBaseDTO = this.configRepository.querySpaceInfo(dto);
        if (projectSpaceBaseDTO != null && (parentProjectSpaceId = projectSpaceBaseDTO.getParentProjectSpaceId()) != null) {
            this.updateWorksheetConstantToKafka(parentProjectSpaceId, spaceSpecialWorksheetNumBO.getType().intValue());
        }
    }

    public void updateWorksheetConstantToKafka(String spaceId, int type) {
        SpaceSpecialWorksheetNumBO bo = new SpaceSpecialWorksheetNumBO();
        bo.setSpaceId(spaceId);
        bo.setType(Integer.valueOf(type));
        this.updateSpaceWorksheetKafkaClient.syncProduce(JSONUtils.jacksonToJson((Object)bo));
        log.info("\u66f4\u65b0\u7a7a\u95f4\u5bf9\u5e94\u7279\u6b8a\u5de5\u5355\u6570\u91cf\u5230kafka:" + bo.toString());
    }

    public boolean judge(String topic) {
        return StringUtils.equals((CharSequence)topic, (CharSequence)"dbm_tracker_update_space_special_worksheet_num");
    }
}

