/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.tracker.service.impl;

import com.ifourthwall.common.utils.IFWUUIDUtils;
import com.ifourthwall.dbm.tracker.bo.TransferTaskBO;
import com.ifourthwall.dbm.tracker.bo.TransferTaskSpaceBO;
import com.ifourthwall.dbm.tracker.bo.TransferWorksheetBO;
import com.ifourthwall.dbm.tracker.bo.TransferWorksheetEventBO;
import com.ifourthwall.dbm.tracker.bo.TransferWorksheetExecutorBO;
import com.ifourthwall.dbm.tracker.bo.TransferWrapWorksheet;
import com.ifourthwall.dbm.tracker.domain.OrganizationRepository;
import com.ifourthwall.dbm.tracker.domain.TransferRepository;
import com.ifourthwall.dbm.tracker.dto.TransferWorksheetInputDTO;
import com.ifourthwall.dbm.tracker.service.TransferService;
import com.ifourthwall.dbm.tracker.utils.DataUtils;
import com.ifourthwall.dbm.tracker.utils.DateUtils;
import com.ifourthwall.dbm.tracker.utils.ExcelUtils;
import com.ifourthwall.dbm.user.dto.QuUserAndPositionIdReqDTO;
import com.ifourthwall.dbm.user.dto.QuUserAndPositionIdResDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

@Service(value="transferServiceImpl")
public class TransferServiceImpl
implements TransferService {
    @Resource(name="organizationRepository")
    OrganizationRepository organizationRepository;
    @Resource(name="transferRepository")
    TransferRepository transferRepository;

    public void transferWorksheet(MultipartFile file, TransferWorksheetInputDTO transferWorksheetInputDTO) {
        HashMap<String, QuUserAndPositionIdResDTO> map = new HashMap<String, QuUserAndPositionIdResDTO>();
        List list = ExcelUtils.importTaskTransferExcel((MultipartFile)file);
        ArrayList<TransferTaskBO> transferTaskBOList = new ArrayList<TransferTaskBO>();
        ArrayList<TransferTaskSpaceBO> transferTaskSpaceBOList = new ArrayList<TransferTaskSpaceBO>();
        ArrayList<TransferWorksheetBO> transferWorksheetBOList = new ArrayList<TransferWorksheetBO>();
        ArrayList<TransferWorksheetExecutorBO> transferWorksheetExecutorBOList = new ArrayList<TransferWorksheetExecutorBO>();
        ArrayList<TransferWorksheetEventBO> transferWorksheetEventBOList = new ArrayList<TransferWorksheetEventBO>();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (Object[] obj : list) {
                QuUserAndPositionIdResDTO updateQuUserAndPositionIdResDTO;
                QuUserAndPositionIdResDTO createQuUserAndPositionIdResDTO;
                String sId;
                String createTime = obj[0].toString();
                String createName = obj[1].toString();
                String updateTime = obj[2].toString();
                String updateName = obj[3].toString();
                String taskDesc = obj[4].toString();
                String taskName = obj[5].toString();
                String spaceId = obj.length >= 7 ? (StringUtils.isBlank((CharSequence)(sId = obj[6].toString())) ? transferWorksheetInputDTO.getDefaultSpaceId() : sId) : transferWorksheetInputDTO.getDefaultSpaceId();
                if (map.containsKey(createName)) {
                    createQuUserAndPositionIdResDTO = (QuUserAndPositionIdResDTO)map.get(createName);
                } else {
                    createQuUserAndPositionIdResDTO = this.selectUserIdAndPositionId(createName, transferWorksheetInputDTO);
                    map.put(createName, createQuUserAndPositionIdResDTO);
                }
                if (map.containsKey(updateName)) {
                    updateQuUserAndPositionIdResDTO = (QuUserAndPositionIdResDTO)map.get(updateName);
                } else {
                    updateQuUserAndPositionIdResDTO = this.selectUserIdAndPositionId(updateName, transferWorksheetInputDTO);
                    map.put(updateName, updateQuUserAndPositionIdResDTO);
                }
                Date createDate = DateUtils.convertStringToDate((String)createTime);
                Date updateDate = !StringUtils.isBlank((CharSequence)updateTime) ? DateUtils.convertStringToDate((String)updateTime) : null;
                if (DateUtils.getDiffHour((Date)createDate, (Date)updateDate) >= 50) {
                    updateDate = DateUtils.addTimeToDate((Date)createDate, (long)180000000L);
                }
                TransferTaskBO transferTaskBO = new TransferTaskBO();
                String taskId = IFWUUIDUtils.randomUUID();
                transferTaskBO.setTenantId(transferWorksheetInputDTO.getTenantId());
                transferTaskBO.setProjectId(transferWorksheetInputDTO.getProjectId());
                transferTaskBO.setTaskId(taskId);
                transferTaskBO.setCreateTime(createDate);
                transferTaskBO.setCreateBy(createQuUserAndPositionIdResDTO.getUserId());
                transferTaskBO.setTaskTypeId("1");
                transferTaskBO.setValid("0");
                transferTaskBO.setCreateByPositionId((String)createQuUserAndPositionIdResDTO.getPositionIds().get(0));
                transferTaskBO.setTaskTemplateId(transferWorksheetInputDTO.getTaskTemplateId());
                transferTaskBO.setTaskDescription(taskDesc);
                transferTaskBO.setTaskName(taskName);
                transferTaskBOList.add(transferTaskBO);
                TransferTaskSpaceBO transferTaskSpaceBO = new TransferTaskSpaceBO();
                transferTaskSpaceBO.setTaskId(taskId);
                transferTaskSpaceBO.setTaskSpaceDescription("");
                transferTaskSpaceBO.setCreateTime(createDate);
                transferTaskSpaceBO.setSpaceId(spaceId);
                transferTaskSpaceBO.setTenantId(transferWorksheetInputDTO.getTenantId());
                transferTaskSpaceBO.setCreateBy(createQuUserAndPositionIdResDTO.getUserId());
                transferTaskSpaceBOList.add(transferTaskSpaceBO);
                TransferWorksheetBO transferWorksheetBO = new TransferWorksheetBO();
                String taskWorksheetId = IFWUUIDUtils.randomUUID();
                transferWorksheetBO.setTenantId(transferWorksheetInputDTO.getTenantId());
                transferWorksheetBO.setProjectId(transferWorksheetInputDTO.getProjectId());
                transferWorksheetBO.setCreateBy(createQuUserAndPositionIdResDTO.getUserId());
                transferWorksheetBO.setCreateTime(createDate);
                transferWorksheetBO.setTaskId(taskId);
                transferWorksheetBO.setValid("0");
                transferWorksheetBO.setTaskWorksheetId(taskWorksheetId);
                transferWorksheetBO.setUpdateBy(updateQuUserAndPositionIdResDTO.getUserId());
                transferWorksheetBO.setUpdateTime(updateDate);
                transferWorksheetBO.setWorksheetStatusId("6");
                transferWorksheetBO.setWorksheetNo(DataUtils.genUUID4Time((Date)createDate));
                transferWorksheetBOList.add(transferWorksheetBO);
                TransferWorksheetExecutorBO transferWorksheetExecutorBO = new TransferWorksheetExecutorBO();
                transferWorksheetExecutorBO.setExecutorUserId(updateQuUserAndPositionIdResDTO.getUserId());
                transferWorksheetExecutorBO.setExecutorPositionId((String)updateQuUserAndPositionIdResDTO.getPositionIds().get(0));
                transferWorksheetExecutorBO.setTaskWorksheetId(taskWorksheetId);
                transferWorksheetExecutorBO.setTenantId(transferWorksheetInputDTO.getTenantId());
                transferWorksheetExecutorBOList.add(transferWorksheetExecutorBO);
                TransferWorksheetEventBO createEvent = new TransferWorksheetEventBO();
                createEvent.setCreateBy(createQuUserAndPositionIdResDTO.getUserId());
                createEvent.setCreateTime(createDate);
                createEvent.setProjectId(transferWorksheetInputDTO.getProjectId());
                createEvent.setTenantId(transferWorksheetInputDTO.getTenantId());
                createEvent.setWorksheetId(taskWorksheetId);
                createEvent.setWorksheetEventId(IFWUUIDUtils.randomUUID());
                createEvent.setTaskOperationId("1");
                transferWorksheetEventBOList.add(createEvent);
                TransferWorksheetEventBO finishEvent = new TransferWorksheetEventBO();
                finishEvent.setCreateBy(updateQuUserAndPositionIdResDTO.getUserId());
                finishEvent.setCreateTime(updateDate);
                finishEvent.setProjectId(transferWorksheetInputDTO.getProjectId());
                finishEvent.setTenantId(transferWorksheetInputDTO.getTenantId());
                finishEvent.setWorksheetId(taskWorksheetId);
                finishEvent.setTaskOperationId("8");
                transferWorksheetEventBOList.add(finishEvent);
                TransferWorksheetEventBO feedBackEvent = new TransferWorksheetEventBO();
                feedBackEvent.setCreateBy(updateQuUserAndPositionIdResDTO.getUserId());
                feedBackEvent.setCreateTime(DateUtils.addTimeToDate((Date)updateDate, (long)1000L));
                feedBackEvent.setProjectId(transferWorksheetInputDTO.getProjectId());
                feedBackEvent.setTenantId(transferWorksheetInputDTO.getTenantId());
                feedBackEvent.setWorksheetId(taskWorksheetId);
                feedBackEvent.setTaskOperationId("11");
                transferWorksheetEventBOList.add(feedBackEvent);
            }
        }
        TransferWrapWorksheet transferWrapWorksheet = new TransferWrapWorksheet();
        transferWrapWorksheet.setTransferTaskBOList(transferTaskBOList);
        transferWrapWorksheet.setTransferTaskSpaceBOList(transferTaskSpaceBOList);
        transferWrapWorksheet.setTransferWorksheetBOList(transferWorksheetBOList);
        transferWrapWorksheet.setTransferWorksheetEventBOList(transferWorksheetEventBOList);
        transferWrapWorksheet.setTransferWorksheetExecutorBOList(transferWorksheetExecutorBOList);
        this.transferRepository.transferWorksheet(transferWrapWorksheet);
    }

    public QuUserAndPositionIdResDTO selectUserIdAndPositionId(String userName, TransferWorksheetInputDTO transferWorksheetInputDTO) {
        List positionIds;
        QuUserAndPositionIdReqDTO quUserAndPositionIdReqDTO = new QuUserAndPositionIdReqDTO();
        quUserAndPositionIdReqDTO.setTenantId(transferWorksheetInputDTO.getTenantId());
        quUserAndPositionIdReqDTO.setEmployeeName(userName);
        QuUserAndPositionIdResDTO quUserAndPositionIdResDTO = null;
        quUserAndPositionIdResDTO = this.organizationRepository.selectUserIdAndPositionId(quUserAndPositionIdReqDTO);
        if (quUserAndPositionIdResDTO == null) {
            quUserAndPositionIdResDTO = new QuUserAndPositionIdResDTO();
            quUserAndPositionIdResDTO.setUserId(transferWorksheetInputDTO.getDefaultUserId());
            ArrayList<String> positionIdList = new ArrayList<String>();
            positionIdList.add(transferWorksheetInputDTO.getDefaultPositionId());
            quUserAndPositionIdResDTO.setPositionIds(positionIdList);
        }
        if (CollectionUtils.isEmpty((Collection)(positionIds = quUserAndPositionIdResDTO.getPositionIds()))) {
            ArrayList<String> positionIdList = new ArrayList<String>();
            positionIdList.add(transferWorksheetInputDTO.getDefaultPositionId());
            quUserAndPositionIdResDTO.setPositionIds(positionIdList);
        }
        return quUserAndPositionIdResDTO;
    }
}

