/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.tracker.service.impl;

import com.ifourthwall.common.PlatformCodeEnum;
import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWPageInfo;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.common.utils.IFWBeanCopyUtil;
import com.ifourthwall.common.utils.IFWValidator;
import com.ifourthwall.dbm.project.dto.project.QueryListByIdsDTO;
import com.ifourthwall.dbm.project.dto.project.QueryListByIdsQuDTO;
import com.ifourthwall.dbm.tracker.bo.ThirdBindPushQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.ThirdPushBindInsertInputBO;
import com.ifourthwall.dbm.tracker.bo.ThirdPushBindUpdateInputBO;
import com.ifourthwall.dbm.tracker.bo.ThirdPushRecordQueryInputBO;
import com.ifourthwall.dbm.tracker.domain.GodzillaRepository;
import com.ifourthwall.dbm.tracker.domain.OrganizationRepository;
import com.ifourthwall.dbm.tracker.domain.ThirdBindPushRepository;
import com.ifourthwall.dbm.tracker.dto.ThirdPushBindOutputDTO;
import com.ifourthwall.dbm.tracker.dto.ThirdPushRecordOutputDTO;
import com.ifourthwall.dbm.tracker.dto.ThirdPushWorksheetDetailDTO;
import com.ifourthwall.dbm.tracker.service.ThirdBindPushService;
import com.ifourthwall.dbm.tracker.utils.BaseResponseUtils;
import com.ifourthwall.dbm.tracker.utils.CheckAccessUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="thirdBindPushServiceImpl")
public class ThirdBindPushServiceImpl
implements ThirdBindPushService {
    @Resource(name="thirdBindPushRepository")
    ThirdBindPushRepository thirdBindPushRepository;
    @Resource(name="godzillaRepository")
    GodzillaRepository godzillaRepository;
    @Resource(name="organizationRepository")
    OrganizationRepository organizationRepository;

    public BaseResponse<List<ThirdPushBindOutputDTO>> queryThirdPushBind(IFWUser ifwUser, ThirdBindPushQueryInputBO thirdBindPushQueryInputBO) {
        if (StringUtils.isBlank((String)thirdBindPushQueryInputBO.getTenantId())) {
            thirdBindPushQueryInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)thirdBindPushQueryInputBO.getTenantId());
        }
        IFWValidator.validate((Object)thirdBindPushQueryInputBO);
        List thirdPushBindOutputDTOS = this.thirdBindPushRepository.queryThirdPushBind(thirdBindPushQueryInputBO);
        BaseResponse response = BaseResponseUtils.getSuccessResponse((Object)thirdPushBindOutputDTOS, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    public BaseResponse createThirdPushBind(IFWUser ifwUser, ThirdPushBindInsertInputBO thirdPushBindInsertInputBO) {
        if (StringUtils.isBlank((String)thirdPushBindInsertInputBO.getTenantId())) {
            thirdPushBindInsertInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)thirdPushBindInsertInputBO.getTenantId());
        }
        thirdPushBindInsertInputBO.setCreateBy(ifwUser.getUserId());
        IFWValidator.validate((Object)thirdPushBindInsertInputBO);
        this.checkCallBackUrl(thirdPushBindInsertInputBO.getCallBackUrl(), thirdPushBindInsertInputBO.getToken(), thirdPushBindInsertInputBO.getTenantId(), thirdPushBindInsertInputBO.getLanguageCode());
        Object thirdPushBind = this.thirdBindPushRepository.createThirdPushBind(thirdPushBindInsertInputBO);
        BaseResponse response = BaseResponseUtils.getSuccessResponse((Object)thirdPushBind, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    public BaseResponse updateThirdPushBind(IFWUser ifwUser, ThirdPushBindUpdateInputBO thirdPushBindUpdateInputBO) {
        if (StringUtils.isBlank((String)thirdPushBindUpdateInputBO.getTenantId())) {
            thirdPushBindUpdateInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)thirdPushBindUpdateInputBO.getTenantId());
        }
        thirdPushBindUpdateInputBO.setUpdateBy(ifwUser.getUserId());
        IFWValidator.validate((Object)thirdPushBindUpdateInputBO);
        if (StringUtils.isBlank((String)thirdPushBindUpdateInputBO.getToken())) {
            thirdPushBindUpdateInputBO.setToken("");
        }
        this.checkCallBackUrl(thirdPushBindUpdateInputBO.getCallBackUrl(), thirdPushBindUpdateInputBO.getToken(), thirdPushBindUpdateInputBO.getTenantId(), thirdPushBindUpdateInputBO.getLanguageCode());
        Object o = this.thirdBindPushRepository.updateThirdPushBind(thirdPushBindUpdateInputBO);
        BaseResponse response = BaseResponseUtils.getSuccessResponse((Object)o, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    private void checkCallBackUrl(String url, String token, String tenantId, String languageCode) {
        ThirdPushBindOutputDTO thirdPushBindOutputDTO = new ThirdPushBindOutputDTO();
        thirdPushBindOutputDTO.setCallBackUrl(url);
        thirdPushBindOutputDTO.setToken(token);
        thirdPushBindOutputDTO.setLanguageCode(languageCode);
        thirdPushBindOutputDTO.setTenantId(tenantId);
        try {
            Map map = this.godzillaRepository.sendWorksheetMessageToThird(thirdPushBindOutputDTO, new ThirdPushWorksheetDetailDTO());
            if (map == null || !map.containsKey("flag")) {
                throw new BizException(PlatformCodeEnum.WORKSHEET_CALLBACK_FAILED.getDesc(), PlatformCodeEnum.WORKSHEET_CALLBACK_FAILED.getCode());
            }
            boolean bl = (Boolean)map.get("flag");
        }
        catch (Exception e) {
            throw new BizException(PlatformCodeEnum.WORKSHEET_CALLBACK_FAILED.getDesc(), PlatformCodeEnum.WORKSHEET_CALLBACK_FAILED.getCode());
        }
    }

    public BaseResponse deleteThirdPushBind(IFWUser ifwUser, ThirdBindPushQueryInputBO thirdBindPushQueryInputBO) {
        if (StringUtils.isBlank((String)thirdBindPushQueryInputBO.getTenantId())) {
            thirdBindPushQueryInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)thirdBindPushQueryInputBO.getTenantId());
        }
        IFWValidator.validate((Object)thirdBindPushQueryInputBO);
        this.thirdBindPushRepository.deleteThirdPushBind(thirdBindPushQueryInputBO);
        BaseResponse response = BaseResponseUtils.getSuccessResponse(null, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    public BaseResponse<IFWPageInfo<ThirdPushRecordOutputDTO>> queryRecordList(IFWUser ifwUser, ThirdPushRecordQueryInputBO thirdPushRecordQueryInputBO) {
        if (StringUtils.isBlank((String)thirdPushRecordQueryInputBO.getTenantId())) {
            thirdPushRecordQueryInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)thirdPushRecordQueryInputBO.getTenantId());
        }
        IFWValidator.validate((Object)thirdPushRecordQueryInputBO);
        IFWPageInfo pageInfo = this.thirdBindPushRepository.queryRecordList(thirdPushRecordQueryInputBO);
        List thirdPushRecordOutputDTOList = IFWBeanCopyUtil.mapAsList((Iterable)pageInfo.getList(), ThirdPushRecordOutputDTO.class);
        if (!CollectionUtils.isEmpty((Collection)thirdPushRecordOutputDTOList)) {
            List projectIdList = thirdPushRecordOutputDTOList.stream().map(ThirdPushRecordOutputDTO::getProjectId).distinct().collect(Collectors.toList());
            QueryListByIdsQuDTO queryListByIdsQuDTO = new QueryListByIdsQuDTO();
            queryListByIdsQuDTO.setProjectIds(projectIdList);
            queryListByIdsQuDTO.setTenantId(thirdPushRecordQueryInputBO.getTenantId());
            queryListByIdsQuDTO.setLanguageCode(thirdPushRecordQueryInputBO.getLanguageCode());
            List projectNameByList = this.organizationRepository.getProjectNameByList(queryListByIdsQuDTO);
            if (!CollectionUtils.isEmpty((Collection)projectNameByList)) {
                for (ThirdPushRecordOutputDTO dto : thirdPushRecordOutputDTOList) {
                    for (QueryListByIdsDTO queryListByIdsDTO : projectNameByList) {
                        if (!StringUtils.isEquals((String)dto.getProjectId(), (String)queryListByIdsDTO.getProjectId())) continue;
                        dto.setProjectName(queryListByIdsDTO.getProjectName());
                    }
                }
            }
        }
        IFWPageInfo result = new IFWPageInfo();
        result.setPageNum(pageInfo.getPageNum());
        result.setPageSize(pageInfo.getPageSize());
        result.setTotal(pageInfo.getTotal());
        result.setList(thirdPushRecordOutputDTOList);
        BaseResponse response = BaseResponseUtils.getSuccessResponse((Object)result, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }
}

