/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.tracker.service.impl;

import com.ifourthwall.common.PlatformCodeEnum;
import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWPosition;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.common.utils.IFWBeanCopyUtil;
import com.ifourthwall.common.utils.IFWValidator;
import com.ifourthwall.dbm.security.dto.task.QueryTemplateUseQuDTO;
import com.ifourthwall.dbm.tracker.bo.BaseInputBO;
import com.ifourthwall.dbm.tracker.bo.TaskTemplateInsertWrapInputBO;
import com.ifourthwall.dbm.tracker.bo.TaskTemplateListQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.TaskTemplatePermissionRelationQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.TaskTemplateTagInsertInputBO;
import com.ifourthwall.dbm.tracker.bo.TaskTemplateTagQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.TaskTemplateTagUpdateInputBO;
import com.ifourthwall.dbm.tracker.bo.TaskTemplateUpdateWrapInputBO;
import com.ifourthwall.dbm.tracker.bo.TaskTemplateWarpQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.TaskTemplateWrapOutputBO;
import com.ifourthwall.dbm.tracker.domain.OrganizationRepository;
import com.ifourthwall.dbm.tracker.domain.TaskTemplateRepository;
import com.ifourthwall.dbm.tracker.dto.PositionDTO;
import com.ifourthwall.dbm.tracker.dto.TaskTemplateOutputDTO;
import com.ifourthwall.dbm.tracker.dto.TaskTemplatePermissionOutputDTO;
import com.ifourthwall.dbm.tracker.dto.TaskTemplateTagOutputDTO;
import com.ifourthwall.dbm.tracker.dto.TaskTemplateWrapOutputDTO;
import com.ifourthwall.dbm.tracker.service.TaskTemplateService;
import com.ifourthwall.dbm.tracker.utils.BaseResponseUtils;
import com.ifourthwall.dbm.tracker.utils.CheckAccessUtils;
import com.ifourthwall.dbm.user.dto.QuDeptInfoDTO;
import com.ifourthwall.dbm.user.dto.QueryDeptInfosReqDTO;
import com.ifourthwall.dbm.user.dto.QueryPositionNameResDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="taskTemplateServiceImpl")
public class TaskTemplateServiceImpl
implements TaskTemplateService {
    @Resource(name="taskTemplateRepository")
    TaskTemplateRepository taskTemplateRepository;
    @Resource(name="organizationRepository")
    OrganizationRepository organizationRepository;

    public BaseResponse<Object> createTaskTemplateTag(IFWUser ifwUser, TaskTemplateTagInsertInputBO taskTemplateTagInsertInputBO) {
        if (StringUtils.isBlank((String)taskTemplateTagInsertInputBO.getTenantId())) {
            taskTemplateTagInsertInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)taskTemplateTagInsertInputBO.getTenantId());
        }
        taskTemplateTagInsertInputBO.setCreateBy(ifwUser.getUserId());
        IFWValidator.validate((Object)taskTemplateTagInsertInputBO);
        this.taskTemplateRepository.createTaskTemplateTag(taskTemplateTagInsertInputBO);
        BaseResponse response = BaseResponseUtils.getSuccessResponse(null, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    public BaseResponse<Object> updateTaskTemplateTag(IFWUser ifwUser, TaskTemplateTagUpdateInputBO taskTemplateTagUpdateInputBO) {
        if (StringUtils.isBlank((String)taskTemplateTagUpdateInputBO.getTenantId())) {
            taskTemplateTagUpdateInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)taskTemplateTagUpdateInputBO.getTenantId());
        }
        taskTemplateTagUpdateInputBO.setUpdateBy(ifwUser.getUserId());
        IFWValidator.validate((Object)taskTemplateTagUpdateInputBO);
        this.taskTemplateRepository.updateTaskTemplateTag(taskTemplateTagUpdateInputBO);
        BaseResponse response = BaseResponseUtils.getSuccessResponse(null, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    public BaseResponse<List<TaskTemplateTagOutputDTO>> getTaskTemplateTagList(IFWUser ifwUser, TaskTemplateTagQueryInputBO taskTemplateTagQueryInputBO) {
        if (StringUtils.isBlank((String)taskTemplateTagQueryInputBO.getTenantId())) {
            taskTemplateTagQueryInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)taskTemplateTagQueryInputBO.getTenantId());
        }
        IFWValidator.validate((Object)taskTemplateTagQueryInputBO);
        ArrayList taskTemplateTagList = new ArrayList();
        if (StringUtils.isBlank((String)taskTemplateTagQueryInputBO.getTaskTemplateId())) {
            taskTemplateTagList.addAll(this.taskTemplateRepository.getTaskTemplateTagList((BaseInputBO)IFWBeanCopyUtil.map((Object)taskTemplateTagQueryInputBO, BaseInputBO.class)));
        } else {
            taskTemplateTagList.addAll(this.taskTemplateRepository.getTaskTemplateTagListByTaskTemplateId(taskTemplateTagQueryInputBO));
        }
        BaseResponse response = BaseResponseUtils.getSuccessResponse((Object)IFWBeanCopyUtil.mapAsList(taskTemplateTagList, TaskTemplateTagOutputDTO.class), (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    public BaseResponse<Object> createTaskTemplate(IFWUser ifwUser, TaskTemplateInsertWrapInputBO taskTemplateInsertWrapInputBO) {
        if (StringUtils.isBlank((String)taskTemplateInsertWrapInputBO.getTenantId())) {
            taskTemplateInsertWrapInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)taskTemplateInsertWrapInputBO.getTenantId());
        }
        taskTemplateInsertWrapInputBO.setCreateBy(ifwUser.getUserId());
        IFWValidator.validate((Object)taskTemplateInsertWrapInputBO);
        this.taskTemplateRepository.createTaskTemplate(taskTemplateInsertWrapInputBO);
        BaseResponse response = BaseResponseUtils.getSuccessResponse(null, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    public BaseResponse<List<TaskTemplateOutputDTO>> getTaskTemplateList(IFWUser ifwUser, TaskTemplateListQueryInputBO taskTemplateListQueryInputBO) {
        if (StringUtils.isBlank((String)taskTemplateListQueryInputBO.getTenantId())) {
            taskTemplateListQueryInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)taskTemplateListQueryInputBO.getTenantId());
        }
        IFWValidator.validate((Object)taskTemplateListQueryInputBO);
        List taskTemplateList = this.taskTemplateRepository.getTaskTemplateList(taskTemplateListQueryInputBO);
        BaseResponse response = BaseResponseUtils.getSuccessResponse((Object)IFWBeanCopyUtil.mapAsList((Iterable)taskTemplateList, TaskTemplateOutputDTO.class), (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    public BaseResponse<TaskTemplateWrapOutputDTO> getTaskTemplateDetail(IFWUser ifwUser, TaskTemplateWarpQueryInputBO taskTemplateWarpQueryInputBO) {
        if (StringUtils.isBlank((String)taskTemplateWarpQueryInputBO.getTenantId())) {
            taskTemplateWarpQueryInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)taskTemplateWarpQueryInputBO.getTenantId());
        }
        IFWValidator.validate((Object)taskTemplateWarpQueryInputBO);
        TaskTemplateWrapOutputBO taskTemplateDetail = this.taskTemplateRepository.getTaskTemplateDetail(taskTemplateWarpQueryInputBO);
        TaskTemplateWrapOutputDTO map = (TaskTemplateWrapOutputDTO)IFWBeanCopyUtil.map((Object)taskTemplateDetail, TaskTemplateWrapOutputDTO.class);
        List taskTemplatePermissionList = map.getTaskTemplatePermissionList();
        HashSet<String> positionIdSet = new HashSet<String>();
        if (taskTemplatePermissionList != null && !taskTemplatePermissionList.isEmpty()) {
            for (TaskTemplatePermissionOutputDTO dto : taskTemplatePermissionList) {
                if (!StringUtils.isBlank((String)dto.getPermissionSubjectPositionId())) {
                    positionIdSet.add(dto.getPermissionSubjectPositionId());
                }
                if (StringUtils.isBlank((String)dto.getPermissionObjectPositionId())) continue;
                positionIdSet.add(dto.getPermissionObjectPositionId());
            }
            ArrayList positionIdList = new ArrayList(positionIdSet);
            if (positionIdList != null && !positionIdList.isEmpty()) {
                QueryDeptInfosReqDTO queryDeptInfosReqDTO = new QueryDeptInfosReqDTO();
                queryDeptInfosReqDTO.setPositionIds(positionIdList);
                queryDeptInfosReqDTO.setLanguageCode(taskTemplateWarpQueryInputBO.getLanguageCode());
                queryDeptInfosReqDTO.setTenantId(taskTemplateWarpQueryInputBO.getTenantId());
                List quDeptInfoDTOS = this.organizationRepository.queryDeptByPositionIds(queryDeptInfosReqDTO);
                if (!CollectionUtils.isEmpty((Collection)quDeptInfoDTOS)) {
                    for (TaskTemplatePermissionOutputDTO dto : taskTemplatePermissionList) {
                        for (QuDeptInfoDTO quDeptInfoDTO : quDeptInfoDTOS) {
                            List deptList = quDeptInfoDTO.getDeptList();
                            if (StringUtils.isEquals((String)dto.getPermissionSubjectPositionId(), (String)quDeptInfoDTO.getPositionId())) {
                                dto.setPermissionSubjectPositionName(quDeptInfoDTO.getPositionName());
                                dto.setSubjectDeptList(deptList);
                            }
                            if (!StringUtils.isEquals((String)dto.getPermissionObjectPositionId(), (String)quDeptInfoDTO.getPositionId())) continue;
                            dto.setPermissionObjectPositionName(quDeptInfoDTO.getPositionName());
                            dto.setObjectDeptList(deptList);
                        }
                    }
                }
            }
        }
        BaseResponse response = BaseResponseUtils.getSuccessResponse((Object)map, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    public BaseResponse<Object> deleteTaskTemplate(IFWUser ifwUser, TaskTemplateWarpQueryInputBO taskTemplateWarpQueryInputBO) {
        if (StringUtils.isBlank((String)taskTemplateWarpQueryInputBO.getTenantId())) {
            taskTemplateWarpQueryInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)taskTemplateWarpQueryInputBO.getTenantId());
        }
        IFWValidator.validate((Object)taskTemplateWarpQueryInputBO);
        boolean uface = this.taskTemplateRepository.queryTaskTempId(taskTemplateWarpQueryInputBO);
        if (uface) {
            throw new BizException(PlatformCodeEnum.TEMPLATE_IS_CONFIGURED_IN_UFACE.getDesc(), PlatformCodeEnum.TEMPLATE_IS_CONFIGURED_IN_UFACE.getCode());
        }
        boolean sentry = this.taskTemplateRepository.sentryQueryTask(taskTemplateWarpQueryInputBO);
        if (sentry) {
            throw new BizException(PlatformCodeEnum.TEMPLATE_IS_CONFIGURED_IN_SENTRY.getDesc(), PlatformCodeEnum.TEMPLATE_IS_CONFIGURED_IN_SENTRY.getCode());
        }
        QueryTemplateUseQuDTO queryTemplateUseQuDTO = new QueryTemplateUseQuDTO();
        queryTemplateUseQuDTO.setTaskTemplateId(taskTemplateWarpQueryInputBO.getTaskTemplateId());
        boolean camera = this.taskTemplateRepository.queryTemplateUse(queryTemplateUseQuDTO);
        if (camera) {
            throw new BizException(PlatformCodeEnum.TEMPLATE_IS_CONFIGURED_IN_CAMERA.getDesc(), PlatformCodeEnum.TEMPLATE_IS_CONFIGURED_IN_CAMERA.getCode());
        }
        this.taskTemplateRepository.deleteTaskTemplate(taskTemplateWarpQueryInputBO);
        BaseResponse response = BaseResponseUtils.getSuccessResponse(null, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    public BaseResponse<Object> updateTaskTemplate(IFWUser ifwUser, TaskTemplateUpdateWrapInputBO taskTemplateUpdateWrapInputBO) {
        if (StringUtils.isBlank((String)taskTemplateUpdateWrapInputBO.getTenantId())) {
            taskTemplateUpdateWrapInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)taskTemplateUpdateWrapInputBO.getTenantId());
        }
        taskTemplateUpdateWrapInputBO.setUpdateBy(ifwUser.getUserId());
        IFWValidator.validate((Object)taskTemplateUpdateWrapInputBO);
        this.taskTemplateRepository.updateTaskTemplate(taskTemplateUpdateWrapInputBO);
        BaseResponse response = BaseResponseUtils.getSuccessResponse(null, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    public BaseResponse<List<PositionDTO>> getTaskTemplatePermissionByOperationId(IFWUser ifwUser, TaskTemplatePermissionRelationQueryInputBO taskTemplatePermissionRelationQueryInputBO) {
        List queryResEmployeeOutputBOList;
        if (StringUtils.isBlank((String)taskTemplatePermissionRelationQueryInputBO.getTenantId())) {
            taskTemplatePermissionRelationQueryInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)taskTemplatePermissionRelationQueryInputBO.getTenantId());
        }
        if (CollectionUtils.isEmpty((Collection)taskTemplatePermissionRelationQueryInputBO.getPermissionSubjectPositionIdList())) {
            List positions = ifwUser.getPositions();
            List<Object> collect = new ArrayList();
            if (positions != null && !positions.isEmpty()) {
                collect = positions.stream().map(IFWPosition::getPositionId).collect(Collectors.toList());
            }
            taskTemplatePermissionRelationQueryInputBO.setPermissionSubjectPositionIdList(collect);
        }
        IFWValidator.validate((Object)taskTemplatePermissionRelationQueryInputBO);
        ArrayList<PositionDTO> result = new ArrayList<PositionDTO>();
        List positionIdList = this.taskTemplateRepository.getTaskTemplatePermissionByOperationId(taskTemplatePermissionRelationQueryInputBO);
        if (positionIdList != null && !positionIdList.isEmpty() && (queryResEmployeeOutputBOList = this.organizationRepository.queryPositionNameList(positionIdList, taskTemplatePermissionRelationQueryInputBO.getTenantId(), taskTemplatePermissionRelationQueryInputBO.getLanguageCode())) != null && queryResEmployeeOutputBOList.isEmpty()) {
            for (String positionId : positionIdList) {
                PositionDTO positionDTO = new PositionDTO();
                positionDTO.setPositionId(positionId);
                for (QueryPositionNameResDTO bo : queryResEmployeeOutputBOList) {
                    if (!StringUtils.isEquals((String)bo.getPositionId(), (String)positionId)) continue;
                    positionDTO.setPositionName(bo.getPositionName());
                }
                result.add(positionDTO);
            }
        }
        BaseResponse response = BaseResponseUtils.getSuccessResponse(result, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }
}

