/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.tracker.service.impl;

import com.ifourthwall.common.PlatformCodeEnum;
import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWPageInfo;
import com.ifourthwall.common.base.IFWPosition;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.common.utils.IFWBeanCopyUtil;
import com.ifourthwall.common.utils.IFWValidator;
import com.ifourthwall.dbm.project.dto.QueryAllDeptDTO;
import com.ifourthwall.dbm.task.dto.SingleStringOutDTO;
import com.ifourthwall.dbm.task.dto.WorksheetByUserDTO;
import com.ifourthwall.dbm.tracker.bo.CheckpointPackageInputBO;
import com.ifourthwall.dbm.tracker.bo.ContactQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.CustomizeTaskCycleInputBO;
import com.ifourthwall.dbm.tracker.bo.QueryCheckPointListOutputBO;
import com.ifourthwall.dbm.tracker.bo.QueryCheckPointListQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.QueryResEmployeeOutputBO;
import com.ifourthwall.dbm.tracker.bo.QueryWorksheetByUserInputBO;
import com.ifourthwall.dbm.tracker.bo.ServiceSupplierListQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.SingleStringOutBO;
import com.ifourthwall.dbm.tracker.bo.TaskCheckPointRelationInsertInputBO;
import com.ifourthwall.dbm.tracker.bo.TaskDetailQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.TaskExecutorInsertInputBO;
import com.ifourthwall.dbm.tracker.bo.TaskInsertInputBO;
import com.ifourthwall.dbm.tracker.bo.TaskListPageQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.TaskOperateInputBO;
import com.ifourthwall.dbm.tracker.bo.TaskSpaceInsertInputBO;
import com.ifourthwall.dbm.tracker.bo.TaskTemplatePermissionExecutorQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.TaskWrapDetailOutputBO;
import com.ifourthwall.dbm.tracker.bo.TaskWrapInsertInputBO;
import com.ifourthwall.dbm.tracker.bo.TaskWrapUpdateInputBO;
import com.ifourthwall.dbm.tracker.bo.UserDeatilInfoOutputBO;
import com.ifourthwall.dbm.tracker.domain.ConfigRepository;
import com.ifourthwall.dbm.tracker.domain.OrganizationRepository;
import com.ifourthwall.dbm.tracker.domain.TaskRepository;
import com.ifourthwall.dbm.tracker.dto.CheckpointOfflinePackageWrapOutputDTO;
import com.ifourthwall.dbm.tracker.dto.PositionDTO;
import com.ifourthwall.dbm.tracker.dto.QueryResEmployeeOutputDTO;
import com.ifourthwall.dbm.tracker.dto.ServiceSupplierOutputDTO;
import com.ifourthwall.dbm.tracker.dto.TaskListOutputDTO;
import com.ifourthwall.dbm.tracker.dto.TaskWrapDetailOutputDTO;
import com.ifourthwall.dbm.tracker.dto.WorksheetByUserOutputDTO;
import com.ifourthwall.dbm.tracker.service.TaskService;
import com.ifourthwall.dbm.tracker.utils.BaseResponseUtils;
import com.ifourthwall.dbm.tracker.utils.CheckAccessUtils;
import com.ifourthwall.dbm.user.dto.QueryPositionNameResDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="taskServiceImpl")
public class TaskServiceImpl
implements TaskService {
    private static final Logger log = LoggerFactory.getLogger(TaskServiceImpl.class);
    @Resource(name="taskRepository")
    TaskRepository taskRepository;
    @Resource(name="organizationRepository")
    OrganizationRepository organizationRepository;
    @Resource(name="configRepository")
    ConfigRepository configRepository;
    @Value(value="${robot.system.position.id}")
    private String robotPositionId;
    @Value(value="${robot.system.id}")
    private String robotId;

    public BaseResponse<CheckpointOfflinePackageWrapOutputDTO> getCheckpointPackage(IFWUser ifwUser, CheckpointPackageInputBO checkpointPackageInputBO) {
        BaseResponse response = BaseResponseUtils.getSuccessResponse(null, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    public BaseResponse<SingleStringOutDTO> createTask(IFWUser ifwUser, TaskWrapInsertInputBO taskWrapInsertInputBO) {
        CustomizeTaskCycleInputBO customizeTaskCycle;
        Integer taskCycle;
        if (StringUtils.isBlank((String)taskWrapInsertInputBO.getTenantId())) {
            taskWrapInsertInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)taskWrapInsertInputBO.getTenantId());
        }
        if (taskWrapInsertInputBO.getTask() != null) {
            if (StringUtils.isEquals((String)taskWrapInsertInputBO.getTask().getCreateByPositionId(), (String)this.robotPositionId)) {
                taskWrapInsertInputBO.getTask().setCreateBy(this.robotId);
            } else {
                taskWrapInsertInputBO.getTask().setCreateBy(ifwUser.getUserId());
            }
            taskWrapInsertInputBO.getTask().setTenantId(taskWrapInsertInputBO.getTenantId());
            if (StringUtils.isEquals((String)taskWrapInsertInputBO.getTask().getTaskTypeId(), (String)"1")) {
                List taskSpaceList = taskWrapInsertInputBO.getTaskSpaceList();
                if (taskSpaceList == null && taskSpaceList.isEmpty()) {
                    throw new BizException(PlatformCodeEnum.TASK_SPACE_CANNOT_NULL.getDesc(), PlatformCodeEnum.TASK_SPACE_CANNOT_NULL.getCode());
                }
                for (TaskSpaceInsertInputBO taskSpaceInsertInputBO : taskSpaceList) {
                    if (!StringUtils.isBlank((String)taskSpaceInsertInputBO.getSpaceId()) && !StringUtils.isBlank((String)taskSpaceInsertInputBO.getTaskSpaceDescription())) continue;
                    throw new BizException(PlatformCodeEnum.SPACE_ID_AND_DESC_CANNOT_NULL.getDesc(), PlatformCodeEnum.SPACE_ID_AND_DESC_CANNOT_NULL.getCode());
                }
            }
            if (StringUtils.isBlank((String)taskWrapInsertInputBO.getTask().getReportingId())) {
                taskWrapInsertInputBO.getTask().setTaskSource("1");
            } else {
                taskWrapInsertInputBO.getTask().setTaskSource("3");
            }
        }
        if (taskWrapInsertInputBO.getTaskExecutorList() != null && !taskWrapInsertInputBO.getTaskExecutorList().isEmpty()) {
            List taskExecutorList = taskWrapInsertInputBO.getTaskExecutorList();
            taskExecutorList.stream().forEach(new /* Unavailable Anonymous Inner Class!! */);
        }
        if ((taskCycle = taskWrapInsertInputBO.getTask().getTaskCycle()) != null && taskCycle == 4 && ((customizeTaskCycle = taskWrapInsertInputBO.getCustomizeTaskCycle()).getValidStartTime() == null || customizeTaskCycle.getCustomizeTaskCycle() == 0)) {
            throw new BizException(PlatformCodeEnum.CUSTOMIZE_TASK_CYCLE_PARAM_ERROR.getDesc(), PlatformCodeEnum.CUSTOMIZE_TASK_CYCLE_PARAM_ERROR.getCode());
        }
        IFWValidator.validate((Object)taskWrapInsertInputBO);
        SingleStringOutBO singleStringOutBO = this.taskRepository.createTask(taskWrapInsertInputBO);
        BaseResponse response = BaseResponseUtils.getSuccessResponse((Object)IFWBeanCopyUtil.map((Object)singleStringOutBO, SingleStringOutDTO.class), (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    public BaseResponse<Object> operateTask(IFWUser ifwUser, TaskOperateInputBO taskOperateBO) {
        if (StringUtils.isBlank((String)taskOperateBO.getTenantId())) {
            taskOperateBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)taskOperateBO.getTenantId());
        }
        taskOperateBO.setUpdateBy(ifwUser.getUserId());
        if (ifwUser.getPositions() == null || ifwUser.getPositions().isEmpty()) {
            return BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.USER_POSITION_INFO_IS_NULL.getCode(), (String)PlatformCodeEnum.USER_POSITION_INFO_IS_NULL.getDesc());
        }
        taskOperateBO.setPermissionSubjectPositionIdList(ifwUser.getPositions().stream().map(IFWPosition::getPositionId).collect(Collectors.toList()));
        IFWValidator.validate((Object)taskOperateBO);
        this.taskRepository.operateTask(taskOperateBO);
        BaseResponse response = BaseResponseUtils.getSuccessResponse(null, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    public BaseResponse<List<QueryResEmployeeOutputDTO>> getTaskExecutor(IFWUser ifwUser, TaskTemplatePermissionExecutorQueryInputBO taskTemplatePermissionExecutorQueryBO) {
        List positionDTOList;
        if (StringUtils.isBlank((String)taskTemplatePermissionExecutorQueryBO.getTenantId())) {
            taskTemplatePermissionExecutorQueryBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)taskTemplatePermissionExecutorQueryBO.getTenantId());
        }
        IFWValidator.validate((Object)taskTemplatePermissionExecutorQueryBO);
        List result = new ArrayList();
        ContactQueryInputBO contactQueryInputBO = new ContactQueryInputBO();
        contactQueryInputBO.setProjectId(taskTemplatePermissionExecutorQueryBO.getProjectId());
        contactQueryInputBO.setLanguageCode(taskTemplatePermissionExecutorQueryBO.getLanguageCode());
        contactQueryInputBO.setTenantId(taskTemplatePermissionExecutorQueryBO.getTenantId());
        List deptInfoList = this.organizationRepository.getDeptInfoList(contactQueryInputBO);
        if (!CollectionUtils.isEmpty((Collection)deptInfoList) && !CollectionUtils.isEmpty((Collection)(positionDTOList = this.taskRepository.getTaskExecutor(taskTemplatePermissionExecutorQueryBO)))) {
            List deptIdList = deptInfoList.stream().map(QueryAllDeptDTO::getDeptId).collect(Collectors.toList());
            List collect = positionDTOList.stream().map(PositionDTO::getPositionId).collect(Collectors.toList());
            List queryResEmployeeOutputBOList = this.organizationRepository.queryPositionAndEmployeeByPositionId(collect, taskTemplatePermissionExecutorQueryBO.getTenantId(), taskTemplatePermissionExecutorQueryBO.getLanguageCode());
            ArrayList filterDeptList = new ArrayList();
            if (!CollectionUtils.isEmpty(deptIdList)) {
                queryResEmployeeOutputBOList.stream().filter(item -> deptIdList.contains(item.getDeptId())).collect(Collectors.groupingBy(item -> item.getUserId() + "#" + item.getPositionId())).forEach((BiConsumer<String, List<QueryResEmployeeOutputBO>>)new /* Unavailable Anonymous Inner Class!! */);
            }
            result = IFWBeanCopyUtil.mapAsList(filterDeptList, QueryResEmployeeOutputDTO.class);
        }
        BaseResponse response = BaseResponseUtils.getSuccessResponse(result, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    public BaseResponse<Object> updateTask(IFWUser ifwUser, TaskWrapUpdateInputBO taskWrapUpdateInputBO) {
        if (StringUtils.isBlank((String)taskWrapUpdateInputBO.getTenantId())) {
            taskWrapUpdateInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)taskWrapUpdateInputBO.getTenantId());
        }
        if (ifwUser.getPositions() == null || ifwUser.getPositions().isEmpty()) {
            return BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.USER_POSITION_INFO_IS_NULL.getCode(), (String)PlatformCodeEnum.USER_POSITION_INFO_IS_NULL.getDesc());
        }
        taskWrapUpdateInputBO.setPermissionSubjectPositionIdList(ifwUser.getPositions().stream().map(IFWPosition::getPositionId).collect(Collectors.toList()));
        TaskInsertInputBO task = taskWrapUpdateInputBO.getTask();
        if (task != null) {
            task.setTenantId(taskWrapUpdateInputBO.getTenantId());
            task.setCreateBy(ifwUser.getUserId());
            task.setTaskSource("1");
            if (task.getTaskCycle() != null && 4 == task.getTaskCycle() && taskWrapUpdateInputBO.getCustomizeTaskCycle() == null) {
                throw new BizException(PlatformCodeEnum.CUSTOMIZE_TASK_CYCLE_PARAM_ERROR.getDesc(), PlatformCodeEnum.CUSTOMIZE_TASK_CYCLE_PARAM_ERROR.getCode());
            }
        }
        IFWValidator.validate((Object)taskWrapUpdateInputBO);
        this.taskRepository.updateTask(taskWrapUpdateInputBO);
        BaseResponse response = BaseResponseUtils.getSuccessResponse(null, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    public BaseResponse<List<ServiceSupplierOutputDTO>> getServiceSupplierList(IFWUser ifwUser, ServiceSupplierListQueryInputBO serviceSupplierListQueryInputBO) {
        if (StringUtils.isBlank((String)serviceSupplierListQueryInputBO.getTenantId())) {
            serviceSupplierListQueryInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)serviceSupplierListQueryInputBO.getTenantId());
        }
        IFWValidator.validate((Object)serviceSupplierListQueryInputBO);
        List serviceSupplierList = this.taskRepository.getServiceSupplierList(serviceSupplierListQueryInputBO);
        BaseResponse response = BaseResponseUtils.getSuccessResponse((Object)IFWBeanCopyUtil.mapAsList((Iterable)serviceSupplierList, ServiceSupplierOutputDTO.class), (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    public BaseResponse<TaskWrapDetailOutputDTO> getTaskDetail(IFWUser ifwUser, TaskDetailQueryInputBO taskDetailQueryInputBO) {
        List taskCheckPointRelationList;
        List taskExecutorList;
        if (StringUtils.isBlank((String)taskDetailQueryInputBO.getTenantId())) {
            taskDetailQueryInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)taskDetailQueryInputBO.getTenantId());
        }
        IFWValidator.validate((Object)taskDetailQueryInputBO);
        TaskWrapDetailOutputBO taskDetail = this.taskRepository.getTaskDetail(taskDetailQueryInputBO);
        TaskInsertInputBO task = taskDetail.getTask();
        String createPositionId = null;
        if (task != null) {
            createPositionId = task.getCreateByPositionId();
        }
        if ((taskExecutorList = taskDetail.getTaskExecutorList()) != null && !taskExecutorList.isEmpty()) {
            List positionIdList;
            List queryResEmployeeOutputBOList;
            List userIdList = taskDetail.getTaskExecutorList().stream().map(TaskExecutorInsertInputBO::getTaskExecutorUserId).collect(Collectors.toList());
            List userDeatilInfoOutputBOList = this.organizationRepository.queryUserDetailByUserId(userIdList, taskDetailQueryInputBO.getTenantId(), taskDetailQueryInputBO.getLanguageCode());
            if (userDeatilInfoOutputBOList != null && !userDeatilInfoOutputBOList.isEmpty()) {
                for (TaskExecutorInsertInputBO executorBo : taskExecutorList) {
                    for (UserDeatilInfoOutputBO bo : userDeatilInfoOutputBOList) {
                        if (!StringUtils.isEquals((String)executorBo.getTaskExecutorUserId(), (String)bo.getUserId())) continue;
                        executorBo.setName(bo.getRealName());
                    }
                }
            }
            if (!CollectionUtils.isEmpty((Collection)(queryResEmployeeOutputBOList = this.organizationRepository.queryPositionAndEmployeeByPositionId(positionIdList = taskExecutorList.stream().filter(item -> !StringUtils.isBlank((String)item.getTaskExecutorPositionId())).map(TaskExecutorInsertInputBO::getTaskExecutorPositionId).distinct().collect(Collectors.toList()), taskDetailQueryInputBO.getTenantId(), taskDetailQueryInputBO.getLanguageCode())))) {
                queryResEmployeeOutputBOList.stream().forEach(new /* Unavailable Anonymous Inner Class!! */);
            }
        }
        if ((taskCheckPointRelationList = taskDetail.getTaskCheckPointRelationList()) != null && !taskCheckPointRelationList.isEmpty()) {
            List collect = taskCheckPointRelationList.stream().map(TaskCheckPointRelationInsertInputBO::getCheckPointId).collect(Collectors.toList());
            QueryCheckPointListQueryInputBO queryCheckPointListQueryInputBO = new QueryCheckPointListQueryInputBO();
            queryCheckPointListQueryInputBO.setCheckPointId(collect);
            queryCheckPointListQueryInputBO.setTenantId(taskDetailQueryInputBO.getTenantId());
            queryCheckPointListQueryInputBO.setProjectId(taskDetailQueryInputBO.getProjectId());
            queryCheckPointListQueryInputBO.setLanguageCode(taskDetailQueryInputBO.getLanguageCode());
            List checkpointList = this.configRepository.getCheckpointList(queryCheckPointListQueryInputBO).getList();
            if (checkpointList != null && !checkpointList.isEmpty()) {
                for (TaskCheckPointRelationInsertInputBO checkpoint : taskCheckPointRelationList) {
                    for (QueryCheckPointListOutputBO checkPointListOutputBO : checkpointList) {
                        if (!StringUtils.isEquals((String)checkpoint.getCheckPointId(), (String)checkPointListOutputBO.getCheckPointId())) continue;
                        checkpoint.setCheckPointName(checkPointListOutputBO.getCheckPointName());
                    }
                }
            }
        }
        TaskWrapDetailOutputDTO map = (TaskWrapDetailOutputDTO)IFWBeanCopyUtil.map((Object)taskDetail, TaskWrapDetailOutputDTO.class);
        if (!StringUtils.isBlank((String)createPositionId)) {
            ArrayList<String> positionId = new ArrayList<String>();
            positionId.add(createPositionId);
            List queryPositionNameResDTOS = this.organizationRepository.queryPositionNameList(positionId, taskDetailQueryInputBO.getTenantId(), taskDetailQueryInputBO.getLanguageCode());
            if (!CollectionUtils.isEmpty((Collection)queryPositionNameResDTOS)) {
                for (QueryPositionNameResDTO dto : queryPositionNameResDTOS) {
                    if (!StringUtils.isEquals((String)dto.getPositionId(), (String)createPositionId)) continue;
                    map.getTask().setCreatePositionName(dto.getPositionName());
                }
            }
        }
        BaseResponse response = BaseResponseUtils.getSuccessResponse((Object)map, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    public BaseResponse<IFWPageInfo<TaskListOutputDTO>> getTaskList(IFWUser ifwUser, TaskListPageQueryInputBO taskListPageQueryInputBO) {
        List collect;
        List userDeatilInfoOutputBOList;
        IFWPageInfo pageInfo;
        List taskListOutputDTOList;
        if (StringUtils.isBlank((String)taskListPageQueryInputBO.getTenantId())) {
            taskListPageQueryInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)taskListPageQueryInputBO.getTenantId());
        }
        IFWValidator.validate((Object)taskListPageQueryInputBO);
        if (StringUtils.isBlank((String)taskListPageQueryInputBO.getSortByCreateTime())) {
            taskListPageQueryInputBO.setSortByCreateTime("0");
        }
        if ((taskListOutputDTOList = IFWBeanCopyUtil.mapAsList((Iterable)(pageInfo = this.taskRepository.getTaskList(taskListPageQueryInputBO)).getList(), TaskListOutputDTO.class)) != null && !taskListOutputDTOList.isEmpty() && (userDeatilInfoOutputBOList = this.organizationRepository.queryUserDetailByUserId(collect = taskListOutputDTOList.stream().map(TaskListOutputDTO::getCreateBy).collect(Collectors.toList()), taskListPageQueryInputBO.getTenantId(), taskListPageQueryInputBO.getLanguageCode())) != null && !userDeatilInfoOutputBOList.isEmpty()) {
            for (TaskListOutputDTO dto : taskListOutputDTOList) {
                for (UserDeatilInfoOutputBO bo : userDeatilInfoOutputBOList) {
                    if (!StringUtils.isEquals((String)dto.getCreateBy(), (String)bo.getUserId())) continue;
                    dto.setCreateName(bo.getRealName());
                }
            }
        }
        IFWPageInfo result = new IFWPageInfo();
        result.setPageSize(pageInfo.getPageSize());
        result.setPageNum(pageInfo.getPageNum());
        result.setTotal(pageInfo.getTotal());
        result.setList(taskListOutputDTOList);
        BaseResponse response = BaseResponseUtils.getSuccessResponse((Object)result, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    public BaseResponse<WorksheetByUserOutputDTO> queryWorksheetByUser(IFWUser ifwUser, QueryWorksheetByUserInputBO queryWorksheetByUserInputBO) {
        if (StringUtils.isBlank((String)queryWorksheetByUserInputBO.getTenantId())) {
            queryWorksheetByUserInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)queryWorksheetByUserInputBO.getTenantId());
        }
        IFWValidator.validate((Object)queryWorksheetByUserInputBO);
        WorksheetByUserDTO worksheetByUserDTO = this.taskRepository.queryWorksheetByUser(queryWorksheetByUserInputBO);
        BaseResponse response = BaseResponseUtils.getSuccessResponse((Object)IFWBeanCopyUtil.map((Object)worksheetByUserDTO, WorksheetByUserOutputDTO.class), (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }
}

