/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.tracker.service.impl;

import com.ifourthwall.common.PlatformCodeEnum;
import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWPageInfo;
import com.ifourthwall.common.base.IFWPosition;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.common.cache.RedisKeyPrefixUtil;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.common.utils.IFWBeanCopyUtil;
import com.ifourthwall.common.utils.IFWValidator;
import com.ifourthwall.dbm.asset.dto.QueryAssetListByIdsDTO;
import com.ifourthwall.dbm.asset.dto.QueryAssetListDTO;
import com.ifourthwall.dbm.asset.dto.QueryNoMonitorQuDTO;
import com.ifourthwall.dbm.project.dto.ProjectSpacePathDTO;
import com.ifourthwall.dbm.project.dto.QueryAllDeptDTO;
import com.ifourthwall.dbm.project.dto.QuerySonSpaceListDTO;
import com.ifourthwall.dbm.task.dto.AssetCheckRecordDTO;
import com.ifourthwall.dbm.task.dto.DailyWorksheetStatisticDTO;
import com.ifourthwall.dbm.task.dto.FaultAssetQueryDTO;
import com.ifourthwall.dbm.task.dto.WorksheetAggStatisticDTO;
import com.ifourthwall.dbm.task.dto.WorksheetStatisticByDeptDTO;
import com.ifourthwall.dbm.task.dto.WorksheetTypeStatisticDTO;
import com.ifourthwall.dbm.tracker.bo.AppTodaySummeryInputBO;
import com.ifourthwall.dbm.tracker.bo.CheckpointListOutputBO;
import com.ifourthwall.dbm.tracker.bo.CheckpointScanOutlineOutputBO;
import com.ifourthwall.dbm.tracker.bo.CheckpointScanOutlineQueryBO;
import com.ifourthwall.dbm.tracker.bo.CheckpointScanOutlineQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.ContactQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.PatrolRecordByMonthOutputBO;
import com.ifourthwall.dbm.tracker.bo.PatrolRecordByMonthQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.PlanTaskCategoryListQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.PlanTaskCategoryOutputBO;
import com.ifourthwall.dbm.tracker.bo.PositionResOutputBO;
import com.ifourthwall.dbm.tracker.bo.QueryCheckPointListQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.QueryDeptPositionReqInputBO;
import com.ifourthwall.dbm.tracker.bo.QueryDeptPositionResOutputBO;
import com.ifourthwall.dbm.tracker.bo.QueryResEmployeeOutputBO;
import com.ifourthwall.dbm.tracker.bo.QuerySeerWorksheetNumInputBO;
import com.ifourthwall.dbm.tracker.bo.QueryWorksheetByAssetInputBO;
import com.ifourthwall.dbm.tracker.bo.ReportSummeryOutputBO;
import com.ifourthwall.dbm.tracker.bo.ReportSummeryQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.SeerAssetOutputBO;
import com.ifourthwall.dbm.tracker.bo.SeerAssetQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.SeerQuerySpecialBySpaceInputBO;
import com.ifourthwall.dbm.tracker.bo.SeerWorksheetQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.SpaceSpecialQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.TagStatisticInputBO;
import com.ifourthwall.dbm.tracker.bo.TaskAndReportSummeryQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.TaskSummeryOutputBO;
import com.ifourthwall.dbm.tracker.bo.UserDeatilInfoOutputBO;
import com.ifourthwall.dbm.tracker.bo.WorksheetCountForSeerOutputBO;
import com.ifourthwall.dbm.tracker.bo.WorksheetNumQueryByUserInputBO;
import com.ifourthwall.dbm.tracker.bo.WorksheetQueryBySpaceInputBO;
import com.ifourthwall.dbm.tracker.bo.WorksheetQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.WorksheetStatisticForSeerInputBO;
import com.ifourthwall.dbm.tracker.bo.WorksheetStatisticInputBO;
import com.ifourthwall.dbm.tracker.bo.WorksheetStatisticLineChartInputBO;
import com.ifourthwall.dbm.tracker.bo.WorksheetStatisticListInputBO;
import com.ifourthwall.dbm.tracker.domain.ConfigRepository;
import com.ifourthwall.dbm.tracker.domain.OrganizationRepository;
import com.ifourthwall.dbm.tracker.domain.PlanTaskCategoryRepository;
import com.ifourthwall.dbm.tracker.domain.StatisticsRepository;
import com.ifourthwall.dbm.tracker.domain.WorksheetRepository;
import com.ifourthwall.dbm.tracker.dto.AppTodaySummeryOutputDTO;
import com.ifourthwall.dbm.tracker.dto.AssetStatisticOutputDTO;
import com.ifourthwall.dbm.tracker.dto.AssetWorksheetOutputDTO;
import com.ifourthwall.dbm.tracker.dto.DailyTaskWorkSheetListOutputDTO;
import com.ifourthwall.dbm.tracker.dto.DailyWorksheetStatisticOutputDTO;
import com.ifourthwall.dbm.tracker.dto.DeptOutlineOutputDTO;
import com.ifourthwall.dbm.tracker.dto.PatrolRecordByMonthOutputDTO;
import com.ifourthwall.dbm.tracker.dto.ReportSummeryOutputDTO;
import com.ifourthwall.dbm.tracker.dto.ScanOutlineOutputDTO;
import com.ifourthwall.dbm.tracker.dto.SeerAssetOutputDTO;
import com.ifourthwall.dbm.tracker.dto.SeerQuerySpecialBySpaceOutputDTO;
import com.ifourthwall.dbm.tracker.dto.SpaceSpecialOutputDTO;
import com.ifourthwall.dbm.tracker.dto.TagStatisticOutputDTO;
import com.ifourthwall.dbm.tracker.dto.TaskAndReportFinishSummeryDTO;
import com.ifourthwall.dbm.tracker.dto.TaskFinishSummeryDTO;
import com.ifourthwall.dbm.tracker.dto.TaskSpaceInsertInputDTO;
import com.ifourthwall.dbm.tracker.dto.TemporyTaskWorkSheetListOutputDTO;
import com.ifourthwall.dbm.tracker.dto.WorksheetAggStatisticOutputDTO;
import com.ifourthwall.dbm.tracker.dto.WorksheetExecutorOutputDTO;
import com.ifourthwall.dbm.tracker.dto.WorksheetFinishStatisticOutputDTO;
import com.ifourthwall.dbm.tracker.dto.WorksheetListOutlineForSeerOutputDTO;
import com.ifourthwall.dbm.tracker.dto.WorksheetNumByProjectOutputDTO;
import com.ifourthwall.dbm.tracker.dto.WorksheetNumByUserOutputDTO;
import com.ifourthwall.dbm.tracker.dto.WorksheetOutputDTO;
import com.ifourthwall.dbm.tracker.dto.WorksheetSourceOutputDTO;
import com.ifourthwall.dbm.tracker.dto.WorksheetStatisticDetailOutputDTO;
import com.ifourthwall.dbm.tracker.dto.WorksheetStatisticSeerOutputDTO;
import com.ifourthwall.dbm.tracker.dto.WorksheetSummeryByDeptOutputDTO;
import com.ifourthwall.dbm.tracker.dto.WorksheetSummeryListOutputDTO;
import com.ifourthwall.dbm.tracker.dto.WorksheetTypeStatisticOutputDTO;
import com.ifourthwall.dbm.tracker.service.StatisticsService;
import com.ifourthwall.dbm.tracker.utils.BaseResponseUtils;
import com.ifourthwall.dbm.tracker.utils.CheckAccessUtils;
import com.ifourthwall.dbm.tracker.utils.DateUtils;
import com.ifourthwall.dbm.user.dto.PositionIdsDTO;
import com.ifourthwall.dbm.user.dto.QuDeptInfoDTO;
import com.ifourthwall.dbm.user.dto.QueryDeptInfosReqDTO;
import com.ifourthwall.dbm.user.dto.UserInformationDTO;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service(value="statisticsServiceImpl")
public class StatisticsServiceImpl
implements StatisticsService {
    @Resource(name="statisticsRepository")
    StatisticsRepository statisticsRepository;
    @Resource(name="organizationRepository")
    OrganizationRepository organizationRepository;
    @Resource(name="configRepository")
    ConfigRepository configRepository;
    @Resource(name="worksheetRepository")
    WorksheetRepository worksheetRepository;
    @Resource(name="planTaskCategoryRepository")
    PlanTaskCategoryRepository planTaskCategoryRepository;
    @Value(value="${robot.system.position.id}")
    private String robotPositionId;
    @Autowired
    RedisTemplate redisTemplate;

    public BaseResponse<List<PatrolRecordByMonthOutputDTO>> getPatrolRecordByMonth(IFWUser ifwUser, PatrolRecordByMonthQueryInputBO patrolRecordByMonthQueryInputBO) {
        if (StringUtils.isBlank((String)patrolRecordByMonthQueryInputBO.getTenantId())) {
            patrolRecordByMonthQueryInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)patrolRecordByMonthQueryInputBO.getTenantId());
        }
        IFWValidator.validate((Object)patrolRecordByMonthQueryInputBO);
        if (patrolRecordByMonthQueryInputBO.getIndex() != null && patrolRecordByMonthQueryInputBO.getYear() != null) {
            patrolRecordByMonthQueryInputBO.setStartTime(DateUtils.getStartDayOfMonthNo((int)patrolRecordByMonthQueryInputBO.getYear(), (int)patrolRecordByMonthQueryInputBO.getIndex()));
            patrolRecordByMonthQueryInputBO.setEndTime(DateUtils.getEndDayOfMonth((int)patrolRecordByMonthQueryInputBO.getYear(), (int)patrolRecordByMonthQueryInputBO.getIndex()));
        }
        List patrolRecordByMonth = this.statisticsRepository.getPatrolRecordByMonth(patrolRecordByMonthQueryInputBO);
        QueryCheckPointListQueryInputBO queryCheckPointListQueryInputBO = new QueryCheckPointListQueryInputBO();
        queryCheckPointListQueryInputBO.setTenantId(patrolRecordByMonthQueryInputBO.getTenantId());
        queryCheckPointListQueryInputBO.setProjectId(patrolRecordByMonthQueryInputBO.getProjectId());
        queryCheckPointListQueryInputBO.setLanguageCode(patrolRecordByMonthQueryInputBO.getLanguageCode());
        IFWPageInfo checkpointPageInfo = this.configRepository.getCheckpointList(queryCheckPointListQueryInputBO);
        if (checkpointPageInfo != null && checkpointPageInfo.getList() != null && patrolRecordByMonth != null && !patrolRecordByMonth.isEmpty()) {
            for (PatrolRecordByMonthOutputBO bo : patrolRecordByMonth) {
                bo.setTotalNum(Integer.valueOf(checkpointPageInfo.getList().size()));
            }
        }
        BaseResponse response = BaseResponseUtils.getSuccessResponse((Object)IFWBeanCopyUtil.mapAsList((Iterable)patrolRecordByMonth, PatrolRecordByMonthOutputDTO.class), (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    private List<String> getPositionIdList(String deptId, String languageCode, String tenantId) {
        List collect;
        List positionNames;
        QueryDeptPositionResOutputBO queryDeptPositionResOutputBO;
        ArrayList<String> positionIdList = new ArrayList<String>();
        QueryDeptPositionReqInputBO queryDeptPositionReqInputBO = new QueryDeptPositionReqInputBO();
        queryDeptPositionReqInputBO.setLanguageCode(languageCode);
        queryDeptPositionReqInputBO.setTenantId(tenantId);
        ArrayList<String> deptIdList = new ArrayList<String>();
        deptIdList.add(deptId);
        queryDeptPositionReqInputBO.setDeptIds(deptIdList);
        List queryDeptPositionResOutputBOS = this.organizationRepository.queryDeptAndPositionByPositionIds(queryDeptPositionReqInputBO);
        if (!(queryDeptPositionResOutputBOS == null || queryDeptPositionResOutputBOS.isEmpty() || (queryDeptPositionResOutputBO = (QueryDeptPositionResOutputBO)queryDeptPositionResOutputBOS.get(0)) == null || (positionNames = queryDeptPositionResOutputBO.getPositionNames()) == null || positionNames.isEmpty() || (collect = positionNames.stream().map(PositionResOutputBO::getPositionId).collect(Collectors.toList())) == null || collect.isEmpty())) {
            positionIdList.addAll(collect);
        }
        return positionIdList;
    }

    public BaseResponse<TaskAndReportFinishSummeryDTO> getTodaySummery(IFWUser ifwUser, ReportSummeryQueryInputBO reportSummeryQueryInputBO) {
        TaskAndReportFinishSummeryDTO result = new TaskAndReportFinishSummeryDTO();
        ReportSummeryOutputDTO report = new ReportSummeryOutputDTO();
        if (StringUtils.isBlank((String)reportSummeryQueryInputBO.getTenantId())) {
            reportSummeryQueryInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)reportSummeryQueryInputBO.getTenantId());
        }
        reportSummeryQueryInputBO.setStartDate(DateUtils.getFirstDateOfDay((Date)new Date()));
        reportSummeryQueryInputBO.setEndDate(DateUtils.getLastDateOfDay((Date)new Date()));
        IFWValidator.validate((Object)reportSummeryQueryInputBO);
        ReportSummeryOutputBO todayReportSummery = this.statisticsRepository.getReportSummery(reportSummeryQueryInputBO);
        report.setReportNum(todayReportSummery.getReportNum());
        report.setFinishNum(todayReportSummery.getReportToTaskFinishNum());
        ReportSummeryQueryInputBO yesterdaySummeryQueryInputBO = new ReportSummeryQueryInputBO();
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.add(5, -1);
        Date yesterdayDate = c.getTime();
        yesterdaySummeryQueryInputBO.setTenantId(reportSummeryQueryInputBO.getTenantId());
        yesterdaySummeryQueryInputBO.setProjectId(reportSummeryQueryInputBO.getProjectId());
        yesterdaySummeryQueryInputBO.setEndDate(DateUtils.getFirstDateOfDay((Date)yesterdayDate));
        yesterdaySummeryQueryInputBO.setStartDate(DateUtils.getLastDateOfDay((Date)yesterdayDate));
        ReportSummeryOutputBO yesterdayReportSummery = this.statisticsRepository.getReportSummery(yesterdaySummeryQueryInputBO);
        report.setYesterdayReportNum(yesterdayReportSummery.getReportNum());
        report.setYesterdayFinishNum(yesterdayReportSummery.getReportToTaskFinishNum());
        result.setReportSummery(report);
        TaskFinishSummeryDTO taskFinishSummeryDTO = new TaskFinishSummeryDTO();
        TaskAndReportSummeryQueryInputBO todayTaskQueryBO = (TaskAndReportSummeryQueryInputBO)IFWBeanCopyUtil.map((Object)reportSummeryQueryInputBO, TaskAndReportSummeryQueryInputBO.class);
        TaskSummeryOutputBO todayTaskSummery = this.statisticsRepository.getTaskSummery(todayTaskQueryBO);
        taskFinishSummeryDTO.setWorksheetTotalNum(todayTaskSummery.getWorksheetTotalNum());
        taskFinishSummeryDTO.setFinishWorksheetNum(todayTaskSummery.getFinishWorksheetTotalNum());
        TaskAndReportSummeryQueryInputBO yesterdayTaskQueryBO = (TaskAndReportSummeryQueryInputBO)IFWBeanCopyUtil.map((Object)yesterdaySummeryQueryInputBO, TaskAndReportSummeryQueryInputBO.class);
        TaskSummeryOutputBO yesterdayTaskSummery = this.statisticsRepository.getTaskSummery(yesterdayTaskQueryBO);
        taskFinishSummeryDTO.setYesterdayWorksheetTotalNum(yesterdayTaskSummery.getWorksheetTotalNum());
        taskFinishSummeryDTO.setYesterdayFinishWorksheetNum(yesterdayTaskSummery.getFinishWorksheetTotalNum());
        result.setTaskSummery(taskFinishSummeryDTO);
        BaseResponse response = BaseResponseUtils.getSuccessResponse((Object)result, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    public BaseResponse<AppTodaySummeryOutputDTO> getTodaySummeryForApp(IFWUser ifwUser, AppTodaySummeryInputBO appTodaySummeryInputBO) {
        ReportSummeryOutputBO todayReportSummery;
        if (StringUtils.isBlank((String)appTodaySummeryInputBO.getTenantId())) {
            appTodaySummeryInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)appTodaySummeryInputBO.getTenantId());
        }
        appTodaySummeryInputBO.setStartDate(DateUtils.getFirstDateOfDay((Date)new Date()));
        appTodaySummeryInputBO.setEndDate(DateUtils.getLastDateOfDay((Date)new Date()));
        IFWValidator.validate((Object)appTodaySummeryInputBO);
        AppTodaySummeryOutputDTO appTodaySummeryOutputDTO = new AppTodaySummeryOutputDTO();
        ReportSummeryQueryInputBO reportSummeryQueryInputBO = (ReportSummeryQueryInputBO)IFWBeanCopyUtil.map((Object)appTodaySummeryInputBO, ReportSummeryQueryInputBO.class);
        if (StringUtils.isEquals((String)appTodaySummeryInputBO.getIsPersonal(), (String)"0")) {
            reportSummeryQueryInputBO.setUserId(ifwUser.getUserId());
        }
        appTodaySummeryOutputDTO.setReportNum(Integer.valueOf((todayReportSummery = this.statisticsRepository.getReportSummery(reportSummeryQueryInputBO)).getReportNum() == null ? 0 : todayReportSummery.getReportNum()));
        appTodaySummeryOutputDTO.setFinishReportNum(Integer.valueOf(todayReportSummery.getReportToTaskNum() == null ? 0 : todayReportSummery.getReportToTaskNum()));
        if (!StringUtils.isEquals((String)appTodaySummeryInputBO.getIsPersonal(), (String)"0")) {
            PlanTaskCategoryListQueryInputBO planTaskCategoryListQueryInputBO = new PlanTaskCategoryListQueryInputBO();
            planTaskCategoryListQueryInputBO.setTenantId(appTodaySummeryInputBO.getTenantId());
            planTaskCategoryListQueryInputBO.setPlanTaskCategoryYear(DateUtils.getYear() + "");
            planTaskCategoryListQueryInputBO.setProjectId(appTodaySummeryInputBO.getProjectId());
            planTaskCategoryListQueryInputBO.setLanguageCode(appTodaySummeryInputBO.getLanguageCode());
            ArrayList<String> positionIdList = new ArrayList<String>();
            positionIdList.add(this.robotPositionId);
            planTaskCategoryListQueryInputBO.setPermissionSubjectPositionIdList(positionIdList);
            List planTaskCategoryList = this.planTaskCategoryRepository.getPlanTaskCategoryList(planTaskCategoryListQueryInputBO);
            if (planTaskCategoryList != null && !planTaskCategoryList.isEmpty()) {
                PlanTaskCategoryOutputBO planTaskCategoryOutputBO = (PlanTaskCategoryOutputBO)planTaskCategoryList.get(0);
                appTodaySummeryOutputDTO.setTotalTaskNum(Integer.valueOf(planTaskCategoryOutputBO.getTotalWorksheetNum() == null ? 0 : planTaskCategoryOutputBO.getTotalWorksheetNum()));
                appTodaySummeryOutputDTO.setFinishTaskNum(Integer.valueOf(planTaskCategoryOutputBO.getFinishWorksheetNum() == null ? 0 : planTaskCategoryOutputBO.getFinishWorksheetNum()));
            } else {
                appTodaySummeryOutputDTO.setTotalTaskNum(Integer.valueOf(0));
                appTodaySummeryOutputDTO.setFinishTaskNum(Integer.valueOf(0));
            }
        }
        BaseResponse response = BaseResponseUtils.getSuccessResponse((Object)appTodaySummeryOutputDTO, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    public BaseResponse<List<WorksheetNumByProjectOutputDTO>> getProcessingWorksheetNumByProject(IFWUser ifwUser, QuerySeerWorksheetNumInputBO querySeerWorksheetNumInputBO) {
        if (StringUtils.isBlank((String)querySeerWorksheetNumInputBO.getTenantId())) {
            querySeerWorksheetNumInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)querySeerWorksheetNumInputBO.getTenantId());
        }
        IFWValidator.validate((Object)querySeerWorksheetNumInputBO);
        List list = this.statisticsRepository.getSeerWorksheetNumByProject(querySeerWorksheetNumInputBO);
        BaseResponse response = BaseResponseUtils.getSuccessResponse((Object)IFWBeanCopyUtil.mapAsList((Iterable)list, WorksheetNumByProjectOutputDTO.class), (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    public BaseResponse<IFWPageInfo<ScanOutlineOutputDTO>> getScanOutline(IFWUser ifwUser, CheckpointScanOutlineQueryBO checkpointScanOutlineQueryBO) {
        if (StringUtils.isBlank((String)checkpointScanOutlineQueryBO.getTenantId())) {
            checkpointScanOutlineQueryBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)checkpointScanOutlineQueryBO.getTenantId());
        }
        IFWValidator.validate((Object)checkpointScanOutlineQueryBO);
        IFWPageInfo result = new IFWPageInfo();
        ArrayList<ScanOutlineOutputDTO> scanOutlineOutputDTOList = new ArrayList<ScanOutlineOutputDTO>();
        IFWPageInfo checkpointListFromTotal = this.configRepository.getCheckpointListFromTotal(checkpointScanOutlineQueryBO);
        List list = checkpointListFromTotal.getList();
        if (list != null && !list.isEmpty()) {
            List collect = list.stream().map(CheckpointListOutputBO::getCheckPointId).collect(Collectors.toList());
            CheckpointScanOutlineQueryInputBO checkpointScanOutlineQueryInputBO = new CheckpointScanOutlineQueryInputBO();
            checkpointScanOutlineQueryInputBO.setCheckpointIdList(collect);
            checkpointScanOutlineQueryInputBO.setProjectId(checkpointScanOutlineQueryBO.getProjectId());
            checkpointScanOutlineQueryInputBO.setDate(checkpointScanOutlineQueryBO.getDate());
            checkpointScanOutlineQueryInputBO.setLanguageCode(checkpointScanOutlineQueryBO.getLanguageCode());
            checkpointScanOutlineQueryInputBO.setTenantId(checkpointScanOutlineQueryBO.getTenantId());
            List scanOutlineByCheckpointId = this.statisticsRepository.getScanOutlineByCheckpointId(checkpointScanOutlineQueryInputBO);
            HashSet deptSet = new HashSet();
            for (CheckpointListOutputBO bo : list) {
                List deptId = bo.getDeptId();
                if (deptId == null || deptId.isEmpty()) continue;
                deptId.stream().forEach(new /* Unavailable Anonymous Inner Class!! */);
            }
            ArrayList deptList = new ArrayList(deptSet);
            QueryDeptPositionReqInputBO queryDeptPositionReqInputBO = new QueryDeptPositionReqInputBO();
            queryDeptPositionReqInputBO.setDeptIds(deptList);
            queryDeptPositionReqInputBO.setLanguageCode(checkpointScanOutlineQueryBO.getLanguageCode());
            queryDeptPositionReqInputBO.setTenantId(checkpointScanOutlineQueryBO.getTenantId());
            List queryDeptPositionResOutputBOS = this.organizationRepository.queryDeptAndPositionByPositionIds(queryDeptPositionReqInputBO);
            for (CheckpointListOutputBO bo : list) {
                ScanOutlineOutputDTO scanOutlineOutputDTO = new ScanOutlineOutputDTO();
                scanOutlineOutputDTO.setCheckpointId(bo.getCheckPointId());
                scanOutlineOutputDTO.setCheckpointName(bo.getCheckPointName());
                scanOutlineOutputDTO.setSpaceId(bo.getCheckPointSpaceId());
                for (CheckpointScanOutlineOutputBO scanB0 : scanOutlineByCheckpointId) {
                    if (!StringUtils.isEquals((String)bo.getCheckPointId(), (String)scanB0.getCheckpointId())) continue;
                    scanOutlineOutputDTO.setScanTimes(scanB0.getScanTimes());
                    scanOutlineOutputDTO.setLastDate(scanB0.getDate());
                }
                ArrayList<DeptOutlineOutputDTO> deptOutlineOutputDTOList = new ArrayList<DeptOutlineOutputDTO>();
                List deptId = bo.getDeptId();
                if (deptId != null && !deptId.isEmpty() && queryDeptPositionResOutputBOS != null && !queryDeptPositionResOutputBOS.isEmpty()) {
                    for (String dept : deptId) {
                        for (QueryDeptPositionResOutputBO deptBO : queryDeptPositionResOutputBOS) {
                            if (!StringUtils.isEquals((String)dept, (String)deptBO.getDeptId())) continue;
                            DeptOutlineOutputDTO deptOutlineOutputDTO = new DeptOutlineOutputDTO();
                            deptOutlineOutputDTO.setDeptId(dept);
                            deptOutlineOutputDTO.setDeptName(deptBO.getDeptName());
                            deptOutlineOutputDTOList.add(deptOutlineOutputDTO);
                        }
                    }
                }
                scanOutlineOutputDTO.setDeptList(deptOutlineOutputDTOList);
                scanOutlineOutputDTOList.add(scanOutlineOutputDTO);
            }
            result.setTotal(checkpointListFromTotal.getTotal());
            result.setPageNum(checkpointListFromTotal.getPageNum());
            result.setPageSize(checkpointListFromTotal.getPageSize());
            result.setList(scanOutlineOutputDTOList);
        }
        BaseResponse response = BaseResponseUtils.getSuccessResponse((Object)result, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    public BaseResponse<IFWPageInfo<TemporyTaskWorkSheetListOutputDTO>> getTemporaryWorksheetList(IFWUser ifwUser, WorksheetStatisticListInputBO worksheetStatisticListInputBO) {
        if (StringUtils.isBlank((String)worksheetStatisticListInputBO.getTenantId())) {
            worksheetStatisticListInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)worksheetStatisticListInputBO.getTenantId());
        }
        IFWValidator.validate((Object)worksheetStatisticListInputBO);
        List positionIdList = new ArrayList();
        if (CollectionUtils.isEmpty((Collection)worksheetStatisticListInputBO.getPositionIdList())) {
            if (StringUtils.isBlank((String)worksheetStatisticListInputBO.getDeptId())) {
                return BaseResponseUtils.getSuccessResponse(null, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
            }
            positionIdList = this.getPositionIdList(worksheetStatisticListInputBO.getDeptId(), worksheetStatisticListInputBO.getLanguageCode(), worksheetStatisticListInputBO.getTenantId());
            if (CollectionUtils.isEmpty(positionIdList)) {
                return BaseResponseUtils.getSuccessResponse(null, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
            }
            worksheetStatisticListInputBO.setPositionIdList(positionIdList);
        } else {
            positionIdList = worksheetStatisticListInputBO.getPositionIdList();
        }
        IFWPageInfo pageInfo = this.worksheetRepository.getStatisticTempWorksheetList(worksheetStatisticListInputBO);
        ArrayList worksheetList = new ArrayList();
        ArrayList userIdList = new ArrayList();
        List<Object> spaceIdList = new ArrayList();
        if (pageInfo.getList() != null && !pageInfo.getList().isEmpty()) {
            worksheetList.addAll(IFWBeanCopyUtil.mapAsList((Iterable)pageInfo.getList(), TemporyTaskWorkSheetListOutputDTO.class));
            userIdList.addAll(worksheetList.stream().map(TemporyTaskWorkSheetListOutputDTO::getCreateBy).distinct().collect(Collectors.toList()));
            spaceIdList = worksheetList.stream().map(TemporyTaskWorkSheetListOutputDTO::getTaskSpaceList).flatMap(Collection::stream).map(TaskSpaceInsertInputDTO::getSpaceId).filter(t -> !StringUtils.isEmpty((String)t)).distinct().collect(Collectors.toList());
        }
        List userDeatilInfoOutputBOList = new ArrayList();
        if (userIdList != null && !userIdList.isEmpty()) {
            userDeatilInfoOutputBOList = this.organizationRepository.queryUserDetailByUserId(userIdList, worksheetStatisticListInputBO.getTenantId(), worksheetStatisticListInputBO.getLanguageCode());
        }
        List queryResEmployeeOutputBOS = new ArrayList();
        if (positionIdList != null && !positionIdList.isEmpty()) {
            queryResEmployeeOutputBOS = this.organizationRepository.queryPositionAndEmployeeByPositionId(positionIdList, worksheetStatisticListInputBO.getTenantId(), worksheetStatisticListInputBO.getLanguageCode());
        }
        List spaceList = null;
        if (!CollectionUtils.isEmpty(spaceIdList)) {
            spaceList = this.configRepository.querySpaceNameBySpaceList(spaceIdList, worksheetStatisticListInputBO.getTenantId(), worksheetStatisticListInputBO.getLanguageCode(), worksheetStatisticListInputBO.getProjectId());
        }
        for (TemporyTaskWorkSheetListOutputDTO dto : worksheetList) {
            List taskSpaceList;
            List worksheetExecutorList;
            if (userDeatilInfoOutputBOList != null && !userDeatilInfoOutputBOList.isEmpty()) {
                for (UserDeatilInfoOutputBO userBO : userDeatilInfoOutputBOList) {
                    if (!StringUtils.isEquals((String)dto.getCreateBy(), (String)userBO.getUserId())) continue;
                    dto.setCreateName(userBO.getRealName());
                }
            }
            if (queryResEmployeeOutputBOS != null && !queryResEmployeeOutputBOS.isEmpty() && (worksheetExecutorList = dto.getWorksheetExecutorList()) != null && !worksheetExecutorList.isEmpty()) {
                for (WorksheetExecutorOutputDTO executor : worksheetExecutorList) {
                    for (QueryResEmployeeOutputBO bo : queryResEmployeeOutputBOS) {
                        if (!StringUtils.isEquals((String)executor.getExecutorPositionId(), (String)bo.getPositionId())) continue;
                        executor.setName(bo.getPositionName());
                    }
                }
            }
            if (CollectionUtils.isEmpty((Collection)spaceList) || CollectionUtils.isEmpty((Collection)(taskSpaceList = dto.getTaskSpaceList()))) continue;
            for (TaskSpaceInsertInputDTO spaceInsertInputDTO : taskSpaceList) {
                for (ProjectSpacePathDTO projectSpacePathDTO : spaceList) {
                    if (!StringUtils.isEquals((String)spaceInsertInputDTO.getSpaceId(), (String)projectSpacePathDTO.getId())) continue;
                    spaceInsertInputDTO.setTaskSpaceDescription(projectSpacePathDTO.getNameStr());
                }
            }
        }
        IFWPageInfo result = new IFWPageInfo();
        result.setPageSize(pageInfo.getPageSize());
        result.setPageNum(pageInfo.getPageNum());
        result.setTotal(pageInfo.getTotal());
        result.setList(worksheetList);
        BaseResponse response = BaseResponseUtils.getSuccessResponse((Object)result, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    public BaseResponse<IFWPageInfo<DailyTaskWorkSheetListOutputDTO>> getDailyWorksheetList(IFWUser ifwUser, WorksheetStatisticListInputBO worksheetStatisticListInputBO) {
        List positionIdList;
        if (StringUtils.isBlank((String)worksheetStatisticListInputBO.getTenantId())) {
            worksheetStatisticListInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)worksheetStatisticListInputBO.getTenantId());
        }
        IFWValidator.validate((Object)worksheetStatisticListInputBO);
        if (CollectionUtils.isEmpty((Collection)worksheetStatisticListInputBO.getPositionIdList())) {
            if (StringUtils.isBlank((String)worksheetStatisticListInputBO.getDeptId())) {
                return BaseResponseUtils.getSuccessResponse(null, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
            }
            positionIdList = this.getPositionIdList(worksheetStatisticListInputBO.getDeptId(), worksheetStatisticListInputBO.getLanguageCode(), worksheetStatisticListInputBO.getTenantId());
            if (CollectionUtils.isEmpty((Collection)positionIdList)) {
                return BaseResponseUtils.getSuccessResponse(null, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
            }
            worksheetStatisticListInputBO.setPositionIdList(positionIdList);
        } else {
            positionIdList = worksheetStatisticListInputBO.getPositionIdList();
        }
        IFWPageInfo pageInfo = this.worksheetRepository.getStatisticDailyWorksheetList(worksheetStatisticListInputBO);
        ArrayList worksheetList = new ArrayList();
        ArrayList userIdList = new ArrayList();
        if (pageInfo.getList() != null && !pageInfo.getList().isEmpty()) {
            worksheetList.addAll(IFWBeanCopyUtil.mapAsList((Iterable)pageInfo.getList(), DailyTaskWorkSheetListOutputDTO.class));
            userIdList.addAll(worksheetList.stream().map(DailyTaskWorkSheetListOutputDTO::getCreateBy).distinct().collect(Collectors.toList()));
        }
        List userDeatilInfoOutputBOList = new ArrayList();
        if (!CollectionUtils.isEmpty(userIdList)) {
            userDeatilInfoOutputBOList = this.organizationRepository.queryUserDetailByUserId(userIdList, worksheetStatisticListInputBO.getTenantId(), worksheetStatisticListInputBO.getLanguageCode());
        }
        List queryResEmployeeOutputBOS = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)positionIdList)) {
            queryResEmployeeOutputBOS = this.organizationRepository.queryPositionAndEmployeeByPositionId(positionIdList, worksheetStatisticListInputBO.getTenantId(), worksheetStatisticListInputBO.getLanguageCode());
        }
        for (DailyTaskWorkSheetListOutputDTO dto : worksheetList) {
            List worksheetExecutorList;
            if (userDeatilInfoOutputBOList != null && !userDeatilInfoOutputBOList.isEmpty()) {
                for (UserDeatilInfoOutputBO userBO : userDeatilInfoOutputBOList) {
                    if (!StringUtils.isEquals((String)dto.getCreateBy(), (String)userBO.getUserId())) continue;
                    dto.setCreateName(userBO.getRealName());
                }
            }
            if (CollectionUtils.isEmpty(queryResEmployeeOutputBOS) || CollectionUtils.isEmpty((Collection)(worksheetExecutorList = dto.getWorksheetExecutorList()))) continue;
            for (WorksheetExecutorOutputDTO executor : worksheetExecutorList) {
                for (QueryResEmployeeOutputBO bo : queryResEmployeeOutputBOS) {
                    if (!StringUtils.isEquals((String)executor.getExecutorPositionId(), (String)bo.getPositionId())) continue;
                    executor.setName(bo.getPositionName());
                }
            }
        }
        IFWPageInfo result = new IFWPageInfo();
        result.setPageSize(pageInfo.getPageSize());
        result.setPageNum(pageInfo.getPageNum());
        result.setTotal(pageInfo.getTotal());
        result.setList(worksheetList);
        return BaseResponseUtils.getSuccessResponse((Object)result, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
    }

    public BaseResponse<WorksheetNumByUserOutputDTO> getWorksheetNumByUser(IFWUser ifwUser, WorksheetNumQueryByUserInputBO worksheetNumQueryByUserInputBO) {
        WorksheetNumByUserOutputDTO worksheetNumByUserOutputDTO = new WorksheetNumByUserOutputDTO();
        if (StringUtils.isBlank((String)worksheetNumQueryByUserInputBO.getTenantId())) {
            worksheetNumQueryByUserInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)worksheetNumQueryByUserInputBO.getTenantId());
        }
        if (StringUtils.isBlank((String)worksheetNumQueryByUserInputBO.getUserId())) {
            worksheetNumQueryByUserInputBO.setUserId(ifwUser.getUserId());
            List positions = ifwUser.getPositions();
            if (positions != null && !positions.isEmpty()) {
                List collect = positions.stream().map(IFWPosition::getPositionId).collect(Collectors.toList());
                worksheetNumQueryByUserInputBO.setPositionIdList(collect);
            }
        } else {
            UserInformationDTO userInformationDTO = this.organizationRepository.queryUser(worksheetNumQueryByUserInputBO.getUserId(), worksheetNumQueryByUserInputBO.getTenantId(), worksheetNumQueryByUserInputBO.getLanguageCode());
            if (userInformationDTO != null) {
                List positionIds = userInformationDTO.getPositionIds();
                if (positionIds != null && !positionIds.isEmpty()) {
                    List collect = positionIds.stream().map(PositionIdsDTO::getPositionId).collect(Collectors.toList());
                    worksheetNumQueryByUserInputBO.setPositionIdList(collect);
                }
            } else {
                throw new BizException(PlatformCodeEnum.USER_INFO_IS_NULL.getDesc(), PlatformCodeEnum.USER_INFO_IS_NULL.getCode());
            }
        }
        SeerWorksheetQueryInputBO seerWorksheetQueryInputBO = (SeerWorksheetQueryInputBO)IFWBeanCopyUtil.map((Object)worksheetNumQueryByUserInputBO, SeerWorksheetQueryInputBO.class);
        WorksheetCountForSeerOutputBO worksheetCountForSeer = this.worksheetRepository.getWorksheetCountForSeer(seerWorksheetQueryInputBO);
        if (worksheetCountForSeer != null) {
            worksheetNumByUserOutputDTO = (WorksheetNumByUserOutputDTO)IFWBeanCopyUtil.map((Object)worksheetCountForSeer, WorksheetNumByUserOutputDTO.class);
        }
        BaseResponse response = BaseResponseUtils.getSuccessResponse((Object)worksheetNumByUserOutputDTO, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    public BaseResponse<List<TagStatisticOutputDTO>> getTagStatistic(IFWUser ifwUser, TagStatisticInputBO tagStatisticInputBO) {
        if (StringUtils.isBlank((String)tagStatisticInputBO.getTenantId())) {
            tagStatisticInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)tagStatisticInputBO.getTenantId());
        }
        IFWValidator.validate((Object)tagStatisticInputBO);
        List tagStatistic = this.statisticsRepository.getTagStatistic(tagStatisticInputBO);
        BaseResponse response = BaseResponseUtils.getSuccessResponse((Object)tagStatistic, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    public BaseResponse<AssetStatisticOutputDTO> queryAssetStatisticForSeer(IFWUser ifwUser, WorksheetStatisticForSeerInputBO worksheetStatisticForSeerInputBO) {
        List assetIdList;
        if (StringUtils.isBlank((String)worksheetStatisticForSeerInputBO.getTenantId())) {
            worksheetStatisticForSeerInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)worksheetStatisticForSeerInputBO.getTenantId());
        }
        WorksheetStatisticForSeerInputBO queryBO = this.convertWorksheetStatisticForSeerInputBO(worksheetStatisticForSeerInputBO);
        IFWValidator.validate((Object)queryBO);
        AssetStatisticOutputDTO result = new AssetStatisticOutputDTO();
        List assetList = this.configRepository.getAssetList(queryBO.getTenantId(), queryBO.getProjectId(), queryBO.getSpaceIdList(), queryBO.getLanguageCode());
        if (assetList != null && !assetList.isEmpty() && (assetIdList = assetList.stream().filter(new /* Unavailable Anonymous Inner Class!! */).map(QueryAssetListDTO::getAssetId).collect(Collectors.toList())) != null && !assetIdList.isEmpty()) {
            result.setTotalAssetNum((long)assetIdList.size());
            FaultAssetQueryDTO faultAssetQueryDTO = new FaultAssetQueryDTO();
            faultAssetQueryDTO.setAssetIdList(assetIdList);
            faultAssetQueryDTO.setProjectId(queryBO.getProjectId());
            faultAssetQueryDTO.setTenantId(queryBO.getTenantId());
            List assetRecordList = this.statisticsRepository.getAssetListByAssetId(faultAssetQueryDTO);
            if (assetRecordList != null && !assetRecordList.isEmpty()) {
                long count = assetRecordList.stream().map(AssetCheckRecordDTO::getAssetId).distinct().count();
                result.setFaultAssetNum(count);
            }
        }
        BaseResponse response = BaseResponseUtils.getSuccessResponse((Object)result, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    public BaseResponse<List<TagStatisticOutputDTO>> queryWorksheetTagForSeer(IFWUser ifwUser, WorksheetStatisticForSeerInputBO worksheetStatisticForSeerInputBO) {
        if (StringUtils.isBlank((String)worksheetStatisticForSeerInputBO.getTenantId())) {
            worksheetStatisticForSeerInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)worksheetStatisticForSeerInputBO.getTenantId());
        }
        WorksheetStatisticForSeerInputBO queryBO = this.convertWorksheetStatisticForSeerInputBO(worksheetStatisticForSeerInputBO);
        IFWValidator.validate((Object)queryBO);
        List tagStatistic = this.statisticsRepository.getTagStatistic((TagStatisticInputBO)IFWBeanCopyUtil.map((Object)queryBO, TagStatisticInputBO.class));
        BaseResponse response = BaseResponseUtils.getSuccessResponse((Object)tagStatistic, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    public BaseResponse<IFWPageInfo<WorksheetListOutlineForSeerOutputDTO>> queryWorksheetBySpace(IFWUser ifwUser, WorksheetQueryBySpaceInputBO worksheetQueryBySpaceInputBO) {
        BaseResponse response;
        try {
            List assetName;
            List assetIdList;
            if (StringUtils.isBlank((String)worksheetQueryBySpaceInputBO.getTenantId())) {
                worksheetQueryBySpaceInputBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)worksheetQueryBySpaceInputBO.getTenantId());
            }
            IFWValidator.validate((Object)worksheetQueryBySpaceInputBO);
            List sonSpace = this.configRepository.getSonSpace(worksheetQueryBySpaceInputBO.getSpaceId());
            worksheetQueryBySpaceInputBO.setSpaceIdList(sonSpace);
            IFWPageInfo pageInfo = this.worksheetRepository.queryWorksheetBySpace(worksheetQueryBySpaceInputBO);
            List list = pageInfo.getList();
            if (!(list == null || list.isEmpty() || (assetIdList = list.stream().filter(new /* Unavailable Anonymous Inner Class!! */).map(WorksheetListOutlineForSeerOutputDTO::getAssetId).collect(Collectors.toList())) == null || assetIdList.isEmpty() || (assetName = this.configRepository.getAssetName(worksheetQueryBySpaceInputBO.getTenantId(), worksheetQueryBySpaceInputBO.getProjectId(), worksheetQueryBySpaceInputBO.getLanguageCode(), assetIdList)) == null || assetName.isEmpty())) {
                for (WorksheetListOutlineForSeerOutputDTO dto : list) {
                    if (StringUtils.isBlank((String)dto.getAssetId())) continue;
                    for (QueryAssetListByIdsDTO assetDto : assetName) {
                        if (!StringUtils.isEquals((String)assetDto.getAssetId(), (String)dto.getAssetId())) continue;
                        dto.setAssetName(assetDto.getAssetName());
                    }
                }
            }
            response = BaseResponseUtils.getSuccessResponse((Object)pageInfo, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    public BaseResponse<List<SpaceSpecialOutputDTO>> querySpecialBySpace(IFWUser ifwUser, SpaceSpecialQueryInputBO spaceSpecialQueryInputBO) {
        List sonSpaceList;
        if (StringUtils.isBlank((String)spaceSpecialQueryInputBO.getTenantId())) {
            spaceSpecialQueryInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)spaceSpecialQueryInputBO.getTenantId());
        }
        IFWValidator.validate((Object)spaceSpecialQueryInputBO);
        List result = new ArrayList();
        if (spaceSpecialQueryInputBO.getSpaceIdList() != null && !spaceSpecialQueryInputBO.getSpaceIdList().isEmpty() && (sonSpaceList = this.configRepository.querySonSpaceList(spaceSpecialQueryInputBO.getTenantId(), spaceSpecialQueryInputBO.getLanguageCode(), spaceSpecialQueryInputBO.getSpaceIdList())) != null && !sonSpaceList.isEmpty()) {
            List spaceIdList = sonSpaceList.stream().map(QuerySonSpaceListDTO::getSpaceIds).flatMap(Collection::stream).distinct().collect(Collectors.toList());
            spaceSpecialQueryInputBO.setSpaceIdList(spaceIdList);
            List spaceSpecialDTOS = this.worksheetRepository.querySpecialBySpace(spaceSpecialQueryInputBO);
            if (spaceSpecialDTOS != null && !spaceSpecialDTOS.isEmpty()) {
                result = IFWBeanCopyUtil.mapAsList((Iterable)spaceSpecialDTOS, SpaceSpecialOutputDTO.class);
            }
        }
        BaseResponse response = BaseResponseUtils.getSuccessResponse(result, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    public BaseResponse<IFWPageInfo<SeerAssetOutputDTO>> getAssetList(IFWUser ifwUser, SeerAssetQueryInputBO seerAssetQueryInputBO) {
        if (StringUtils.isBlank((String)seerAssetQueryInputBO.getTenantId())) {
            seerAssetQueryInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)seerAssetQueryInputBO.getTenantId());
        }
        IFWValidator.validate((Object)seerAssetQueryInputBO);
        IFWPageInfo result = new IFWPageInfo();
        IFWPageInfo ifwPageInfo = this.configRepository.queryNoMonitorAsset((QueryNoMonitorQuDTO)IFWBeanCopyUtil.map((Object)seerAssetQueryInputBO, QueryNoMonitorQuDTO.class));
        List list = ifwPageInfo.getList();
        if (list != null && !list.isEmpty()) {
            list.stream().forEach(new /* Unavailable Anonymous Inner Class!! */);
            List assetIdList = list.stream().map(SeerAssetOutputBO::getAssetId).filter((Predicate<String>)new /* Unavailable Anonymous Inner Class!! */).distinct().collect(Collectors.toList());
            if (assetIdList != null && !assetIdList.isEmpty()) {
                FaultAssetQueryDTO faultAssetQueryDTO = new FaultAssetQueryDTO();
                faultAssetQueryDTO.setTenantId(seerAssetQueryInputBO.getTenantId());
                faultAssetQueryDTO.setProjectId(seerAssetQueryInputBO.getProjectId());
                faultAssetQueryDTO.setAssetIdList(assetIdList);
                List assetList = this.statisticsRepository.getAssetListByAssetId(faultAssetQueryDTO);
                if (assetList != null && !assetIdList.isEmpty()) {
                    for (SeerAssetOutputBO bo : list) {
                        for (AssetCheckRecordDTO dto : assetList) {
                            if (!StringUtils.isEquals((String)bo.getAssetId(), (String)dto.getAssetId())) continue;
                            bo.setStatus("1");
                            bo.setTaskId(dto.getNewTaskId());
                        }
                    }
                }
            }
            result.setList(IFWBeanCopyUtil.mapAsList((Iterable)list, SeerAssetOutputDTO.class));
            result.setTotal(ifwPageInfo.getTotal());
            result.setPageNum(ifwPageInfo.getPageNum());
            result.setPageSize(ifwPageInfo.getPageSize());
        }
        return BaseResponseUtils.getSuccessResponse((Object)result, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
    }

    public BaseResponse<List<SeerQuerySpecialBySpaceOutputDTO>> getSpecialBySpace(IFWUser ifwUser, SeerQuerySpecialBySpaceInputBO seerQuerySpecialBySpaceInputBO) {
        if (StringUtils.isBlank((String)seerQuerySpecialBySpaceInputBO.getTenantId())) {
            seerQuerySpecialBySpaceInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)seerQuerySpecialBySpaceInputBO.getTenantId());
        }
        List areaSpaceIdList = seerQuerySpecialBySpaceInputBO.getSpaceIdList();
        if (StringUtils.isBlank((String)seerQuerySpecialBySpaceInputBO.getSpaceId()) && (areaSpaceIdList == null || areaSpaceIdList.isEmpty())) {
            throw new BizException(PlatformCodeEnum.SPACE_ID_CANNOT_NULL.getDesc(), PlatformCodeEnum.SPACE_ID_CANNOT_NULL.getCode());
        }
        IFWValidator.validate((Object)seerQuerySpecialBySpaceInputBO);
        ArrayList<SeerQuerySpecialBySpaceOutputDTO> result = new ArrayList<SeerQuerySpecialBySpaceOutputDTO>();
        List spaceIdList = new ArrayList();
        spaceIdList = !StringUtils.isBlank((String)seerQuerySpecialBySpaceInputBO.getSpaceId()) ? this.configRepository.queryNextSonList(seerQuerySpecialBySpaceInputBO) : seerQuerySpecialBySpaceInputBO.getSpaceIdList();
        ArrayList<String> spaceKeyList = new ArrayList<String>();
        if (spaceIdList != null && !spaceIdList.isEmpty()) {
            for (String spaceId : spaceIdList) {
                spaceKeyList.add(RedisKeyPrefixUtil.getTrackerUpdateSpaceSpecialWorksheetPrefix((String)spaceId));
            }
        }
        if (spaceKeyList != null && !spaceKeyList.isEmpty()) {
            for (String key : spaceKeyList) {
                Integer num = (Integer)this.redisTemplate.opsForValue().get((Object)key);
                String[] split = key.split(":");
                SeerQuerySpecialBySpaceOutputDTO dto = new SeerQuerySpecialBySpaceOutputDTO();
                if (split != null && split.length > 0) {
                    String spaceId = split[split.length - 1];
                    dto.setSpaceId(spaceId);
                    dto.setWorksheetNum(num + "");
                }
                result.add(dto);
            }
        }
        BaseResponse response = BaseResponseUtils.getSuccessResponse(result, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    public BaseResponse<IFWPageInfo<AssetWorksheetOutputDTO>> getWorksheetListByAsset(IFWUser ifwUser, QueryWorksheetByAssetInputBO queryWorksheetByAssetInputBO) {
        List list;
        List spaceIdList;
        List spaceList;
        if (StringUtils.isBlank((String)queryWorksheetByAssetInputBO.getTenantId())) {
            queryWorksheetByAssetInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)queryWorksheetByAssetInputBO.getTenantId());
        }
        IFWValidator.validate((Object)queryWorksheetByAssetInputBO);
        IFWPageInfo pageInfo = this.statisticsRepository.selectWorksheetByAsset(queryWorksheetByAssetInputBO);
        if (pageInfo != null && !CollectionUtils.isEmpty((Collection)pageInfo.getList()) && !CollectionUtils.isEmpty((Collection)(spaceList = this.configRepository.querySpaceNameBySpaceList(spaceIdList = (list = pageInfo.getList()).stream().map(AssetWorksheetOutputDTO::getSpaceId).distinct().collect(Collectors.toList()), queryWorksheetByAssetInputBO.getTenantId(), queryWorksheetByAssetInputBO.getLanguageCode(), queryWorksheetByAssetInputBO.getProjectId())))) {
            for (AssetWorksheetOutputDTO dto : list) {
                for (ProjectSpacePathDTO space : spaceList) {
                    if (!StringUtils.isEquals((String)dto.getSpaceId(), (String)space.getId())) continue;
                    dto.setTaskSpaceDescription(space.getNameStr());
                }
            }
        }
        BaseResponse response = BaseResponseUtils.getSuccessResponse((Object)pageInfo, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    public BaseResponse<IFWPageInfo<WorksheetOutputDTO>> getWorksheetList(IFWUser ifwUser, WorksheetQueryInputBO worksheetQueryInputBO) {
        List list;
        List<Object> positionIdList;
        if (StringUtils.isBlank((String)worksheetQueryInputBO.getTenantId())) {
            worksheetQueryInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)worksheetQueryInputBO.getTenantId());
        }
        IFWValidator.validate((Object)worksheetQueryInputBO);
        if (!StringUtils.isBlank((String)worksheetQueryInputBO.getDeptId())) {
            QueryDeptPositionReqInputBO queryDeptPositionReqInputBO = new QueryDeptPositionReqInputBO();
            queryDeptPositionReqInputBO.setTenantId(worksheetQueryInputBO.getTenantId());
            queryDeptPositionReqInputBO.setLanguageCode(worksheetQueryInputBO.getLanguageCode());
            ArrayList<String> deptIdList = new ArrayList<String>();
            deptIdList.add(worksheetQueryInputBO.getDeptId());
            queryDeptPositionReqInputBO.setDeptIds(deptIdList);
            List queryDeptAndPositionByPositionIds = this.organizationRepository.queryDeptAndPositionByPositionIds(queryDeptPositionReqInputBO);
            if (!CollectionUtils.isEmpty((Collection)queryDeptAndPositionByPositionIds)) {
                positionIdList = queryDeptAndPositionByPositionIds.stream().filter(item -> !CollectionUtils.isEmpty((Collection)item.getPositionNames())).map(QueryDeptPositionResOutputBO::getPositionNames).flatMap(Collection::stream).map(PositionResOutputBO::getPositionId).distinct().collect(Collectors.toList());
                if (CollectionUtils.isEmpty(positionIdList)) {
                    return BaseResponseUtils.getSuccessResponse(null, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
                }
                worksheetQueryInputBO.setPositionIdList(positionIdList);
            }
        }
        IFWPageInfo pageInfo = new IFWPageInfo();
        pageInfo = this.statisticsRepository.getWorksheetList(worksheetQueryInputBO);
        if (pageInfo != null && !CollectionUtils.isEmpty((Collection)(list = pageInfo.getList()))) {
            List userDeatilInfoOutputBOList;
            List<Object> userIdList = new ArrayList();
            positionIdList = new ArrayList();
            List collect = list.stream().filter(item -> !CollectionUtils.isEmpty((Collection)item.getExecutorList())).map(WorksheetOutputDTO::getExecutorList).flatMap(Collection::stream).collect(Collectors.toList());
            userIdList = collect.stream().filter(item -> !StringUtils.isBlank((String)item.getExecutorUserId())).map(WorksheetExecutorOutputDTO::getExecutorUserId).collect(Collectors.toList());
            positionIdList = collect.stream().filter(new /* Unavailable Anonymous Inner Class!! */).map(WorksheetExecutorOutputDTO::getExecutorPositionId).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(userIdList) && (userDeatilInfoOutputBOList = this.organizationRepository.queryUserDetailByUserId(userIdList, worksheetQueryInputBO.getTenantId(), worksheetQueryInputBO.getLanguageCode())) != null && !userDeatilInfoOutputBOList.isEmpty()) {
                for (WorksheetOutputDTO dto : list) {
                    List worksheetExecutorList = dto.getExecutorList();
                    if (worksheetExecutorList == null || worksheetExecutorList.isEmpty()) continue;
                    for (WorksheetExecutorOutputDTO executorDTO : worksheetExecutorList) {
                        for (UserDeatilInfoOutputBO bo : userDeatilInfoOutputBOList) {
                            if (StringUtils.isEmpty((String)executorDTO.getExecutorUserId()) || !StringUtils.isEquals((String)bo.getUserId(), (String)executorDTO.getExecutorUserId())) continue;
                            executorDTO.setName(bo.getRealName());
                        }
                    }
                }
            }
            if (!CollectionUtils.isEmpty(positionIdList)) {
                QueryDeptInfosReqDTO queryDeptInfosReqDTO = new QueryDeptInfosReqDTO();
                queryDeptInfosReqDTO.setTenantId(worksheetQueryInputBO.getTenantId());
                queryDeptInfosReqDTO.setLanguageCode(worksheetQueryInputBO.getLanguageCode());
                queryDeptInfosReqDTO.setPositionIds(positionIdList);
                List quDeptInfoList = this.organizationRepository.queryDeptByPositionIds(queryDeptInfosReqDTO);
                if (!CollectionUtils.isEmpty((Collection)quDeptInfoList)) {
                    for (WorksheetOutputDTO dto : list) {
                        List worksheetExecutorList = dto.getExecutorList();
                        if (CollectionUtils.isEmpty((Collection)worksheetExecutorList)) continue;
                        for (WorksheetExecutorOutputDTO executorDTO : worksheetExecutorList) {
                            for (QuDeptInfoDTO positionDTO : quDeptInfoList) {
                                if (!StringUtils.isEmpty((String)executorDTO.getExecutorUserId()) || StringUtils.isEmpty((String)executorDTO.getExecutorPositionId()) || !StringUtils.isEquals((String)executorDTO.getExecutorPositionId(), (String)positionDTO.getPositionId())) continue;
                                executorDTO.setName(positionDTO.getPositionName());
                                executorDTO.setDeptList(positionDTO.getDeptList());
                            }
                        }
                    }
                }
            }
        }
        BaseResponse response = BaseResponseUtils.getSuccessResponse((Object)pageInfo, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    public BaseResponse<List<WorksheetSummeryListOutputDTO>> queryWorksheetStatisticLineChart(IFWUser ifwUser, WorksheetStatisticLineChartInputBO worksheetStatisticInputBO) {
        if (StringUtils.isBlank((String)worksheetStatisticInputBO.getTenantId())) {
            worksheetStatisticInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)worksheetStatisticInputBO.getTenantId());
        }
        if (!StringUtils.isBlank((String)worksheetStatisticInputBO.getDeptId())) {
            QueryDeptPositionReqInputBO queryDeptPositionReqInputBO = new QueryDeptPositionReqInputBO();
            queryDeptPositionReqInputBO.setLanguageCode(worksheetStatisticInputBO.getLanguageCode());
            queryDeptPositionReqInputBO.setTenantId(worksheetStatisticInputBO.getTenantId());
            ArrayList<String> deptIdList = new ArrayList<String>();
            deptIdList.add(worksheetStatisticInputBO.getDeptId());
            queryDeptPositionReqInputBO.setDeptIds(deptIdList);
            List deptPositionList = this.organizationRepository.queryDeptAndPositionByPositionIds(queryDeptPositionReqInputBO);
            List<Object> positionIdList = new ArrayList();
            if (!CollectionUtils.isEmpty((Collection)deptPositionList)) {
                positionIdList = deptPositionList.stream().map(QueryDeptPositionResOutputBO::getPositionNames).flatMap(Collection::stream).map(PositionResOutputBO::getPositionId).distinct().collect(Collectors.toList());
                worksheetStatisticInputBO.setPositionIdList(positionIdList);
            }
            if (CollectionUtils.isEmpty(positionIdList)) {
                return BaseResponseUtils.getSuccessResponse(null, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
            }
        }
        if (StringUtils.isEquals((String)"1", (String)worksheetStatisticInputBO.getRelativeMe())) {
            worksheetStatisticInputBO.setUserId(ifwUser.getUserId());
            List positions = ifwUser.getPositions();
            if (!CollectionUtils.isEmpty((Collection)positions)) {
                worksheetStatisticInputBO.setPositionIdList(positions.stream().map(IFWPosition::getPositionId).distinct().collect(Collectors.toList()));
            }
        }
        List worksheetSummeryList = new ArrayList();
        worksheetSummeryList = StringUtils.isEquals((String)"1", (String)worksheetStatisticInputBO.getType()) ? this.statisticsRepository.queryWaitResolveLineChart(worksheetStatisticInputBO) : this.statisticsRepository.queryWorksheetStatisticLineChart(worksheetStatisticInputBO);
        BaseResponse response = BaseResponseUtils.getSuccessResponse((Object)IFWBeanCopyUtil.mapAsList(worksheetSummeryList, WorksheetSummeryListOutputDTO.class), (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    public BaseResponse<WorksheetStatisticDetailOutputDTO> queryWorksheetAllStatistic(IFWUser ifwUser, WorksheetStatisticInputBO worksheetStatisticInputBO) {
        if (StringUtils.isBlank((String)worksheetStatisticInputBO.getTenantId())) {
            worksheetStatisticInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)worksheetStatisticInputBO.getTenantId());
        }
        if (!StringUtils.isBlank((String)worksheetStatisticInputBO.getDeptId())) {
            QueryDeptPositionReqInputBO queryDeptPositionReqInputBO = new QueryDeptPositionReqInputBO();
            queryDeptPositionReqInputBO.setLanguageCode(worksheetStatisticInputBO.getLanguageCode());
            queryDeptPositionReqInputBO.setTenantId(worksheetStatisticInputBO.getTenantId());
            ArrayList<String> deptIdList = new ArrayList<String>();
            deptIdList.add(worksheetStatisticInputBO.getDeptId());
            queryDeptPositionReqInputBO.setDeptIds(deptIdList);
            List deptPositionList = this.organizationRepository.queryDeptAndPositionByPositionIds(queryDeptPositionReqInputBO);
            List<Object> positionIdList = new ArrayList();
            if (!CollectionUtils.isEmpty((Collection)deptPositionList)) {
                positionIdList = deptPositionList.stream().map(QueryDeptPositionResOutputBO::getPositionNames).flatMap(Collection::stream).map(PositionResOutputBO::getPositionId).distinct().collect(Collectors.toList());
                worksheetStatisticInputBO.setPositionIdList(positionIdList);
            }
            if (CollectionUtils.isEmpty(positionIdList)) {
                return BaseResponseUtils.getSuccessResponse(null, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
            }
        }
        if (StringUtils.isEquals((String)"1", (String)worksheetStatisticInputBO.getRelativeMe())) {
            worksheetStatisticInputBO.setUserId(ifwUser.getUserId());
            List positions = ifwUser.getPositions();
            if (!CollectionUtils.isEmpty((Collection)positions)) {
                worksheetStatisticInputBO.setPositionIdList(positions.stream().map(IFWPosition::getPositionId).distinct().collect(Collectors.toList()));
            }
        }
        WorksheetStatisticDetailOutputDTO result = new WorksheetStatisticDetailOutputDTO();
        List worksheetSourceDTOS = this.statisticsRepository.queryWorksheetWithSource(worksheetStatisticInputBO);
        List worksheetTypeStatisticDTOS = this.statisticsRepository.queryWorksheetWithType(worksheetStatisticInputBO);
        List worksheetFinishStatisticDTOS = this.statisticsRepository.queryWorksheetFinishTime(worksheetStatisticInputBO);
        if (!CollectionUtils.isEmpty((Collection)worksheetSourceDTOS)) {
            result.setWorksheetSourceList(IFWBeanCopyUtil.mapAsList((Iterable)worksheetSourceDTOS, WorksheetSourceOutputDTO.class));
        }
        if (!CollectionUtils.isEmpty((Collection)worksheetTypeStatisticDTOS)) {
            result.setWorksheetTypeStatisticList(IFWBeanCopyUtil.mapAsList((Iterable)worksheetTypeStatisticDTOS, WorksheetTypeStatisticOutputDTO.class));
        }
        if (!CollectionUtils.isEmpty((Collection)worksheetFinishStatisticDTOS)) {
            result.setWorksheetFinishStatisticList(IFWBeanCopyUtil.mapAsList((Iterable)worksheetFinishStatisticDTOS, WorksheetFinishStatisticOutputDTO.class));
        }
        Integer waitNum = this.statisticsRepository.queryCurrentWaitResolveWorksheet(worksheetStatisticInputBO);
        result.setCurrentWaitResolveNum(waitNum);
        BaseResponse response = BaseResponseUtils.getSuccessResponse((Object)result, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    public BaseResponse<WorksheetStatisticDetailOutputDTO> queryPersonalWorksheetStatistic(IFWUser ifwUser, WorksheetStatisticInputBO worksheetStatisticInputBO) {
        if (StringUtils.isBlank((String)worksheetStatisticInputBO.getTenantId())) {
            worksheetStatisticInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)worksheetStatisticInputBO.getTenantId());
        }
        if (StringUtils.isEmpty((String)worksheetStatisticInputBO.getUserId())) {
            return BaseResponseUtils.getSuccessResponse(null, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        WorksheetStatisticDetailOutputDTO result = new WorksheetStatisticDetailOutputDTO();
        List worksheetTypeStatisticDTOS = this.statisticsRepository.queryWorksheetWithType(worksheetStatisticInputBO);
        if (!CollectionUtils.isEmpty((Collection)worksheetTypeStatisticDTOS)) {
            result.setWorksheetTypeStatisticList(IFWBeanCopyUtil.mapAsList((Iterable)worksheetTypeStatisticDTOS, WorksheetTypeStatisticOutputDTO.class));
        }
        DailyWorksheetStatisticDTO dailyWorksheetStatisticDTO = this.statisticsRepository.queryDailyWorksheetFinish(worksheetStatisticInputBO);
        result.setDailyWorksheetStatistic((DailyWorksheetStatisticOutputDTO)IFWBeanCopyUtil.map((Object)dailyWorksheetStatisticDTO, DailyWorksheetStatisticOutputDTO.class));
        BaseResponse response = BaseResponseUtils.getSuccessResponse((Object)result, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    public BaseResponse<List<WorksheetSummeryByDeptOutputDTO>> queryWorksheetStatisticByDept(IFWUser ifwUser, WorksheetStatisticInputBO worksheetStatisticInputBO) {
        if (StringUtils.isBlank((String)worksheetStatisticInputBO.getTenantId())) {
            worksheetStatisticInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)worksheetStatisticInputBO.getTenantId());
        }
        IFWValidator.validate((Object)worksheetStatisticInputBO);
        ArrayList<WorksheetSummeryByDeptOutputDTO> result = new ArrayList<WorksheetSummeryByDeptOutputDTO>();
        ContactQueryInputBO contactQueryInputBO = (ContactQueryInputBO)IFWBeanCopyUtil.map((Object)worksheetStatisticInputBO, ContactQueryInputBO.class);
        List deptInfoList = this.organizationRepository.getDeptInfoList(contactQueryInputBO);
        Date currentDate = new Date();
        if (deptInfoList != null && !deptInfoList.isEmpty()) {
            List worksheetList;
            List deptIdList = deptInfoList.stream().map(QueryAllDeptDTO::getDeptId).collect(Collectors.toList());
            QueryDeptPositionReqInputBO queryDeptPositionReqInputBO = new QueryDeptPositionReqInputBO();
            queryDeptPositionReqInputBO.setTenantId(worksheetStatisticInputBO.getTenantId());
            queryDeptPositionReqInputBO.setLanguageCode(worksheetStatisticInputBO.getLanguageCode());
            queryDeptPositionReqInputBO.setDeptIds(deptIdList);
            List deptPositionList = this.organizationRepository.queryDeptAndPositionByPositionIds(queryDeptPositionReqInputBO);
            if (!CollectionUtils.isEmpty((Collection)deptPositionList) && !CollectionUtils.isEmpty((Collection)(worksheetList = this.statisticsRepository.queryWorksheetStatisticByDept(worksheetStatisticInputBO)))) {
                Map<String, List<WorksheetStatisticByDeptDTO>> map = worksheetList.stream().collect(Collectors.groupingBy(WorksheetStatisticByDeptDTO::getExecutorPositionId));
                for (QueryDeptPositionResOutputBO bo : deptPositionList) {
                    WorksheetSummeryByDeptOutputDTO worksheetSummeryByDeptOutputDTO = new WorksheetSummeryByDeptOutputDTO();
                    worksheetSummeryByDeptOutputDTO.setDeptId(bo.getDeptId());
                    worksheetSummeryByDeptOutputDTO.setDeptName(bo.getDeptName());
                    List positionNames = bo.getPositionNames();
                    HashSet totalSet = new HashSet();
                    HashSet finishSet = new HashSet();
                    HashSet waitSet = new HashSet();
                    if (!CollectionUtils.isEmpty((Collection)positionNames)) {
                        List positionIdList = positionNames.stream().map(PositionResOutputBO::getPositionId).distinct().collect(Collectors.toList());
                        for (String positionId : positionIdList) {
                            if (!map.containsKey(positionId)) continue;
                            List<WorksheetStatisticByDeptDTO> worksheetStatisticByDeptDTOS = map.get(positionId);
                            totalSet.addAll(worksheetStatisticByDeptDTOS.stream().map(WorksheetStatisticByDeptDTO::getTaskWorksheetId).distinct().collect(Collectors.toList()));
                            List finishList = worksheetStatisticByDeptDTOS.stream().filter(new /* Unavailable Anonymous Inner Class!! */).collect(Collectors.toList());
                            finishSet.addAll(finishList.stream().map(WorksheetStatisticByDeptDTO::getTaskWorksheetId).distinct().collect(Collectors.toList()));
                            List waitList = worksheetStatisticByDeptDTOS.stream().filter(new /* Unavailable Anonymous Inner Class!! */).collect(Collectors.toList());
                            waitSet.addAll(waitList.stream().map(WorksheetStatisticByDeptDTO::getTaskWorksheetId).distinct().collect(Collectors.toList()));
                        }
                    }
                    worksheetSummeryByDeptOutputDTO.setTotalWorksheetNum(Integer.valueOf(totalSet.size()));
                    worksheetSummeryByDeptOutputDTO.setFinishWorksheetNum(Integer.valueOf(finishSet.size()));
                    worksheetSummeryByDeptOutputDTO.setWaitResolvedNum(Integer.valueOf(waitSet.size()));
                    result.add(worksheetSummeryByDeptOutputDTO);
                }
            }
        }
        BaseResponse response = BaseResponseUtils.getSuccessResponse(result.stream().sorted(Comparator.comparing(WorksheetSummeryByDeptOutputDTO::getTotalWorksheetNum).reversed()).collect(Collectors.toList()), (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    public BaseResponse<WorksheetAggStatisticOutputDTO> queryWorksheetAggStatistic(IFWUser ifwUser, WorksheetStatisticInputBO worksheetStatisticInputBO) {
        if (StringUtils.isBlank((String)worksheetStatisticInputBO.getTenantId())) {
            worksheetStatisticInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)worksheetStatisticInputBO.getTenantId());
        }
        WorksheetAggStatisticDTO worksheetAggStatisticDTO = this.statisticsRepository.queryWorksheetAggStatistic(worksheetStatisticInputBO);
        BaseResponse response = BaseResponseUtils.getSuccessResponse((Object)IFWBeanCopyUtil.map((Object)worksheetAggStatisticDTO, WorksheetAggStatisticOutputDTO.class), (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    public BaseResponse<WorksheetStatisticSeerOutputDTO> queryWorksheetStatisticForSeer(IFWUser ifwUser, WorksheetStatisticInputBO worksheetStatisticInputBO) {
        List worksheetTypeStatisticDTOS;
        List worksheetTypeStatisticList;
        if (StringUtils.isBlank((String)worksheetStatisticInputBO.getTenantId())) {
            worksheetStatisticInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)worksheetStatisticInputBO.getTenantId());
        }
        WorksheetStatisticSeerOutputDTO worksheetStatisticSeerOutputDTO = new WorksheetStatisticSeerOutputDTO();
        WorksheetAggStatisticDTO worksheetAggStatisticDTO = this.statisticsRepository.queryWorksheetAggStatistic(worksheetStatisticInputBO);
        if (worksheetAggStatisticDTO != null && !CollectionUtils.isEmpty((Collection)(worksheetTypeStatisticList = worksheetAggStatisticDTO.getWorksheetTypeStatisticList()))) {
            int totalNum = worksheetTypeStatisticList.stream().filter(item -> item.getNum() != null).mapToInt(WorksheetTypeStatisticDTO::getNum).sum();
            int finishNum = worksheetTypeStatisticList.stream().filter(item -> item.getFinishNum() != null).mapToInt(WorksheetTypeStatisticDTO::getFinishNum).sum();
            int waitResolvedNum = worksheetTypeStatisticList.stream().filter(item -> item.getWaitNum() != null).mapToInt(WorksheetTypeStatisticDTO::getWaitNum).sum();
            int unResolvedNum = worksheetTypeStatisticList.stream().filter(item -> item.getUnResolvedNum() != null).mapToInt(WorksheetTypeStatisticDTO::getUnResolvedNum).sum();
            worksheetStatisticSeerOutputDTO.setFinishNum(Integer.valueOf(finishNum));
            worksheetStatisticSeerOutputDTO.setTotalNum(Integer.valueOf(totalNum));
            worksheetStatisticSeerOutputDTO.setUnResolvedNum(Integer.valueOf(unResolvedNum));
            worksheetStatisticSeerOutputDTO.setWaitResolvedNum(Integer.valueOf(waitResolvedNum));
        }
        if (!CollectionUtils.isEmpty((Collection)(worksheetTypeStatisticDTOS = this.statisticsRepository.queryWorksheetWithType(worksheetStatisticInputBO)))) {
            worksheetStatisticSeerOutputDTO.setWorksheetTypeStatisticList(IFWBeanCopyUtil.mapAsList((Iterable)worksheetTypeStatisticDTOS, WorksheetTypeStatisticOutputDTO.class));
        }
        worksheetStatisticSeerOutputDTO.setUnAssignNum(Integer.valueOf(0));
        WorksheetQueryInputBO worksheetQueryInputBO = new WorksheetQueryInputBO();
        worksheetQueryInputBO.setLanguageCode(worksheetStatisticInputBO.getLanguageCode());
        worksheetQueryInputBO.setTenantId(worksheetStatisticInputBO.getTenantId());
        worksheetQueryInputBO.setProjectId(worksheetStatisticInputBO.getProjectId());
        ArrayList<String> worksheetStatusIdList = new ArrayList<String>();
        worksheetStatusIdList.add("1");
        worksheetQueryInputBO.setWorksheetStatusIdList(worksheetStatusIdList);
        IFWPageInfo pageInfo = this.statisticsRepository.getWorksheetList(worksheetQueryInputBO);
        if (pageInfo != null) {
            List list = pageInfo.getList();
            worksheetStatisticSeerOutputDTO.setUnAssignNum(Integer.valueOf(CollectionUtils.isEmpty((Collection)list) ? 0 : list.size()));
        }
        BaseResponse response = BaseResponseUtils.getSuccessResponse((Object)worksheetStatisticSeerOutputDTO, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    WorksheetStatisticForSeerInputBO convertWorksheetStatisticForSeerInputBO(WorksheetStatisticForSeerInputBO worksheetStatisticForSeerInputBO) {
        Date startDate = null;
        Date endDate = null;
        Date date = new Date();
        if (StringUtils.isEquals((String)worksheetStatisticForSeerInputBO.getQueryType(), (String)"1")) {
            startDate = DateUtils.getFirstDateOfDay((Date)date);
            endDate = DateUtils.getLastDateOfDay((Date)date);
        } else if (StringUtils.isEquals((String)worksheetStatisticForSeerInputBO.getQueryType(), (String)"2")) {
            int weekNo = DateUtils.getWeekNo((Date)date);
            int year = DateUtils.getYearByDate((Date)date);
            startDate = DateUtils.getStartDayOfWeekNo((int)year, (int)weekNo);
            endDate = DateUtils.getEndDayOfWeekNo((int)year, (int)weekNo);
        } else {
            int month = DateUtils.getMonthByDate((Date)date);
            int year = DateUtils.getYearByDate((Date)date);
            startDate = DateUtils.getStartDayOfMonthNo((int)year, (int)month);
            endDate = DateUtils.getEndDayOfMonth((int)year, (int)month);
        }
        worksheetStatisticForSeerInputBO.setStartDate(startDate);
        worksheetStatisticForSeerInputBO.setEndDate(endDate);
        if (!StringUtils.isBlank((String)worksheetStatisticForSeerInputBO.getSpaceId())) {
            List sonSpace = this.configRepository.getSonSpace(worksheetStatisticForSeerInputBO.getSpaceId());
            worksheetStatisticForSeerInputBO.setSpaceIdList(sonSpace);
        }
        return worksheetStatisticForSeerInputBO;
    }
}

