/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.tracker.service.impl;

import com.ifourthwall.common.cache.RedisKeyPrefixUtil;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.common.utils.JSONUtils;
import com.ifourthwall.dbm.task.dto.ThirdPushRecordDTO;
import com.ifourthwall.dbm.tracker.bo.ThirdBindPushQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.ThirdMessagePushWrapBO;
import com.ifourthwall.dbm.tracker.domain.GodzillaRepository;
import com.ifourthwall.dbm.tracker.domain.ThirdBindPushRepository;
import com.ifourthwall.dbm.tracker.dto.ThirdPushBindOutputDTO;
import com.ifourthwall.kafka.DataHandler;
import com.ifourthwall.kafka.IFWKafkaClient;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
@DependsOn(value={"trackerConfiguration"})
public class SendWorksheetToThirdDataHandler
implements DataHandler {
    private static final Logger log = LoggerFactory.getLogger(SendWorksheetToThirdDataHandler.class);
    @Resource(name="godzillaRepository")
    GodzillaRepository godzillaRepository;
    @Resource(name="thirdBindPushRepository")
    ThirdBindPushRepository thirdBindPushRepository;
    @Resource(name="IFWKafkaClient-dbm_tracker_send_message_to_third")
    private IFWKafkaClient ifwKafkaClient;
    @Autowired
    RedisTemplate redisTemplate;

    public void handle(String jsonStrData) {
        log.info("\u63a5\u53d7\u5230\u7b2c\u4e09\u65b9\u6d88\u606fkafka\u4f20\u53c2\uff1a" + jsonStrData);
        try {
            ThirdMessagePushWrapBO thirdMessagePushWrapBO = null;
            ThirdPushRecordDTO thirdPushRecordDTO = null;
            thirdMessagePushWrapBO = (ThirdMessagePushWrapBO)JSONUtils.jacksonFromJson((String)jsonStrData, ThirdMessagePushWrapBO.class);
            if (thirdMessagePushWrapBO != null) {
                ThirdPushBindOutputDTO thirdPushBindOutputDTO;
                ThirdBindPushQueryInputBO thirdBindPushQueryInputBO = new ThirdBindPushQueryInputBO();
                thirdBindPushQueryInputBO.setTenantId(thirdMessagePushWrapBO.getThirdPushBind().getTenantId());
                List thirdPushBindOutputDTOS = this.thirdBindPushRepository.queryThirdPushBind(thirdBindPushQueryInputBO);
                if (!CollectionUtils.isEmpty((Collection)thirdPushBindOutputDTOS) && (thirdPushBindOutputDTO = (ThirdPushBindOutputDTO)thirdPushBindOutputDTOS.get(0)) != null && !StringUtils.isBlank((CharSequence)thirdPushBindOutputDTO.getCallBackUrl())) {
                    if (this.redisTemplate.hasKey((Object)RedisKeyPrefixUtil.getTrackerWorksheetCallbackFailedRecord((String)thirdMessagePushWrapBO.getThirdPushWorksheetDetail().getTaskWorksheet().getWorksheetNo())).booleanValue()) {
                        String messageId = (String)this.redisTemplate.opsForValue().get((Object)RedisKeyPrefixUtil.getTrackerWorksheetCallbackFailedRecord((String)thirdMessagePushWrapBO.getThirdPushWorksheetDetail().getTaskWorksheet().getWorksheetNo()));
                        if (StringUtils.equals((CharSequence)thirdMessagePushWrapBO.getMessageId(), (CharSequence)messageId)) {
                            thirdPushRecordDTO = this.sendAndReturn(thirdMessagePushWrapBO, thirdPushBindOutputDTO, jsonStrData);
                        } else {
                            this.ifwKafkaClient.syncProduce(jsonStrData);
                        }
                    } else {
                        thirdPushRecordDTO = this.sendAndReturn(thirdMessagePushWrapBO, thirdPushBindOutputDTO, jsonStrData);
                    }
                }
            }
            if (thirdPushRecordDTO != null) {
                log.info("\u63d2\u5165\u672c\u5730\u56de\u8c03\u8bb0\u5f55{}", thirdPushRecordDTO);
                this.thirdBindPushRepository.createThirdPushRecord(thirdPushRecordDTO);
                log.info("\u63d2\u5165\u672c\u5730\u56de\u8c03\u8bb0\u5f55\u7ed3\u675f{}", thirdPushRecordDTO);
                if (StringUtils.equals((CharSequence)thirdPushRecordDTO.getPushResult(), (CharSequence)"1")) {
                    if (thirdMessagePushWrapBO != null && thirdMessagePushWrapBO.getIndex() <= 9) {
                        this.sendMessageToQueueAgain(thirdMessagePushWrapBO);
                        this.redisTemplate.opsForValue().set((Object)RedisKeyPrefixUtil.getTrackerWorksheetCallbackFailedRecord((String)thirdPushRecordDTO.getWorksheetNo()), (Object)thirdPushRecordDTO.getPushMessageId(), 40L, TimeUnit.MINUTES);
                    } else {
                        this.redisTemplate.delete((Object)RedisKeyPrefixUtil.getTrackerWorksheetCallbackFailedRecord((String)thirdPushRecordDTO.getWorksheetNo()));
                    }
                } else {
                    this.redisTemplate.delete((Object)RedisKeyPrefixUtil.getTrackerWorksheetCallbackFailedRecord((String)thirdPushRecordDTO.getWorksheetNo()));
                }
            }
        }
        catch (BizException e) {
            log.info("AlertDataHandler:" + e.getMessage());
        }
    }

    public boolean judge(String topic) {
        return StringUtils.equals((CharSequence)topic, (CharSequence)"dbm_tracker_send_message_to_third");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ThirdPushRecordDTO sendAndReturn(ThirdMessagePushWrapBO thirdMessagePushWrapBO, ThirdPushBindOutputDTO thirdPushBindOutputDTO, String jsonStrData) {
        ThirdPushRecordDTO thirdPushRecordDTO = null;
        try {
            Date currentDate = new Date();
            Date validDate = thirdMessagePushWrapBO.getValidDate();
            if (currentDate.getTime() >= validDate.getTime()) {
                thirdPushRecordDTO = new ThirdPushRecordDTO();
                thirdPushRecordDTO.setPushContent(JSONUtils.jacksonToJson((Object)thirdMessagePushWrapBO.getThirdPushWorksheetDetail()));
                thirdPushRecordDTO.setTenantId(thirdMessagePushWrapBO.getThirdPushBind().getTenantId());
                thirdPushRecordDTO.setPushMessageId(thirdMessagePushWrapBO.getMessageId());
                thirdPushRecordDTO.setProjectId(thirdMessagePushWrapBO.getThirdPushWorksheetDetail().getTask().getProjectId());
                thirdPushRecordDTO.setWorksheetNo(thirdMessagePushWrapBO.getThirdPushWorksheetDetail().getTaskWorksheet().getWorksheetNo());
                Map result = this.godzillaRepository.sendWorksheetMessageToThird(thirdPushBindOutputDTO, thirdMessagePushWrapBO.getThirdPushWorksheetDetail());
                if (result != null && result.containsKey("flag")) {
                    boolean flag = (Boolean)result.get("flag");
                    if (flag) {
                        log.info("tracker\u5411\u7b2c\u4e09\u65b9\u53d1\u9001\u8bf7\u6c42\u53c2\u6570\u6210\u529f{}", (Object)thirdMessagePushWrapBO.getThirdPushWorksheetDetail());
                    } else {
                        log.info("tracker\u5411\u7b2c\u4e09\u65b9\u53d1\u9001\u8bf7\u6c42\u53c2\u6570\u5931\u8d25{}", (Object)thirdMessagePushWrapBO.getThirdPushWorksheetDetail());
                        thirdPushRecordDTO.setPushFailedType("1");
                    }
                    thirdPushRecordDTO.setPushResult(flag ? "0" : "1");
                } else {
                    thirdPushRecordDTO.setPushResult("1");
                    thirdPushRecordDTO.setPushFailedType("2");
                    log.info("tracker\u5411\u7b2c\u4e09\u65b9\u53d1\u9001\u8bf7\u6c42\u53c2\u6570\u5931\u8d25{}", (Object)thirdMessagePushWrapBO.getThirdPushWorksheetDetail());
                }
            } else {
                this.ifwKafkaClient.syncProduce(jsonStrData);
            }
            Thread.sleep(200L);
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u6d88\u606f{}\u5931\u8d25", (Object)jsonStrData);
            log.error("\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff0c\u539f\u56e0", (Throwable)e);
            if (thirdPushRecordDTO != null) {
                thirdPushRecordDTO.setPushResult("1");
                thirdPushRecordDTO.setPushFailedType("3");
            }
        }
        finally {
            return thirdPushRecordDTO;
        }
    }

    public void sendMessageToQueueAgain(ThirdMessagePushWrapBO thirdMessagePushWrapBO) {
        Integer index = thirdMessagePushWrapBO.getIndex();
        Date currentDate = new Date();
        double pow = Math.pow(2.0, index.intValue());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(currentDate);
        calendar.add(13, (int)pow);
        thirdMessagePushWrapBO.setValidDate(calendar.getTime());
        thirdMessagePushWrapBO.setIndex(Integer.valueOf(index + 1));
        this.ifwKafkaClient.syncProduce(JSONUtils.jacksonToJson((Object)thirdMessagePushWrapBO));
        log.info("\u518d\u6b21\u53d1\u9001\u7b2c\u4e09\u65b9\u6d88\u606f\u5230kafka\u961f\u5217{}", (Object)thirdMessagePushWrapBO);
    }
}

